/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.chunk_tracking;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.chunks.ChunkUnwatchTask;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b*\u0010+J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\b\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0013\u001a\u00060\u0011j\u0002`\u00128\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\u00020 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020%8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lorg/valkyrienskies/core/impl/chunk_tracking/ChunkUnwatchTaskImpl;", "", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkUnwatchTask;", "other", "", "compareTo", "(Lorg/valkyrienskies/core/apigame/world/chunks/ChunkUnwatchTask;)I", "", "chunkPos", "J", "getChunkPos", "()J", "getChunkX", "()I", "chunkX", "getChunkZ", "chunkZ", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "dimensionId", "Ljava/lang/String;", "getDimensionId", "()Ljava/lang/String;", "", "distanceToClosestPlayer", "D", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "playersNeedUnwatching", "Ljava/lang/Iterable;", "getPlayersNeedUnwatching", "()Ljava/lang/Iterable;", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "getShip", "()Lorg/valkyrienskies/core/api/ships/ServerShip;", "", "shouldUnload", "Z", "getShouldUnload", "()Z", "<init>", "(JLjava/lang/String;Ljava/lang/Iterable;ZDLorg/valkyrienskies/core/api/ships/ServerShip;)V", "impl"})
public final class ChunkUnwatchTaskImpl
implements Comparable<ChunkUnwatchTask>,
ChunkUnwatchTask {
    private final long chunkPos;
    @NotNull
    private final String dimensionId;
    @NotNull
    private final Iterable<IPlayer> playersNeedUnwatching;
    private final boolean shouldUnload;
    private final double distanceToClosestPlayer;
    @NotNull
    private final ServerShip ship;

    public ChunkUnwatchTaskImpl(long chunkPos, @NotNull String dimensionId, @NotNull Iterable<? extends IPlayer> playersNeedUnwatching, boolean shouldUnload, double distanceToClosestPlayer, @NotNull ServerShip ship) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        Intrinsics.checkNotNullParameter(playersNeedUnwatching, (String)"playersNeedUnwatching");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        this.chunkPos = chunkPos;
        this.dimensionId = dimensionId;
        this.playersNeedUnwatching = playersNeedUnwatching;
        this.shouldUnload = shouldUnload;
        this.distanceToClosestPlayer = distanceToClosestPlayer;
        this.ship = ship;
    }

    @Override
    public long getChunkPos() {
        return this.chunkPos;
    }

    @Override
    @NotNull
    public String getDimensionId() {
        return this.dimensionId;
    }

    @Override
    @NotNull
    public Iterable<IPlayer> getPlayersNeedUnwatching() {
        return this.playersNeedUnwatching;
    }

    @Override
    public boolean getShouldUnload() {
        return this.shouldUnload;
    }

    @Override
    @NotNull
    public ServerShip getShip() {
        return this.ship;
    }

    @Override
    public int getChunkX() {
        return IShipActiveChunksSet.Companion.longToChunkX(this.getChunkPos());
    }

    @Override
    public int getChunkZ() {
        return IShipActiveChunksSet.Companion.longToChunkZ(this.getChunkPos());
    }

    @Override
    public int compareTo(@NotNull ChunkUnwatchTask other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ChunkUnwatchTaskImpl cfr_ignored_0 = (ChunkUnwatchTaskImpl)other;
        return Double.compare(this.distanceToClosestPlayer, ((ChunkUnwatchTaskImpl)other).distanceToClosestPlayer);
    }
}

