/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.chunk_tracking;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.chunks.ChunkUnwatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTasks;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkTrackingInfo;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkUnwatchTaskKt;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkWatchTaskImpl;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkWatchTaskKt;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkWatchTasksKt;
import org.valkyrienskies.core.impl.chunk_tracking.ShipObjectServerWorldChunkTracker;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.core.impl.game.DimensionInfo;
import org.valkyrienskies.core.impl.util.AABBdUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u00102\u001a\u000201\u0012\u0018\b\u0001\u00108\u001a\u0012\u0012\b\u0012\u00060 j\u0002`!\u0012\u0004\u0012\u00020706\u00a2\u0006\u0004\bL\u0010MJ-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0011\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JE\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070#2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\n\u0010\"\u001a\u00060 j\u0002`!\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010'\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002\u00a2\u0006\u0004\b'\u0010(J-\u0010*\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b*\u0010\u000bJ\u000f\u0010+\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b+\u0010,R \u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070.0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0017\u00102\u001a\u0002018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R'\u00108\u001a\u0012\u0012\b\u0012\u00060 j\u0002`!\u0012\u0004\u0012\u000207068\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R&\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020.0>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R&\u0010A\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020.0>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010@R,\u0010D\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020C0B0>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010@R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR \u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070.0H8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010G\u00a8\u0006N"}, d2={"Lorg/valkyrienskies/core/impl/chunk_tracking/ShipObjectServerWorldChunkTracker;", "", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "shipData", "", "chunkPos", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "newWatchingPlayers", "", "addWatchersToChunk", "(Lorg/valkyrienskies/core/impl/api/ServerShipInternal;JLjava/lang/Iterable;)V", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTask;", "executedWatchTasks", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkUnwatchTask;", "executedUnwatchTasks", "Lorg/valkyrienskies/core/impl/chunk_tracking/ChunkTrackingInfo;", "applyTasksAndGenerateTrackingInfo", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)Lorg/valkyrienskies/core/impl/chunk_tracking/ChunkTrackingInfo;", "deletedShips", "cleanDeletedShips", "(Ljava/lang/Iterable;)V", "", "players", "lastTickPlayers", "ships", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "generateChunkWatchTasksAndUpdatePlayers", "(Ljava/util/Set;Ljava/util/Set;Ljava/lang/Iterable;Ljava/lang/Iterable;)Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "", "chunkX", "chunkZ", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "dimensionId", "", "getPlayersWatchingChunk", "(IILjava/lang/String;)Ljava/util/Collection;", "removedPlayers", "removePlayers", "(Ljava/util/Set;)V", "removedWatchingPlayers", "removeWatchersFromChunk", "resetForNewTick", "()V", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "chunkToPlayersWatchingMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "config", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "getConfig", "()Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "", "Lorg/valkyrienskies/core/impl/game/DimensionInfo;", "dimensionInfoMap", "Ljava/util/Map;", "getDimensionInfoMap", "()Ljava/util/Map;", "newPlayers", "Ljava/util/Set;", "Ljava/util/HashMap;", "playersToShipsNewlyWatchingMap", "Ljava/util/HashMap;", "playersToShipsNoLongerWatchingMap", "", "Lit/unimi/dsi/fastutil/longs/LongSet;", "playersToShipsWatchingMap", "Ljava/util/HashSet;", "shipsToLoad", "Ljava/util/HashSet;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "shipsToPlayersWatchingMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "shipsToUnload", "<init>", "(Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;Ljava/util/Map;)V", "impl"})
public final class ShipObjectServerWorldChunkTracker {
    @NotNull
    private final VSCoreConfig.Server config;
    @NotNull
    private final Map<String, DimensionInfo> dimensionInfoMap;
    @NotNull
    private final Long2ObjectMap<Set<IPlayer>> chunkToPlayersWatchingMap;
    @NotNull
    private final HashMap<IPlayer, Map<ServerShipInternal, LongSet>> playersToShipsWatchingMap;
    @NotNull
    private final Long2ObjectOpenHashMap<Set<IPlayer>> shipsToPlayersWatchingMap;
    @NotNull
    private final HashMap<IPlayer, Set<ServerShipInternal>> playersToShipsNewlyWatchingMap;
    @NotNull
    private final HashMap<IPlayer, Set<ServerShipInternal>> playersToShipsNoLongerWatchingMap;
    @NotNull
    private final HashSet<ServerShipInternal> shipsToLoad;
    @NotNull
    private final HashSet<ServerShipInternal> shipsToUnload;
    @NotNull
    private Set<? extends IPlayer> newPlayers;

    @Inject
    public ShipObjectServerWorldChunkTracker(@NotNull VSCoreConfig.Server config, @Named(value="dimensionInfo") @NotNull Map<String, DimensionInfo> dimensionInfoMap) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(dimensionInfoMap, (String)"dimensionInfoMap");
        this.config = config;
        this.dimensionInfoMap = dimensionInfoMap;
        this.chunkToPlayersWatchingMap = (Long2ObjectMap)new Long2ObjectOpenHashMap();
        this.playersToShipsWatchingMap = new HashMap();
        this.shipsToPlayersWatchingMap = new Long2ObjectOpenHashMap();
        this.playersToShipsNewlyWatchingMap = new HashMap();
        this.playersToShipsNoLongerWatchingMap = new HashMap();
        this.shipsToLoad = new HashSet();
        this.shipsToUnload = new HashSet();
        this.newPlayers = SetsKt.emptySet();
    }

    @NotNull
    public final VSCoreConfig.Server getConfig() {
        return this.config;
    }

    @NotNull
    public final Map<String, DimensionInfo> getDimensionInfoMap() {
        return this.dimensionInfoMap;
    }

    private final void cleanDeletedShips(Iterable<? extends ServerShipInternal> deletedShips) {
        for (ServerShipInternal serverShipInternal : deletedShips) {
            Collection<Map<ServerShipInternal, LongSet>> collection = this.playersToShipsWatchingMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"playersToShipsWatchingMap.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map it = (Map)element$iv;
                boolean bl = false;
                it.remove(serverShipInternal);
            }
            this.shipsToPlayersWatchingMap.remove(serverShipInternal.getId());
            this.shipsToUnload.add(serverShipInternal);
        }
    }

    private final void resetForNewTick() {
        this.shipsToLoad.clear();
        this.shipsToUnload.clear();
        this.playersToShipsNewlyWatchingMap.clear();
        this.playersToShipsNoLongerWatchingMap.clear();
    }

    @NotNull
    public final ChunkWatchTasks generateChunkWatchTasksAndUpdatePlayers(@NotNull Set<? extends IPlayer> players, @NotNull Set<? extends IPlayer> lastTickPlayers, @NotNull Iterable<? extends ServerShipInternal> ships, @NotNull Iterable<? extends ServerShipInternal> deletedShips) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(lastTickPlayers, (String)"lastTickPlayers");
        Intrinsics.checkNotNullParameter(ships, (String)"ships");
        Intrinsics.checkNotNullParameter(deletedShips, (String)"deletedShips");
        this.resetForNewTick();
        this.cleanDeletedShips(deletedShips);
        this.removePlayers(SetsKt.minus(lastTickPlayers, (Iterable)players));
        this.newPlayers = SetsKt.minus(players, (Iterable)lastTickPlayers);
        TreeSet newChunkWatchTasks = new TreeSet();
        TreeSet newChunkUnwatchTasks = new TreeSet();
        double chunkWatchDistance = this.config.getShipLoadDistance();
        double chunkUnwatchDistance = this.config.getShipUnloadDistance();
        Vector3d tempVector = new Vector3d();
        AABBd tempAABB = new AABBd();
        Iterable<? extends ServerShipInternal> $this$forEach$iv = ships;
        boolean $i$f$forEach = false;
        Iterator<? extends ServerShipInternal> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            ServerShipInternal element$iv;
            ServerShipInternal shipData = element$iv = iterator2.next();
            boolean bl = false;
            ShipTransform shipTransform = shipData.getTransform();
            AABBic voxelAABB = shipData.getShipAABB();
            LevelYRange worldHeight = ((DimensionInfo)MapsKt.getValue(this.dimensionInfoMap, (Object)shipData.getChunkClaimDimension())).getYRange();
            shipData.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipObjectServerWorldChunkTracker.generateChunkWatchTasksAndUpdatePlayers$lambda$2$lambda$1(tempAABB, voxelAABB, worldHeight, shipTransform, this, shipData, players, tempVector, chunkWatchDistance, chunkUnwatchDistance, newChunkWatchTasks, newChunkUnwatchTasks, arg_0, arg_1));
        }
        return ChunkWatchTasksKt.ChunkWatchTasks(newChunkWatchTasks, newChunkUnwatchTasks);
    }

    @NotNull
    public final ChunkTrackingInfo applyTasksAndGenerateTrackingInfo(@NotNull Iterable<? extends ChunkWatchTask> executedWatchTasks, @NotNull Iterable<? extends ChunkUnwatchTask> executedUnwatchTasks) {
        Intrinsics.checkNotNullParameter(executedWatchTasks, (String)"executedWatchTasks");
        Intrinsics.checkNotNullParameter(executedUnwatchTasks, (String)"executedUnwatchTasks");
        for (ChunkWatchTask chunkWatchTask : executedWatchTasks) {
            ServerShip serverShip = chunkWatchTask.getShip();
            Intrinsics.checkNotNull((Object)serverShip, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.api.ServerShipInternal");
            this.addWatchersToChunk((ServerShipInternal)serverShip, chunkWatchTask.getChunkPos(), chunkWatchTask.getPlayersNeedWatching());
        }
        for (ChunkUnwatchTask chunkUnwatchTask : executedUnwatchTasks) {
            ServerShip serverShip = chunkUnwatchTask.getShip();
            Intrinsics.checkNotNull((Object)serverShip, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.api.ServerShipInternal");
            this.removeWatchersFromChunk((ServerShipInternal)serverShip, chunkUnwatchTask.getChunkPos(), chunkUnwatchTask.getPlayersNeedUnwatching());
        }
        return new ChunkTrackingInfo((Map<IPlayer, ? extends Map<ServerShipInternal, ? extends LongSet>>)this.playersToShipsWatchingMap, (Long2ObjectMap<Set<IPlayer>>)((Long2ObjectMap)this.shipsToPlayersWatchingMap), (Map<IPlayer, ? extends Set<? extends ServerShipInternal>>)this.playersToShipsNewlyWatchingMap, (Map<IPlayer, ? extends Set<? extends ServerShipInternal>>)this.playersToShipsNoLongerWatchingMap, (Set<? extends ServerShipInternal>)this.shipsToLoad, (Set<? extends ServerShipInternal>)this.shipsToUnload, this.newPlayers);
    }

    @NotNull
    public final Collection<IPlayer> getPlayersWatchingChunk(int chunkX, int chunkZ, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        long chunkPosAsLong = IShipActiveChunksSet.Companion.chunkPosToLong(chunkX, chunkZ);
        Set set = (Set)this.chunkToPlayersWatchingMap.get(chunkPosAsLong);
        return set == null ? (Collection)CollectionsKt.emptyList() : (Collection)set;
    }

    private final void addWatchersToChunk(ServerShipInternal shipData, long chunkPos, Iterable<? extends IPlayer> newWatchingPlayers) {
        Object object = this.chunkToPlayersWatchingMap.computeIfAbsent(chunkPos, ShipObjectServerWorldChunkTracker::addWatchersToChunk$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chunkToPlayersWatchingMa\u2026t(chunkPos) { HashSet() }");
        CollectionsKt.addAll((Collection)((Collection)object), newWatchingPlayers);
        Iterable<? extends IPlayer> $this$forEach$iv = newWatchingPlayers;
        boolean $i$f$forEach = false;
        Iterator<? extends IPlayer> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IPlayer element$iv;
            IPlayer player = element$iv = iterator2.next();
            boolean bl = false;
            this.playersToShipsWatchingMap.computeIfAbsent(player, arg_0 -> ShipObjectServerWorldChunkTracker.addWatchersToChunk$lambda$6$lambda$4(addWatchersToChunk.2.1.INSTANCE, arg_0)).compute(shipData, (arg_0, arg_1) -> ShipObjectServerWorldChunkTracker.addWatchersToChunk$lambda$6$lambda$5((Function2)new Function2<ServerShipInternal, LongSet, LongSet>(this, player, shipData, chunkPos){
                final /* synthetic */ ShipObjectServerWorldChunkTracker this$0;
                final /* synthetic */ IPlayer $player;
                final /* synthetic */ ServerShipInternal $shipData;
                final /* synthetic */ long $chunkPos;
                {
                    this.this$0 = $receiver;
                    this.$player = $player;
                    this.$shipData = $shipData;
                    this.$chunkPos = $chunkPos;
                    super(2);
                }

                @Nullable
                public final LongSet invoke(@NotNull ServerShipInternal serverShipInternal, @Nullable LongSet chunks) {
                    LongSet longSet;
                    Intrinsics.checkNotNullParameter((Object)serverShipInternal, (String)"<anonymous parameter 0>");
                    if (chunks == null) {
                        ShipObjectServerWorldChunkTracker.access$getPlayersToShipsNewlyWatchingMap$p(this.this$0).computeIfAbsent(this.$player, arg_0 -> addWatchersToChunk.2.2.invoke$lambda$0(addWatchersToChunk.2.1.INSTANCE, arg_0)).add(this.$shipData);
                        Set playersWatchingShip = (Set)ShipObjectServerWorldChunkTracker.access$getShipsToPlayersWatchingMap$p(this.this$0).computeIfAbsent(this.$shipData.getId(), addWatchersToChunk.2.2::invoke$lambda$1);
                        if (playersWatchingShip.isEmpty()) {
                            ShipObjectServerWorldChunkTracker.access$getShipsToLoad$p(this.this$0).add(this.$shipData);
                        }
                        playersWatchingShip.add(this.$player);
                        LongOpenHashSet longOpenHashSet = new LongOpenHashSet();
                        long l = this.$chunkPos;
                        LongOpenHashSet $this$invoke_u24lambda_u242 = longOpenHashSet;
                        boolean bl = false;
                        $this$invoke_u24lambda_u242.add(l);
                        longSet = (LongSet)longOpenHashSet;
                    } else {
                        chunks.add(this.$chunkPos);
                        longSet = chunks;
                    }
                    return longSet;
                }

                private static final Set invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Set)$tmp0.invoke(p0);
                }

                private static final HashSet invoke$lambda$1(long it) {
                    return new HashSet<E>();
                }
            }, arg_0, arg_1));
        }
    }

    private final void removeWatchersFromChunk(ServerShipInternal shipData, long chunkPos, Iterable<? extends IPlayer> removedWatchingPlayers) {
        this.chunkToPlayersWatchingMap.computeIfPresent(chunkPos, (arg_0, arg_1) -> ShipObjectServerWorldChunkTracker.removeWatchersFromChunk$lambda$7((Function2)new Function2<Long, Set<IPlayer>, Set<IPlayer>>(removedWatchingPlayers){
            final /* synthetic */ Iterable<IPlayer> $removedWatchingPlayers;
            {
                this.$removedWatchingPlayers = $removedWatchingPlayers;
                super(2);
            }

            public final Set<IPlayer> invoke(Long l, Set<IPlayer> playersWatchingChunk) {
                Collection collection;
                Intrinsics.checkNotNullExpressionValue(playersWatchingChunk, (String)"playersWatchingChunk");
                CollectionsKt.removeAll((Collection)playersWatchingChunk, this.$removedWatchingPlayers);
                Collection collection2 = playersWatchingChunk;
                if (collection2.isEmpty()) {
                    boolean bl = false;
                    collection = null;
                } else {
                    collection = collection2;
                }
                return (Set)collection;
            }
        }, arg_0, arg_1));
        Iterable<? extends IPlayer> $this$forEach$iv = removedWatchingPlayers;
        boolean $i$f$forEach = false;
        Iterator<? extends IPlayer> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IPlayer element$iv;
            IPlayer player = element$iv = iterator2.next();
            boolean bl = false;
            this.playersToShipsWatchingMap.computeIfPresent(player, (arg_0, arg_1) -> ShipObjectServerWorldChunkTracker.removeWatchersFromChunk$lambda$9$lambda$8((Function2)new Function2<IPlayer, Map<ServerShipInternal, LongSet>, Map<ServerShipInternal, LongSet>>(shipData, chunkPos, this, player){
                final /* synthetic */ ServerShipInternal $shipData;
                final /* synthetic */ long $chunkPos;
                final /* synthetic */ ShipObjectServerWorldChunkTracker this$0;
                final /* synthetic */ IPlayer $player;
                {
                    this.$shipData = $shipData;
                    this.$chunkPos = $chunkPos;
                    this.this$0 = $receiver;
                    this.$player = $player;
                    super(2);
                }

                @Nullable
                public final Map<ServerShipInternal, LongSet> invoke(@NotNull IPlayer iPlayer, @NotNull Map<ServerShipInternal, LongSet> shipsWatchingMap) {
                    Intrinsics.checkNotNullParameter((Object)iPlayer, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter(shipsWatchingMap, (String)"shipsWatchingMap");
                    shipsWatchingMap.computeIfPresent(this.$shipData, (arg_0, arg_1) -> removeWatchersFromChunk.2.1.invoke$lambda$0((Function2)new Function2<ServerShipInternal, LongSet, LongSet>(this.$chunkPos, this.this$0, this.$player, this.$shipData){
                        final /* synthetic */ long $chunkPos;
                        final /* synthetic */ ShipObjectServerWorldChunkTracker this$0;
                        final /* synthetic */ IPlayer $player;
                        final /* synthetic */ ServerShipInternal $shipData;
                        {
                            this.$chunkPos = $chunkPos;
                            this.this$0 = $receiver;
                            this.$player = $player;
                            this.$shipData = $shipData;
                            super(2);
                        }

                        @Nullable
                        public final LongSet invoke(@NotNull ServerShipInternal serverShipInternal, @NotNull LongSet chunks) {
                            LongSet longSet;
                            Intrinsics.checkNotNullParameter((Object)serverShipInternal, (String)"<anonymous parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)chunks, (String)"chunks");
                            if (chunks.size() == 1) {
                                if (!chunks.contains(this.$chunkPos)) {
                                    boolean $i$a$-check-ShipObjectServerWorldChunkTracker$removeWatchersFromChunk$2$1$1$22 = false;
                                    String $i$a$-check-ShipObjectServerWorldChunkTracker$removeWatchersFromChunk$2$1$1$22 = "Last chunk on ship was not what we expected it to be";
                                    throw new IllegalStateException($i$a$-check-ShipObjectServerWorldChunkTracker$removeWatchersFromChunk$2$1$1$22.toString());
                                }
                                ShipObjectServerWorldChunkTracker.access$getPlayersToShipsNoLongerWatchingMap$p(this.this$0).computeIfAbsent(this.$player, arg_0 -> removeWatchersFromChunk.2.1.invoke$lambda$1(removeWatchersFromChunk.2.2.INSTANCE, arg_0)).add(this.$shipData);
                                Object object = ShipObjectServerWorldChunkTracker.access$getShipsToPlayersWatchingMap$p(this.this$0).get(this.$shipData.getId());
                                Intrinsics.checkNotNull((Object)object);
                                Set playersWatchingShip = (Set)object;
                                playersWatchingShip.remove(this.$player);
                                if (playersWatchingShip.isEmpty()) {
                                    ShipObjectServerWorldChunkTracker.access$getShipsToUnload$p(this.this$0).add(this.$shipData);
                                }
                                chunks.clear();
                                longSet = null;
                            } else {
                                if (!chunks.remove(this.$chunkPos)) {
                                    boolean bl = false;
                                    String string = "Player not watching chunk that we thought they were";
                                    throw new IllegalStateException(string.toString());
                                }
                                longSet = chunks;
                            }
                            return longSet;
                        }

                        private static final Set invoke$lambda$1(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Set)$tmp0.invoke(p0);
                        }
                    }, arg_0, arg_1));
                    return shipsWatchingMap.isEmpty() ? null : shipsWatchingMap;
                }

                private static final LongSet invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (LongSet)$tmp0.invoke(p0, p1);
                }
            }, arg_0, arg_1));
        }
    }

    private final void removePlayers(Set<? extends IPlayer> removedPlayers) {
        Set playersWatching;
        Object object;
        Object element$iv;
        if (removedPlayers.isEmpty()) {
            return;
        }
        Object $this$forEach$iv = removedPlayers;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            IPlayer player = (IPlayer)element$iv;
            boolean bl = false;
            this.playersToShipsWatchingMap.remove(player);
        }
        $this$forEach$iv = (Map)this.shipsToPlayersWatchingMap;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            object = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            playersWatching = (Set)object.getValue();
            playersWatching.removeAll((Collection)removedPlayers);
        }
        $this$forEach$iv = (Map)this.chunkToPlayersWatchingMap;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            object = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            playersWatching = (Set)object.getValue();
            playersWatching.removeAll((Collection)removedPlayers);
        }
    }

    private static final void generateChunkWatchTasksAndUpdatePlayers$lambda$2$lambda$1(AABBd $tempAABB, AABBic $voxelAABB, LevelYRange $worldHeight, ShipTransform $shipTransform, ShipObjectServerWorldChunkTracker this$0, ServerShipInternal $shipData, Set $players, Vector3d $tempVector, double $chunkWatchDistance, double $chunkUnwatchDistance, TreeSet $newChunkWatchTasks, TreeSet $newChunkUnwatchTasks, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$tempAABB, (String)"$tempAABB");
        Intrinsics.checkNotNullParameter((Object)$worldHeight, (String)"$worldHeight");
        Intrinsics.checkNotNullParameter((Object)$shipTransform, (String)"$shipTransform");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$shipData, (String)"$shipData");
        Intrinsics.checkNotNullParameter((Object)$players, (String)"$players");
        Intrinsics.checkNotNullParameter((Object)$tempVector, (String)"$tempVector");
        Intrinsics.checkNotNullParameter((Object)$newChunkWatchTasks, (String)"$newChunkWatchTasks");
        Intrinsics.checkNotNullParameter((Object)$newChunkUnwatchTasks, (String)"$newChunkUnwatchTasks");
        AABBic aABBic = $voxelAABB;
        AABBic aABBic2 = $voxelAABB;
        AABBd chunkAABBInWorld = AABBdUtilKt.set($tempAABB, chunkX << 4, aABBic != null ? (double)aABBic.minY() : (double)$worldHeight.getMinY(), chunkZ << 4, (double)(chunkX << 4) + 16.0, (aABBic2 != null ? (double)aABBic2.maxY() : (double)$worldHeight.getMaxY()) + 1.0, (double)(chunkZ << 4) + 16.0).transform($shipTransform.getShipToWorld());
        List newPlayersWatching = new ArrayList();
        List newPlayersUnwatching = new ArrayList();
        double minWatchingDistance = Double.MAX_VALUE;
        double minUnwatchingDistance = Double.MAX_VALUE;
        Collection<IPlayer> playersWatchingChunk = this$0.getPlayersWatchingChunk(chunkX, chunkZ, $shipData.getChunkClaimDimension());
        long chunkPosAsLong = IShipActiveChunksSet.Companion.chunkPosToLong(chunkX, chunkZ);
        for (IPlayer player : $players) {
            Vector3dc playerPositionInWorldCoordinates = player.getPosition($tempVector);
            Intrinsics.checkNotNullExpressionValue((Object)chunkAABBInWorld, (String)"chunkAABBInWorld");
            double displacementDistance = AABBdUtilKt.signedDistanceTo(chunkAABBInWorld, playerPositionInWorldCoordinates);
            boolean isPlayerWatchingThisChunk = playersWatchingChunk.contains(player);
            if (!Intrinsics.areEqual((Object)$shipData.getChunkClaimDimension(), (Object)player.getDimension())) {
                if (!isPlayerWatchingThisChunk) continue;
                this$0.removeWatchersFromChunk($shipData, chunkPosAsLong, CollectionsKt.listOf((Object)player));
                continue;
            }
            if (displacementDistance < $chunkWatchDistance) {
                if (isPlayerWatchingThisChunk) continue;
                newPlayersWatching.add(player);
                minWatchingDistance = Math.min(minWatchingDistance, displacementDistance);
                continue;
            }
            if (!(displacementDistance > $chunkUnwatchDistance) || !isPlayerWatchingThisChunk) continue;
            newPlayersUnwatching.add(player);
            minUnwatchingDistance = Math.min(minUnwatchingDistance, displacementDistance);
        }
        if (!((Collection)newPlayersWatching).isEmpty()) {
            ChunkWatchTaskImpl newChunkWatchTask = ChunkWatchTaskKt.ChunkWatchTask(chunkPosAsLong, $shipData.getChunkClaimDimension(), newPlayersWatching, minWatchingDistance, $shipData);
            $newChunkWatchTasks.add(newChunkWatchTask);
        }
        if (!((Collection)newPlayersUnwatching).isEmpty()) {
            boolean shouldUnloadChunk = playersWatchingChunk.size() == newPlayersUnwatching.size();
            ChunkUnwatchTask newChunkUnwatchTask = ChunkUnwatchTaskKt.ChunkUnwatchTask(chunkPosAsLong, $shipData.getChunkClaimDimension(), newPlayersUnwatching, shouldUnloadChunk, minUnwatchingDistance, $shipData);
            $newChunkUnwatchTasks.add(newChunkUnwatchTask);
        }
    }

    private static final Set addWatchersToChunk$lambda$3(long it) {
        return new HashSet();
    }

    private static final Map addWatchersToChunk$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final LongSet addWatchersToChunk$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LongSet)$tmp0.invoke(p0, p1);
    }

    private static final Set removeWatchersFromChunk$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0, p1);
    }

    private static final Map removeWatchersFromChunk$lambda$9$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ HashMap access$getPlayersToShipsNewlyWatchingMap$p(ShipObjectServerWorldChunkTracker $this) {
        return $this.playersToShipsNewlyWatchingMap;
    }

    public static final /* synthetic */ Long2ObjectOpenHashMap access$getShipsToPlayersWatchingMap$p(ShipObjectServerWorldChunkTracker $this) {
        return $this.shipsToPlayersWatchingMap;
    }

    public static final /* synthetic */ HashSet access$getShipsToLoad$p(ShipObjectServerWorldChunkTracker $this) {
        return $this.shipsToLoad;
    }

    public static final /* synthetic */ HashMap access$getPlayersToShipsNoLongerWatchingMap$p(ShipObjectServerWorldChunkTracker $this) {
        return $this.playersToShipsNoLongerWatchingMap;
    }

    public static final /* synthetic */ HashSet access$getShipsToUnload$p(ShipObjectServerWorldChunkTracker $this) {
        return $this.shipsToUnload;
    }
}

