/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import com.rubydesic.jacksonktdsl.JacksonKotlinDslKt;
import com.rubydesic.jacksonktdsl.ObjectNodeBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.impl.config.VSConfigClass;
import org.valkyrienskies.core.impl.hooks.CoreHooksImplKt;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001BI\u0012\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0017\u0012\u0006\u0010\u001c\u001a\u00020\u0001\u0012\u0006\u00101\u001a\u00020\u000b\u0012\u0006\u0010%\u001a\u00020\u000b\u0012\u0006\u0010.\u001a\u00020\b\u0012\u0006\u0010*\u001a\u00020)\u0012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\u0004\b3\u00104J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u0010\nR\u0017\u00101\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b1\u0010&\u001a\u0004\b2\u0010(\u00a8\u00065"}, d2={"Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "newConfig", "", "Lcom/networknt/schema/ValidationMessage;", "attemptUpdate", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/util/Set;", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "generateInstJson", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "", "key", "value", "generateInstJsonAndMergeWith", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/JsonNode;)Lcom/fasterxml/jackson/databind/node/ObjectNode;", "Ljava/nio/file/Path;", "configDir", "readOrCreateConfig", "(Ljava/nio/file/Path;)Ljava/lang/String;", "", "saveConfig", "(Ljava/nio/file/Path;)V", "Ljava/lang/Class;", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "inst", "Ljava/lang/Object;", "getInst", "()Ljava/lang/Object;", "Lkotlin/Function0;", "onUpdate", "Lkotlin/jvm/functions/Function0;", "getOnUpdate", "()Lkotlin/jvm/functions/Function0;", "parentName", "Ljava/lang/String;", "getParentName", "()Ljava/lang/String;", "Lcom/networknt/schema/JsonSchema;", "schema", "Lcom/networknt/schema/JsonSchema;", "getSchema", "()Lcom/networknt/schema/JsonSchema;", "schemaJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getSchemaJson", "sideName", "getSideName", "<init>", "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/networknt/schema/JsonSchema;Lkotlin/jvm/functions/Function0;)V", "impl"})
public final class SidedVSConfigClass {
    @NotNull
    private final Class<?> clazz;
    @NotNull
    private final Object inst;
    @NotNull
    private final String sideName;
    @NotNull
    private final String parentName;
    @NotNull
    private final ObjectNode schemaJson;
    @NotNull
    private final JsonSchema schema;
    @NotNull
    private final Function0<Unit> onUpdate;

    public SidedVSConfigClass(@NotNull Class<?> clazz, @NotNull Object inst, @NotNull String sideName, @NotNull String parentName, @NotNull ObjectNode schemaJson, @NotNull JsonSchema schema, @NotNull Function0<Unit> onUpdate2) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Intrinsics.checkNotNullParameter((Object)sideName, (String)"sideName");
        Intrinsics.checkNotNullParameter((Object)parentName, (String)"parentName");
        Intrinsics.checkNotNullParameter((Object)schemaJson, (String)"schemaJson");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(onUpdate2, (String)"onUpdate");
        this.clazz = clazz;
        this.inst = inst;
        this.sideName = sideName;
        this.parentName = parentName;
        this.schemaJson = schemaJson;
        this.schema = schema;
        this.onUpdate = onUpdate2;
    }

    @NotNull
    public final Class<?> getClazz() {
        return this.clazz;
    }

    @NotNull
    public final Object getInst() {
        return this.inst;
    }

    @NotNull
    public final String getSideName() {
        return this.sideName;
    }

    @NotNull
    public final String getParentName() {
        return this.parentName;
    }

    @NotNull
    public final ObjectNode getSchemaJson() {
        return this.schemaJson;
    }

    @NotNull
    public final JsonSchema getSchema() {
        return this.schema;
    }

    @NotNull
    public final Function0<Unit> getOnUpdate() {
        return this.onUpdate;
    }

    @NotNull
    public final ObjectNode generateInstJson() {
        Object t = VSConfigClass.Companion.getMapper().valueToTree(this.inst);
        Intrinsics.checkNotNullExpressionValue(t, (String)"VSConfigClass.mapper.valueToTree(inst)");
        return (ObjectNode)t;
    }

    @NotNull
    public final ObjectNode generateInstJsonAndMergeWith(@NotNull String key, @NotNull JsonNode value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return VSJacksonUtilKt.merge(this.generateInstJson(), JacksonKotlinDslKt.obj((Function1<? super ObjectNodeBuilder, Unit>)((Function1)new Function1<ObjectNodeBuilder, Unit>(key, value){
            final /* synthetic */ String $key;
            final /* synthetic */ JsonNode $value;
            {
                this.$key = $key;
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull ObjectNodeBuilder $this$obj) {
                Intrinsics.checkNotNullParameter((Object)$this$obj, (String)"$this$obj");
                $this$obj.to(this.$key, this.$value);
            }
        })));
    }

    @NotNull
    public final Set<ValidationMessage> attemptUpdate(@NotNull JsonNode newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        Set<ValidationMessage> errors = this.schema.validate((ObjectNode)newConfig);
        Intrinsics.checkNotNullExpressionValue(errors, (String)"errors");
        if (!((Collection)errors).isEmpty()) {
            return errors;
        }
        VSConfigClass.Companion.getMapper().readerForUpdating(this.inst).withoutAttribute("$schema").readValue(newConfig, this.clazz);
        this.onUpdate.invoke();
        return SetsKt.emptySet();
    }

    public final void saveConfig(@NotNull Path configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        ObjectMapper mapper = VSConfigClass.Companion.getMapper();
        String string = (this.parentName + '_' + this.sideName).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String name = string;
        String schemaRelativePath = "schemas/" + name + ".schema.json";
        Path configPath = configDir.resolve(name + ".json");
        ObjectNode json = (ObjectNode)mapper.valueToTree(this.inst);
        json.put("$schema", schemaRelativePath);
        mapper.writeValue(Files.newBufferedWriter(configPath, new OpenOption[0]), (Object)json);
    }

    public static /* synthetic */ void saveConfig$default(SidedVSConfigClass sidedVSConfigClass, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = CoreHooksImplKt.getCoreHooks().getConfigDir();
        }
        sidedVSConfigClass.saveConfig(path);
    }

    @Nullable
    public final String readOrCreateConfig(@NotNull Path configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        ObjectMapper mapper = VSConfigClass.Companion.getMapper();
        String string = (this.parentName + '_' + this.sideName).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String name = string;
        String schemaRelativePath = "schemas/" + name + ".schema.json";
        Path schemaPath = configDir.resolve(schemaRelativePath);
        Path configPath = configDir.resolve(name + ".json");
        Files.createDirectories(configDir.resolve("schemas"), new FileAttribute[0]);
        mapper.writeValue(Files.newBufferedWriter(schemaPath, new OpenOption[0]), (Object)this.schemaJson);
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                JsonNode jsonNode = mapper.readTree(Files.newBufferedReader(configPath));
                Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                ObjectNode json = (ObjectNode)jsonNode;
                json.remove("$schema");
                Set<ValidationMessage> errors = this.attemptUpdate(json);
                if (!((Collection)errors).isEmpty()) {
                    return CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                return null;
            }
            catch (JsonProcessingException ex) {
                return ex.getMessage();
            }
        }
        ObjectNode json = (ObjectNode)mapper.valueToTree(this.inst);
        json.put("$schema", schemaRelativePath);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW};
        mapper.writeValue(Files.newBufferedWriter(configPath, openOptionArray), (Object)json);
        return null;
    }
}

