/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.imifou.jsonschema.module.addon.AddonModule;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.apigame.hooks.PlayState;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.config.SidedVSConfigClass;
import org.valkyrienskies.core.impl.config.UpdatableConfig;
import org.valkyrienskies.core.impl.config.VSConfigClass;
import org.valkyrienskies.core.impl.hooks.CoreHooksImplKt;
import org.valkyrienskies.core.impl.networking.impl.PacketCommonConfigUpdate;
import org.valkyrienskies.core.impl.networking.impl.PacketServerConfigUpdate;
import org.valkyrienskies.core.impl.networking.simple.SimplePackets;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\t\b\u0086\b\u0018\u0000 62\u00020\u0001:\u000267B9\u0012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b4\u00105J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0012\u0010\f\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJL\u0010\u0012\u001a\u00020\u00002\f\b\u0002\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0011\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0011\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020!\u00a2\u0006\u0004\b$\u0010#J\u0010\u0010%\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b%\u0010\u0007J\r\u0010&\u001a\u00020!\u00a2\u0006\u0004\b&\u0010#R\u001b\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010'\u001a\u0004\b(\u0010\u0004R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010)\u001a\u0004\b*\u0010\nR\u0019\u0010\u0010\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010)\u001a\u0004\b+\u0010\nR\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010,\u001a\u0004\b-\u0010\u0007R\u0019\u0010\u0011\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010)\u001a\u0004\b.\u0010\nR\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020\b0/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00068"}, d2={"Lorg/valkyrienskies/core/impl/config/VSConfigClass;", "", "Ljava/lang/Class;", "component1", "()Ljava/lang/Class;", "", "component2", "()Ljava/lang/String;", "Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;", "component3", "()Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;", "component4", "component5", "clazz", "name", "client", "common", "server", "copy", "(Ljava/lang/Class;Ljava/lang/String;Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;)Lorg/valkyrienskies/core/impl/config/VSConfigClass;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/valkyrienskies/core/impl/networking/impl/PacketCommonConfigUpdate;", "makeCommonConfigUpdatePacket", "()Lorg/valkyrienskies/core/impl/networking/impl/PacketCommonConfigUpdate;", "Lorg/valkyrienskies/core/impl/networking/impl/PacketServerConfigUpdate;", "makeServerConfigUpdatePacket", "()Lorg/valkyrienskies/core/impl/networking/impl/PacketServerConfigUpdate;", "", "readOrCreateConfig", "()V", "syncToServer", "toString", "writeToDisk", "Ljava/lang/Class;", "getClazz", "Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;", "getClient", "getCommon", "Ljava/lang/String;", "getName", "getServer", "", "sides", "Ljava/util/List;", "getSides", "()Ljava/util/List;", "<init>", "(Ljava/lang/Class;Ljava/lang/String;Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;)V", "Companion", "VSConfigClassSide", "impl"})
public final class VSConfigClass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<?> clazz;
    @NotNull
    private final String name;
    @Nullable
    private final SidedVSConfigClass client;
    @Nullable
    private final SidedVSConfigClass common;
    @Nullable
    private final SidedVSConfigClass server;
    @NotNull
    private final List<SidedVSConfigClass> sides;
    @NotNull
    private static final ObjectMapper mapper = VSJacksonUtil.INSTANCE.getConfigMapper();
    @NotNull
    private static final HashMap<Class<?>, VSConfigClass> registeredConfigMap = new HashMap();
    @NotNull
    private static final SchemaVersion JSON_SCHEMA_GENERATOR_VERSION = SchemaVersion.DRAFT_2019_09;
    @NotNull
    private static final SpecVersion.VersionFlag JSON_SCHEMA_VALIDATOR_VERSION = SpecVersion.VersionFlag.V201909;
    private static final SchemaGeneratorConfig schemaGeneratorConfig;

    public VSConfigClass(@NotNull Class<?> clazz, @NotNull String name, @Nullable SidedVSConfigClass client, @Nullable SidedVSConfigClass common, @Nullable SidedVSConfigClass server) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.clazz = clazz;
        this.name = name;
        this.client = client;
        this.common = common;
        this.server = server;
        Object[] objectArray = new SidedVSConfigClass[]{this.client, this.common, this.server};
        this.sides = CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public final Class<?> getClazz() {
        return this.clazz;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final SidedVSConfigClass getClient() {
        return this.client;
    }

    @Nullable
    public final SidedVSConfigClass getCommon() {
        return this.common;
    }

    @Nullable
    public final SidedVSConfigClass getServer() {
        return this.server;
    }

    @NotNull
    public final List<SidedVSConfigClass> getSides() {
        return this.sides;
    }

    private final PacketServerConfigUpdate makeServerConfigUpdatePacket() {
        if (this.server == null) {
            return null;
        }
        Object t = mapper.valueToTree(this.server.getInst());
        Intrinsics.checkNotNullExpressionValue(t, (String)"mapper.valueToTree(server.inst)");
        return new PacketServerConfigUpdate(this.clazz, (JsonNode)t);
    }

    private final PacketCommonConfigUpdate makeCommonConfigUpdatePacket() {
        if (this.common == null) {
            return null;
        }
        Object t = mapper.valueToTree(this.common.getInst());
        Intrinsics.checkNotNullExpressionValue(t, (String)"mapper.valueToTree(common.inst)");
        return new PacketCommonConfigUpdate(this.clazz, (JsonNode)t);
    }

    public final void readOrCreateConfig() {
        Iterable $this$forEach$iv = this.sides;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SidedVSConfigClass it = (SidedVSConfigClass)element$iv;
            boolean bl = false;
            it.readOrCreateConfig(CoreHooksImplKt.getCoreHooks().getConfigDir());
        }
    }

    public final void writeToDisk() {
        block4: {
            if (CoreHooksImplKt.getCoreHooks().isPhysicalClient()) {
                SidedVSConfigClass sidedVSConfigClass = this.client;
                if (sidedVSConfigClass != null) {
                    SidedVSConfigClass.saveConfig$default(sidedVSConfigClass, null, 1, null);
                }
            }
            if (CoreHooksImplKt.getCoreHooks().getPlayState() == PlayState.CLIENT_MULTIPLAYER) break block4;
            SidedVSConfigClass sidedVSConfigClass = this.server;
            if (sidedVSConfigClass != null) {
                SidedVSConfigClass.saveConfig$default(sidedVSConfigClass, null, 1, null);
            }
            SidedVSConfigClass sidedVSConfigClass2 = this.client;
            if (sidedVSConfigClass2 != null) {
                SidedVSConfigClass.saveConfig$default(sidedVSConfigClass2, null, 1, null);
            }
        }
    }

    public final void syncToServer() {
        block2: {
            if (CoreHooksImplKt.getCoreHooks().getPlayState() != PlayState.CLIENT_MULTIPLAYER) break block2;
            PacketServerConfigUpdate packetServerConfigUpdate = this.makeServerConfigUpdatePacket();
            if (packetServerConfigUpdate != null) {
                SimplePackets.sendToServer(packetServerConfigUpdate);
            }
            PacketCommonConfigUpdate packetCommonConfigUpdate = this.makeCommonConfigUpdatePacket();
            if (packetCommonConfigUpdate != null) {
                SimplePackets.sendToServer(packetCommonConfigUpdate);
            }
        }
    }

    @NotNull
    public final Class<?> component1() {
        return this.clazz;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @Nullable
    public final SidedVSConfigClass component3() {
        return this.client;
    }

    @Nullable
    public final SidedVSConfigClass component4() {
        return this.common;
    }

    @Nullable
    public final SidedVSConfigClass component5() {
        return this.server;
    }

    @NotNull
    public final VSConfigClass copy(@NotNull Class<?> clazz, @NotNull String name, @Nullable SidedVSConfigClass client, @Nullable SidedVSConfigClass common, @Nullable SidedVSConfigClass server) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new VSConfigClass(clazz, name, client, common, server);
    }

    public static /* synthetic */ VSConfigClass copy$default(VSConfigClass vSConfigClass, Class clazz, String string, SidedVSConfigClass sidedVSConfigClass, SidedVSConfigClass sidedVSConfigClass2, SidedVSConfigClass sidedVSConfigClass3, int n, Object object) {
        if ((n & 1) != 0) {
            clazz = vSConfigClass.clazz;
        }
        if ((n & 2) != 0) {
            string = vSConfigClass.name;
        }
        if ((n & 4) != 0) {
            sidedVSConfigClass = vSConfigClass.client;
        }
        if ((n & 8) != 0) {
            sidedVSConfigClass2 = vSConfigClass.common;
        }
        if ((n & 0x10) != 0) {
            sidedVSConfigClass3 = vSConfigClass.server;
        }
        return vSConfigClass.copy(clazz, string, sidedVSConfigClass, sidedVSConfigClass2, sidedVSConfigClass3);
    }

    @NotNull
    public String toString() {
        return "VSConfigClass(clazz=" + this.clazz + ", name=" + this.name + ", client=" + this.client + ", common=" + this.common + ", server=" + this.server + ')';
    }

    public int hashCode() {
        int result2 = this.clazz.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + (this.client == null ? 0 : this.client.hashCode());
        result2 = result2 * 31 + (this.common == null ? 0 : this.common.hashCode());
        result2 = result2 * 31 + (this.server == null ? 0 : this.server.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VSConfigClass)) {
            return false;
        }
        VSConfigClass vSConfigClass = (VSConfigClass)other;
        if (!Intrinsics.areEqual(this.clazz, vSConfigClass.clazz)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)vSConfigClass.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.client, (Object)vSConfigClass.client)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.common, (Object)vSConfigClass.common)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.server, (Object)vSConfigClass.server);
    }

    static {
        Option[] optionArray = new Option[]{Option.SCHEMA_VERSION_INDICATOR, Option.ADDITIONAL_FIXED_TYPES, Option.EXTRA_OPEN_API_FORMAT_VALUES, Option.FLATTENED_ENUMS, Option.FLATTENED_OPTIONALS, Option.PUBLIC_NONSTATIC_FIELDS, Option.NONPUBLIC_NONSTATIC_FIELDS_WITH_GETTERS, Option.MAP_VALUES_AS_ADDITIONAL_PROPERTIES, Option.FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT, Option.ALLOF_CLEANUP_AT_THE_END};
        schemaGeneratorConfig = new SchemaGeneratorConfigBuilder(mapper, JSON_SCHEMA_GENERATOR_VERSION, new OptionPreset(optionArray)).with(new AddonModule()).with(new JacksonModule()).build();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b>\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ9\u0010\u0011\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\u000b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00152\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u0018\u0010\u0019J5\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u00152\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00132\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\bJ\u0013\u0010#\u001a\u00020\u000e*\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u0004\u0018\u00010\u0015*\u00020\"H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0011\u0010'\u001a\u00020\u0004*\u00020\"\u00a2\u0006\u0004\b'\u0010(J\u0011\u0010)\u001a\u00020\u0004*\u00020\"\u00a2\u0006\u0004\b)\u0010(J\u0011\u0010*\u001a\u00020\u0004*\u00020\"\u00a2\u0006\u0004\b*\u0010(R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0017\u00102\u001a\u0002018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R8\u00108\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u000e06j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u000e`78\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001c\u0010<\u001a\n ;*\u0004\u0018\u00010:0:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/core/impl/config/VSConfigClass$Companion;", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "", "afterClientJoinServer", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "afterDisconnect", "()V", "Ljava/lang/Class;", "mainClass", "Lcom/fasterxml/jackson/databind/JsonNode;", "newConfig", "Lkotlin/Function1;", "Lorg/valkyrienskies/core/impl/config/VSConfigClass;", "Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;", "side", "attemptUpdate", "(Ljava/lang/Class;Lcom/fasterxml/jackson/databind/JsonNode;Lkotlin/jvm/functions/Function1;)V", "", "parentName", "Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide;", "createSidedVSConfigClass", "(Ljava/lang/String;Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide;Ljava/lang/Class;)Lorg/valkyrienskies/core/impl/config/SidedVSConfigClass;", "getRegisteredConfig", "(Ljava/lang/Class;)Lorg/valkyrienskies/core/impl/config/VSConfigClass;", "Lkotlin/Pair;", "getSidedConfigClassAndInstance", "(Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide;Ljava/lang/Class;)Lkotlin/Pair;", "name", "clazz", "registerConfig", "(Ljava/lang/String;Ljava/lang/Class;)Lorg/valkyrienskies/core/impl/config/VSConfigClass;", "registerNetworkHandlers", "Lorg/valkyrienskies/core/impl/config/UpdatableConfig;", "getMainConfig", "(Lorg/valkyrienskies/core/impl/config/UpdatableConfig;)Lorg/valkyrienskies/core/impl/config/VSConfigClass;", "getSide", "(Lorg/valkyrienskies/core/impl/config/UpdatableConfig;)Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide;", "syncConfigToClient", "(Lorg/valkyrienskies/core/impl/config/UpdatableConfig;)V", "syncConfigToServer", "writeToDisk", "Lcom/github/victools/jsonschema/generator/SchemaVersion;", "JSON_SCHEMA_GENERATOR_VERSION", "Lcom/github/victools/jsonschema/generator/SchemaVersion;", "Lcom/networknt/schema/SpecVersion$VersionFlag;", "JSON_SCHEMA_VALIDATOR_VERSION", "Lcom/networknt/schema/SpecVersion$VersionFlag;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "registeredConfigMap", "Ljava/util/HashMap;", "Lcom/github/victools/jsonschema/generator/SchemaGeneratorConfig;", "kotlin.jvm.PlatformType", "schemaGeneratorConfig", "Lcom/github/victools/jsonschema/generator/SchemaGeneratorConfig;", "<init>", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public final void afterDisconnect() {
            Collection collection = registeredConfigMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"registeredConfigMap.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VSConfigClass config = (VSConfigClass)element$iv;
                boolean bl = false;
                config.readOrCreateConfig();
            }
        }

        public final void afterClientJoinServer(@NotNull IPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (CoreHooksImplKt.getCoreHooks().isPhysicalClient()) {
                return;
            }
            Collection collection = registeredConfigMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"registeredConfigMap.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VSConfigClass config = (VSConfigClass)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
                PacketCommonConfigUpdate packetCommonConfigUpdate = config.makeCommonConfigUpdatePacket();
                if (packetCommonConfigUpdate != null) {
                    SimplePackets.sendToClient(packetCommonConfigUpdate, player);
                }
                if (!player.getCanModifyServerConfig()) continue;
                PacketServerConfigUpdate packetServerConfigUpdate = config.makeServerConfigUpdatePacket();
                if (packetServerConfigUpdate == null) continue;
                SimplePackets.sendToClient(packetServerConfigUpdate, player);
            }
        }

        public final void writeToDisk(@NotNull UpdatableConfig $this$writeToDisk) {
            Intrinsics.checkNotNullParameter((Object)$this$writeToDisk, (String)"<this>");
            this.getMainConfig($this$writeToDisk).writeToDisk();
        }

        private final VSConfigClass getMainConfig(UpdatableConfig $this$getMainConfig) {
            Class<?> clazz = this.getSide($this$getMainConfig) == null ? $this$getMainConfig.getClass() : $this$getMainConfig.getClass().getEnclosingClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"if (getSide() == null) t\u2026class.java.enclosingClass");
            return this.getRegisteredConfig(clazz);
        }

        private final VSConfigClassSide getSide(UpdatableConfig $this$getSide) {
            Object v0;
            block1: {
                Iterable iterable = VSConfigClassSide.Companion.getVALUES();
                for (Object t : iterable) {
                    VSConfigClassSide it = (VSConfigClassSide)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSubclassName(), (Object)$this$getSide.getClass().getName())) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final void syncConfigToClient(@NotNull UpdatableConfig $this$syncConfigToClient) {
            Intrinsics.checkNotNullParameter((Object)$this$syncConfigToClient, (String)"<this>");
            VSConfigClassSide vSConfigClassSide = this.getSide($this$syncConfigToClient);
            switch (vSConfigClassSide == null ? -1 : WhenMappings.$EnumSwitchMapping$0[vSConfigClassSide.ordinal()]) {
                case -1: {
                    VSConfigClass registeredConfig = this.getRegisteredConfig($this$syncConfigToClient.getClass());
                    PacketCommonConfigUpdate packetCommonConfigUpdate = registeredConfig.makeCommonConfigUpdatePacket();
                    if (packetCommonConfigUpdate != null) {
                        SimplePackets.sendToAllClients(packetCommonConfigUpdate);
                    }
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException("Cannot sync client config to client");
                }
                case 2: {
                    throw new IllegalArgumentException("Currently syncing server config to client is unsupported...");
                }
                case 3: {
                    Class<?> clazz = $this$syncConfigToClient.getClass().getEnclosingClass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"this::class.java.enclosingClass");
                    VSConfigClass registeredConfig = this.getRegisteredConfig(clazz);
                    PacketCommonConfigUpdate packetCommonConfigUpdate = registeredConfig.makeCommonConfigUpdatePacket();
                    Intrinsics.checkNotNull((Object)packetCommonConfigUpdate);
                    SimplePackets.sendToAllClients(packetCommonConfigUpdate);
                }
            }
        }

        public final void syncConfigToServer(@NotNull UpdatableConfig $this$syncConfigToServer) {
            Intrinsics.checkNotNullParameter((Object)$this$syncConfigToServer, (String)"<this>");
            VSConfigClassSide vSConfigClassSide = this.getSide($this$syncConfigToServer);
            switch (vSConfigClassSide == null ? -1 : WhenMappings.$EnumSwitchMapping$0[vSConfigClassSide.ordinal()]) {
                case -1: {
                    this.getRegisteredConfig($this$syncConfigToServer.getClass()).syncToServer();
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException("Cannot sync client config to server");
                }
                case 2: {
                    Class<?> clazz = $this$syncConfigToServer.getClass().getEnclosingClass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"this::class.java.enclosingClass");
                    VSConfigClass registeredConfig = this.getRegisteredConfig(clazz);
                    PacketServerConfigUpdate packetServerConfigUpdate = registeredConfig.makeServerConfigUpdatePacket();
                    Intrinsics.checkNotNull((Object)packetServerConfigUpdate);
                    SimplePackets.sendToServer(packetServerConfigUpdate);
                    break;
                }
                case 3: {
                    Class<?> clazz = $this$syncConfigToServer.getClass().getEnclosingClass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"this::class.java.enclosingClass");
                    VSConfigClass registeredConfig = this.getRegisteredConfig(clazz);
                    PacketCommonConfigUpdate packetCommonConfigUpdate = registeredConfig.makeCommonConfigUpdatePacket();
                    Intrinsics.checkNotNull((Object)packetCommonConfigUpdate);
                    SimplePackets.sendToServer(packetCommonConfigUpdate);
                }
            }
        }

        @NotNull
        public final VSConfigClass getRegisteredConfig(@NotNull Class<?> mainClass) {
            Intrinsics.checkNotNullParameter(mainClass, (String)"mainClass");
            Object v = registeredConfigMap.get(mainClass);
            if (v == null) {
                boolean bl = false;
                String string = "This UpdatableConfig (" + mainClass + ") is not registered as a main config";
                throw new IllegalArgumentException(string.toString());
            }
            return (VSConfigClass)v;
        }

        private final void attemptUpdate(Class<?> mainClass, JsonNode newConfig, Function1<? super VSConfigClass, SidedVSConfigClass> side) {
            try {
                SidedVSConfigClass sidedVSConfigClass = (SidedVSConfigClass)side.invoke((Object)this.getRegisteredConfig(mainClass));
                if (sidedVSConfigClass == null) {
                    return;
                }
                SidedVSConfigClass config = sidedVSConfigClass;
                Set<ValidationMessage> errors = config.attemptUpdate(newConfig);
                if (!((Collection)errors).isEmpty()) {
                    System.out.println((Object)("Attempted to update config with invalid schema:\n" + errors));
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public final void registerNetworkHandlers() {
            System.out.println((Object)"registering network handlers");
            SimplePackets.registerServerHandler(Reflection.getOrCreateKotlinClass(PacketServerConfigUpdate.class), registerNetworkHandlers.1.INSTANCE);
            SimplePackets.registerClientHandler(Reflection.getOrCreateKotlinClass(PacketServerConfigUpdate.class), registerNetworkHandlers.2.INSTANCE);
            SimplePackets.registerServerHandler(Reflection.getOrCreateKotlinClass(PacketCommonConfigUpdate.class), registerNetworkHandlers.3.INSTANCE);
            SimplePackets.registerClientHandler(Reflection.getOrCreateKotlinClass(PacketCommonConfigUpdate.class), registerNetworkHandlers.4.INSTANCE);
        }

        private final Pair<Class<?>, Object> getSidedConfigClassAndInstance(VSConfigClassSide side, Class<?> mainClass) {
            Object object;
            block3: {
                Field[] fieldArray = mainClass.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"mainClass.fields");
                for (Object object2 : (Object[])fieldArray) {
                    Field it = (Field)object2;
                    boolean bl = false;
                    if (!(Modifier.isStatic(it.getModifiers()) && Intrinsics.areEqual((Object)it.getName(), (Object)side.getFieldName()))) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            Field field = (Field)object;
            if (field == null) {
                return null;
            }
            Field sidedConfigField = field;
            Object object3 = sidedConfigField.get(null);
            if (object3 == null) {
                throw new IllegalArgumentException("Type B (Java Class) main config class (" + mainClass + ") property " + sidedConfigField + " is null!");
            }
            Object instance = object3;
            return new Pair(sidedConfigField.getType(), instance);
        }

        private final SidedVSConfigClass createSidedVSConfigClass(String parentName, VSConfigClassSide side, Class<?> mainClass) {
            Pair<Class<?>, Object> pair = this.getSidedConfigClassAndInstance(side, mainClass);
            if (pair == null) {
                return null;
            }
            Pair<Class<?>, Object> pair2 = pair;
            Class clazz = (Class)pair2.component1();
            Object inst = pair2.component2();
            SchemaGenerator generator = new SchemaGenerator(schemaGeneratorConfig);
            ObjectNode schemaJson = generator.generateSchema(clazz, new Type[0]);
            JsonNode jsonNode = schemaJson.get("properties");
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode != null && (objectNode = objectNode.putObject("$schema")) != null) {
                objectNode.put("type", "string");
            }
            JsonSchema schema = JsonSchemaFactory.getInstance(JSON_SCHEMA_VALIDATOR_VERSION).getSchema(schemaJson);
            Function0 onUpdate2 = inst instanceof UpdatableConfig ? (Function0)new Function0<Unit>(inst){

                public final void invoke() {
                    ((UpdatableConfig)this.receiver).onUpdate();
                }
            } : (Function0)createSidedVSConfigClass.onUpdate.2.INSTANCE;
            String string = side.getSubclassName();
            Intrinsics.checkNotNullExpressionValue((Object)schemaJson, (String)"schemaJson");
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema");
            return new SidedVSConfigClass(clazz, inst, string, parentName, schemaJson, schema, (Function0<Unit>)onUpdate2);
        }

        @NotNull
        public final VSConfigClass registerConfig(@NotNull String name, @NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            VSConfigClass registered = (VSConfigClass)registeredConfigMap.get(clazz);
            if (registered != null) {
                throw new IllegalArgumentException("Already registered");
            }
            SidedVSConfigClass client = this.createSidedVSConfigClass(name, VSConfigClassSide.CLIENT, clazz);
            SidedVSConfigClass common = this.createSidedVSConfigClass(name, VSConfigClassSide.COMMON, clazz);
            SidedVSConfigClass server = this.createSidedVSConfigClass(name, VSConfigClassSide.SERVER, clazz);
            VSConfigClass configClass = new VSConfigClass(clazz, name, client, common, server);
            configClass.readOrCreateConfig();
            ((Map)registeredConfigMap).put(clazz, configClass);
            return configClass;
        }

        public static final /* synthetic */ void access$attemptUpdate(Companion $this, Class mainClass, JsonNode newConfig, Function1 side) {
            $this.attemptUpdate(mainClass, newConfig, (Function1<? super VSConfigClass, SidedVSConfigClass>)side);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VSConfigClassSide.values().length];
                try {
                    nArray[VSConfigClassSide.CLIENT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VSConfigClassSide.SERVER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VSConfigClassSide.COMMON.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\r\b\u0082\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u001b\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0006j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide;", "", "", "fieldName", "Ljava/lang/String;", "getFieldName", "()Ljava/lang/String;", "subclassName", "getSubclassName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "Companion", "CLIENT", "COMMON", "SERVER", "impl"})
    private static final class VSConfigClassSide
    extends Enum<VSConfigClassSide> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String subclassName;
        @NotNull
        private final String fieldName;
        @NotNull
        private static final List<VSConfigClassSide> VALUES;
        public static final /* enum */ VSConfigClassSide CLIENT;
        public static final /* enum */ VSConfigClassSide COMMON;
        public static final /* enum */ VSConfigClassSide SERVER;
        private static final /* synthetic */ VSConfigClassSide[] $VALUES;

        private VSConfigClassSide(String subclassName, String fieldName) {
            this.subclassName = subclassName;
            this.fieldName = fieldName;
        }

        /* synthetic */ VSConfigClassSide(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                String string4 = string2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                string3 = string4;
            }
            this(string2, string3);
        }

        @NotNull
        public final String getSubclassName() {
            return this.subclassName;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        public static VSConfigClassSide[] values() {
            return (VSConfigClassSide[])$VALUES.clone();
        }

        public static VSConfigClassSide valueOf(String value) {
            return Enum.valueOf(VSConfigClassSide.class, value);
        }

        static {
            CLIENT = new VSConfigClassSide("CLIENT", 0, "Client", null, 2, null);
            COMMON = new VSConfigClassSide("COMMON", 1, "Common", null, 2, null);
            SERVER = new VSConfigClassSide("SERVER", 2, "Server", null, 2, null);
            $VALUES = vSConfigClassSideArray = new VSConfigClassSide[]{VSConfigClassSide.CLIENT, VSConfigClassSide.COMMON, VSConfigClassSide.SERVER};
            Companion = new Companion(null);
            VALUES = ArraysKt.toList((Object[])VSConfigClassSide.values());
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide$Companion;", "", "", "Lorg/valkyrienskies/core/impl/config/VSConfigClass$VSConfigClassSide;", "VALUES", "Ljava/util/List;", "getVALUES", "()Ljava/util/List;", "<init>", "()V", "impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<VSConfigClassSide> getVALUES() {
                return VALUES;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

