/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.config;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.impl.config.PhysicsConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig;", "", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "SERVER", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "<init>", "()V", "Server", "ServerConfigModule", "impl"})
public final class VSCoreConfig {
    @NotNull
    public static final VSCoreConfig INSTANCE = new VSCoreConfig();
    @JvmField
    @NotNull
    public static final Server SERVER = new Server();

    private VSCoreConfig() {
    }

    @Module
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig$ServerConfigModule;", "", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "server", "()Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "<init>", "()V", "impl"})
    public static final class ServerConfigModule {
        @Provides
        @Singleton
        @NotNull
        public final Server server() {
            return SERVER;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b&\u0010'R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "", "", "enableUdp", "Z", "getEnableUdp", "()Z", "setEnableUdp", "(Z)V", "Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "physics", "Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "getPhysics", "()Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "setPhysics", "(Lorg/valkyrienskies/core/impl/config/PhysicsConfig;)V", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "pt", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "getPt", "()Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "", "shipLoadDistance", "D", "getShipLoadDistance", "()D", "setShipLoadDistance", "(D)V", "shipUnloadDistance", "getShipUnloadDistance", "setShipUnloadDistance", "", "udpPort", "I", "getUdpPort", "()I", "setUdpPort", "(I)V", "<init>", "()V", "PhysicsThreadSettings", "impl"})
    public static final class Server {
        @JsonSchema(title="Physics Thread Settings")
        @NotNull
        private final PhysicsThreadSettings pt = new PhysicsThreadSettings();
        @JsonSchema(description="Port to attempt to establish UDP connections on")
        private int udpPort = 25565;
        @JsonSchema(description="Is udp enabled? If not, the server will only use TCP")
        private boolean enableUdp;
        @JsonSchema(description="Ship load distance in blocks")
        private double shipLoadDistance = 128.0;
        @JsonSchema(description="Ship unload distance in blocks")
        private double shipUnloadDistance = 196.0;
        @JsonSchema(description="All related settings to the physics engine")
        @NotNull
        private PhysicsConfig physics = new PhysicsConfig();

        @NotNull
        public final PhysicsThreadSettings getPt() {
            return this.pt;
        }

        public final int getUdpPort() {
            return this.udpPort;
        }

        public final void setUdpPort(int n) {
            this.udpPort = n;
        }

        public final boolean getEnableUdp() {
            return this.enableUdp;
        }

        public final void setEnableUdp(boolean bl) {
            this.enableUdp = bl;
        }

        public final double getShipLoadDistance() {
            return this.shipLoadDistance;
        }

        public final void setShipLoadDistance(double d) {
            this.shipLoadDistance = d;
        }

        public final double getShipUnloadDistance() {
            return this.shipUnloadDistance;
        }

        public final void setShipUnloadDistance(double d) {
            this.shipUnloadDistance = d;
        }

        @NotNull
        public final PhysicsConfig getPhysics() {
            return this.physics;
        }

        public final void setPhysics(@NotNull PhysicsConfig physicsConfig) {
            Intrinsics.checkNotNullParameter((Object)physicsConfig, (String)"<set-?>");
            this.physics = physicsConfig;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "", "", "physicsTicksPerGameTick", "I", "getPhysicsTicksPerGameTick", "()I", "setPhysicsTicksPerGameTick", "(I)V", "", "synchronizePhysics", "Z", "getSynchronizePhysics", "()Z", "setSynchronizePhysics", "(Z)V", "<init>", "()V", "impl"})
        public static final class PhysicsThreadSettings {
            @JsonSchema(description="Synchronize the physics thread and the game thread")
            private boolean synchronizePhysics;
            private int physicsTicksPerGameTick = 3;

            public final boolean getSynchronizePhysics() {
                return this.synchronizePhysics;
            }

            public final void setSynchronizePhysics(boolean bl) {
                this.synchronizePhysics = bl;
            }

            public final int getPhysicsTicksPerGameTick() {
                return this.physicsTicksPerGameTick;
            }

            public final void setPhysicsTicksPerGameTick(int n) {
                this.physicsTicksPerGameTick = n;
            }
        }
    }
}

