/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

import it.unimi.dsi.fastutil.HashCommon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.impl.datastructures.MurmurHash3;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\n\u0018\u0000 O*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001OB\u001b\u0012\b\b\u0002\u0010K\u001a\u00020\u0006\u0012\b\b\u0002\u0010L\u001a\u000203\u00a2\u0006\u0004\bM\u0010NJ\r\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ9\u0010\u0011\u001a\u00020\u00032$\u0010\u0010\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J3\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000eJ9\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ1\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b#\u0010\u0014J\u0019\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0011\u0010&\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\"R$\u0010*\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R$\u0010.\u001a\u0004\u0018\u00018\u00008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u0010'\"\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R$\u00107\u001a\u0002062\u0006\u0010)\u001a\u0002068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0014\u0010=\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0016\u0010>\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010?R$\u0010A\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bA\u0010?\u001a\u0004\bB\u0010<R\u0014\u0010D\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010<R\u0016\u0010E\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010?R4\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000F2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000F8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006P"}, d2={"Lorg/valkyrienskies/core/impl/datastructures/BlockPos2ObjectOpenHashMap;", "T", "", "", "clear", "()V", "", "x", "y", "z", "", "contains", "(III)Z", "find", "(III)I", "Lkotlin/Function4;", "fn", "forEach", "(Lkotlin/jvm/functions/Function4;)V", "get", "(III)Ljava/lang/Object;", "Lkotlin/Function0;", "default", "getOrPut", "(IIILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "hash", "pos", "v", "insert", "(IIIILjava/lang/Object;)V", "put", "(IIILjava/lang/Object;)Ljava/lang/Object;", "newN", "rehash", "(I)V", "remove", "removeEntry", "(I)Ljava/lang/Object;", "removeNullEntry", "()Ljava/lang/Object;", "shiftKeys", "<set-?>", "containsNullKey", "Z", "getContainsNullKey", "()Z", "defRetValue", "Ljava/lang/Object;", "getDefRetValue", "setDefRetValue", "(Ljava/lang/Object;)V", "", "f", "F", "", "keys", "[I", "getKeys", "()[I", "getMask", "()I", "mask", "maxFill", "I", "minN", "n", "getN", "getRealSize", "realSize", "size", "", "values", "[Ljava/lang/Object;", "getValues", "()[Ljava/lang/Object;", "expected", "loadFactor", "<init>", "(IF)V", "Companion", "impl"})
public final class BlockPos2ObjectOpenHashMap<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int n;
    private int size;
    @NotNull
    private int[] keys;
    @NotNull
    private T[] values;
    private boolean containsNullKey;
    private int maxFill;
    @Nullable
    private T defRetValue;
    private final int minN;
    private final float f;
    public static final int NUM_KEYS = 3;

    public BlockPos2ObjectOpenHashMap(int expected, float loadFactor) {
        this.f = loadFactor;
        this.minN = this.n = HashCommon.arraySize((int)expected, (float)this.f);
        this.maxFill = HashCommon.maxFill((int)this.n, (float)loadFactor);
        this.keys = new int[(this.n + 1) * 3];
        this.values = new Object[this.n + 1];
    }

    public /* synthetic */ BlockPos2ObjectOpenHashMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            f = 0.75f;
        }
        this(n, f);
    }

    public final int getN() {
        return this.n;
    }

    @NotNull
    public final int[] getKeys() {
        return this.keys;
    }

    @NotNull
    public final T[] getValues() {
        return this.values;
    }

    public final boolean getContainsNullKey() {
        return this.containsNullKey;
    }

    @Nullable
    public final T getDefRetValue() {
        return this.defRetValue;
    }

    public final void setDefRetValue(@Nullable T t) {
        this.defRetValue = t;
    }

    private final int getMask() {
        return this.n - 1;
    }

    private final int getRealSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    @Nullable
    public final T get(int x, int y, int z) {
        int pos = this.find(x, y, z);
        return pos < 0 ? this.defRetValue : this.values[pos];
    }

    public final void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        ArraysKt.fill$default((int[])this.keys, (int)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])this.values, null, (int)0, (int)0, (int)6, null);
    }

    public final T getOrPut(int x, int y, int z, @NotNull Function0<? extends T> function0) {
        Object object;
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        if (this.contains(x, y, z)) {
            object = this.get(x, y, z);
        } else {
            Object newValue = function0.invoke();
            this.put(x, y, z, newValue);
            object = newValue;
        }
        return object;
    }

    public final void forEach(@NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super T, Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$forEach = false;
        if (this.getContainsNullKey()) {
            fn.invoke((Object)this.getKeys()[this.getN() * 3], (Object)this.getKeys()[this.getN() * 3 + 1], (Object)this.getKeys()[this.getN() * 3 + 2], this.getValues()[this.getN()]);
        }
        for (int pos = this.getN(); -1 < pos; --pos) {
            if (this.getKeys()[pos * 3] == 0 && this.getKeys()[pos * 3 + 1] == 0 && this.getKeys()[pos * 3 + 2] == 0) continue;
            fn.invoke((Object)this.getKeys()[pos * 3], (Object)this.getKeys()[pos * 3 + 1], (Object)this.getKeys()[pos * 3 + 2], this.getValues()[pos]);
        }
    }

    @Nullable
    public final T put(int x, int y, int z, @Nullable T v) {
        int pos = this.find(x, y, z);
        if (pos < 0) {
            this.insert(-pos - 1, x, y, z, v);
            return this.defRetValue;
        }
        T oldValue = this.values[pos];
        this.values[pos] = v;
        return oldValue;
    }

    @Nullable
    public final T remove(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return this.containsNullKey ? this.removeNullEntry() : this.defRetValue;
        }
        int pos = this.find(x, y, z);
        if (pos < 0) {
            return this.defRetValue;
        }
        return this.removeEntry(pos);
    }

    public final boolean contains(int x, int y, int z) {
        return this.find(x, y, z) >= 0;
    }

    private final T removeNullEntry() {
        this.containsNullKey = false;
        T oldValue = this.values[this.n];
        int n = this.size;
        this.size = n + -1;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private final T removeEntry(int pos) {
        T oldValue = this.values[pos];
        int n = this.size;
        this.size = n + -1;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last2 = 0;
        int slot = 0;
        int curX = 0;
        int curY = 0;
        int curZ = 0;
        int[] key = this.keys;
        while (true) {
            last2 = pos2;
            pos2 = pos2 + 1 & this.getMask();
            while (true) {
                curX = key[pos2 * 3];
                curY = key[pos2 * 3 + 1];
                curZ = key[pos2 * 3 + 2];
                if (curX == 0 && curY == 0 && curZ == 0) {
                    key[last2 * 3] = 0;
                    key[last2 * 3 + 1] = 0;
                    key[last2 * 3 + 2] = 0;
                    return;
                }
                slot = this.hash(curX, curY, curZ) & this.getMask();
                if (last2 <= pos2 ? last2 >= slot || slot > pos2 : last2 >= slot && slot > pos2) break;
                pos2 = pos2 + 1 & this.getMask();
            }
            key[last2 * 3] = curX;
            key[last2 * 3 + 1] = curY;
            key[last2 * 3 + 2] = curZ;
            this.values[last2] = this.values[pos2];
        }
    }

    private final int hash(int x, int y, int z) {
        int hash = 0;
        hash = MurmurHash3.INSTANCE.mix32(x, hash);
        hash = MurmurHash3.INSTANCE.mix32(y, hash);
        hash = MurmurHash3.INSTANCE.mix32(z, hash);
        return MurmurHash3.INSTANCE.fmix32(hash ^= 0xC);
    }

    private final void insert(int pos, int x, int y, int z, T v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        int keyPos = pos * 3;
        this.keys[keyPos] = x;
        this.keys[keyPos + 1] = y;
        this.keys[keyPos + 2] = z;
        this.values[pos] = v;
        int n = this.size;
        this.size = n + 1;
        if (n >= this.maxFill) {
            this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
        }
    }

    private final void rehash(int newN) {
        int[] keys2 = this.keys;
        T[] values2 = this.values;
        int newMask = newN - 1;
        int[] newKey = new int[(newN + 1) * 3];
        Object[] newValue = new Object[newN + 1];
        int pos = 0;
        int j = this.getRealSize();
        int i = this.n * 3;
        while (j-- != 0) {
            do {
            } while (keys2[i -= 3] == 0 && keys2[i + 1] == 0 && keys2[i + 2] == 0);
            int oldPos = i / 3;
            pos = this.hash(keys2[i], keys2[i + 1], keys2[i + 2]) & newMask;
            int keyPos = pos * 3;
            while (newKey[keyPos] != 0 || newKey[keyPos + 1] != 0 || newKey[keyPos + 2] != 0) {
                pos = pos + 1 & newMask;
                keyPos = pos * 3;
            }
            newKey[keyPos] = keys2[i];
            newKey[keyPos + 1] = keys2[i + 1];
            newKey[keyPos + 2] = keys2[i + 2];
            newValue[pos] = values2[oldPos];
        }
        newValue[newN] = values2[this.n];
        this.n = newN;
        this.maxFill = HashCommon.maxFill((int)this.n, (float)this.f);
        this.keys = newKey;
        this.values = newValue;
    }

    private final int find(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] keys2 = this.keys;
        int mask = this.getMask();
        int pos = this.hash(x, y, z) & mask;
        while (true) {
            int keyPos = pos * 3;
            int curX = keys2[keyPos];
            int curY = keys2[keyPos + 1];
            int curZ = keys2[keyPos + 2];
            if (curX == 0 && curY == 0 && curZ == 0) {
                return -(pos + 1);
            }
            if (x == curX && y == curY && z == curZ) {
                return pos;
            }
            pos = pos + 1 & mask;
        }
    }

    public BlockPos2ObjectOpenHashMap() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/core/impl/datastructures/BlockPos2ObjectOpenHashMap$Companion;", "", "", "NUM_KEYS", "I", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

