/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.util.functions.IntTernaryConsumer;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.core.impl.datastructures.DenseBlockPosSet;
import org.valkyrienskies.core.impl.datastructures.FastMinMaxMap;
import org.valkyrienskies.core.impl.datastructures.IBlockPosSet;
import org.valkyrienskies.core.impl.datastructures.IBlockPosSetAABB;
import org.valkyrienskies.core.impl.datastructures.SmallBlockPosSet;

@JsonDeserialize(using=SmallBlockPosSetAABBDeserializer.class)
@JsonSerialize(using=SmallBlockPosSetAABBSerializer.class)
public class BlockPosSetAABBGenerator
implements IBlockPosSetAABB {
    private final IBlockPosSet blockPosSet;
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private final FastMinMaxMap xMap;
    private final FastMinMaxMap yMap;
    private final FastMinMaxMap zMap;

    public BlockPosSetAABBGenerator(ChunkClaim chunkClaim, LevelYRange yRange) {
        this(chunkClaim, yRange, new DenseBlockPosSet());
    }

    public BlockPosSetAABBGenerator(ChunkClaim chunkClaim, LevelYRange yRange, IBlockPosSet backingSet) {
        Vector3i centerCoordinates = chunkClaim.getCenterBlockCoordinates(yRange, new Vector3i());
        Vector3i claimSize = chunkClaim.getBlockSize(yRange, new Vector3i());
        this.blockPosSet = backingSet;
        this.centerX = centerCoordinates.x();
        this.centerY = centerCoordinates.y();
        this.centerZ = centerCoordinates.z();
        this.xSize = claimSize.x();
        this.ySize = claimSize.y();
        this.zSize = claimSize.z();
        this.xMap = new FastMinMaxMap(this.xSize);
        this.yMap = new FastMinMaxMap(this.ySize);
        this.zMap = new FastMinMaxMap(this.zSize);
    }

    public BlockPosSetAABBGenerator(int centerX, int centerY, int centerZ, int xSize, int ySize, int zSize) {
        this(new DenseBlockPosSet(), centerX, centerY, centerZ, xSize, ySize, zSize);
    }

    private BlockPosSetAABBGenerator(IBlockPosSet blockPosSet, int centerX, int centerY, int centerZ, int xSize, int ySize, int zSize) {
        this.blockPosSet = blockPosSet;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.xMap = new FastMinMaxMap(xSize);
        this.yMap = new FastMinMaxMap(ySize);
        this.zMap = new FastMinMaxMap(zSize);
    }

    @Override
    @Nullable
    public AABBi makeAABB() {
        if (this.blockPosSet.isEmpty()) {
            return null;
        }
        int minX = this.xMap.getFront() - this.xSize / 2;
        int maxX = this.xMap.getBack() - this.xSize / 2;
        int minY = this.yMap.getFront() - this.ySize / 2;
        int maxY = this.yMap.getBack() - this.ySize / 2;
        int minZ = this.zMap.getFront() - this.zSize / 2;
        int maxZ = this.zMap.getBack() - this.zSize / 2;
        return new AABBi(minX += this.centerX, minY += this.centerY, minZ += this.centerZ, maxX += this.centerX, maxY += this.centerY, maxZ += this.centerZ);
    }

    @Override
    public boolean add(int x, int y, int z) throws IllegalArgumentException {
        boolean setResult = this.blockPosSet.add(x, y, z);
        if (setResult) {
            this.incrementAABBMaker(x, y, z);
        }
        return setResult;
    }

    private void incrementAABBMaker(int x, int y, int z) {
        this.xMap.increment(x - this.centerX + this.xSize / 2);
        this.yMap.increment(y - this.centerY + this.ySize / 2);
        this.zMap.increment(z - this.centerZ + this.zSize / 2);
    }

    @Override
    public boolean remove(int x, int y, int z) {
        boolean setResult = this.blockPosSet.remove(x, y, z);
        if (setResult) {
            this.decrementAABBMaker(x, y, z);
        }
        return setResult;
    }

    private void decrementAABBMaker(int x, int y, int z) {
        this.xMap.decrement(x - this.centerX + this.xSize / 2);
        this.yMap.decrement(y - this.centerY + this.ySize / 2);
        this.zMap.decrement(z - this.centerZ + this.zSize / 2);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.blockPosSet.contains(x, y, z);
    }

    @Override
    public boolean canStore(int x, int y, int z) {
        return this.blockPosSet.canStore(x, y, z);
    }

    @Override
    public int size() {
        return this.blockPosSet.size();
    }

    @Override
    @Nonnull
    public Iterator<Vector3ic> iterator() {
        return this.blockPosSet.iterator();
    }

    @Override
    public void clear() {
        this.blockPosSet.clear();
        this.xMap.clear();
        this.yMap.clear();
        this.zMap.clear();
    }

    @Override
    public void forEach(@Nonnull IntTernaryConsumer action) {
        this.blockPosSet.forEach(action);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IBlockPosSetAABB) {
            return ((IBlockPosSetAABB)other).size() == this.size() && ((IBlockPosSetAABB)other).containsAll(this);
        }
        return false;
    }

    public static class SmallBlockPosSetAABBDeserializer
    extends StdDeserializer<BlockPosSetAABBGenerator> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        public SmallBlockPosSetAABBDeserializer() {
            super((Class)null);
        }

        @Override
        public BlockPosSetAABBGenerator deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            SmallBlockPosSet blockPosSet = this.objectMapper.treeToValue((TreeNode)node.get("blockPosSet"), SmallBlockPosSet.class);
            int centerX = node.get("centerX").asInt();
            int centerY = node.get("centerY").asInt();
            int centerZ = node.get("centerZ").asInt();
            int xSize = node.get("xSize").asInt();
            int ySize = node.get("ySize").asInt();
            int zSize = node.get("zSize").asInt();
            BlockPosSetAABBGenerator wrapper = new BlockPosSetAABBGenerator(blockPosSet, centerX, centerY, centerZ, xSize, ySize, zSize);
            blockPosSet.forEach((x$0, x$1, x$2) -> wrapper.incrementAABBMaker(x$0, x$1, x$2));
            return wrapper;
        }
    }

    public static class SmallBlockPosSetAABBSerializer
    extends StdSerializer<BlockPosSetAABBGenerator> {
        public SmallBlockPosSetAABBSerializer() {
            super((Class)null);
        }

        @Override
        public void serialize(BlockPosSetAABBGenerator value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("blockPosSet", value.blockPosSet);
            gen.writeNumberField("centerX", value.centerX);
            gen.writeNumberField("centerY", value.centerY);
            gen.writeNumberField("centerZ", value.centerZ);
            gen.writeNumberField("xSize", value.xSize);
            gen.writeNumberField("ySize", value.ySize);
            gen.writeNumberField("zSize", value.zSize);
            gen.writeEndObject();
        }
    }
}

