/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.util.functions.IntTernaryConsumer;
import org.valkyrienskies.core.impl.datastructures.IBlockPosSet;

@JsonDeserialize(using=SmallBlockPosSetDeserializer.class)
@JsonSerialize(using=SmallBlockPosSetSerializer.class)
public class SmallBlockPosSet
implements IBlockPosSet {
    private static final int BOT_12_BITS = 4095;
    private static final int BOT_8_BITS = 255;
    @Nonnull
    private final IntList compressedBlockPosList = new IntArrayList();
    @Nonnull
    private final Int2IntMap listValueToIndex = new Int2IntOpenHashMap();
    private final int centerX;
    private final int centerY;
    private final int centerZ;

    public SmallBlockPosSet(int centerX, int centerY, int centerZ) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
    }

    @Override
    public boolean add(int x, int y, int z) throws IllegalArgumentException {
        if (!this.canStore(x, y, z)) {
            throw new IllegalArgumentException("Cannot store block position at <" + x + "," + y + "," + z + "> into SmallBlockPosSet centered at <" + this.centerX + "," + this.centerY + "," + this.centerZ + ">");
        }
        int compressedPos = this.compress(x, y, z);
        if (this.listValueToIndex.containsKey(compressedPos)) {
            return false;
        }
        this.compressedBlockPosList.add(compressedPos);
        this.listValueToIndex.put(compressedPos, this.compressedBlockPosList.size() - 1);
        return true;
    }

    @Override
    public boolean remove(int x, int y, int z) {
        if (!this.canStore(x, y, z)) {
            throw new IllegalArgumentException("Cannot remove block position at <" + x + "," + y + "," + z + ">");
        }
        int compressedPos = this.compress(x, y, z);
        if (!this.listValueToIndex.containsKey(compressedPos)) {
            return false;
        }
        int elementIndex = this.listValueToIndex.get(compressedPos);
        if (elementIndex == this.compressedBlockPosList.size() - 1) {
            this.compressedBlockPosList.removeInt(elementIndex);
        } else {
            int lastElementValue = this.compressedBlockPosList.removeInt(this.compressedBlockPosList.size() - 1);
            this.compressedBlockPosList.set(elementIndex, lastElementValue);
            this.listValueToIndex.put(lastElementValue, elementIndex);
        }
        this.listValueToIndex.remove(compressedPos);
        return true;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (!this.canStore(x, y, z)) {
            return false;
        }
        return this.listValueToIndex.containsKey(this.compress(x, y, z));
    }

    @Override
    public boolean canStore(int x, int y, int z) {
        int xLocal = x - this.centerX;
        int yLocal = y - this.centerY;
        int zLocal = z - this.centerZ;
        return !(yLocal < -128 | yLocal > 127 | xLocal < -2048 | xLocal > 2047 | zLocal < -2048 | zLocal > 2047);
    }

    @Override
    public int size() {
        return this.compressedBlockPosList.size();
    }

    @Override
    @Nonnull
    public Iterator<Vector3ic> iterator() {
        return new SmallBlockPosIterator((IntIterator)this.compressedBlockPosList.iterator());
    }

    @Override
    public void forEach(@Nonnull IntTernaryConsumer action) {
        IntListIterator iterator2 = this.compressedBlockPosList.iterator();
        while (iterator2.hasNext()) {
            int compressed = iterator2.nextInt();
            int z = compressed >> 20;
            int y = compressed >> 12 & 0xFF;
            if ((y & 0x80) != 0) {
                y |= 0xFFFFFF00;
            }
            int x = (compressed & 0xFFF) << 20 >> 20;
            action.accept(x + this.centerX, y + this.centerY, z + this.centerZ);
        }
    }

    @Override
    public void clear() {
        this.compressedBlockPosList.clear();
        this.listValueToIndex.clear();
    }

    @Nonnull
    private Vector3ic decompress(int compressed) {
        return this.decompressMutable(compressed, new Vector3i());
    }

    private Vector3i decompressMutable(int compressed, Vector3i mutableBlockPos) {
        int z = compressed >> 20;
        int y = compressed >> 12 & 0xFF;
        if ((y & 0x80) != 0) {
            y |= 0xFFFFFF00;
        }
        int x = (compressed & 0xFFF) << 20 >> 20;
        mutableBlockPos.set(x + this.centerX, y + this.centerY, z + this.centerZ);
        return mutableBlockPos;
    }

    private int compress(int x, int y, int z) {
        int xBits = x - this.centerX & 0xFFF;
        int yBits = y - this.centerY & 0xFF;
        int zBits = z - this.centerZ & 0xFFF;
        return xBits | yBits << 12 | zBits << 20;
    }

    @Override
    public void forEachUnsafe(@Nonnull IntTernaryConsumer action) {
        Vector3i mutableBlockPos = new Vector3i();
        for (int curIndex = 0; this.compressedBlockPosList.size() >= curIndex; ++curIndex) {
            try {
                int currentValue = this.compressedBlockPosList.get(curIndex);
                this.decompressMutable(currentValue, mutableBlockPos);
                action.accept(mutableBlockPos.x(), mutableBlockPos.y(), mutableBlockPos.z());
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IBlockPosSet) {
            return ((IBlockPosSet)other).size() == this.size() && ((IBlockPosSet)other).containsAll(this);
        }
        return false;
    }

    private class SmallBlockPosIterator
    implements Iterator<Vector3ic> {
        private final IntIterator iterator;

        SmallBlockPosIterator(IntIterator intIterator) {
            this.iterator = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Vector3ic next() {
            return SmallBlockPosSet.this.decompress(this.iterator.next());
        }
    }

    public static class SmallBlockPosSetDeserializer
    extends StdDeserializer<SmallBlockPosSet> {
        public SmallBlockPosSetDeserializer() {
            super((Class)null);
        }

        @Override
        public SmallBlockPosSet deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            int centerX = node.get("centerX").asInt();
            int centerY = node.get("centerY").asInt();
            int centerZ = node.get("centerZ").asInt();
            SmallBlockPosSet set = new SmallBlockPosSet(centerX, centerY, centerZ);
            for (JsonNode elem : node.get("positions")) {
                int positionInt = elem.asInt();
                set.compressedBlockPosList.add(positionInt);
                set.listValueToIndex.put(positionInt, set.compressedBlockPosList.size() - 1);
            }
            return set;
        }
    }

    public static class SmallBlockPosSetSerializer
    extends StdSerializer<SmallBlockPosSet> {
        public SmallBlockPosSetSerializer() {
            super((Class)null);
        }

        @Override
        public void serialize(SmallBlockPosSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("positions");
            gen.writeStartArray(value.compressedBlockPosList, value.compressedBlockPosList.size());
            IntListIterator iter = value.compressedBlockPosList.iterator();
            while (iter.hasNext()) {
                gen.writeNumber(iter.nextInt());
            }
            gen.writeEndArray();
            gen.writeNumberField("centerX", value.centerX);
            gen.writeNumberField("centerY", value.centerY);
            gen.writeNumberField("centerZ", value.centerZ);
            gen.writeEndObject();
        }
    }
}

