/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.impl.game.ChunkClaimImpl;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0087\b\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b0\u00101J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c2\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\bH\u00c2\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c2\u0003\u00a2\u0006\u0004\b\f\u0010\u0007J.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\nJ%\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001dJ\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001b\u0010 J\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\u001b\u0010#J\u001d\u0010&\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010&\u001a\u00020\u00132\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b&\u0010*J\u0010\u0010,\u001a\u00020+H\u00d6\u0001\u00a2\u0006\u0004\b,\u0010-R\u0016\u0010\r\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010.R\u0016\u0010\u000e\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010.R\u0016\u0010\u000f\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010/\u00a8\u00063"}, d2={"Lorg/valkyrienskies/core/impl/game/ChunkAllocator;", "", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "allocateNewChunkClaim", "()Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "", "allocateShipId", "()J", "", "component1", "()I", "component2", "component3", "nextClaimX", "nextClaimZ", "nextShipId", "copy", "(IIJ)Lorg/valkyrienskies/core/impl/game/ChunkAllocator;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "posX", "posY", "posZ", "isBlockInShipyard", "(DDD)Z", "(III)Z", "Lorg/joml/Vector3dc;", "pos", "(Lorg/joml/Vector3dc;)Z", "Lorg/joml/Vector3ic;", "blockPos", "(Lorg/joml/Vector3ic;)Z", "chunkX", "chunkZ", "isChunkInShipyard", "(II)Z", "Lorg/joml/Vector2i;", "chunkPos", "(Lorg/joml/Vector2i;)Z", "", "toString", "()Ljava/lang/String;", "I", "J", "<init>", "(IIJ)V", "Companion", "impl"})
public final class ChunkAllocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int nextClaimX;
    private int nextClaimZ;
    private long nextShipId;
    public static final int X_INDEX_START = -7000;
    public static final int X_INDEX_END = 7000;
    public static final int Z_INDEX_START = 3000;
    public static final int Z_INDEX_END = 7000;
    public static final long SHIP_ID_START = 0L;

    public ChunkAllocator(int nextClaimX, int nextClaimZ, long nextShipId) {
        this.nextClaimX = nextClaimX;
        this.nextClaimZ = nextClaimZ;
        this.nextShipId = nextShipId;
    }

    public final boolean isChunkInShipyard(int chunkX, int chunkZ) {
        int claimXIndex = ChunkClaim.Companion.getClaimXIndex(chunkX);
        int claimZIndex = ChunkClaim.Companion.getClaimZIndex(chunkZ);
        return (-7000 <= claimXIndex ? claimXIndex < 7001 : false) & (3000 <= claimZIndex ? claimZIndex < 7001 : false);
    }

    public final boolean isChunkInShipyard(@NotNull Vector2i chunkPos) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        return this.isChunkInShipyard(chunkPos.x, chunkPos.y);
    }

    public final boolean isBlockInShipyard(int posX, int posY, int posZ) {
        return this.isChunkInShipyard(posX >> 4, posZ >> 4);
    }

    public final boolean isBlockInShipyard(double posX, double posY, double posZ) {
        return this.isChunkInShipyard((int)posX >> 4, (int)posZ >> 4);
    }

    public final boolean isBlockInShipyard(@NotNull Vector3ic blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return this.isBlockInShipyard(blockPos.x(), blockPos.y(), blockPos.z());
    }

    public final boolean isBlockInShipyard(@NotNull Vector3dc pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.isBlockInShipyard(pos.x(), pos.y(), pos.z());
    }

    public final long allocateShipId() {
        long l = this.nextShipId;
        this.nextShipId = l + 1L;
        return l;
    }

    @NotNull
    public final ChunkClaim allocateNewChunkClaim() {
        ChunkClaimImpl nextClaim = new ChunkClaimImpl(this.nextClaimX, this.nextClaimZ);
        int n = this.nextClaimX;
        this.nextClaimX = n + 1;
        if (this.nextClaimX > 7000) {
            this.nextClaimX = -7000;
            n = this.nextClaimZ;
            this.nextClaimZ = n + 1;
        }
        if (!(3000 <= (n = this.nextClaimZ) ? n < 7001 : false)) {
            throw new IllegalStateException("We ran out of chunk claims to allocate!");
        }
        return nextClaim;
    }

    private final int component1() {
        return this.nextClaimX;
    }

    private final int component2() {
        return this.nextClaimZ;
    }

    private final long component3() {
        return this.nextShipId;
    }

    @NotNull
    public final ChunkAllocator copy(int nextClaimX, int nextClaimZ, long nextShipId) {
        return new ChunkAllocator(nextClaimX, nextClaimZ, nextShipId);
    }

    public static /* synthetic */ ChunkAllocator copy$default(ChunkAllocator chunkAllocator, int n, int n2, long l, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = chunkAllocator.nextClaimX;
        }
        if ((n3 & 2) != 0) {
            n2 = chunkAllocator.nextClaimZ;
        }
        if ((n3 & 4) != 0) {
            l = chunkAllocator.nextShipId;
        }
        return chunkAllocator.copy(n, n2, l);
    }

    @NotNull
    public String toString() {
        return "ChunkAllocator(nextClaimX=" + this.nextClaimX + ", nextClaimZ=" + this.nextClaimZ + ", nextShipId=" + this.nextShipId + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.nextClaimX);
        result2 = result2 * 31 + Integer.hashCode(this.nextClaimZ);
        result2 = result2 * 31 + Long.hashCode(this.nextShipId);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChunkAllocator)) {
            return false;
        }
        ChunkAllocator chunkAllocator = (ChunkAllocator)other;
        if (this.nextClaimX != chunkAllocator.nextClaimX) {
            return false;
        }
        if (this.nextClaimZ != chunkAllocator.nextClaimZ) {
            return false;
        }
        return this.nextShipId == chunkAllocator.nextShipId;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/valkyrienskies/core/impl/game/ChunkAllocator$Companion;", "", "Lorg/valkyrienskies/core/impl/game/ChunkAllocator;", "create", "()Lorg/valkyrienskies/core/impl/game/ChunkAllocator;", "", "SHIP_ID_START", "J", "", "X_INDEX_END", "I", "X_INDEX_START", "Z_INDEX_END", "Z_INDEX_START", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChunkAllocator create() {
            return new ChunkAllocator(-7000, 3000, 0L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

