/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.api.ShipInternal;
import org.valkyrienskies.core.impl.game.ships.ShipPhysicsData;
import org.valkyrienskies.core.impl.util.AABBdUtilKt;
import org.valkyrienskies.core.impl.util.serialization.DeltaIgnore;
import org.valkyrienskies.core.impl.util.serialization.PacketIgnore;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001Bg\u0012\n\u0010+\u001a\u00060)j\u0002`*\u0012\b\u0010I\u001a\u0004\u0018\u00010#\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\n\u0010%\u001a\u00060#j\u0002`$\u0012\u0006\u00104\u001a\u000203\u0012\u0006\u0010M\u001a\u000208\u0012\b\b\u0002\u0010Z\u001a\u000208\u0012\b\b\u0002\u0010T\u001a\u00020S\u0012\b\u0010?\u001a\u0004\u0018\u00010>\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b[\u0010\\J\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJO\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\u001e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001e\u0010%\u001a\u00060#j\u0002`$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001e\u0010+\u001a\u00060)j\u0002`*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0014\u00102\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00104\u001a\u0002038\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R$\u0010:\u001a\u0002082\u0006\u00109\u001a\u0002088\u0006@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R$\u0010?\u001a\u0004\u0018\u00010>8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0014\u0010H\u001a\u00020E8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR$\u0010I\u001a\u0004\u0018\u00010#8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010&\u001a\u0004\bJ\u0010(\"\u0004\bK\u0010LR*\u0010M\u001a\u0002082\u0006\u0010M\u001a\u0002088\u0016@VX\u0097\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010;\u001a\u0004\bN\u0010=\"\u0004\bO\u0010PR\u0014\u0010R\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u00101R$\u0010T\u001a\u00020S2\u0006\u00109\u001a\u00020S8\u0006@BX\u0087\u000e\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u0010WR\u0014\u0010Y\u001a\u00020E8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010G\u00a8\u0006]"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "Lorg/valkyrienskies/core/impl/api/ShipInternal;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "updatePrevTickShipTransform", "()V", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "activeChunksSet", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "getActiveChunksSet", "()Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "getChunkClaim", "()Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "chunkClaimDimension", "Ljava/lang/String;", "getChunkClaimDimension", "()Ljava/lang/String;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "id", "J", "getId", "()J", "Lorg/joml/Vector3dc;", "getOmega", "()Lorg/joml/Vector3dc;", "omega", "Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "physicsData", "Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "getPhysicsData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "<set-?>", "prevTickTransform", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getPrevTickTransform", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/primitives/AABBic;", "shipAABB", "Lorg/joml/primitives/AABBic;", "getShipAABB", "()Lorg/joml/primitives/AABBic;", "setShipAABB", "(Lorg/joml/primitives/AABBic;)V", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "slug", "getSlug", "setSlug", "(Ljava/lang/String;)V", "transform", "getTransform", "setTransform", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;)V", "getVelocity", "velocity", "Lorg/joml/primitives/AABBdc;", "worldAABB", "Lorg/joml/primitives/AABBdc;", "getWorldAABB", "()Lorg/joml/primitives/AABBdc;", "getWorldToShip", "worldToShip", "prevTickShipTransform", "<init>", "(JLjava/lang/String;Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/String;Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/joml/primitives/AABBdc;Lorg/joml/primitives/AABBic;Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;)V", "impl"})
public class ShipDataCommon
implements ShipInternal {
    private final long id;
    @Nullable
    private String slug;
    @NotNull
    private final ChunkClaim chunkClaim;
    @NotNull
    private final String chunkClaimDimension;
    @DeltaIgnore
    @NotNull
    private final ShipPhysicsData physicsData;
    @Nullable
    private AABBic shipAABB;
    @NotNull
    private final IShipActiveChunksSet activeChunksSet;
    @DeltaIgnore
    @NotNull
    private ShipTransform transform;
    @PacketIgnore
    @NotNull
    private ShipTransform prevTickTransform;
    @DeltaIgnore
    @NotNull
    private AABBdc worldAABB;

    public ShipDataCommon(long id, @Nullable String slug, @NotNull ChunkClaim chunkClaim, @NotNull String chunkClaimDimension, @NotNull ShipPhysicsData physicsData, @NotNull ShipTransform transform2, @NotNull ShipTransform prevTickShipTransform, @NotNull AABBdc worldAABB, @Nullable AABBic shipAABB, @NotNull IShipActiveChunksSet activeChunksSet) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"chunkClaim");
        Intrinsics.checkNotNullParameter((Object)chunkClaimDimension, (String)"chunkClaimDimension");
        Intrinsics.checkNotNullParameter((Object)physicsData, (String)"physicsData");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)prevTickShipTransform, (String)"prevTickShipTransform");
        Intrinsics.checkNotNullParameter((Object)worldAABB, (String)"worldAABB");
        Intrinsics.checkNotNullParameter((Object)activeChunksSet, (String)"activeChunksSet");
        this.id = id;
        this.slug = slug;
        this.chunkClaim = chunkClaim;
        this.chunkClaimDimension = chunkClaimDimension;
        this.physicsData = physicsData;
        this.shipAABB = shipAABB;
        this.activeChunksSet = activeChunksSet;
        this.transform = transform2;
        this.prevTickTransform = prevTickShipTransform;
        this.worldAABB = worldAABB;
    }

    public /* synthetic */ ShipDataCommon(long l, String string, ChunkClaim chunkClaim, String string2, ShipPhysicsData shipPhysicsData, ShipTransform shipTransform, ShipTransform shipTransform2, AABBdc aABBdc, AABBic aABBic, IShipActiveChunksSet iShipActiveChunksSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            shipTransform2 = shipTransform;
        }
        if ((n & 0x80) != 0) {
            aABBdc = shipTransform.createEmptyAABB();
        }
        this(l, string, chunkClaim, string2, shipPhysicsData, shipTransform, shipTransform2, aABBdc, aABBic, iShipActiveChunksSet);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getSlug() {
        return this.slug;
    }

    public void setSlug(@Nullable String string) {
        this.slug = string;
    }

    @Override
    @NotNull
    public ChunkClaim getChunkClaim() {
        return this.chunkClaim;
    }

    @Override
    @NotNull
    public String getChunkClaimDimension() {
        return this.chunkClaimDimension;
    }

    @NotNull
    public final ShipPhysicsData getPhysicsData() {
        return this.physicsData;
    }

    @Override
    @Nullable
    public AABBic getShipAABB() {
        return this.shipAABB;
    }

    public void setShipAABB(@Nullable AABBic aABBic) {
        this.shipAABB = aABBic;
    }

    @Override
    @NotNull
    public IShipActiveChunksSet getActiveChunksSet() {
        return this.activeChunksSet;
    }

    @Override
    @NotNull
    public Vector3dc getVelocity() {
        return this.physicsData.getLinearVelocity();
    }

    @Override
    @NotNull
    public Vector3dc getOmega() {
        return this.physicsData.getAngularVelocity();
    }

    @Override
    @NotNull
    public ShipTransform getTransform() {
        return this.transform;
    }

    public void setTransform(@NotNull ShipTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        this.transform = transform2;
        Object object = this.getShipAABB();
        AABBd aABBd = object != null && (object = AABBdUtilKt.toAABBd((AABBic)object, new AABBd())) != null ? ((AABBd)object).transform(transform2.getShipToWorld(), new AABBd()) : null;
        this.worldAABB = aABBd == null ? transform2.createEmptyAABB() : (AABBdc)aABBd;
    }

    @Override
    @NotNull
    public final ShipTransform getPrevTickTransform() {
        return this.prevTickTransform;
    }

    @Override
    @NotNull
    public final AABBdc getWorldAABB() {
        return this.worldAABB;
    }

    public final void updatePrevTickShipTransform() {
        this.prevTickTransform = this.getTransform();
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, @NotNull BlockType oldBlockType, @NotNull BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"oldBlockType");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"newBlockType");
        if (!this.getChunkClaim().contains(posX >> 4, posZ >> 4)) {
            boolean bl = false;
            String string = "Block at <" + posX + ", " + posY + ", " + posZ + "> is not in the chunk claim belonging to " + this;
            throw new IllegalArgumentException(string.toString());
        }
        this.getActiveChunksSet().add(posX >> 4, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) - 1, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) + 1, posZ >> 4);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) - 1);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) + 1);
    }

    @Override
    @NotNull
    public Matrix4dc getShipToWorld() {
        return this.getTransform().getShipToWorld();
    }

    @Override
    @NotNull
    public Matrix4dc getWorldToShip() {
        return this.getTransform().getWorldToShip();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipDataCommon");
        ShipDataCommon cfr_ignored_0 = (ShipDataCommon)other;
        return this.getId() == ((ShipDataCommon)other).getId();
    }

    public int hashCode() {
        return Long.hashCode(this.getId());
    }
}

