/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.impl.game.ships.PhysInertia;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001AB\u001f\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\u0002\u0012\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b?\u0010@J/\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u00c2\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c2\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00c2\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u000fH\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!J5\u0010'\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0002\u00a2\u0006\u0004\b'\u0010(J5\u0010)\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0002\u00a2\u0006\u0004\b)\u0010(J\u0010\u0010+\u001a\u00020*H\u00d6\u0001\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b-\u0010.R\u0014\u0010\u0012\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010/R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u00100R\u0014\u0010\u0014\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00101R\u0014\u00105\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00107\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u000eR\u0016\u00108\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00101R\u0014\u0010<\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010>\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010;\u00a8\u0006B"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "Lorg/valkyrienskies/core/api/ships/properties/ShipInertiaData;", "", "x", "y", "z", "addedMass", "", "addMassAt", "(DDDD)V", "Lorg/joml/Vector3d;", "component1", "()Lorg/joml/Vector3d;", "component2", "()D", "Lorg/joml/Matrix3d;", "component3", "()Lorg/joml/Matrix3d;", "_centerOfMassInShip", "_mass", "_momentOfInertiaTensor", "copy", "(Lorg/joml/Vector3d;DLorg/joml/Matrix3d;)Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "Lorg/valkyrienskies/core/impl/game/ships/PhysInertia;", "copyToPhyInertia", "()Lorg/valkyrienskies/core/impl/game/ships/PhysInertia;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "posX", "posY", "posZ", "oldBlockMass", "newBlockMass", "onSetBlock", "(IIIDD)V", "onSetBlockUseSphereMOI", "", "toString", "()Ljava/lang/String;", "updateSphericalMOI", "()V", "Lorg/joml/Vector3d;", "D", "Lorg/joml/Matrix3d;", "Lorg/joml/Vector3dc;", "getCenterOfMassInShip", "()Lorg/joml/Vector3dc;", "centerOfMassInShip", "getMass", "mass", "momentOfInertiaSpherical", "Lorg/joml/Matrix3dc;", "getMomentOfInertiaTensor", "()Lorg/joml/Matrix3dc;", "momentOfInertiaTensor", "getMomentOfInertiaTensorToSave", "momentOfInertiaTensorToSave", "<init>", "(Lorg/joml/Vector3d;DLorg/joml/Matrix3d;)V", "Companion", "impl"})
public final class ShipInertiaDataImpl
implements ShipInertiaData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3d _centerOfMassInShip;
    private double _mass;
    @NotNull
    private final Matrix3d _momentOfInertiaTensor;
    @NotNull
    private Matrix3d momentOfInertiaSpherical;
    private static final double EPSILON = 1.0E-6;
    private static final double INERTIA_OFFSET = 0.4;

    public ShipInertiaDataImpl(@NotNull Vector3d _centerOfMassInShip, double _mass, @NotNull Matrix3d _momentOfInertiaTensor) {
        Intrinsics.checkNotNullParameter((Object)_centerOfMassInShip, (String)"_centerOfMassInShip");
        Intrinsics.checkNotNullParameter((Object)_momentOfInertiaTensor, (String)"_momentOfInertiaTensor");
        this._centerOfMassInShip = _centerOfMassInShip;
        this._mass = _mass;
        this._momentOfInertiaTensor = _momentOfInertiaTensor;
        this.momentOfInertiaSpherical = new Matrix3d(this._momentOfInertiaTensor);
        this.updateSphericalMOI();
    }

    @Override
    @NotNull
    public Matrix3dc getMomentOfInertiaTensor() {
        return this.momentOfInertiaSpherical;
    }

    @Override
    @NotNull
    public Matrix3dc getMomentOfInertiaTensorToSave() {
        return this._momentOfInertiaTensor;
    }

    @Override
    @NotNull
    public Vector3dc getCenterOfMassInShip() {
        return this._centerOfMassInShip;
    }

    @Override
    public double getMass() {
        return this._mass;
    }

    public final void onSetBlock(int posX, int posY, int posZ, double oldBlockMass, double newBlockMass) {
        double deltaBlockMass = newBlockMass - oldBlockMass;
        if (Math.abs(deltaBlockMass) < 1.0E-6) {
            return;
        }
        double addedMassAtEachPoint = deltaBlockMass / 8.0;
        this.addMassAt((double)posX + 0.4, (double)posY + 0.4, (double)posZ + 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX + 0.4, (double)posY + 0.4, (double)posZ - 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX + 0.4, (double)posY - 0.4, (double)posZ + 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX + 0.4, (double)posY - 0.4, (double)posZ - 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX - 0.4, (double)posY + 0.4, (double)posZ + 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX - 0.4, (double)posY + 0.4, (double)posZ - 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX - 0.4, (double)posY - 0.4, (double)posZ + 0.4, addedMassAtEachPoint);
        this.addMassAt((double)posX - 0.4, (double)posY - 0.4, (double)posZ - 0.4, addedMassAtEachPoint);
    }

    public final void onSetBlockUseSphereMOI(int posX, int posY, int posZ, double oldBlockMass, double newBlockMass) {
        this.onSetBlock(posX, posY, posZ, oldBlockMass, newBlockMass);
        this.updateSphericalMOI();
    }

    private final void updateSphericalMOI() {
        double inertiaAlongX = this._momentOfInertiaTensor.transform(new Vector3d(1.0, 0.0, 0.0)).length();
        double inertiaAlongY = this._momentOfInertiaTensor.transform(new Vector3d(0.0, 1.0, 0.0)).length();
        double inertiaAlongZ = this._momentOfInertiaTensor.transform(new Vector3d(0.0, 0.0, 1.0)).length();
        double avgInertia = (inertiaAlongX + inertiaAlongY + inertiaAlongZ) / 3.0;
        this.momentOfInertiaSpherical.identity().scale(avgInertia);
    }

    private final void addMassAt(double x, double y, double z, double addedMass) {
        double[] gameMoITensor = new double[9];
        Matrix3d matrix3d = this._momentOfInertiaTensor.transpose(new Matrix3d());
        Intrinsics.checkNotNullExpressionValue((Object)matrix3d, (String)"_momentOfInertiaTensor.transpose(Matrix3d())");
        Matrix3d transposed = matrix3d;
        transposed.get(gameMoITensor);
        double gameTickMass = this.getMass();
        Vector3d prevCenterOfMass = new Vector3d(this.getCenterOfMassInShip());
        if (gameTickMass + addedMass > 1.0E-6) {
            Vector3d vector3d = this.getCenterOfMassInShip().mul(gameTickMass, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"centerOfMassInShip.mul(gameTickMass, Vector3d())");
            Vector3d newCenterOfMass = vector3d;
            newCenterOfMass.add(x * addedMass, y * addedMass, z * addedMass);
            newCenterOfMass.mul(1.0 / (gameTickMass + addedMass));
            this._centerOfMassInShip.set(newCenterOfMass);
            double cmShiftX = prevCenterOfMass.x - this.getCenterOfMassInShip().x();
            double cmShiftY = prevCenterOfMass.y - this.getCenterOfMassInShip().y();
            double cmShiftZ = prevCenterOfMass.z - this.getCenterOfMassInShip().z();
            double rx = x - this.getCenterOfMassInShip().x();
            double ry = y - this.getCenterOfMassInShip().y();
            double rz = z - this.getCenterOfMassInShip().z();
            gameMoITensor[0] = gameMoITensor[0] + (cmShiftY * cmShiftY + cmShiftZ * cmShiftZ) * gameTickMass + (ry * ry + rz * rz) * addedMass;
            gameMoITensor[1] = gameMoITensor[1] - cmShiftX * cmShiftY * gameTickMass - rx * ry * addedMass;
            gameMoITensor[2] = gameMoITensor[2] - cmShiftX * cmShiftZ * gameTickMass - rx * rz * addedMass;
            gameMoITensor[3] = gameMoITensor[1];
            gameMoITensor[4] = gameMoITensor[4] + (cmShiftX * cmShiftX + cmShiftZ * cmShiftZ) * gameTickMass + (rx * rx + rz * rz) * addedMass;
            gameMoITensor[5] = gameMoITensor[5] - cmShiftY * cmShiftZ * gameTickMass - ry * rz * addedMass;
            gameMoITensor[6] = gameMoITensor[2];
            gameMoITensor[7] = gameMoITensor[5];
            gameMoITensor[8] = gameMoITensor[8] + (cmShiftX * cmShiftX + cmShiftY * cmShiftY) * gameTickMass + (rx * rx + ry * ry) * addedMass;
            this._momentOfInertiaTensor.set(gameMoITensor).transpose();
            this._mass += addedMass;
        } else {
            this._centerOfMassInShip.set(x, y, z);
            this._momentOfInertiaTensor.zero();
            this._mass = 0.0;
        }
    }

    @NotNull
    public final PhysInertia copyToPhyInertia() {
        return new PhysInertia(this.getMass(), new Matrix3d(this._momentOfInertiaTensor));
    }

    private final Vector3d component1() {
        return this._centerOfMassInShip;
    }

    private final double component2() {
        return this._mass;
    }

    private final Matrix3d component3() {
        return this._momentOfInertiaTensor;
    }

    @NotNull
    public final ShipInertiaDataImpl copy(@NotNull Vector3d _centerOfMassInShip, double _mass, @NotNull Matrix3d _momentOfInertiaTensor) {
        Intrinsics.checkNotNullParameter((Object)_centerOfMassInShip, (String)"_centerOfMassInShip");
        Intrinsics.checkNotNullParameter((Object)_momentOfInertiaTensor, (String)"_momentOfInertiaTensor");
        return new ShipInertiaDataImpl(_centerOfMassInShip, _mass, _momentOfInertiaTensor);
    }

    public static /* synthetic */ ShipInertiaDataImpl copy$default(ShipInertiaDataImpl shipInertiaDataImpl, Vector3d vector3d, double d, Matrix3d matrix3d, int n, Object object) {
        if ((n & 1) != 0) {
            vector3d = shipInertiaDataImpl._centerOfMassInShip;
        }
        if ((n & 2) != 0) {
            d = shipInertiaDataImpl._mass;
        }
        if ((n & 4) != 0) {
            matrix3d = shipInertiaDataImpl._momentOfInertiaTensor;
        }
        return shipInertiaDataImpl.copy(vector3d, d, matrix3d);
    }

    @NotNull
    public String toString() {
        return "ShipInertiaDataImpl(_centerOfMassInShip=" + this._centerOfMassInShip + ", _mass=" + this._mass + ", _momentOfInertiaTensor=" + this._momentOfInertiaTensor + ')';
    }

    public int hashCode() {
        int result2 = this._centerOfMassInShip.hashCode();
        result2 = result2 * 31 + Double.hashCode(this._mass);
        result2 = result2 * 31 + this._momentOfInertiaTensor.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShipInertiaDataImpl)) {
            return false;
        }
        ShipInertiaDataImpl shipInertiaDataImpl = (ShipInertiaDataImpl)other;
        if (!Intrinsics.areEqual((Object)this._centerOfMassInShip, (Object)shipInertiaDataImpl._centerOfMassInShip)) {
            return false;
        }
        if (Double.compare(this._mass, shipInertiaDataImpl._mass) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this._momentOfInertiaTensor, (Object)shipInertiaDataImpl._momentOfInertiaTensor);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl$Companion;", "", "Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "newEmptyShipInertiaData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "", "EPSILON", "D", "INERTIA_OFFSET", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShipInertiaDataImpl newEmptyShipInertiaData() {
            return new ShipInertiaDataImpl(new Vector3d(), 0.0, new Matrix3d());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

