/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.WingManager;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.api.LoadedServerShipInternal;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.api.ServerShipUser;
import org.valkyrienskies.core.impl.api.ShipForcesInducer;
import org.valkyrienskies.core.impl.api.Ticked;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipObject;
import org.valkyrienskies.core.impl.game.ships.WingManagerImpl;
import org.valkyrienskies.core.impl.networking.delta.DeltaAlgorithm;
import org.valkyrienskies.core.impl.networking.delta.DeltaEncodedChannelServerTCP;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0011\u0012\u0006\u0010b\u001a\u00020a\u00a2\u0006\u0006\b\u008a\u0001\u0010\u008b\u0001J%\u0010\t\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u0096\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0012\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0096\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018JP\u0010#\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0004\b#\u0010$J \u0010%\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0096\u0001\u00a2\u0006\u0004\b%\u0010\u0018J-\u0010&\u001a\u00020\b\"\u0004\b\u0000\u0010\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b&\u0010\nJ-\u0010'\u001a\u00020\b\"\u0004\b\u0000\u0010\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b'\u0010\nJ\u0017\u0010*\u001a\u00020\b2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b*\u0010+J0\u0010-\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0004\b-\u0010.R\u0014\u00102\u001a\u00020/8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u00101R;\u00105\u001a&\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00060\u0006 4*\u0012\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00060\u0006\u0018\u000103038\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0014\u0010<\u001a\u0002098\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0018\u0010A\u001a\u00060=j\u0002`>8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR\u0018\u0010L\u001a\u00060Hj\u0002`I8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0014\u0010P\u001a\u00020M8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0014\u0010T\u001a\u00020Q8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010X\u001a\u00020U8VX\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u0014\u0010Z\u001a\u00020U8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bY\u0010WR\u0016\u0010^\u001a\u0004\u0018\u00010[8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u0014\u0010`\u001a\u00020/8VX\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\b_\u00101R\u001a\u0010b\u001a\u00020a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bb\u0010c\u001a\u0004\bd\u0010eR\u001d\u0010h\u001a\b\u0012\u0004\u0012\u00020g0f8\u0006\u00a2\u0006\f\n\u0004\bh\u0010i\u001a\u0004\bj\u0010kR$\u0010m\u001a\u00020\u00142\u0006\u0010l\u001a\u00020\u00148\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\bm\u0010n\u001a\u0004\bo\u0010pR\u0014\u0010t\u001a\u00020q8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\br\u0010sR\u0014\u0010v\u001a\u00020U8VX\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bu\u0010WR\u0016\u0010x\u001a\u0004\u0018\u00010[8VX\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bw\u0010]R\u001e\u0010|\u001a\u0004\u0018\u00010=8\u0016@\u0016X\u0096\u000f\u00a2\u0006\f\u001a\u0004\by\u0010@\"\u0004\bz\u0010{R\u001d\u0010~\u001a\b\u0012\u0004\u0012\u00020}0B8\u0006\u00a2\u0006\f\n\u0004\b~\u0010E\u001a\u0004\b\u007f\u0010GR\u0016\u0010\u0081\u0001\u001a\u00020U8\u0016X\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u0010WR\u0016\u0010\u0083\u0001\u001a\u00020Q8\u0016X\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010SR\u0018\u0010\u0087\u0001\u001a\u00030\u0084\u00018\u0016X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R\u0016\u0010\u0089\u0001\u001a\u00020q8VX\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u0088\u0001\u0010s\u00a8\u0006\u008c\u0001"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServer;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObject;", "Lorg/valkyrienskies/core/impl/api/LoadedServerShipInternal;", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "Ljava/lang/Class;", "clazz", "", "value", "", "applyAttachmentInterfaces", "(Ljava/lang/Class;Ljava/lang/Object;)V", "", "areVoxelsFullyLoaded", "()Z", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "asShipDataCommon", "()Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "T", "getAttachment", "(Ljava/lang/Class;)Ljava/lang/Object;", "", "chunkX", "chunkZ", "onLoadChunk", "(II)V", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "onUnloadChunk", "saveAttachment", "setAttachment", "Lorg/valkyrienskies/core/apigame/ShipTeleportData;", "teleportData", "teleportShip", "(Lorg/valkyrienskies/core/apigame/ShipTeleportData;)V", "set", "updateShipAABBGenerator", "(IIIZ)V", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "getActiveChunksSet", "()Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "activeChunksSet", "Lcom/google/common/collect/MutableClassToInstanceMap;", "kotlin.jvm.PlatformType", "attachedData", "Lcom/google/common/collect/MutableClassToInstanceMap;", "getAttachedData", "()Lcom/google/common/collect/MutableClassToInstanceMap;", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "getChunkClaim", "()Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "getChunkClaimDimension", "()Ljava/lang/String;", "chunkClaimDimension", "", "Lorg/valkyrienskies/core/impl/api/ShipForcesInducer;", "forceInducers", "Ljava/util/List;", "getForceInducers", "()Ljava/util/List;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "getId", "()J", "id", "Lorg/valkyrienskies/core/api/ships/properties/ShipInertiaData;", "getInertiaData", "()Lorg/valkyrienskies/core/api/ships/properties/ShipInertiaData;", "inertiaData", "Lorg/joml/Vector3dc;", "getOmega", "()Lorg/joml/Vector3dc;", "omega", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getPrevTickShipTransform", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "prevTickShipTransform", "getPrevTickTransform", "prevTickTransform", "Lorg/joml/primitives/AABBic;", "getShipAABB", "()Lorg/joml/primitives/AABBic;", "shipAABB", "getShipActiveChunksSet", "shipActiveChunksSet", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "shipData", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "getShipData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "Lorg/valkyrienskies/core/impl/networking/delta/DeltaEncodedChannelServerTCP;", "Lcom/fasterxml/jackson/databind/JsonNode;", "shipDataChannel", "Lorg/valkyrienskies/core/impl/networking/delta/DeltaEncodedChannelServerTCP;", "getShipDataChannel", "()Lorg/valkyrienskies/core/impl/networking/delta/DeltaEncodedChannelServerTCP;", "<set-?>", "shipTeleportId", "I", "getShipTeleportId", "()I", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "getShipTransform", "shipTransform", "getShipVoxelAABB", "shipVoxelAABB", "getSlug", "setSlug", "(Ljava/lang/String;)V", "slug", "Lorg/valkyrienskies/core/impl/api/Ticked;", "toBeTicked", "getToBeTicked", "getTransform", "transform", "getVelocity", "velocity", "Lorg/joml/primitives/AABBdc;", "getWorldAABB", "()Lorg/joml/primitives/AABBdc;", "worldAABB", "getWorldToShip", "worldToShip", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipData;)V", "impl"})
public final class ShipObjectServer
extends ShipObject
implements LoadedServerShipInternal,
ServerShipInternal {
    @NotNull
    private final ShipData shipData;
    private int shipTeleportId;
    @NotNull
    private final DeltaEncodedChannelServerTCP<JsonNode> shipDataChannel;
    private final MutableClassToInstanceMap<Object> attachedData;
    @NotNull
    private final List<ShipForcesInducer> forceInducers;
    @NotNull
    private final List<Ticked> toBeTicked;

    public ShipObjectServer(@NotNull ShipData shipData) {
        Intrinsics.checkNotNullParameter((Object)shipData, (String)"shipData");
        super(shipData);
        this.shipData = shipData;
        DeltaAlgorithm deltaAlgorithm = ShipObject.Companion.getJsonDiffDeltaAlgorithm();
        Object t = VSJacksonUtil.INSTANCE.getDeltaMapper().valueToTree(this.getShipData());
        Intrinsics.checkNotNullExpressionValue(t, (String)"VSJacksonUtil.deltaMapper.valueToTree(shipData)");
        this.shipDataChannel = new DeltaEncodedChannelServerTCP(deltaAlgorithm, t);
        this.attachedData = MutableClassToInstanceMap.create();
        this.forceInducers = new ArrayList();
        this.toBeTicked = new ArrayList();
        for (Map.Entry data : ((Map)this.getShipData().getPersistentAttachedData()).entrySet()) {
            Object k = data.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"data.key");
            this.applyAttachmentInterfaces((Class)k, data.getValue());
        }
        WingManagerImpl wingManager = new WingManagerImpl();
        wingManager.createWingGroup();
        this.setAttachment(WingManager.class, wingManager);
    }

    @Override
    @NotNull
    public ShipData getShipData() {
        return this.shipData;
    }

    @Override
    @NotNull
    public IShipActiveChunksSet getActiveChunksSet() {
        return this.shipData.getActiveChunksSet();
    }

    @Override
    @NotNull
    public ChunkClaim getChunkClaim() {
        return this.shipData.getChunkClaim();
    }

    @Override
    @NotNull
    public String getChunkClaimDimension() {
        return this.shipData.getChunkClaimDimension();
    }

    @Override
    public long getId() {
        return this.shipData.getId();
    }

    @Override
    @NotNull
    public ShipInertiaData getInertiaData() {
        return this.shipData.getInertiaData();
    }

    @Override
    @NotNull
    public Vector3dc getOmega() {
        return this.shipData.getOmega();
    }

    @Override
    @NotNull
    public ShipTransform getPrevTickShipTransform() {
        return this.shipData.getPrevTickShipTransform();
    }

    @Override
    @NotNull
    public ShipTransform getPrevTickTransform() {
        return this.shipData.getPrevTickTransform();
    }

    @Override
    @Nullable
    public AABBic getShipAABB() {
        return this.shipData.getShipAABB();
    }

    @Override
    @NotNull
    public IShipActiveChunksSet getShipActiveChunksSet() {
        return this.shipData.getShipActiveChunksSet();
    }

    @Override
    @NotNull
    public Matrix4dc getShipToWorld() {
        return this.shipData.getShipToWorld();
    }

    @Override
    @NotNull
    public ShipTransform getShipTransform() {
        return this.shipData.getShipTransform();
    }

    @Override
    @Nullable
    public AABBic getShipVoxelAABB() {
        return this.shipData.getShipVoxelAABB();
    }

    @Override
    @Nullable
    public String getSlug() {
        return this.shipData.getSlug();
    }

    @Override
    public void setSlug(@Nullable String string) {
        this.shipData.setSlug(string);
    }

    @Override
    @NotNull
    public ShipTransform getTransform() {
        return this.shipData.getTransform();
    }

    @Override
    @NotNull
    public Vector3dc getVelocity() {
        return this.shipData.getVelocity();
    }

    @Override
    @NotNull
    public AABBdc getWorldAABB() {
        return this.shipData.getWorldAABB();
    }

    @Override
    @NotNull
    public Matrix4dc getWorldToShip() {
        return this.shipData.getWorldToShip();
    }

    @Override
    public boolean areVoxelsFullyLoaded() {
        return this.shipData.areVoxelsFullyLoaded();
    }

    @Override
    @NotNull
    public ShipDataCommon asShipDataCommon() {
        return this.shipData.asShipDataCommon();
    }

    @Override
    public void onLoadChunk(int chunkX, int chunkZ) {
        this.shipData.onLoadChunk(chunkX, chunkZ);
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, @NotNull BlockType oldBlockType, @NotNull BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"oldBlockType");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"newBlockType");
        this.shipData.onSetBlock(posX, posY, posZ, oldBlockType, newBlockType, oldBlockMass, newBlockMass, isRunningOnServer);
    }

    @Override
    public void onUnloadChunk(int chunkX, int chunkZ) {
        this.shipData.onUnloadChunk(chunkX, chunkZ);
    }

    @Override
    public void updateShipAABBGenerator(int posX, int posY, int posZ, boolean set) {
        this.shipData.updateShipAABBGenerator(posX, posY, posZ, set);
    }

    @Override
    public int getShipTeleportId() {
        return this.shipTeleportId;
    }

    @NotNull
    public final DeltaEncodedChannelServerTCP<JsonNode> getShipDataChannel() {
        return this.shipDataChannel;
    }

    public final MutableClassToInstanceMap<Object> getAttachedData() {
        return this.attachedData;
    }

    @NotNull
    public final List<ShipForcesInducer> getForceInducers() {
        return this.forceInducers;
    }

    @NotNull
    public final List<Ticked> getToBeTicked() {
        return this.toBeTicked;
    }

    @Override
    public <T> void setAttachment(@NotNull Class<T> clazz, @Nullable T value) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (value == null) {
            this.attachedData.remove(clazz);
        } else {
            MutableClassToInstanceMap<Object> mutableClassToInstanceMap = this.attachedData;
            Intrinsics.checkNotNullExpressionValue(mutableClassToInstanceMap, (String)"attachedData");
            ((Map)mutableClassToInstanceMap).put(clazz, value);
        }
        this.applyAttachmentInterfaces(clazz, value);
    }

    @Override
    @Nullable
    public <T> T getAttachment(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.attachedData.getInstance(clazz);
        if (object == null) {
            object = this.getShipData().getAttachment(clazz);
        }
        return (T)object;
    }

    @Override
    public <T> void saveAttachment(@NotNull Class<T> clazz, @Nullable T value) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.applyAttachmentInterfaces(clazz, value);
        this.getShipData().saveAttachment(clazz, value);
    }

    private final void applyAttachmentInterfaces(Class<?> clazz, Object value) {
        if (value == null) {
            this.forceInducers.removeIf(arg_0 -> ShipObjectServer.applyAttachmentInterfaces$lambda$0((Function1)new Function1<ShipForcesInducer, Boolean>(clazz){
                final /* synthetic */ Class<?> $clazz;
                {
                    this.$clazz = $clazz;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ShipForcesInducer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$clazz.isAssignableFrom(it.getClass());
                }
            }, arg_0));
            this.toBeTicked.removeIf(arg_0 -> ShipObjectServer.applyAttachmentInterfaces$lambda$1((Function1)new Function1<Ticked, Boolean>(clazz){
                final /* synthetic */ Class<?> $clazz;
                {
                    this.$clazz = $clazz;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Ticked it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$clazz.isAssignableFrom(it.getClass());
                }
            }, arg_0));
        } else {
            if (value instanceof ShipForcesInducer) {
                this.forceInducers.add((ShipForcesInducer)value);
            }
            if (value instanceof ServerShipUser) {
                ((ServerShipUser)value).setShip(this);
            }
            if (value instanceof Ticked) {
                this.toBeTicked.add((Ticked)value);
            }
        }
    }

    @Override
    public void teleportShip(@NotNull ShipTeleportData teleportData) {
        Intrinsics.checkNotNullParameter((Object)teleportData, (String)"teleportData");
        int n = this.getShipTeleportId();
        this.shipTeleportId = n + 1;
        this.getShipData().setTransform(teleportData.createNewShipTransform(this.getTransform()));
        this.getShipData().getPhysicsData().setLinearVelocity(teleportData.getNewVel());
        this.getShipData().getPhysicsData().setAngularVelocity(teleportData.getNewOmega());
    }

    private static final boolean applyAttachmentInterfaces$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean applyAttachmentInterfaces$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

