/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.constraints.VSForceConstraint;
import org.valkyrienskies.core.apigame.ships.MutableQueryableShipData;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.apigame.world.chunks.BlockTypes;
import org.valkyrienskies.core.apigame.world.chunks.ChunkUnwatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTasks;
import org.valkyrienskies.core.apigame.world.chunks.TerrainUpdate;
import org.valkyrienskies.core.impl.api.LoadedServerShipInternal;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.game.BlockTypeImpl;
import org.valkyrienskies.core.impl.game.ChunkAllocator;
import org.valkyrienskies.core.impl.game.ChunkAllocatorProvider;
import org.valkyrienskies.core.impl.game.DimensionInfo;
import org.valkyrienskies.core.impl.game.ships.QueryableShipDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServer;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.game.ships.ShipObjectWorld;
import org.valkyrienskies.core.impl.game.ships.loading.ShipLoadManagerServer;
import org.valkyrienskies.core.impl.game.ships.modules.AllShips;
import org.valkyrienskies.core.impl.game.ships.types.TerrainUpdateImpl;
import org.valkyrienskies.core.impl.hooks.VSEvents;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.UdpServerImpl;
import org.valkyrienskies.core.impl.networking.VSNetworking;
import org.valkyrienskies.core.impl.util.WorldScoped;
import org.valkyrienskies.core.impl.util.assertions.stages.TickStageEnforcer;
import org.valkyrienskies.core.impl.util.assertions.stages.TickStageEnforcerKt;
import org.valkyrienskies.core.impl.util.events.EventEmitterImpl;
import org.valkyrienskies.core.impl.util.names.NounListNameGenerator;
import org.valkyrienskies.physics_api.voxel_updates.DeleteVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.DenseVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.EmptyVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.IVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.SparseVoxelShapeUpdate;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00fa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0006\u00c9\u0001\u00ca\u0001\u00cb\u0001B_\b\u0007\u0012\u0012\b\u0001\u0010n\u001a\f\u0012\u0004\u0012\u00020%0lj\u0002`m\u0012\u0006\u0010v\u001a\u00020u\u0012\b\u0010\u009e\u0001\u001a\u00030\u009d\u0001\u0012\b\u0010\u00c6\u0001\u001a\u00030\u00c5\u0001\u0012\u0006\u0010s\u001a\u00020r\u0012\u001a\b\u0001\u0010\u0085\u0001\u001a\u0013\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0005\u0012\u00030\u0084\u00010z\u00a2\u0006\u0006\b\u00c7\u0001\u0010\u00c8\u0001J'\u0010\u000b\u001a\u00020\n2\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\t\u001a\u00060\u0007j\u0002`\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0013\u001a\u00020\u00122\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0018\u001a\u00020\u00122\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001e\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ3\u0010&\u001a\u00020%2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010$\u001a\u00020#2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eH\u0016\u00a2\u0006\u0004\b&\u0010'J9\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\n2\b\b\u0002\u0010$\u001a\u00020#2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020\u00122\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b/\u0010\u001bJ\u000f\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b1\u00102J\u0011\u00104\u001a\u000603R\u00020\u0000\u00a2\u0006\u0004\b4\u00105J1\u0010:\u001a\b\u0012\u0004\u0012\u000209082\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eH\u0016\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020<\u00a2\u0006\u0004\b=\u0010>J\u0019\u0010?\u001a\u00020\u00102\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0004\b?\u0010@J\u001b\u0010A\u001a\u00020\n2\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\u00122\u0006\u0010C\u001a\u000209H\u0016\u00a2\u0006\u0004\bD\u0010EJS\u0010N\u001a\u00020\u00122\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020#H\u0016\u00a2\u0006\u0004\bN\u0010OJ\r\u0010P\u001a\u00020\u0012\u00a2\u0006\u0004\bP\u0010\u001bJ\u000f\u0010Q\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\bQ\u0010\u001bJ\u001b\u0010S\u001a\u00020\n2\n\u0010R\u001a\u00060\u0007j\u0002`\bH\u0016\u00a2\u0006\u0004\bS\u0010TJ'\u0010W\u001a\u00020\u00122\n\u0010U\u001a\u00060\u0004j\u0002`\u00052\n\u0010V\u001a\u00060\u0007j\u0002`\bH\u0002\u00a2\u0006\u0004\bW\u0010XJ\u001b\u0010Y\u001a\u00020\u00122\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eH\u0016\u00a2\u0006\u0004\bY\u0010ZJ+\u0010`\u001a\u00020\u00122\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\\0[2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020^0[H\u0016\u00a2\u0006\u0004\b`\u0010aJ\u001f\u0010d\u001a\u00020\u00122\u0006\u0010,\u001a\u00020+2\u0006\u0010c\u001a\u00020bH\u0016\u00a2\u0006\u0004\bd\u0010eJ#\u0010g\u001a\u00020\n2\n\u0010R\u001a\u00060\u0007j\u0002`\b2\u0006\u0010f\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\bg\u0010hR\u001a\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00020i8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bj\u0010kR$\u0010n\u001a\f\u0012\u0004\u0012\u00020%0lj\u0002`m8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bn\u0010o\u001a\u0004\bp\u0010qR\u0014\u0010s\u001a\u00020r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bs\u0010tR\u0017\u0010v\u001a\u00020u8\u0006\u00a2\u0006\f\n\u0004\bv\u0010w\u001a\u0004\bx\u0010yR$\u0010{\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u001c0z8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u001d\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020~0}8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u007f\u0010\u0080\u0001R#\u0010\u0081\u0001\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0}8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0081\u0001\u0010\u0080\u0001R\u001f\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020~0}8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0080\u0001R\u001d\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020%0}8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0083\u0001\u0010\u0080\u0001R'\u0010\u0085\u0001\u001a\u0013\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0005\u0012\u00030\u0084\u00010z8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0085\u0001\u0010|R*\u0010\u0086\u0001\u001a\u0016\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\b\u0012\u00060\u0004j\u0002`\u00050z8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0086\u0001\u0010|R,\u0010\u008a\u0001\u001a\u0017\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0087\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R1\u0010\u008d\u0001\u001a\u001c\u0012\b\u0012\u00060\rj\u0002`\u000e0\u008b\u0001j\r\u0012\b\u0012\u00060\rj\u0002`\u000e`\u008c\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008d\u0001\u0010\u008e\u0001R1\u0010\u008f\u0001\u001a\u001c\u0012\b\u0012\u00060\rj\u0002`\u000e0\u008b\u0001j\r\u0012\b\u0012\u00060\rj\u0002`\u000e`\u008c\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008f\u0001\u0010\u008e\u0001R\u001f\u0010\u0092\u0001\u001a\n\u0012\u0005\u0012\u00030\u0091\u00010\u0090\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0093\u0001R'\u0010\u0094\u0001\u001a\b\u0012\u0004\u0012\u00020%0\u00158B@\u0002X\u0082\u000e\u00a2\u0006\u0010\n\u0006\b\u0094\u0001\u0010\u0080\u0001\u001a\u0006\b\u0095\u0001\u0010\u0096\u0001R8\u0010\u0099\u0001\u001a\t\u0012\u0004\u0012\u0002090\u0097\u00012\u000e\u0010\u0098\u0001\u001a\t\u0012\u0004\u0012\u0002090\u0097\u00018\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u0099\u0001\u0010\u009a\u0001\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001R\u0018\u0010\u009e\u0001\u001a\u00030\u009d\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009e\u0001\u0010\u009f\u0001R\u001e\u0010\u00a3\u0001\u001a\t\u0012\u0004\u0012\u00020\u00020\u00a0\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u00a1\u0001\u0010\u00a2\u0001R\u001d\u0010\u00a4\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020}8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00a4\u0001\u0010\u0080\u0001R\u001d\u0010\u00a5\u0001\u001a\u00060\u0007j\u0002`\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00a5\u0001\u0010\u00a6\u0001R@\u0010\u00a8\u0001\u001a\t\u0012\u0004\u0012\u0002090\u0097\u00012\u000e\u0010\u00a7\u0001\u001a\t\u0012\u0004\u0012\u0002090\u0097\u00018\u0016@VX\u0096\u000e\u00a2\u0006\u0018\n\u0006\b\u00a8\u0001\u0010\u009a\u0001\u001a\u0006\b\u00a9\u0001\u0010\u009c\u0001\"\u0006\b\u00aa\u0001\u0010\u00ab\u0001R4\u0010\u00b2\u0001\u001a\u0016\u0012\u0004\u0012\u000209\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020<0\u00ad\u00010\u00ac\u00018FX\u0086\u0084\u0002\u00a2\u0006\u0010\u001a\u0006\b\u00ae\u0001\u0010\u00af\u0001*\u0006\b\u00b0\u0001\u0010\u00b1\u0001R1\u0010\u00b4\u0001\u001a\u001d\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u000f\u0012\r\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00b3\u00010z8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u00b4\u0001\u0010|R/\u0010\u00bb\u0001\u001a\n\u0012\u0005\u0012\u00030\u00b6\u00010\u00b5\u00018FX\u0087\u0084\u0002\u00a2\u0006\u0017\u0012\u0005\b\u00b9\u0001\u0010\u001b\u001a\u0006\b\u00b7\u0001\u0010\u00b8\u0001*\u0006\b\u00ba\u0001\u0010\u00b1\u0001R8\u0010\u00be\u0001\u001a$\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020 \u0012\u0005\u0012\u00030\u00bc\u00010z0zj\u0003`\u00bd\u00018\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u00be\u0001\u0010|R\u001a\u0010\u00c0\u0001\u001a\u0005\u0018\u00010\u00bf\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00c0\u0001\u0010\u00c1\u0001R\u001d\u0010\u00c2\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020}8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00c2\u0001\u0010\u0080\u0001R+\u0010\u00c4\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u00c3\u00010\u008b\u0001j\n\u0012\u0005\u0012\u00030\u00c3\u0001`\u008c\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00c4\u0001\u0010\u008e\u0001\u00a8\u0006\u00cc\u0001"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectWorld;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServer;", "Lorg/valkyrienskies/core/apigame/world/ServerShipWorldCore;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraintId;", "newConstraintId", "", "addConstraintIdToRigidBodyIdToConstraintsHelper", "(JI)Z", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "dimensionId", "Lorg/valkyrienskies/core/api/world/LevelYRange;", "yRange", "", "addDimension", "(Ljava/lang/String;Lorg/valkyrienskies/core/api/world/LevelYRange;)V", "", "Lorg/valkyrienskies/core/apigame/world/chunks/TerrainUpdate;", "terrainUpdates", "addTerrainUpdates", "(Ljava/lang/String;Ljava/util/List;)V", "clearNewUpdatedDeletedShipObjectsAndVoxelUpdates", "()V", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;", "vsConstraint", "createNewConstraint", "(Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;)Ljava/lang/Integer;", "Lorg/joml/Vector3ic;", "blockPosInWorldCoordinates", "createShipObjectImmediately", "", "scaling", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "createNewShipAtBlock", "(Lorg/joml/Vector3ic;ZDLjava/lang/String;)Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "Ljava/util/concurrent/CompletableFuture;", "createNewShipObjectAtBlock", "(Lorg/joml/Vector3ic;ZDLjava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "deleteShip", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)V", "destroyWorld", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "getChunkWatchTasks", "()Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$CurrentTickChanges;", "getCurrentTickChanges", "()Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$CurrentTickChanges;", "chunkX", "chunkZ", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "getIPlayersWatchingShipChunk", "(IILjava/lang/String;)Ljava/util/Iterator;", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "getShipObject", "(Lorg/valkyrienskies/core/impl/api/ServerShipInternal;)Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServer;", "getYRange", "(Ljava/lang/String;)Lorg/valkyrienskies/core/api/world/LevelYRange;", "isShipLoaded", "(J)Z", "player", "onDisconnect", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "oldBlockMass", "newBlockMass", "onSetBlock", "(IIILjava/lang/String;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DD)V", "postTick", "preTick", "constraintId", "removeConstraint", "(I)Z", "rigidBodyId", "oldConstraintId", "removeConstraintIdFromRigidBodyIdToConstraintsHelper", "(JI)V", "removeDimension", "(Ljava/lang/String;)V", "", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTask;", "watchTasks", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkUnwatchTask;", "unwatchTasks", "setExecutedChunkWatchTasks", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "Lorg/valkyrienskies/core/apigame/ShipTeleportData;", "teleportData", "teleportShip", "(Lorg/valkyrienskies/core/api/ships/ServerShip;Lorg/valkyrienskies/core/apigame/ShipTeleportData;)V", "updatedVSConstraint", "updateConstraint", "(ILorg/valkyrienskies/core/apigame/constraints/VSConstraint;)Z", "Lorg/valkyrienskies/core/impl/game/ships/QueryableShipDataImpl;", "_loadedShips", "Lorg/valkyrienskies/core/impl/game/ships/QueryableShipDataImpl;", "Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "Lorg/valkyrienskies/core/impl/game/ships/MutableQueryableShipDataServer;", "allShips", "Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "getAllShips", "()Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockTypes;", "blockTypes", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockTypes;", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "chunkAllocators", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "getChunkAllocators", "()Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "", "constraints", "Ljava/util/Map;", "", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraintAndId;", "constraintsCreatedThisTick", "Ljava/util/List;", "constraintsDeletedThisTick", "constraintsUpdatedThisTick", "deletedShipObjects", "Lorg/valkyrienskies/core/impl/game/DimensionInfo;", "dimensionInfo", "dimensionToGroundBodyId", "", "getDimensionToGroundBodyIdImmutable", "()Ljava/util/Map;", "dimensionToGroundBodyIdImmutable", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "dimensionsAddedThisTick", "Ljava/util/ArrayList;", "dimensionsRemovedThisTick", "Lorg/valkyrienskies/core/impl/util/assertions/stages/TickStageEnforcer;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$Stages;", "enforcer", "Lorg/valkyrienskies/core/impl/util/assertions/stages/TickStageEnforcer;", "lastTickDeletedShipObjects", "getLastTickDeletedShipObjects", "()Ljava/util/List;", "", "<set-?>", "lastTickPlayers", "Ljava/util/Set;", "getLastTickPlayers", "()Ljava/util/Set;", "Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer;", "loadManager", "Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer;", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "getLoadedShips", "()Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "loadedShips", "newShipObjects", "nextConstraintId", "I", "value", "players", "getPlayers", "setPlayers", "(Ljava/util/Set;)V", "Lcom/google/common/collect/ImmutableMap;", "Lcom/google/common/collect/ImmutableSet;", "getPlayersToTrackedShips", "()Lcom/google/common/collect/ImmutableMap;", "getPlayersToTrackedShips$delegate", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;)Ljava/lang/Object;", "playersToTrackedShips", "", "shipIdToConstraints", "Lorg/valkyrienskies/core/impl/util/events/EventEmitterImpl;", "Lorg/valkyrienskies/core/impl/hooks/VSEvents$ShipLoadEvent;", "getShipLoadEvent", "()Lorg/valkyrienskies/core/impl/util/events/EventEmitterImpl;", "getShipLoadEvent$annotations", "getShipLoadEvent$delegate", "shipLoadEvent", "Lorg/valkyrienskies/physics_api/voxel_updates/IVoxelShapeUpdate;", "Lorg/valkyrienskies/core/impl/game/ships/types/MutableShipVoxelUpdates;", "shipToVoxelUpdates", "Lorg/valkyrienskies/core/impl/networking/UdpServerImpl;", "udpServer", "Lorg/valkyrienskies/core/impl/networking/UdpServerImpl;", "updatedShipObjects", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$LevelVoxelUpdates;", "voxelShapeUpdatesList", "Lorg/valkyrienskies/core/impl/networking/VSNetworking;", "networking", "<init>", "(Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer;Lorg/valkyrienskies/core/impl/networking/VSNetworking;Lorg/valkyrienskies/core/apigame/world/chunks/BlockTypes;Ljava/util/Map;)V", "CurrentTickChanges", "LevelVoxelUpdates", "Stages", "impl"})
@WorldScoped
public final class ShipObjectServerWorld
extends ShipObjectWorld<ShipObjectServer>
implements ServerShipWorldCore {
    @NotNull
    private final MutableQueryableShipData<ShipData> allShips;
    @NotNull
    private final ChunkAllocatorProvider chunkAllocators;
    @NotNull
    private final ShipLoadManagerServer loadManager;
    @NotNull
    private final BlockTypes blockTypes;
    @NotNull
    private final Map<String, DimensionInfo> dimensionInfo;
    @NotNull
    private final TickStageEnforcer<Stages> enforcer;
    @NotNull
    private Set<? extends IPlayer> lastTickPlayers;
    @NotNull
    private Set<? extends IPlayer> players;
    @NotNull
    private final QueryableShipDataImpl<ShipObjectServer> _loadedShips;
    @NotNull
    private final Map<String, Long> dimensionToGroundBodyId;
    @NotNull
    private final ArrayList<String> dimensionsAddedThisTick;
    @NotNull
    private final ArrayList<String> dimensionsRemovedThisTick;
    @NotNull
    private final ArrayList<LevelVoxelUpdates> voxelShapeUpdatesList;
    @NotNull
    private final Map<Integer, VSConstraint> constraints;
    @NotNull
    private final Map<Long, Set<Integer>> shipIdToConstraints;
    private int nextConstraintId;
    @NotNull
    private final List<ShipObjectServer> newShipObjects;
    @NotNull
    private final List<ShipObjectServer> updatedShipObjects;
    @NotNull
    private final List<ShipData> deletedShipObjects;
    @NotNull
    private List<ShipData> lastTickDeletedShipObjects;
    @NotNull
    private List<VSConstraintAndId> constraintsCreatedThisTick;
    @NotNull
    private List<VSConstraintAndId> constraintsUpdatedThisTick;
    @NotNull
    private List<Integer> constraintsDeletedThisTick;
    @Nullable
    private final UdpServerImpl udpServer;
    @NotNull
    private final Map<Long, Map<Vector3ic, IVoxelShapeUpdate>> shipToVoxelUpdates;

    @Inject
    public ShipObjectServerWorld(@AllShips @NotNull MutableQueryableShipData<ShipData> allShips, @NotNull ChunkAllocatorProvider chunkAllocators, @NotNull ShipLoadManagerServer loadManager, @NotNull VSNetworking networking, @NotNull BlockTypes blockTypes, @Named(value="mutableDimensionInfo") @NotNull Map<String, DimensionInfo> dimensionInfo) {
        Intrinsics.checkNotNullParameter(allShips, (String)"allShips");
        Intrinsics.checkNotNullParameter((Object)chunkAllocators, (String)"chunkAllocators");
        Intrinsics.checkNotNullParameter((Object)loadManager, (String)"loadManager");
        Intrinsics.checkNotNullParameter((Object)networking, (String)"networking");
        Intrinsics.checkNotNullParameter((Object)blockTypes, (String)"blockTypes");
        Intrinsics.checkNotNullParameter(dimensionInfo, (String)"dimensionInfo");
        super(chunkAllocators);
        this.allShips = allShips;
        this.chunkAllocators = chunkAllocators;
        this.loadManager = loadManager;
        this.blockTypes = blockTypes;
        this.dimensionInfo = dimensionInfo;
        this.enforcer = TickStageEnforcerKt.TickStageEnforcer(Stages.PRE_TICK, enforcer.1.INSTANCE);
        this.lastTickPlayers = SetsKt.emptySet();
        this.players = SetsKt.emptySet();
        this._loadedShips = new QueryableShipDataImpl(null, 1, null);
        this.dimensionToGroundBodyId = new HashMap();
        this.dimensionsAddedThisTick = new ArrayList();
        this.dimensionsRemovedThisTick = new ArrayList();
        this.voxelShapeUpdatesList = new ArrayList();
        this.constraints = new HashMap();
        this.shipIdToConstraints = new HashMap();
        this.newShipObjects = new ArrayList();
        this.updatedShipObjects = new ArrayList();
        this.deletedShipObjects = new ArrayList();
        this.lastTickDeletedShipObjects = CollectionsKt.emptyList();
        this.constraintsCreatedThisTick = new ArrayList();
        this.constraintsUpdatedThisTick = new ArrayList();
        this.constraintsDeletedThisTick = new ArrayList();
        this.udpServer = networking.tryUdpServer();
        this.shipToVoxelUpdates = new HashMap();
    }

    @NotNull
    public MutableQueryableShipData<ShipData> getAllShips() {
        return this.allShips;
    }

    @NotNull
    public final ChunkAllocatorProvider getChunkAllocators() {
        return this.chunkAllocators;
    }

    @NotNull
    public final Set<IPlayer> getLastTickPlayers() {
        return this.lastTickPlayers;
    }

    @Override
    @NotNull
    public Set<IPlayer> getPlayers() {
        return this.players;
    }

    @Override
    public void setPlayers(@NotNull Set<? extends IPlayer> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.enforcer.stage(Stages.UPDATE_PLAYERS);
        this.lastTickPlayers = this.players;
        this.players = value;
    }

    @NotNull
    public final ImmutableMap<IPlayer, ImmutableSet<ServerShipInternal>> getPlayersToTrackedShips() {
        return this.loadManager.getPlayersToTrackedShips();
    }

    private static Object getPlayersToTrackedShips$delegate(ShipObjectServerWorld shipObjectServerWorld) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)shipObjectServerWorld.loadManager, ShipLoadManagerServer.class, "playersToTrackedShips", "getPlayersToTrackedShips()Lcom/google/common/collect/ImmutableMap;", 0)));
    }

    @Override
    @NotNull
    public QueryableShipData<ShipObjectServer> getLoadedShips() {
        return this._loadedShips;
    }

    @Override
    @NotNull
    public Map<String, Long> getDimensionToGroundBodyIdImmutable() {
        return this.dimensionToGroundBodyId;
    }

    private final List<ShipData> getLastTickDeletedShipObjects() {
        this.enforcer.stage(Stages.GET_LAST_TICK_CHANGES);
        Unit $this$_get_lastTickDeletedShipObjects__u24lambda_u240 = Unit.INSTANCE;
        boolean bl = false;
        return this.lastTickDeletedShipObjects;
    }

    @NotNull
    public final EventEmitterImpl<VSEvents.ShipLoadEvent> getShipLoadEvent() {
        return VSEvents.INSTANCE.getShipLoadEvent();
    }

    @Deprecated(message="All events moved to VSEvents", replaceWith=@ReplaceWith(expression="ShipLoadEvent", imports={"org.valkyrienskies.core.impl.hooks.VSEvents.ShipLoadEvent"}))
    public static /* synthetic */ void getShipLoadEvent$annotations() {
    }

    private static Object getShipLoadEvent$delegate(ShipObjectServerWorld shipObjectServerWorld) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)VSEvents.INSTANCE, VSEvents.class, "shipLoadEvent", "getShipLoadEvent()Lorg/valkyrienskies/core/impl/util/events/EventEmitterImpl;", 0)));
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, @NotNull String dimensionId, @NotNull BlockType oldBlockType, @NotNull BlockType newBlockType, double oldBlockMass, double newBlockMass) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"oldBlockType");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"newBlockType");
        super.onSetBlock(posX, posY, posZ, dimensionId, oldBlockType, newBlockType, oldBlockMass, newBlockMass);
        if (!Intrinsics.areEqual((Object)oldBlockType, (Object)newBlockType)) {
            IVoxelShapeUpdate iVoxelShapeUpdate;
            Map voxelUpdates;
            Map map2;
            Long shipId;
            ShipData shipData;
            Vector3ic chunkPos = new Vector3i(posX >> 4, posY >> 4, posZ >> 4);
            ShipData shipData2 = shipData = (ShipData)this.getAllShips().getShipDataFromChunkPos(chunkPos.x(), chunkPos.z(), dimensionId);
            Long l = shipId = shipData2 != null ? Long.valueOf(shipData2.getId()) : this.dimensionToGroundBodyId.get(dimensionId);
            if (shipId == null) {
                NetworkChannel.Companion.getLogger().error("Could not find ship or dimension body for block update at " + posX + ", " + posY + ", " + posZ + " in dimension " + dimensionId);
                return;
            }
            Map<Long, Map<Vector3ic, IVoxelShapeUpdate>> $this$getOrPut$iv = this.shipToVoxelUpdates;
            boolean $i$f$getOrPut = false;
            Map value$iv = $this$getOrPut$iv.get(shipId);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new HashMap();
                $this$getOrPut$iv.put(shipId, answer$iv);
                map2 = answer$iv;
            } else {
                map2 = value$iv;
            }
            Map $this$getOrPut$iv2 = voxelUpdates = map2;
            boolean $i$f$getOrPut2 = false;
            IVoxelShapeUpdate value$iv2 = $this$getOrPut$iv2.get(chunkPos);
            if (value$iv2 == null) {
                boolean bl = false;
                IVoxelShapeUpdate answer$iv = SparseVoxelShapeUpdate.Companion.createSparseVoxelShapeUpdate(chunkPos);
                $this$getOrPut$iv2.put(chunkPos, answer$iv);
                iVoxelShapeUpdate = answer$iv;
            } else {
                iVoxelShapeUpdate = value$iv2;
            }
            IVoxelShapeUpdate voxelShapeUpdate = iVoxelShapeUpdate;
            byte voxelType = ((BlockTypeImpl)newBlockType).getState();
            IVoxelShapeUpdate iVoxelShapeUpdate2 = voxelShapeUpdate;
            if (iVoxelShapeUpdate2 instanceof SparseVoxelShapeUpdate) {
                ((SparseVoxelShapeUpdate)voxelShapeUpdate).addUpdate(posX & 0xF, posY & 0xF, posZ & 0xF, voxelType);
            } else if (iVoxelShapeUpdate2 instanceof DenseVoxelShapeUpdate) {
                ((DenseVoxelShapeUpdate)voxelShapeUpdate).setVoxel(posX & 0xF, posY & 0xF, posZ & 0xF, voxelType);
            } else if (iVoxelShapeUpdate2 instanceof EmptyVoxelShapeUpdate) {
                SparseVoxelShapeUpdate newVoxelShapeUpdate = SparseVoxelShapeUpdate.Companion.createSparseVoxelShapeUpdate(chunkPos);
                newVoxelShapeUpdate.addUpdate(posX & 0xF, posY & 0xF, posZ & 0xF, voxelType);
                voxelUpdates.put(chunkPos, newVoxelShapeUpdate);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addTerrainUpdates(@NotNull String dimensionId, @NotNull List<? extends TerrainUpdate> terrainUpdates) {
        IVoxelShapeUpdate it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        Intrinsics.checkNotNullParameter(terrainUpdates, (String)"terrainUpdates");
        this.enforcer.stage(Stages.UPDATE_CHUNKS);
        Iterable $this$map$iv = terrainUpdates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TerrainUpdate terrainUpdate = (TerrainUpdate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.types.TerrainUpdateImpl");
            collection.add(((TerrainUpdateImpl)((Object)it)).getUpdate());
        }
        List voxelShapeUpdates = (List)destination$iv$iv;
        this.voxelShapeUpdatesList.add(new LevelVoxelUpdates(dimensionId, voxelShapeUpdates));
        Iterable $this$forEach$iv = voxelShapeUpdates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShipData ship;
            IVoxelShapeUpdate it2 = (IVoxelShapeUpdate)element$iv;
            boolean bl = false;
            if ((ShipData)this.getAllShips().getByChunkPos(it2.getRegionX(), it2.getRegionZ(), dimensionId) == null) continue;
            it = it2;
            if (it instanceof DenseVoxelShapeUpdate ? true : it instanceof EmptyVoxelShapeUpdate) {
                ship.onLoadChunk(it2.getRegionX(), it2.getRegionZ());
            } else if (it instanceof DeleteVoxelShapeUpdate) {
                ship.onUnloadChunk(it2.getRegionX(), it2.getRegionZ());
            }
            if (!(it2 instanceof DenseVoxelShapeUpdate)) continue;
            DenseVoxelShapeUpdate this_$iv = (DenseVoxelShapeUpdate)it2;
            boolean $i$f$forEachVoxel = false;
            DenseVoxelShapeUpdate this_$iv$iv = this_$iv;
            boolean $i$f$iterate = false;
            int n = 0;
            while (n < 16) {
                int y$iv$iv = n++;
                int n2 = 0;
                while (n2 < 16) {
                    int z$iv$iv = n2++;
                    int n3 = 0;
                    while (n3 < 16) {
                        void voxelState;
                        void z;
                        void y;
                        void z$iv;
                        void y$iv;
                        int x$iv$iv = n3++;
                        int n4 = z$iv$iv;
                        int n5 = y$iv$iv;
                        int x$iv = x$iv$iv;
                        boolean bl2 = false;
                        byte by = this_$iv.getVoxel(x$iv, (int)y$iv, (int)z$iv);
                        void var26_29 = z$iv;
                        void var27_30 = y$iv;
                        int x = x$iv;
                        boolean bl3 = false;
                        ship.updateShipAABBGenerator((it2.getRegionX() << 4) + x, (it2.getRegionY() << 4) + y, (it2.getRegionZ() << 4) + z, voxelState != this.blockTypes.getAir().toByte());
                    }
                }
            }
        }
    }

    @Nullable
    public final ShipObjectServer getShipObject(@NotNull ServerShipInternal ship) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        return this.getLoadedShips().getById(ship.getId());
    }

    @Override
    public void preTick() {
        this.enforcer.stage(Stages.PRE_TICK);
        super.preTick();
        this.loadManager.preTick(this.getPlayers(), this.lastTickPlayers, this.getAllShips(), (Iterable<ShipData>)this.getLastTickDeletedShipObjects());
    }

    /*
     * WARNING - void declaration
     */
    public final void postTick() {
        Object element$iv;
        Iterator<Object> $this$filterTo$iv$iv;
        this.enforcer.stage(Stages.POST_TICK_START);
        Iterable $this$filter$iv = this._loadedShips;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ShipObjectServer it = (ShipObjectServer)element$iv$iv;
            boolean bl = false;
            if (!(it.getShipData().getInertiaData().getMass() < 1.0E-8)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map<Integer, VSConstraint> $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            element$iv = $this$filterTo$iv$iv.next();
            ShipObjectServer it = (ShipObjectServer)element$iv;
            boolean bl = false;
            this.deleteShip(it);
        }
        $this$forEach$iv = this.getShipObjects();
        $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object it = element$iv = (Map.Entry)$this$filterTo$iv$iv.next();
            boolean bl = false;
            ShipObjectServer shipObjectServer = (ShipObjectServer)it.getValue();
            this.updatedShipObjects.add(shipObjectServer);
        }
        $this$forEach$iv = this.deletedShipObjects;
        $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Set<Integer> constraintIds;
            element$iv = $this$filterTo$iv$iv.next();
            ShipData deletedShipObject = (ShipData)element$iv;
            boolean bl = false;
            if (this.shipIdToConstraints.get(deletedShipObject.getId()) == null) continue;
            List constraintIdsCopy = new ArrayList(constraintIds);
            Iterable $this$forEach$iv2 = constraintIdsCopy;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int constraintId = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                this.removeConstraint(constraintId);
            }
        }
        $this$forEach$iv = this.constraints;
        $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object deletedShipObject = element$iv = (Map.Entry)$this$filterTo$iv$iv.next();
            boolean bl = false;
            int constraintId = ((Number)deletedShipObject.getKey()).intValue();
            VSConstraint constraint = (VSConstraint)deletedShipObject.getValue();
            if (!(constraint instanceof VSForceConstraint)) continue;
            this.constraintsUpdatedThisTick.add(new VSConstraintAndId(constraintId, constraint));
        }
        List shipsLoadedThisTick = new ArrayList();
        for (ShipData shipData : this.getAllShips()) {
            long shipID = shipData.getId();
            if (shipData.getInertiaData().getMass() == 0.0) {
                NetworkChannel.Companion.getLogger().warn("Ship with ID " + shipID + " has a mass of 0.0, not creating a ShipObject");
                continue;
            }
            if (this._loadedShips.contains(shipID)) continue;
            ShipObjectServer newShipObject = new ShipObjectServer(shipData);
            this.newShipObjects.add(newShipObject);
            this._loadedShips.addShipData((ShipObjectServer)((Ship)newShipObject));
            shipsLoadedThisTick.add(newShipObject);
        }
        for (LevelVoxelUpdates newLoadedChunkAndDimension : this.voxelShapeUpdatesList) {
            String dimensionId = newLoadedChunkAndDimension.component1();
            List<IVoxelShapeUpdate> shapeUpdates = newLoadedChunkAndDimension.component2();
            for (IVoxelShapeUpdate newLoadedChunk : shapeUpdates) {
                Object object;
                void $this$getOrPut$iv;
                long l;
                ShipData shipData;
                Vector3ic chunkPos = new Vector3i(newLoadedChunk.getRegionX(), newLoadedChunk.getRegionY(), newLoadedChunk.getRegionZ());
                ShipData shipData2 = shipData = (ShipData)this.getAllShips().getShipDataFromChunkPos(chunkPos.x(), chunkPos.z(), dimensionId);
                if (shipData2 != null) {
                    l = shipData2.getId();
                } else {
                    Long l2 = this.dimensionToGroundBodyId.get(dimensionId);
                    Intrinsics.checkNotNull((Object)l2);
                    l = ((Number)l2).longValue();
                }
                long shipId = l;
                Map<Long, Map<Vector3ic, IVoxelShapeUpdate>> constraintId = this.shipToVoxelUpdates;
                Long key$iv = shipId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv = new HashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Map voxelUpdates = (Map)object;
                voxelUpdates.put(chunkPos, newLoadedChunk);
            }
        }
        this.enforcer.stage(Stages.POST_TICK_GENERATED);
        this.loadManager.postTick(this.getPlayers());
        Iterable $this$forEach$iv3 = shipsLoadedThisTick;
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            ShipObjectServer it = (ShipObjectServer)element$iv3;
            boolean bl = false;
            VSEvents.INSTANCE.getShipLoadEvent().emit(new VSEvents.ShipLoadEvent(it));
        }
        VSEvents.INSTANCE.getTickEndEvent().emit(new VSEvents.TickEndEvent(this));
        this.enforcer.stage(Stages.POST_TICK_FINISH);
    }

    @Override
    @NotNull
    public Iterator<IPlayer> getIPlayersWatchingShipChunk(int chunkX, int chunkZ, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        return this.loadManager.getIPlayersWatchingShipChunk(chunkX, chunkZ, dimensionId);
    }

    @Override
    @NotNull
    public ChunkWatchTasks getChunkWatchTasks() {
        return this.loadManager.getChunkWatchTasks();
    }

    @Override
    public void setExecutedChunkWatchTasks(@NotNull Iterable<? extends ChunkWatchTask> watchTasks, @NotNull Iterable<? extends ChunkUnwatchTask> unwatchTasks) {
        Intrinsics.checkNotNullParameter(watchTasks, (String)"watchTasks");
        Intrinsics.checkNotNullParameter(unwatchTasks, (String)"unwatchTasks");
        this.loadManager.setExecutedChunkWatchTasks(watchTasks, unwatchTasks);
    }

    @NotNull
    public final CompletableFuture<ShipObjectServer> createNewShipObjectAtBlock(@NotNull Vector3ic blockPosInWorldCoordinates, boolean createShipObjectImmediately, double scaling, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)blockPosInWorldCoordinates, (String)"blockPosInWorldCoordinates");
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        CompletableFuture<ShipObjectServer> future = new CompletableFuture<ShipObjectServer>();
        ShipData shipData = this.createNewShipAtBlock(blockPosInWorldCoordinates, createShipObjectImmediately, scaling, dimensionId);
        VSEvents.ShipLoadEvent.Companion.once(arg_0 -> ShipObjectServerWorld.createNewShipObjectAtBlock$lambda$14(shipData, arg_0), arg_0 -> ShipObjectServerWorld.createNewShipObjectAtBlock$lambda$15(future, arg_0));
        return future;
    }

    public static /* synthetic */ CompletableFuture createNewShipObjectAtBlock$default(ShipObjectServerWorld shipObjectServerWorld, Vector3ic vector3ic, boolean bl, double d, String string, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        return shipObjectServerWorld.createNewShipObjectAtBlock(vector3ic, bl, d, string);
    }

    @Override
    @NotNull
    public ShipData createNewShipAtBlock(@NotNull Vector3ic blockPosInWorldCoordinates, boolean createShipObjectImmediately, double scaling, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)blockPosInWorldCoordinates, (String)"blockPosInWorldCoordinates");
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        ChunkAllocator chunkAllocator = this.chunkAllocators.forDimension(dimensionId);
        ChunkClaim chunkClaim = chunkAllocator.allocateNewChunkClaim();
        String shipName = NounListNameGenerator.INSTANCE.generateName();
        Vector3d vector3d = new Vector3d(blockPosInWorldCoordinates).add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"Vector3d(blockPosInWorld\u2026nates).add(0.5, 0.5, 0.5)");
        Vector3dc shipCenterInWorldCoordinates = vector3d;
        Vector3ic blockPosInShipCoordinates = ChunkClaim.getCenterBlockCoordinates$default(chunkClaim, this.getYRange(dimensionId), null, 2, null);
        Vector3d vector3d2 = new Vector3d(blockPosInShipCoordinates).add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"Vector3d(blockPosInShipC\u2026nates).add(0.5, 0.5, 0.5)");
        Vector3dc shipCenterInShipCoordinates = vector3d2;
        ShipData newShipData = ShipData.Companion.createEmpty$default(ShipData.Companion, shipName, chunkAllocator.allocateShipId(), chunkClaim, dimensionId, shipCenterInWorldCoordinates, shipCenterInShipCoordinates, scaling, false, 128, null);
        this.getAllShips().add((Ship)newShipData);
        if (createShipObjectImmediately) {
            String string = "Not implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return newShipData;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addConstraintIdToRigidBodyIdToConstraintsHelper(long shipId, int newConstraintId) {
        Object object;
        void $this$getOrPut$iv;
        Map<Long, Set<Integer>> map2 = this.shipIdToConstraints;
        Long key$iv = shipId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Set)object).add(newConstraintId);
    }

    private final void removeConstraintIdFromRigidBodyIdToConstraintsHelper(long rigidBodyId, int oldConstraintId) {
        Set<Integer> set = this.shipIdToConstraints.get(rigidBodyId);
        if (set == null) {
            return;
        }
        Set<Integer> constraintIds = set;
        constraintIds.remove(oldConstraintId);
        if (constraintIds.isEmpty()) {
            this.shipIdToConstraints.remove(rigidBodyId);
        }
    }

    private final boolean isShipLoaded(long shipId) {
        return this.getAllShips().contains(shipId) || this.getDimensionToGroundBodyIdImmutable().containsValue(shipId);
    }

    @Override
    @Nullable
    public Integer createNewConstraint(@NotNull VSConstraint vsConstraint) {
        Intrinsics.checkNotNullParameter((Object)vsConstraint, (String)"vsConstraint");
        if (!this.isShipLoaded(vsConstraint.getShipId0()) || !this.isShipLoaded(vsConstraint.getShipId1())) {
            return null;
        }
        int n = this.nextConstraintId;
        this.nextConstraintId = n + 1;
        int constraintId = n;
        Integer n2 = constraintId;
        this.constraints.put(n2, vsConstraint);
        this.addConstraintIdToRigidBodyIdToConstraintsHelper(vsConstraint.getShipId0(), constraintId);
        this.addConstraintIdToRigidBodyIdToConstraintsHelper(vsConstraint.getShipId1(), constraintId);
        this.constraintsCreatedThisTick.add(new VSConstraintAndId(constraintId, vsConstraint));
        return constraintId;
    }

    @Override
    public boolean updateConstraint(int constraintId, @NotNull VSConstraint updatedVSConstraint) {
        Intrinsics.checkNotNullParameter((Object)updatedVSConstraint, (String)"updatedVSConstraint");
        VSConstraint vSConstraint = this.constraints.get(constraintId);
        if (vSConstraint == null) {
            return false;
        }
        VSConstraint oldConstraint = vSConstraint;
        if (!this.isShipLoaded(updatedVSConstraint.getShipId0()) || !this.isShipLoaded(updatedVSConstraint.getShipId1())) {
            return false;
        }
        if (oldConstraint.getShipId0() != updatedVSConstraint.getShipId0() || oldConstraint.getShipId1() != updatedVSConstraint.getShipId1()) {
            this.removeConstraintIdFromRigidBodyIdToConstraintsHelper(oldConstraint.getShipId0(), constraintId);
            this.removeConstraintIdFromRigidBodyIdToConstraintsHelper(oldConstraint.getShipId1(), constraintId);
            this.addConstraintIdToRigidBodyIdToConstraintsHelper(updatedVSConstraint.getShipId0(), constraintId);
            this.addConstraintIdToRigidBodyIdToConstraintsHelper(updatedVSConstraint.getShipId1(), constraintId);
        }
        this.constraintsUpdatedThisTick.add(new VSConstraintAndId(constraintId, updatedVSConstraint));
        return true;
    }

    @Override
    public boolean removeConstraint(int constraintId) {
        VSConstraint vSConstraint = this.constraints.get(constraintId);
        if (vSConstraint == null) {
            return false;
        }
        VSConstraint oldConstraint = vSConstraint;
        this.removeConstraintIdFromRigidBodyIdToConstraintsHelper(oldConstraint.getShipId0(), constraintId);
        this.removeConstraintIdFromRigidBodyIdToConstraintsHelper(oldConstraint.getShipId1(), constraintId);
        this.constraintsDeletedThisTick.add(constraintId);
        this.constraints.remove(constraintId);
        return true;
    }

    @NotNull
    public final LevelYRange getYRange(@NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        return ((DimensionInfo)MapsKt.getValue(this.dimensionInfo, (Object)dimensionId)).getYRange();
    }

    @Override
    public void destroyWorld() {
    }

    @NotNull
    public final CurrentTickChanges getCurrentTickChanges() {
        this.enforcer.stage(Stages.GET_CURRENT_TICK_CHANGES);
        return new CurrentTickChanges((Collection<ShipObjectServer>)this.newShipObjects, (Collection<ShipObjectServer>)this.updatedShipObjects, (Collection<ShipData>)this.deletedShipObjects, this.shipToVoxelUpdates, (Collection<String>)this.dimensionsAddedThisTick, (Collection<String>)this.dimensionsRemovedThisTick, (Collection<VSConstraintAndId>)this.constraintsCreatedThisTick, (Collection<VSConstraintAndId>)this.constraintsUpdatedThisTick, (Collection<Integer>)this.constraintsDeletedThisTick);
    }

    public final void clearNewUpdatedDeletedShipObjectsAndVoxelUpdates() {
        this.enforcer.stage(Stages.CLEAR_FOR_RESET);
        this.newShipObjects.clear();
        this.updatedShipObjects.clear();
        this.lastTickDeletedShipObjects = CollectionsKt.toList((Iterable)this.deletedShipObjects);
        this.deletedShipObjects.clear();
        this.shipToVoxelUpdates.clear();
        this.voxelShapeUpdatesList.clear();
        this.dimensionsAddedThisTick.clear();
        Iterable $this$forEach$iv = this.dimensionsRemovedThisTick;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dimensionRemovedThisTick = (String)element$iv;
            boolean bl = false;
            boolean removedSuccessfully = this.dimensionToGroundBodyId.remove(dimensionRemovedThisTick) != null;
            if (removedSuccessfully) continue;
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.dimensionsRemovedThisTick.clear();
        this.constraintsCreatedThisTick = new ArrayList();
        this.constraintsUpdatedThisTick = new ArrayList();
        this.constraintsDeletedThisTick = new ArrayList();
    }

    @Override
    public void addDimension(@NotNull String dimensionId, @NotNull LevelYRange yRange) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        this.enforcer.stage(Stages.UPDATE_DIMENSIONS);
        if (!(!this.dimensionInfo.containsKey(dimensionId))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.dimensionToGroundBodyId.containsKey(dimensionId))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.dimensionsAddedThisTick.add(dimensionId);
        this.dimensionToGroundBodyId.put(dimensionId, this.chunkAllocators.forDimension(dimensionId).allocateShipId());
        this.dimensionInfo.put(dimensionId, new DimensionInfo(dimensionId, yRange));
    }

    @Override
    public void removeDimension(@NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        this.enforcer.stage(Stages.UPDATE_DIMENSIONS);
        if (!this.dimensionInfo.containsKey(dimensionId)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.dimensionToGroundBodyId.containsKey(dimensionId)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.dimensionsRemovedThisTick.add(dimensionId);
        this.dimensionInfo.remove(dimensionId);
    }

    @Override
    public void onDisconnect(@NotNull IPlayer player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            UdpServerImpl udpServerImpl = this.udpServer;
            if (udpServerImpl == null) break block0;
            udpServerImpl.disconnect(player);
        }
    }

    @Override
    public void deleteShip(@NotNull ServerShip ship) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        if (this._loadedShips.contains(ship.getId())) {
            ShipData shipData = ship instanceof ShipObjectServer ? ((ShipObjectServer)ship).getShipData() : (ShipData)ship;
            this.deletedShipObjects.add(shipData);
            this._loadedShips.remove(ship.getId());
        }
        this.getAllShips().remove(ship.getId());
        this.shipToVoxelUpdates.remove(ship.getId());
    }

    @Override
    public void teleportShip(@NotNull ServerShip ship, @NotNull ShipTeleportData teleportData) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)teleportData, (String)"teleportData");
        if (ship instanceof LoadedServerShipInternal) {
            ((LoadedServerShipInternal)ship).teleportShip(teleportData);
        } else {
            ShipObjectServer shipAsLoaded = this.getLoadedShips().getById(ship.getId());
            if (shipAsLoaded != null) {
                shipAsLoaded.teleportShip(teleportData);
            } else {
                ((ShipData)ship).setTransform(teleportData.createNewShipTransform(((ShipData)ship).getTransform()));
            }
        }
    }

    private static final boolean createNewShipObjectAtBlock$lambda$14(ShipData $shipData, VSEvents.ShipLoadEvent it) {
        Intrinsics.checkNotNullParameter((Object)$shipData, (String)"$shipData");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getShip().getShipData().getId() == $shipData.getId();
    }

    private static final void createNewShipObjectAtBlock$lambda$15(CompletableFuture $future, VSEvents.ShipLoadEvent it) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $future.complete(it.getShip());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$Stages;", "", "<init>", "(Ljava/lang/String;I)V", "PRE_TICK", "POST_TICK_START", "POST_TICK_GENERATED", "POST_TICK_FINISH", "GET_CURRENT_TICK_CHANGES", "GET_LAST_TICK_CHANGES", "UPDATE_DIMENSIONS", "UPDATE_BLOCKS", "UPDATE_CHUNKS", "UPDATE_PLAYERS", "CLEAR_FOR_RESET", "impl"})
    private static final class Stages
    extends Enum<Stages> {
        public static final /* enum */ Stages PRE_TICK = new Stages();
        public static final /* enum */ Stages POST_TICK_START = new Stages();
        public static final /* enum */ Stages POST_TICK_GENERATED = new Stages();
        public static final /* enum */ Stages POST_TICK_FINISH = new Stages();
        public static final /* enum */ Stages GET_CURRENT_TICK_CHANGES = new Stages();
        public static final /* enum */ Stages GET_LAST_TICK_CHANGES = new Stages();
        public static final /* enum */ Stages UPDATE_DIMENSIONS = new Stages();
        public static final /* enum */ Stages UPDATE_BLOCKS = new Stages();
        public static final /* enum */ Stages UPDATE_CHUNKS = new Stages();
        public static final /* enum */ Stages UPDATE_PLAYERS = new Stages();
        public static final /* enum */ Stages CLEAR_FOR_RESET = new Stages();
        private static final /* synthetic */ Stages[] $VALUES;

        public static Stages[] values() {
            return (Stages[])$VALUES.clone();
        }

        public static Stages valueOf(String value) {
            return Enum.valueOf(Stages.class, value);
        }

        static {
            $VALUES = stagesArray = new Stages[]{Stages.PRE_TICK, Stages.POST_TICK_START, Stages.POST_TICK_GENERATED, Stages.POST_TICK_FINISH, Stages.GET_CURRENT_TICK_CHANGES, Stages.GET_LAST_TICK_CHANGES, Stages.UPDATE_DIMENSIONS, Stages.UPDATE_BLOCKS, Stages.UPDATE_CHUNKS, Stages.UPDATE_PLAYERS, Stages.CLEAR_FOR_RESET};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B\u00ab\u0001\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b\u0012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b\u0012&\u0010%\u001a\"\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0!j\u0002`$\u0012\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000b\u0012\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u000b\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u00070\u0002\u00a2\u0006\u0004\b\n\u0010\u0006R\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0010R\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0019\u0010\u0010R!\u0010\u001a\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u001b\u0010\u0010R!\u0010\u001c\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001d\u0010\u0010R\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000e\u001a\u0004\b \u0010\u0010R7\u0010%\u001a\"\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0!j\u0002`$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b8\u0006\u00a2\u0006\f\n\u0004\b)\u0010\u000e\u001a\u0004\b*\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$CurrentTickChanges;", "", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "getDeletedShipObjectsIncludingGround", "()Ljava/util/List;", "Lkotlin/Pair;", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "getNewGroundRigidBodyObjects", "", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraintAndId;", "constraintsCreatedThisTick", "Ljava/util/Collection;", "getConstraintsCreatedThisTick", "()Ljava/util/Collection;", "", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraintId;", "constraintsDeletedThisTick", "getConstraintsDeletedThisTick", "constraintsUpdatedThisTick", "getConstraintsUpdatedThisTick", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "deletedShipObjects", "getDeletedShipObjects", "dimensionsAddedThisTick", "getDimensionsAddedThisTick", "dimensionsRemovedThisTick", "getDimensionsRemovedThisTick", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServer;", "newShipObjects", "getNewShipObjects", "", "Lorg/joml/Vector3ic;", "Lorg/valkyrienskies/physics_api/voxel_updates/IVoxelShapeUpdate;", "Lorg/valkyrienskies/core/impl/game/ships/types/ShipVoxelUpdates;", "shipToVoxelUpdates", "Ljava/util/Map;", "getShipToVoxelUpdates", "()Ljava/util/Map;", "updatedShipObjects", "getUpdatedShipObjects", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Map;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "impl"})
    public final class CurrentTickChanges {
        @NotNull
        private final Collection<ShipObjectServer> newShipObjects;
        @NotNull
        private final Collection<ShipObjectServer> updatedShipObjects;
        @NotNull
        private final Collection<ShipData> deletedShipObjects;
        @NotNull
        private final Map<Long, Map<Vector3ic, IVoxelShapeUpdate>> shipToVoxelUpdates;
        @NotNull
        private final Collection<String> dimensionsAddedThisTick;
        @NotNull
        private final Collection<String> dimensionsRemovedThisTick;
        @NotNull
        private final Collection<VSConstraintAndId> constraintsCreatedThisTick;
        @NotNull
        private final Collection<VSConstraintAndId> constraintsUpdatedThisTick;
        @NotNull
        private final Collection<Integer> constraintsDeletedThisTick;

        public CurrentTickChanges(@NotNull Collection<ShipObjectServer> newShipObjects, @NotNull Collection<ShipObjectServer> updatedShipObjects, @NotNull Collection<ShipData> deletedShipObjects, @NotNull Map<Long, ? extends Map<Vector3ic, ? extends IVoxelShapeUpdate>> shipToVoxelUpdates, @NotNull Collection<String> dimensionsAddedThisTick, @NotNull Collection<String> dimensionsRemovedThisTick, @NotNull Collection<VSConstraintAndId> constraintsCreatedThisTick, @NotNull Collection<VSConstraintAndId> constraintsUpdatedThisTick, Collection<Integer> constraintsDeletedThisTick) {
            Intrinsics.checkNotNullParameter(newShipObjects, (String)"newShipObjects");
            Intrinsics.checkNotNullParameter(updatedShipObjects, (String)"updatedShipObjects");
            Intrinsics.checkNotNullParameter(deletedShipObjects, (String)"deletedShipObjects");
            Intrinsics.checkNotNullParameter(shipToVoxelUpdates, (String)"shipToVoxelUpdates");
            Intrinsics.checkNotNullParameter(dimensionsAddedThisTick, (String)"dimensionsAddedThisTick");
            Intrinsics.checkNotNullParameter(dimensionsRemovedThisTick, (String)"dimensionsRemovedThisTick");
            Intrinsics.checkNotNullParameter(constraintsCreatedThisTick, (String)"constraintsCreatedThisTick");
            Intrinsics.checkNotNullParameter(constraintsUpdatedThisTick, (String)"constraintsUpdatedThisTick");
            Intrinsics.checkNotNullParameter(constraintsDeletedThisTick, (String)"constraintsDeletedThisTick");
            this.newShipObjects = newShipObjects;
            this.updatedShipObjects = updatedShipObjects;
            this.deletedShipObjects = deletedShipObjects;
            this.shipToVoxelUpdates = shipToVoxelUpdates;
            this.dimensionsAddedThisTick = dimensionsAddedThisTick;
            this.dimensionsRemovedThisTick = dimensionsRemovedThisTick;
            this.constraintsCreatedThisTick = constraintsCreatedThisTick;
            this.constraintsUpdatedThisTick = constraintsUpdatedThisTick;
            this.constraintsDeletedThisTick = constraintsDeletedThisTick;
        }

        @NotNull
        public final Collection<ShipObjectServer> getNewShipObjects() {
            return this.newShipObjects;
        }

        @NotNull
        public final Collection<ShipObjectServer> getUpdatedShipObjects() {
            return this.updatedShipObjects;
        }

        @NotNull
        public final Collection<ShipData> getDeletedShipObjects() {
            return this.deletedShipObjects;
        }

        @NotNull
        public final Map<Long, Map<Vector3ic, IVoxelShapeUpdate>> getShipToVoxelUpdates() {
            return this.shipToVoxelUpdates;
        }

        @NotNull
        public final Collection<String> getDimensionsAddedThisTick() {
            return this.dimensionsAddedThisTick;
        }

        @NotNull
        public final Collection<String> getDimensionsRemovedThisTick() {
            return this.dimensionsRemovedThisTick;
        }

        @NotNull
        public final Collection<VSConstraintAndId> getConstraintsCreatedThisTick() {
            return this.constraintsCreatedThisTick;
        }

        @NotNull
        public final Collection<VSConstraintAndId> getConstraintsUpdatedThisTick() {
            return this.constraintsUpdatedThisTick;
        }

        @NotNull
        public final Collection<Integer> getConstraintsDeletedThisTick() {
            return this.constraintsDeletedThisTick;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<String, Long>> getNewGroundRigidBodyObjects() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.dimensionsAddedThisTick;
            ShipObjectServerWorld shipObjectServerWorld = ShipObjectServerWorld.this;
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dimensionId;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object v = shipObjectServerWorld.dimensionToGroundBodyId.get(dimensionId);
                Intrinsics.checkNotNull(v);
                collection.add(new Pair((Object)dimensionId, v));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Long> getDeletedShipObjectsIncludingGround() {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Iterable iterable = this.dimensionsRemovedThisTick;
            ShipObjectServerWorld shipObjectServerWorld = ShipObjectServerWorld.this;
            boolean $i$f$map22 = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void dim;
                String string = (String)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                Object v = shipObjectServerWorld.dimensionToGroundBodyId.get(dim);
                Intrinsics.checkNotNull(v);
                collection.add(((Number)v).longValue());
            }
            List deletedGroundShips = (List)destination$iv$iv;
            $this$map$iv = this.deletedShipObjects;
            collection = deletedGroundShips;
            boolean $i$f$map = false;
            Iterable $i$f$map22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (ShipData)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it.getId());
            }
            return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\n\u001a\u00060\u0002j\u0002`\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0014\u0010\u0004\u001a\u00060\u0002j\u0002`\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ.\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\n\u001a\u00060\u0002j\u0002`\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0005R\u001b\u0010\n\u001a\u00060\u0002j\u0002`\u00038\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0016\u001a\u0004\b\u0017\u0010\u0005R\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0018\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$LevelVoxelUpdates;", "", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "component1", "()Ljava/lang/String;", "", "Lorg/valkyrienskies/physics_api/voxel_updates/IVoxelShapeUpdate;", "component2", "()Ljava/util/List;", "dimensionId", "updates", "copy", "(Ljava/lang/String;Ljava/util/List;)Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld$LevelVoxelUpdates;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getDimensionId", "Ljava/util/List;", "getUpdates", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "impl"})
    public static final class LevelVoxelUpdates {
        @NotNull
        private final String dimensionId;
        @NotNull
        private final List<IVoxelShapeUpdate> updates;

        public LevelVoxelUpdates(@NotNull String dimensionId, @NotNull List<? extends IVoxelShapeUpdate> updates) {
            Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
            Intrinsics.checkNotNullParameter(updates, (String)"updates");
            this.dimensionId = dimensionId;
            this.updates = updates;
        }

        @NotNull
        public final String getDimensionId() {
            return this.dimensionId;
        }

        @NotNull
        public final List<IVoxelShapeUpdate> getUpdates() {
            return this.updates;
        }

        @NotNull
        public final String component1() {
            return this.dimensionId;
        }

        @NotNull
        public final List<IVoxelShapeUpdate> component2() {
            return this.updates;
        }

        @NotNull
        public final LevelVoxelUpdates copy(@NotNull String dimensionId, @NotNull List<? extends IVoxelShapeUpdate> updates) {
            Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
            Intrinsics.checkNotNullParameter(updates, (String)"updates");
            return new LevelVoxelUpdates(dimensionId, updates);
        }

        public static /* synthetic */ LevelVoxelUpdates copy$default(LevelVoxelUpdates levelVoxelUpdates, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = levelVoxelUpdates.dimensionId;
            }
            if ((n & 2) != 0) {
                list = levelVoxelUpdates.updates;
            }
            return levelVoxelUpdates.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "LevelVoxelUpdates(dimensionId=" + this.dimensionId + ", updates=" + this.updates + ')';
        }

        public int hashCode() {
            int result2 = this.dimensionId.hashCode();
            result2 = result2 * 31 + ((Object)this.updates).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LevelVoxelUpdates)) {
                return false;
            }
            LevelVoxelUpdates levelVoxelUpdates = (LevelVoxelUpdates)other;
            if (!Intrinsics.areEqual((Object)this.dimensionId, (Object)levelVoxelUpdates.dimensionId)) {
                return false;
            }
            return Intrinsics.areEqual(this.updates, levelVoxelUpdates.updates);
        }
    }
}

