/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.loading;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.chunks.ChunkUnwatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTasks;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkTrackingInfo;
import org.valkyrienskies.core.impl.chunk_tracking.ShipObjectServerWorldChunkTracker;
import org.valkyrienskies.core.impl.game.ChunkAllocatorProvider;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.loading.ShipLoadManagerServer;
import org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerServer;
import org.valkyrienskies.core.impl.util.assertions.stages.TickStageEnforcer;
import org.valkyrienskies.core.impl.util.assertions.stages.TickStageEnforcerKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001>B!\b\u0007\u0012\u0006\u0010+\u001a\u00020*\u0012\u0006\u0010:\u001a\u000209\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b<\u0010=J/\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010JE\u0010\u0016\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\u001c\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R$\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020!8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00128\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180\u00128\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R-\u00104\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b0\u00101*\u0004\b2\u00103R\u001a\u00107\u001a\b\u0012\u0004\u0012\u000206058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u0010:\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer;", "", "", "chunkX", "chunkZ", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "dimensionId", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "getIPlayersWatchingShipChunk", "(IILjava/lang/String;)Ljava/util/Iterator;", "", "players", "", "postTick", "(Ljava/util/Set;)V", "lastTickPlayers", "", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "ships", "deletedShips", "preTick", "(Ljava/util/Set;Ljava/util/Set;Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTask;", "watchTasks", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkUnwatchTask;", "unwatchTasks", "setExecutedChunkWatchTasks", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "allocators", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "<set-?>", "chunkWatchTasks", "Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "getChunkWatchTasks", "()Lorg/valkyrienskies/core/apigame/world/chunks/ChunkWatchTasks;", "executedChunkUnwatchTasks", "Ljava/lang/Iterable;", "executedChunkWatchTasks", "Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerServer;", "networkManager", "Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerServer;", "Lcom/google/common/collect/ImmutableMap;", "Lcom/google/common/collect/ImmutableSet;", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "getPlayersToTrackedShips", "()Lcom/google/common/collect/ImmutableMap;", "getPlayersToTrackedShips$delegate", "(Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer;)Ljava/lang/Object;", "playersToTrackedShips", "Lorg/valkyrienskies/core/impl/util/assertions/stages/TickStageEnforcer;", "Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer$Stages;", "stageEnforcer", "Lorg/valkyrienskies/core/impl/util/assertions/stages/TickStageEnforcer;", "Lorg/valkyrienskies/core/impl/chunk_tracking/ShipObjectServerWorldChunkTracker;", "tracker", "Lorg/valkyrienskies/core/impl/chunk_tracking/ShipObjectServerWorldChunkTracker;", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerServer;Lorg/valkyrienskies/core/impl/chunk_tracking/ShipObjectServerWorldChunkTracker;Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;)V", "Stages", "impl"})
public final class ShipLoadManagerServer {
    @NotNull
    private final ShipObjectNetworkManagerServer networkManager;
    @NotNull
    private final ShipObjectServerWorldChunkTracker tracker;
    @NotNull
    private final ChunkAllocatorProvider allocators;
    @NotNull
    private final TickStageEnforcer<Stages> stageEnforcer;
    private Iterable<? extends ChunkWatchTask> executedChunkWatchTasks;
    private Iterable<? extends ChunkUnwatchTask> executedChunkUnwatchTasks;
    private ChunkWatchTasks chunkWatchTasks;

    @Inject
    public ShipLoadManagerServer(@NotNull ShipObjectNetworkManagerServer networkManager, @NotNull ShipObjectServerWorldChunkTracker tracker, @NotNull ChunkAllocatorProvider allocators) {
        Intrinsics.checkNotNullParameter((Object)networkManager, (String)"networkManager");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)allocators, (String)"allocators");
        this.networkManager = networkManager;
        this.tracker = tracker;
        this.allocators = allocators;
        this.stageEnforcer = TickStageEnforcerKt.TickStageEnforcer(Stages.PRE_TICK, stageEnforcer.1.INSTANCE);
    }

    @NotNull
    public final ImmutableMap<IPlayer, ImmutableSet<ServerShipInternal>> getPlayersToTrackedShips() {
        return this.networkManager.getPlayersToTrackedShips();
    }

    private static Object getPlayersToTrackedShips$delegate(ShipLoadManagerServer shipLoadManagerServer) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)shipLoadManagerServer.networkManager, ShipObjectNetworkManagerServer.class, "playersToTrackedShips", "getPlayersToTrackedShips()Lcom/google/common/collect/ImmutableMap;", 0)));
    }

    @NotNull
    public final ChunkWatchTasks getChunkWatchTasks() {
        ChunkWatchTasks chunkWatchTasks = this.chunkWatchTasks;
        if (chunkWatchTasks != null) {
            return chunkWatchTasks;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chunkWatchTasks");
        return null;
    }

    public final void preTick(@NotNull Set<? extends IPlayer> players, @NotNull Set<? extends IPlayer> lastTickPlayers, @NotNull Iterable<ShipData> ships, @NotNull Iterable<ShipData> deletedShips) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(lastTickPlayers, (String)"lastTickPlayers");
        Intrinsics.checkNotNullParameter(ships, (String)"ships");
        Intrinsics.checkNotNullParameter(deletedShips, (String)"deletedShips");
        this.stageEnforcer.stage(Stages.PRE_TICK);
        this.chunkWatchTasks = this.tracker.generateChunkWatchTasksAndUpdatePlayers(players, lastTickPlayers, ships, deletedShips);
    }

    public final void postTick(@NotNull Set<? extends IPlayer> players) {
        Iterable<? extends ChunkUnwatchTask> iterable;
        Intrinsics.checkNotNullParameter(players, (String)"players");
        this.stageEnforcer.stage(Stages.POST_TICK);
        Iterable<? extends ChunkWatchTask> iterable2 = this.executedChunkWatchTasks;
        if (iterable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executedChunkWatchTasks");
            iterable2 = null;
        }
        if ((iterable = this.executedChunkUnwatchTasks) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executedChunkUnwatchTasks");
            iterable = null;
        }
        ChunkTrackingInfo trackingInfo = this.tracker.applyTasksAndGenerateTrackingInfo(iterable2, iterable);
        this.networkManager.tick((Iterable<? extends IPlayer>)players, trackingInfo);
    }

    public final void setExecutedChunkWatchTasks(@NotNull Iterable<? extends ChunkWatchTask> watchTasks, @NotNull Iterable<? extends ChunkUnwatchTask> unwatchTasks) {
        Intrinsics.checkNotNullParameter(watchTasks, (String)"watchTasks");
        Intrinsics.checkNotNullParameter(unwatchTasks, (String)"unwatchTasks");
        this.stageEnforcer.stage(Stages.SET_EXECUTED);
        this.executedChunkWatchTasks = watchTasks;
        this.executedChunkUnwatchTasks = unwatchTasks;
    }

    @NotNull
    public final Iterator<IPlayer> getIPlayersWatchingShipChunk(int chunkX, int chunkZ, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        if (this.allocators.forDimension(dimensionId).isChunkInShipyard(chunkX, chunkZ)) {
            return this.tracker.getPlayersWatchingChunk(chunkX, chunkZ, dimensionId).iterator();
        }
        Iterator<IPlayer> iterator2 = Collections.emptyIterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"emptyIterator()");
        return iterator2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/loading/ShipLoadManagerServer$Stages;", "", "<init>", "(Ljava/lang/String;I)V", "PRE_TICK", "SET_EXECUTED", "POST_TICK", "impl"})
    private static final class Stages
    extends Enum<Stages> {
        public static final /* enum */ Stages PRE_TICK = new Stages();
        public static final /* enum */ Stages SET_EXECUTED = new Stages();
        public static final /* enum */ Stages POST_TICK = new Stages();
        private static final /* synthetic */ Stages[] $VALUES;

        public static Stages[] values() {
            return (Stages[])$VALUES.clone();
        }

        public static Stages valueOf(String value) {
            return Enum.valueOf(Stages.class, value);
        }

        static {
            $VALUES = stagesArray = new Stages[]{Stages.PRE_TICK, Stages.SET_EXECUTED, Stages.POST_TICK};
        }
    }
}

