/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.networking;

import com.fasterxml.jackson.databind.JsonNode;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.AdaptedFunctionReference;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClientWorld;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerClient;
import org.valkyrienskies.core.impl.networking.ClientHandler;
import org.valkyrienskies.core.impl.networking.Packet;
import org.valkyrienskies.core.impl.networking.Packets;
import org.valkyrienskies.core.impl.networking.RegisteredHandler;
import org.valkyrienskies.core.impl.networking.RegisteredHandlerKt;
import org.valkyrienskies.core.impl.networking.VSCryptUtils;
import org.valkyrienskies.core.impl.networking.VSNetworking;
import org.valkyrienskies.core.impl.networking.impl.PacketShipDataCreate;
import org.valkyrienskies.core.impl.networking.impl.PacketShipRemove;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.core.impl.util.VSCoreUtilKt;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ;2\u00020\u0001:\u0002;<B+\b\u0007\u0012\b\b\u0001\u0010)\u001a\u00020(\u0012\u0006\u0010#\u001a\u00020\"\u0012\u0006\u00100\u001a\u00020/\u0012\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b9\u0010:J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0004J\u0015\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0018\u0010,\u001a\u0004\u0018\u00010+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010\u001dR\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00108\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006="}, d2={"Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient;", "", "", "onDestroy", "()V", "Lorg/valkyrienskies/core/impl/networking/impl/PacketShipDataCreate;", "packet", "Lkotlinx/coroutines/Job;", "onShipDataCreate", "(Lorg/valkyrienskies/core/impl/networking/impl/PacketShipDataCreate;)Lkotlinx/coroutines/Job;", "Lorg/valkyrienskies/core/impl/networking/Packet;", "onShipDataDelta", "(Lorg/valkyrienskies/core/impl/networking/Packet;)Lkotlinx/coroutines/Job;", "Lorg/valkyrienskies/core/impl/networking/impl/PacketShipRemove;", "onShipDataRemove", "(Lorg/valkyrienskies/core/impl/networking/impl/PacketShipRemove;)Lkotlinx/coroutines/Job;", "onShipTransform", "(Lorg/valkyrienskies/core/impl/networking/Packet;)V", "registerPacketListeners", "Ljava/net/SocketAddress;", "server", "tick", "(Ljava/net/SocketAddress;)V", "", "Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "handlers", "Ljava/util/List;", "", "hasReceivedInitialShips", "Z", "getHasReceivedInitialShips", "()Z", "setHasReceivedInitialShips", "(Z)V", "Lorg/valkyrienskies/core/impl/networking/VSNetworking;", "networking", "Lorg/valkyrienskies/core/impl/networking/VSNetworking;", "Lorg/valkyrienskies/core/impl/networking/Packets;", "packets", "Lorg/valkyrienskies/core/impl/networking/Packets;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;", "parent", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;", "Ljavax/crypto/SecretKey;", "secretKey", "Ljavax/crypto/SecretKey;", "serverNoUdp", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "spNetwork", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "", "tryConnectIn", "I", "Lkotlinx/coroutines/CoroutineScope;", "getWorldScope", "()Lkotlinx/coroutines/CoroutineScope;", "worldScope", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;Lorg/valkyrienskies/core/impl/networking/VSNetworking;Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;Lorg/valkyrienskies/core/impl/networking/Packets;)V", "Companion", "Factory", "impl"})
public final class ShipObjectNetworkManagerClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShipObjectClientWorld parent;
    @NotNull
    private final VSNetworking networking;
    @NotNull
    private final SimplePacketNetworking spNetwork;
    @NotNull
    private final Packets packets;
    private List<? extends RegisteredHandler> handlers;
    @Nullable
    private SecretKey secretKey;
    private volatile boolean hasReceivedInitialShips;
    private boolean serverNoUdp;
    private int tryConnectIn;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerClient$Companion.$$delegatedProperties[0]);

    @AssistedInject
    public ShipObjectNetworkManagerClient(@Assisted @NotNull ShipObjectClientWorld parent, @NotNull VSNetworking networking, @NotNull SimplePacketNetworking spNetwork, @NotNull Packets packets) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)networking, (String)"networking");
        Intrinsics.checkNotNullParameter((Object)spNetwork, (String)"spNetwork");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        this.parent = parent;
        this.networking = networking;
        this.spNetwork = spNetwork;
        this.packets = packets;
        this.tryConnectIn = 100;
    }

    private final CoroutineScope getWorldScope() {
        return this.parent.getCoroutineScope();
    }

    public final boolean getHasReceivedInitialShips() {
        return this.hasReceivedInitialShips;
    }

    public final void setHasReceivedInitialShips(boolean bl) {
        this.hasReceivedInitialShips = bl;
    }

    public final void registerPacketListeners() {
        Object[] objectArray = new RegisteredHandler[]{this.packets.getUDP_SHIP_TRANSFORM().registerClientHandler(new ClientHandler(this){
            final /* synthetic */ ShipObjectNetworkManagerClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handlePacket(@NotNull Packet p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ShipObjectNetworkManagerClient.access$onShipTransform(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, ShipObjectNetworkManagerClient.class, "onShipTransform", "onShipTransform(Lorg/valkyrienskies/core/impl/networking/Packet;)V", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ClientHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }), this.packets.getTCP_SHIP_DATA_DELTA().registerClientHandler(new ClientHandler(this){
            final /* synthetic */ ShipObjectNetworkManagerClient $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void handlePacket(@NotNull Packet p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ShipObjectNetworkManagerClient.access$onShipDataDelta(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new AdaptedFunctionReference(1, (Object)this.$tmp0, ShipObjectNetworkManagerClient.class, "onShipDataDelta", "onShipDataDelta(Lorg/valkyrienskies/core/impl/networking/Packet;)Lkotlinx/coroutines/Job;", 8);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ClientHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }), this.spNetwork.registerClientHandler(Reflection.getOrCreateKotlinClass(PacketShipDataCreate.class), (Function1)new Function1<PacketShipDataCreate, Unit>((Object)this){

            public final void invoke(@NotNull PacketShipDataCreate p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ShipObjectNetworkManagerClient.access$onShipDataCreate((ShipObjectNetworkManagerClient)registerPacketListeners.3.access$getReceiver$p(this), p0);
            }

            public static final /* synthetic */ Object access$getReceiver$p(registerPacketListeners.3 $this) {
                return $this.receiver;
            }
        }), this.spNetwork.registerClientHandler(Reflection.getOrCreateKotlinClass(PacketShipRemove.class), (Function1)new Function1<PacketShipRemove, Unit>((Object)this){

            public final void invoke(@NotNull PacketShipRemove p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ShipObjectNetworkManagerClient.access$onShipDataRemove((ShipObjectNetworkManagerClient)registerPacketListeners.4.access$getReceiver$p(this), p0);
            }

            public static final /* synthetic */ Object access$getReceiver$p(registerPacketListeners.4 $this) {
                return $this.receiver;
            }
        })};
        this.handlers = CollectionsKt.listOf((Object[])objectArray);
        this.networking.getTCP().clientIsReady();
        this.networking.getUDP().clientIsReady();
    }

    public final void onDestroy() {
        List<? extends RegisteredHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
            list = null;
        }
        RegisteredHandlerKt.unregisterAll((Iterable<? extends RegisteredHandler>)list);
        this.secretKey = null;
        this.networking.getTCP().disable();
        this.networking.getUDP().disable();
    }

    private final Job onShipDataRemove(PacketShipRemove packet) {
        return BuildersKt.launch$default(this.getWorldScope(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(packet, this, null){
            int label;
            final /* synthetic */ PacketShipRemove $packet;
            final /* synthetic */ ShipObjectNetworkManagerClient this$0;
            {
                this.$packet = $packet;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable iterable = this.$packet.getToRemove();
                        ShipObjectClientWorld shipObjectClientWorld = ShipObjectNetworkManagerClient.access$getParent$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            long p0 = ((Number)element$iv).longValue();
                            boolean bl = false;
                            shipObjectClientWorld.removeShip(p0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final Job onShipDataCreate(PacketShipDataCreate packet) {
        return BuildersKt.launch$default(this.getWorldScope(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(packet, this, null){
            int label;
            final /* synthetic */ PacketShipDataCreate $packet;
            final /* synthetic */ ShipObjectNetworkManagerClient this$0;
            {
                this.$packet = $packet;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        for (ShipDataCommon ship : this.$packet.getToCreate()) {
                            if (ShipObjectNetworkManagerClient.access$getParent$p(this.this$0).getAllShips().getById(ship.getId()) == null) {
                                ShipObjectNetworkManagerClient.access$getParent$p(this.this$0).addShip(ship);
                                continue;
                            }
                            ShipObjectClient shipObjectClient = (ShipObjectClient)ShipObjectNetworkManagerClient.access$getParent$p(this.this$0).getShipObjects().get(Boxing.boxLong((long)ship.getId()));
                            if (shipObjectClient != null) {
                                shipObjectClient.setNextShipTransform(ship.getTransform());
                            }
                            Throwable throwable = org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerClient$Companion.access$getLogger(ShipObjectNetworkManagerClient.Companion).throwing((Throwable)new IllegalArgumentException("Received ship create packet for already loaded ship?!"));
                            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"logger.throwing(\n       \u2026hip?!\")\n                )");
                            throw throwable;
                        }
                        this.this$0.setHasReceivedInitialShips(true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final Job onShipDataDelta(Packet packet) {
        Job job;
        Job it = job = BuildersKt.launch$default(this.getWorldScope(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(packet, this, null){
            int label;
            final /* synthetic */ Packet $packet;
            final /* synthetic */ ShipObjectNetworkManagerClient this$0;
            {
                this.$packet = $packet;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ByteBuf buf = this.$packet.getData();
                        while (buf.isReadable()) {
                            long shipId = buf.readLong();
                            ShipObjectClient ship = ShipObjectNetworkManagerClient.access$getParent$p(this.this$0).getLoadedShips().getById(shipId);
                            if (ship == null) {
                                org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerClient$Companion.access$getLogger(ShipObjectNetworkManagerClient.Companion).warn("Received ship data delta for ship with unknown ID!");
                                buf.release();
                                return Unit.INSTANCE;
                            }
                            JsonNode shipDataJson = ship.getShipDataChannel().decode(buf);
                            AABBic original = ship.getShipData().getShipAABB();
                            VSJacksonUtil.INSTANCE.getDeltaMapper().readerForUpdating(ship.getShipData()).readValue(shipDataJson);
                            ship.getShipData().setShipAABB(original);
                        }
                        buf.release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        boolean bl = false;
        packet.getData().retain();
        return job;
    }

    private final void onShipTransform(Packet packet) {
        ByteBuf buf = packet.getData();
        Companion.readShipTransform(buf, this.parent.getShipObjects());
    }

    public final void tick(@NotNull SocketAddress server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!this.networking.getClientUsesUDP() && !this.serverNoUdp) {
            int n = this.tryConnectIn;
            this.tryConnectIn = n + -1;
            if (this.tryConnectIn <= 0) {
                SecretKey secretKey = this.secretKey = VSCryptUtils.INSTANCE.generateAES128Key();
                Intrinsics.checkNotNull((Object)secretKey);
                this.networking.tryUdpClient(server, secretKey, arg_0 -> ShipObjectNetworkManagerClient.tick$lambda$1(this, arg_0));
                this.tryConnectIn = 100;
            }
        }
    }

    private static final void tick$lambda$1(ShipObjectNetworkManagerClient this$0, boolean supports) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!supports) {
            this$0.serverNoUdp = true;
        }
    }

    public static final /* synthetic */ void access$onShipTransform(ShipObjectNetworkManagerClient $this, Packet packet) {
        $this.onShipTransform(packet);
    }

    public static final /* synthetic */ Job access$onShipDataDelta(ShipObjectNetworkManagerClient $this, Packet packet) {
        return $this.onShipDataDelta(packet);
    }

    public static final /* synthetic */ Job access$onShipDataCreate(ShipObjectNetworkManagerClient $this, PacketShipDataCreate packet) {
        return $this.onShipDataCreate(packet);
    }

    public static final /* synthetic */ Job access$onShipDataRemove(ShipObjectNetworkManagerClient $this, PacketShipRemove packet) {
        return $this.onShipDataRemove(packet);
    }

    public static final /* synthetic */ ShipObjectClientWorld access$getParent$p(ShipObjectNetworkManagerClient $this) {
        return $this.parent;
    }

    @AssistedFactory
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient$Factory;", "", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;", "parent", "Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient;", "make", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;)Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient;", "impl"})
    public static interface Factory {
        @NotNull
        public ShipObjectNetworkManagerClient make(@NotNull ShipObjectClientWorld var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0004\b\n\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient$Companion;", "", "Lio/netty/buffer/ByteBuf;", "buf", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClient;", "shipObjects", "", "readShipTransform", "(Lio/netty/buffer/ByteBuf;Ljava/util/Map;)V", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public final void readShipTransform(@NotNull ByteBuf buf, @NotNull Map<Long, ShipObjectClient> shipObjects) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter(shipObjects, (String)"shipObjects");
            int tickNum = buf.readInt();
            try {
                while (buf.isReadable()) {
                    long shipId = buf.readLong();
                    ShipObjectClient ship = shipObjects.get(shipId);
                    if (ship == null) {
                        this.getLogger().debug("Received ship transform for ship with unknown id: " + shipId);
                        buf.skipBytes(120);
                        continue;
                    }
                    if (ship.getLatestNetworkTTick() >= tickNum) {
                        buf.skipBytes(120);
                        continue;
                    }
                    Vector3d centerOfMass = VSCoreUtilKt.readVec3d(buf);
                    Vector3d scaling = VSCoreUtilKt.readVec3fAsDouble(buf);
                    Quaterniond rotation = VSCoreUtilKt.read3FAsNormQuatd(buf);
                    Vector3d position = VSCoreUtilKt.readVec3d(buf);
                    Vector3d velocity = VSCoreUtilKt.readVec3fAsDouble(buf);
                    Vector3d omega = VSCoreUtilKt.readVec3fAsDouble(buf);
                    AABBi shipAABB = VSCoreUtilKt.readAABBi(buf);
                    ship.setLatestNetworkTransform(ShipTransformImpl.Companion.create(position, centerOfMass, rotation, scaling));
                    ship.setLatestNetworkTTick(tickNum);
                    ship.getShipData().getPhysicsData().setAngularVelocity(omega);
                    ship.getShipData().getPhysicsData().setLinearVelocity(velocity);
                    if (!shipAABB.isValid()) continue;
                    ship.getShipData().setShipAABB(shipAABB);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Something went wrong when reading ship transform packets", (Throwable)e);
            }
        }

        public static final /* synthetic */ Logger access$getLogger(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

