/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.networking;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.Lazy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.chunk_tracking.ChunkTrackingInfo;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServer;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.Packets;
import org.valkyrienskies.core.impl.networking.VSNetworking;
import org.valkyrienskies.core.impl.networking.delta.DeltaEncodedChannelServerTCP;
import org.valkyrienskies.core.impl.networking.impl.PacketShipDataCreate;
import org.valkyrienskies.core.impl.networking.impl.PacketShipRemove;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.DaggerUtilKt;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.core.impl.util.VSCoreUtilKt;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 82\u00020\u0001:\u00018B;\b\u0007\u0012\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c04\u0012\b\b\u0001\u0010/\u001a\u00020.\u0012\b\b\u0001\u00103\u001a\u00020.\u0012\u0006\u0010,\u001a\u00020+\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b6\u00107J%\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\r\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\tJ#\u0010\u0011\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001b\u0010!\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\"R4\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050$0#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020\u000f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00100\u00a8\u00069"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerServer;", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "shipsToNotTrack", "", "endTracking", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;Ljava/lang/Iterable;)V", "sendEmptyWatchPacketToNewPlayer", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "shipsToTrack", "startTracking", "players", "Lorg/valkyrienskies/core/impl/chunk_tracking/ChunkTrackingInfo;", "trackingInfo", "tick", "(Ljava/lang/Iterable;Lorg/valkyrienskies/core/impl/chunk_tracking/ChunkTrackingInfo;)V", "updateShipData", "()V", "updateTrackedShips", "updateTracking", "getTrackedShips", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)Ljava/lang/Iterable;", "Lorg/valkyrienskies/core/impl/networking/Packets;", "packets", "Lorg/valkyrienskies/core/impl/networking/Packets;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "parent$delegate", "Ldagger/Lazy;", "getParent", "()Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "parent", "Ljava/lang/Iterable;", "Lcom/google/common/collect/ImmutableMap;", "Lcom/google/common/collect/ImmutableSet;", "playersToTrackedShips", "Lcom/google/common/collect/ImmutableMap;", "getPlayersToTrackedShips", "()Lcom/google/common/collect/ImmutableMap;", "setPlayersToTrackedShips", "(Lcom/google/common/collect/ImmutableMap;)V", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "spNetwork", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "tcp", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "tracker", "Lorg/valkyrienskies/core/impl/chunk_tracking/ChunkTrackingInfo;", "udp", "Ldagger/Lazy;", "_parent", "<init>", "(Ldagger/Lazy;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;Lorg/valkyrienskies/core/impl/networking/Packets;)V", "Companion", "impl"})
public final class ShipObjectNetworkManagerServer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final NetworkChannel tcp;
    @NotNull
    private final NetworkChannel udp;
    @NotNull
    private final SimplePacketNetworking spNetwork;
    @NotNull
    private final Packets packets;
    @NotNull
    private final Lazy parent$delegate;
    private Iterable<? extends IPlayer> players;
    private ChunkTrackingInfo tracker;
    @NotNull
    private volatile ImmutableMap<IPlayer, ImmutableSet<ServerShipInternal>> playersToTrackedShips;
    @NotNull
    private static final Logger logger$delegate;

    @Inject
    public ShipObjectNetworkManagerServer(@NotNull Lazy<ShipObjectServerWorld> _parent, @VSNetworking.NetworkingModule.TCP @NotNull NetworkChannel tcp, @VSNetworking.NetworkingModule.UDP @NotNull NetworkChannel udp, @NotNull SimplePacketNetworking spNetwork, @NotNull Packets packets) {
        Intrinsics.checkNotNullParameter(_parent, (String)"_parent");
        Intrinsics.checkNotNullParameter((Object)tcp, (String)"tcp");
        Intrinsics.checkNotNullParameter((Object)udp, (String)"udp");
        Intrinsics.checkNotNullParameter((Object)spNetwork, (String)"spNetwork");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        this.tcp = tcp;
        this.udp = udp;
        this.spNetwork = spNetwork;
        this.packets = packets;
        this.parent$delegate = _parent;
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of()");
        this.playersToTrackedShips = immutableMap;
        this.tcp.serverIsReady();
        this.udp.serverIsReady();
    }

    private final ShipObjectServerWorld getParent() {
        return (ShipObjectServerWorld)DaggerUtilKt.getValue(this.parent$delegate, this, $$delegatedProperties[0]);
    }

    public final void tick(@NotNull Iterable<? extends IPlayer> players, @NotNull ChunkTrackingInfo trackingInfo) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter((Object)trackingInfo, (String)"trackingInfo");
        this.players = players;
        this.tracker = trackingInfo;
        this.updateShipData();
        this.updateTracking();
        this.updateTrackedShips();
    }

    private final Iterable<ServerShipInternal> getTrackedShips(IPlayer $this$getTrackedShips) {
        ChunkTrackingInfo chunkTrackingInfo = this.tracker;
        if (chunkTrackingInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
            chunkTrackingInfo = null;
        }
        return chunkTrackingInfo.getShipsPlayerIsWatching($this$getTrackedShips);
    }

    private final void updateTrackedShips() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ChunkTrackingInfo chunkTrackingInfo = this.tracker;
        if (chunkTrackingInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
            chunkTrackingInfo = null;
        }
        Map<IPlayer, Map<ServerShipInternal, LongSet>> $this$forEach$iv = chunkTrackingInfo.getPlayersToShipsWatchingMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IPlayer, Map<ServerShipInternal, LongSet>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IPlayer, Map<ServerShipInternal, LongSet>> element$iv;
            Map.Entry<IPlayer, Map<ServerShipInternal, LongSet>> entry = element$iv = iterator2.next();
            boolean bl = false;
            IPlayer player = entry.getKey();
            Map<ServerShipInternal, LongSet> ships = entry.getValue();
            builder.put((Object)player, VSCoreUtilKt.toImmutableSet((Iterable)ships.keySet()));
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"builder.build()");
        this.playersToTrackedShips = immutableMap;
    }

    @NotNull
    public final ImmutableMap<IPlayer, ImmutableSet<ServerShipInternal>> getPlayersToTrackedShips() {
        return this.playersToTrackedShips;
    }

    public final void setPlayersToTrackedShips(@NotNull ImmutableMap<IPlayer, ImmutableSet<ServerShipInternal>> immutableMap) {
        Intrinsics.checkNotNullParameter(immutableMap, (String)"<set-?>");
        this.playersToTrackedShips = immutableMap;
    }

    private final void updateTracking() {
        ChunkTrackingInfo chunkTrackingInfo = this.tracker;
        if (chunkTrackingInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
            chunkTrackingInfo = null;
        }
        Map<IPlayer, Set<ServerShipInternal>> $this$forEach$iv = chunkTrackingInfo.getPlayersToShipsNewlyWatchingMap();
        boolean bl = false;
        Iterator<Map.Entry<IPlayer, Set<ServerShipInternal>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IPlayer, Set<ServerShipInternal>> element$iv;
            Map.Entry<IPlayer, Set<ServerShipInternal>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            IPlayer player = entry.getKey();
            Set<ServerShipInternal> ships = entry.getValue();
            this.startTracking(player, (Iterable<? extends ServerShipInternal>)ships);
        }
        Iterable<? extends IPlayer> iterable = this.players;
        if (iterable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            iterable = null;
        }
        for (IPlayer iPlayer : iterable) {
            ChunkTrackingInfo chunkTrackingInfo2;
            Set shipsNoLongerWatching;
            Set set;
            ChunkTrackingInfo chunkTrackingInfo3 = this.tracker;
            if (chunkTrackingInfo3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                chunkTrackingInfo3 = null;
            }
            if ((set = chunkTrackingInfo3.getPlayersToShipsNoLongerWatchingMap().get(iPlayer)) == null) {
                set = shipsNoLongerWatching = SetsKt.emptySet();
            }
            if ((chunkTrackingInfo2 = this.tracker) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                chunkTrackingInfo2 = null;
            }
            this.endTracking(iPlayer, SetsKt.plus(chunkTrackingInfo2.getShipsToUnload(), (Iterable)shipsNoLongerWatching));
            this.sendEmptyWatchPacketToNewPlayer(iPlayer);
        }
    }

    private final void sendEmptyWatchPacketToNewPlayer(IPlayer player) {
        ChunkTrackingInfo chunkTrackingInfo = this.tracker;
        if (chunkTrackingInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
            chunkTrackingInfo = null;
        }
        if (chunkTrackingInfo.getNewPlayers().contains(player)) {
            Collection collection;
            ChunkTrackingInfo chunkTrackingInfo2 = this.tracker;
            if (chunkTrackingInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                chunkTrackingInfo2 = null;
            }
            if ((collection = (Collection)chunkTrackingInfo2.getPlayersToShipsNewlyWatchingMap().get(player)) == null || collection.isEmpty()) {
                this.spNetwork.sendToClient(new PacketShipDataCreate(CollectionsKt.emptyList()), player);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void endTracking(IPlayer player, Iterable<? extends ServerShipInternal> shipsToNotTrack) {
        void $this$mapTo$iv$iv;
        Iterable<? extends ServerShipInternal> $this$map$iv = shipsToNotTrack;
        boolean $i$f$map = false;
        Iterable<? extends ServerShipInternal> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerShipInternal serverShipInternal = (ServerShipInternal)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List shipIds = (List)destination$iv$iv;
        if (shipIds.isEmpty()) {
            return;
        }
        ShipObjectNetworkManagerServer.Companion.getLogger().debug(player.getUuid() + " unwatched ships " + shipIds);
        this.spNetwork.sendToClient(new PacketShipRemove(shipIds), player);
    }

    private final void startTracking(IPlayer player, Iterable<? extends ServerShipInternal> shipsToTrack) {
        Collection<Long> collection;
        ShipDataCommon it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = shipsToTrack;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ServerShipInternal serverShipInternal = (ServerShipInternal)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.asShipDataCommon());
        }
        List ships = (List)destination$iv$iv;
        if (ships.isEmpty()) {
            return;
        }
        $this$map$iv = ships;
        StringBuilder stringBuilder = new StringBuilder().append(player.getUuid()).append(" watched ships: ");
        object = ShipObjectNetworkManagerServer.Companion.getLogger();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ShipDataCommon)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        object.debug(stringBuilder.append(collection).toString());
        this.spNetwork.sendToClient(new PacketShipDataCreate(ships), player);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateShipData() {
        Iterable<? extends IPlayer> iterable = this.players;
        if (iterable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            iterable = null;
        }
        for (IPlayer iPlayer : iterable) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set set;
            ByteBuf buf = Unpooled.buffer();
            ChunkTrackingInfo chunkTrackingInfo = this.tracker;
            if (chunkTrackingInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                chunkTrackingInfo = null;
            }
            if ((set = chunkTrackingInfo.getPlayersToShipsNewlyWatchingMap().get(iPlayer)) == null) {
                set = SetsKt.emptySet();
            }
            Set newlyWatching = set;
            Iterable<ServerShipInternal> iterable2 = this.getTrackedShips(iPlayer);
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerShipInternal tracked = (ServerShipInternal)element$iv$iv;
                boolean bl = false;
                if (!(!newlyWatching.contains(tracked))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                ShipObjectServer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                ServerShipInternal it = (ServerShipInternal)element$iv$iv;
                boolean bl2 = false;
                if (this.getParent().getShipObject(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List trackedShips = (List)destination$iv$iv;
            if (trackedShips.isEmpty()) continue;
            Iterable $this$forEach$iv = trackedShips;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                ShipObjectServer ship = (ShipObjectServer)element$iv;
                boolean bl = false;
                buf.writeLong(ship.getShipData().getId());
                Object json = VSJacksonUtil.INSTANCE.getDeltaMapper().valueToTree(ship.getShipData());
                DeltaEncodedChannelServerTCP<JsonNode> deltaEncodedChannelServerTCP = ship.getShipDataChannel();
                Intrinsics.checkNotNullExpressionValue(json, (String)"json");
                Intrinsics.checkNotNullExpressionValue((Object)buf, (String)"buf");
                deltaEncodedChannelServerTCP.encode((JsonNode)json, buf);
            }
            PacketType packetType = this.packets.getTCP_SHIP_DATA_DELTA();
            Intrinsics.checkNotNullExpressionValue((Object)buf, (String)"buf");
            packetType.sendToClient(buf, iPlayer);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ShipObjectNetworkManagerServer.class, "parent", "getParent()Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerServer$Companion.$$delegatedProperties[0]);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001b\u0010\u0007\u001a\u00020\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerServer$Companion;", "", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

