/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.serialization.vspipeline;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.impl.game.ChunkAllocator;
import org.valkyrienskies.core.impl.game.ChunkAllocatorProvider;
import org.valkyrienskies.core.impl.game.SingletonChunkAllocatorProviderImpl;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.modules.ShipWorldModule;
import org.valkyrienskies.core.impl.game.ships.serialization.ChainUpdater;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.ServerShipDataConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV0;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV0Updater;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV1;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.VSPipelineDataConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.dto.VSPipelineData;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.dto.VSPipelineDataV1;
import org.valkyrienskies.core.impl.game.ships.serialization.vspipeline.dto.VSPipelineDataV3;
import org.valkyrienskies.core.impl.pipelines.VSPipelineImpl;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\b\u0007\u0012\b\b\u0001\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0006\u0010$\u001a\u00020#\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineSerializer;", "", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineData;", "pipelineData", "Lorg/valkyrienskies/core/impl/game/ships/modules/ShipWorldModule;", "asVsPipelineModule", "(Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineData;)Lorg/valkyrienskies/core/impl/game/ships/modules/ShipWorldModule;", "", "bytes", "deserialize", "([B)Lorg/valkyrienskies/core/impl/game/ships/modules/ShipWorldModule;", "queryableShipDataBytes", "chunkAllocatorBytes", "deserializeLegacy", "([B[B)Lorg/valkyrienskies/core/impl/game/ships/modules/ShipWorldModule;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineDataV1;", "deserializeLegacyAsV1", "([B[B)Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineDataV1;", "Lorg/valkyrienskies/core/impl/pipelines/VSPipelineImpl;", "pipeline", "serialize", "(Lorg/valkyrienskies/core/impl/pipelines/VSPipelineImpl;)[B", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineDataConverter;", "pipelineDataConverter", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineDataConverter;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;", "shipDataMapper", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/ChainUpdater;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/dto/VSPipelineDataV3;", "updater", "Lorg/valkyrienskies/core/impl/game/ships/serialization/ChainUpdater;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV0Updater;", "v0Updater", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV0Updater;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;Lorg/valkyrienskies/core/impl/game/ships/serialization/ChainUpdater;Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV0Updater;Lorg/valkyrienskies/core/impl/game/ships/serialization/vspipeline/VSPipelineDataConverter;)V", "impl"})
public final class VSPipelineSerializer {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ServerShipDataConverter shipDataMapper;
    @NotNull
    private final ChainUpdater<VSPipelineDataV3> updater;
    @NotNull
    private final ServerShipDataV0Updater v0Updater;
    @NotNull
    private final VSPipelineDataConverter pipelineDataConverter;

    @Inject
    public VSPipelineSerializer(@Named(value="dto") @NotNull ObjectMapper objectMapper, @NotNull ServerShipDataConverter shipDataMapper, @NotNull ChainUpdater<VSPipelineDataV3> updater, @NotNull ServerShipDataV0Updater v0Updater, @NotNull VSPipelineDataConverter pipelineDataConverter) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)shipDataMapper, (String)"shipDataMapper");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        Intrinsics.checkNotNullParameter((Object)v0Updater, (String)"v0Updater");
        Intrinsics.checkNotNullParameter((Object)pipelineDataConverter, (String)"pipelineDataConverter");
        this.objectMapper = objectMapper;
        this.shipDataMapper = shipDataMapper;
        this.updater = updater;
        this.v0Updater = v0Updater;
        this.pipelineDataConverter = pipelineDataConverter;
    }

    @NotNull
    public final ShipWorldModule deserializeLegacy(@NotNull byte[] queryableShipDataBytes, @NotNull byte[] chunkAllocatorBytes) {
        Intrinsics.checkNotNullParameter((Object)queryableShipDataBytes, (String)"queryableShipDataBytes");
        Intrinsics.checkNotNullParameter((Object)chunkAllocatorBytes, (String)"chunkAllocatorBytes");
        return this.asVsPipelineModule(this.deserializeLegacyAsV1(queryableShipDataBytes, chunkAllocatorBytes));
    }

    @NotNull
    public final ShipWorldModule deserialize(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ObjectMapper $this$readValue$iv = this.objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        VSPipelineData data = (VSPipelineData)$this$readValue$iv.readValue(bytes, (TypeReference)new TypeReference<VSPipelineData>(){});
        VSPipelineDataV3 updated = this.updater.updateToLatest(data);
        return this.pipelineDataConverter.convertToModel(updated);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serialize(@NotNull VSPipelineImpl pipeline) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Iterable iterable = pipeline.getShipWorld().getAllShips();
        ServerShipDataConverter serverShipDataConverter = this.shipDataMapper;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ShipData shipData = (ShipData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(serverShipDataConverter.convertToDto((ShipData)p0));
        }
        List ships = (List)destination$iv$iv;
        ChunkAllocatorProvider chunkAllocatorProvider = pipeline.getShipWorld().getChunkAllocators();
        Intrinsics.checkNotNull((Object)chunkAllocatorProvider, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.SingletonChunkAllocatorProviderImpl");
        ChunkAllocator chunks = ((SingletonChunkAllocatorProviderImpl)chunkAllocatorProvider).getAllocator();
        VSPipelineDataV3 pipelineData = new VSPipelineDataV3(chunks, ships);
        byte[] byArray = this.objectMapper.writeValueAsBytes(pipelineData);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"objectMapper.writeValueAsBytes(pipelineData)");
        return byArray;
    }

    private final ShipWorldModule asVsPipelineModule(VSPipelineData pipelineData) {
        return this.pipelineDataConverter.convertToModel(this.updater.updateToLatest(pipelineData));
    }

    /*
     * WARNING - void declaration
     */
    private final VSPipelineDataV1 deserializeLegacyAsV1(byte[] queryableShipDataBytes, byte[] chunkAllocatorBytes) {
        void $this$mapTo$iv$iv;
        ObjectMapper $this$readValue$iv = VSJacksonUtil.INSTANCE.getDefaultMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        List ships = (List)$this$readValue$iv.readValue(queryableShipDataBytes, (TypeReference)new TypeReference<List<? extends ServerShipDataV0>>(){});
        ObjectMapper $this$readValue$iv2 = VSJacksonUtil.INSTANCE.getDefaultMapper();
        boolean $i$f$readValue2 = false;
        boolean $i$f$jacksonTypeRef2 = false;
        ChunkAllocator allocator = (ChunkAllocator)$this$readValue$iv2.readValue(chunkAllocatorBytes, (TypeReference)new TypeReference<ChunkAllocator>(){});
        Iterable $this$map$iv = ships;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerShipDataV0 serverShipDataV0 = (ServerShipDataV0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ServerShipDataV1)this.v0Updater.update(it));
        }
        List updated = (List)destination$iv$iv;
        return new VSPipelineDataV1(allocator, updated);
    }
}

