/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.ClientHandler;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.Packet;
import org.valkyrienskies.core.impl.networking.RegisteredHandler;
import org.valkyrienskies.core.impl.networking.ServerHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b5\u00106J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0007J\u0015\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010'\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J)\u0010+\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0)\"\u00020%\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010-\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b-\u0010$J\u0010\u0010.\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b.\u0010\nR\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010/\u001a\u0004\b0\u0010\u0004R\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u00101\u001a\u0004\b2\u0010\u0007R\u0017\u0010\r\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u00103\u001a\u0004\b4\u0010\n\u00a8\u00067"}, d2={"Lorg/valkyrienskies/core/impl/networking/PacketType;", "", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "component1", "()Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "", "component2", "()I", "", "component3", "()Ljava/lang/String;", "channel", "id", "name", "copy", "(Lorg/valkyrienskies/core/impl/networking/NetworkChannel;ILjava/lang/String;)Lorg/valkyrienskies/core/impl/networking/PacketType;", "Lio/netty/buffer/ByteBuf;", "data", "Lorg/valkyrienskies/core/impl/networking/Packet;", "createPacket", "(Lio/netty/buffer/ByteBuf;)Lorg/valkyrienskies/core/impl/networking/Packet;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Lorg/valkyrienskies/core/impl/networking/ClientHandler;", "handler", "Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "registerClientHandler", "(Lorg/valkyrienskies/core/impl/networking/ClientHandler;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "Lorg/valkyrienskies/core/impl/networking/ServerHandler;", "registerServerHandler", "(Lorg/valkyrienskies/core/impl/networking/ServerHandler;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "", "sendToAllClients", "(Lio/netty/buffer/ByteBuf;)V", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "sendToClient", "(Lio/netty/buffer/ByteBuf;Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "", "players", "sendToClients", "(Lio/netty/buffer/ByteBuf;[Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "sendToServer", "toString", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "getChannel", "I", "getId", "Ljava/lang/String;", "getName", "<init>", "(Lorg/valkyrienskies/core/impl/networking/NetworkChannel;ILjava/lang/String;)V", "impl"})
public final class PacketType {
    @NotNull
    private final NetworkChannel channel;
    private final int id;
    @NotNull
    private final String name;

    public PacketType(@NotNull NetworkChannel channel, int id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.channel = channel;
        this.id = id;
        this.name = name;
    }

    @NotNull
    public final NetworkChannel getChannel() {
        return this.channel;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    private final Packet createPacket(ByteBuf data) {
        return new Packet(this, data);
    }

    public final void sendToServer(@NotNull ByteBuf data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.channel.sendToServer(this.createPacket(data));
    }

    public final void sendToClient(@NotNull ByteBuf data, @NotNull IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.channel.sendToClient(this.createPacket(data), player);
    }

    public final void sendToClients(@NotNull ByteBuf data, IPlayer ... players) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)players, (String)"players");
        this.channel.sendToClients(this.createPacket(data), Arrays.copyOf(players, players.length));
    }

    public final void sendToAllClients(@NotNull ByteBuf data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.channel.sendToAllClients(this.createPacket(data));
    }

    @NotNull
    public final RegisteredHandler registerServerHandler(@NotNull ServerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        return this.channel.registerServerHandler(this, handler);
    }

    @NotNull
    public final RegisteredHandler registerClientHandler(@NotNull ClientHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        return this.channel.registerClientHandler(this, handler);
    }

    @NotNull
    public final NetworkChannel component1() {
        return this.channel;
    }

    public final int component2() {
        return this.id;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final PacketType copy(@NotNull NetworkChannel channel, int id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new PacketType(channel, id, name);
    }

    public static /* synthetic */ PacketType copy$default(PacketType packetType, NetworkChannel networkChannel, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            networkChannel = packetType.channel;
        }
        if ((n2 & 2) != 0) {
            n = packetType.id;
        }
        if ((n2 & 4) != 0) {
            string = packetType.name;
        }
        return packetType.copy(networkChannel, n, string);
    }

    @NotNull
    public String toString() {
        return "PacketType(channel=" + this.channel + ", id=" + this.id + ", name=" + this.name + ')';
    }

    public int hashCode() {
        int result2 = this.channel.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.id);
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PacketType)) {
            return false;
        }
        PacketType packetType = (PacketType)other;
        if (!Intrinsics.areEqual((Object)this.channel, (Object)packetType.channel)) {
            return false;
        }
        if (this.id != packetType.id) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)packetType.name);
    }
}

