/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.impl.PacketRequestUdp;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 @2\u00020\u0001:\u0001@B\u001f\u0012\u0006\u00107\u001a\u000206\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b>\u0010?J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016RT\u0010\u001a\u001aB\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00020\u0002 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010\u001eR0\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020+0*j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020+`,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00105\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0017\u00107\u001a\u0002068\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0014\u0010<\u001a\u00020;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006A"}, d2={"Lorg/valkyrienskies/core/impl/networking/UdpServerImpl;", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "", "disconnect", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "Lorg/valkyrienskies/core/impl/networking/impl/PacketRequestUdp;", "packet", "", "prepareIdentifier", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;Lorg/valkyrienskies/core/impl/networking/impl/PacketRequestUdp;)Ljava/lang/Long;", "run", "()V", "Lio/netty/buffer/ByteBuf;", "buf", "sendToClient", "(Lio/netty/buffer/ByteBuf;Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "channel", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "getChannel", "()Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "Lcom/google/common/collect/HashBiMap;", "Ljava/net/SocketAddress;", "kotlin.jvm.PlatformType", "connections", "Lcom/google/common/collect/HashBiMap;", "", "failedConnectionsInRow", "I", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "fallback", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "getFallback", "()Lorg/valkyrienskies/core/impl/networking/PacketType;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectArrayMap;", "identification", "Lit/unimi/dsi/fastutil/longs/Long2ObjectArrayMap;", "lastPacketPrint", "J", "packetCount", "Ljava/util/HashMap;", "Ljavax/crypto/SecretKey;", "Lkotlin/collections/HashMap;", "playerSecrets", "Ljava/util/HashMap;", "", "recvBuffer", "[B", "Ljava/net/DatagramPacket;", "recvPacket", "Ljava/net/DatagramPacket;", "sendPacket", "Ljava/net/DatagramSocket;", "socket", "Ljava/net/DatagramSocket;", "getSocket", "()Ljava/net/DatagramSocket;", "Ljava/lang/Thread;", "thread", "Ljava/lang/Thread;", "<init>", "(Ljava/net/DatagramSocket;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Lorg/valkyrienskies/core/impl/networking/PacketType;)V", "Companion", "impl"})
public final class UdpServerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatagramSocket socket;
    @NotNull
    private final NetworkChannel channel;
    @NotNull
    private final PacketType fallback;
    @NotNull
    private final Thread thread;
    @NotNull
    private final byte[] recvBuffer;
    @NotNull
    private final DatagramPacket recvPacket;
    @NotNull
    private final DatagramPacket sendPacket;
    private final HashBiMap<SocketAddress, IPlayer> connections;
    private int failedConnectionsInRow;
    @NotNull
    private final Long2ObjectArrayMap<IPlayer> identification;
    @NotNull
    private final HashMap<IPlayer, SecretKey> playerSecrets;
    private int packetCount;
    private long lastPacketPrint;
    public static final int PACKET_SIZE = 508;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.networking.UdpServerImpl$Companion.$$delegatedProperties[0]);

    public UdpServerImpl(@NotNull DatagramSocket socket, @NotNull NetworkChannel channel, @NotNull PacketType fallback) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        this.socket = socket;
        this.channel = channel;
        this.fallback = fallback;
        this.thread = new Thread(this::run);
        this.recvBuffer = new byte[508];
        this.recvPacket = new DatagramPacket(this.recvBuffer, 508);
        this.sendPacket = new DatagramPacket(new byte[508], 508);
        this.connections = HashBiMap.create();
        this.identification = new Long2ObjectArrayMap();
        this.playerSecrets = new HashMap();
        this.lastPacketPrint = System.currentTimeMillis();
        this.channel.setRawSendToClient((Function2<? super ByteBuf, ? super IPlayer, Unit>)((Function2)new Function2<ByteBuf, IPlayer, Unit>((Object)this){

            public final void invoke(@NotNull ByteBuf p0, @NotNull IPlayer p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((UdpServerImpl)this.receiver).sendToClient(p0, p1);
            }
        }));
        this.thread.start();
        this.socket.setSendBufferSize(30480);
        this.socket.setReceiveBufferSize(30480);
    }

    @NotNull
    public final DatagramSocket getSocket() {
        return this.socket;
    }

    @NotNull
    public final NetworkChannel getChannel() {
        return this.channel;
    }

    @NotNull
    public final PacketType getFallback() {
        return this.fallback;
    }

    private final void sendToClient(ByteBuf buf, IPlayer player) {
        if (this.connections.inverse().get((Object)player) == null) {
            this.fallback.sendToClient(buf, player);
        } else {
            int n = this.packetCount;
            this.packetCount = n + 1;
            if (this.lastPacketPrint + (long)1000 < System.currentTimeMillis()) {
                UdpServerImpl.Companion.getLogger().trace("Sended " + this.packetCount + " UDP packets");
                this.packetCount = 0;
                this.lastPacketPrint = System.currentTimeMillis();
            }
            this.sendPacket.setSocketAddress((SocketAddress)this.connections.inverse().get((Object)player));
            buf.readBytes(this.sendPacket.getData(), 0, buf.writerIndex());
            this.sendPacket.setLength(buf.writerIndex());
            this.socket.send(this.sendPacket);
        }
    }

    private final void run() {
        while (!this.socket.isClosed()) {
            try {
                this.socket.receive(this.recvPacket);
                IPlayer sender = (IPlayer)this.connections.get((Object)this.recvPacket.getSocketAddress());
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])this.recvBuffer, (int)0, (int)this.recvPacket.getLength());
                if (sender == null) {
                    IPlayer newConnection;
                    if (buffer.capacity() != 8 || (IPlayer)this.identification.remove(buffer.readLong()) == null) continue;
                    HashBiMap<SocketAddress, IPlayer> hashBiMap = this.connections;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"connections");
                    Map map2 = (Map)hashBiMap;
                    map2.put(this.recvPacket.getSocketAddress(), newConnection);
                    this.failedConnectionsInRow = 0;
                    ByteBuf byteBuf = Unpooled.buffer((int)16).writeLong(newConnection.getUuid().getLeastSignificantBits()).writeLong(newConnection.getUuid().getMostSignificantBits());
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(16)\n             \u2026uuid.mostSignificantBits)");
                    this.sendToClient(byteBuf, newConnection);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.channel.onReceiveServer(buffer, sender);
            }
            catch (Exception e) {
                UdpServerImpl.Companion.getLogger().error("Error in server network thread", (Throwable)e);
            }
        }
    }

    @Nullable
    public final Long prepareIdentifier(@NotNull IPlayer player, @NotNull PacketRequestUdp packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Long l = Random.Default.nextLong();
        long $this$prepareIdentifier_u24lambda_u240 = ((Number)l).longValue();
        boolean bl = false;
        byte[] secretKeyBytes = packet.getSecretKeyBytes();
        try {
            ((Map)this.playerSecrets).put(player, new SecretKeySpec(secretKeyBytes, "AES"));
        }
        catch (Exception e) {
            UdpServerImpl.Companion.getLogger().warn("Failed to parse secret from player " + player.getUuid(), (Throwable)e);
            return null;
        }
        this.identification.put($this$prepareIdentifier_u24lambda_u240, (Object)player);
        if (this.failedConnectionsInRow == 5) {
            UdpServerImpl.Companion.getLogger().warn("There were 5 cases of failed connections in a row, is the UDP port accessible?");
            UdpServerImpl.Companion.getLogger().info("By disabling UDP this warning shall not be printed anymore.");
        }
        int n = this.failedConnectionsInRow;
        this.failedConnectionsInRow = n + 1;
        return l;
    }

    public final void disconnect(@NotNull IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.connections.inverse().remove((Object)player);
        ((ObjectCollection)this.identification.values()).remove((Object)player);
        this.playerSecrets.remove(player);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/valkyrienskies/core/impl/networking/UdpServerImpl$Companion;", "", "", "PACKET_SIZE", "I", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

