/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking.delta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.impl.networking.delta.DeltaAlgorithm;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/core/impl/networking/delta/JsonDiffDeltaAlgorithm;", "Lorg/valkyrienskies/core/impl/networking/delta/DeltaAlgorithm;", "Lcom/fasterxml/jackson/databind/JsonNode;", "old", "Lio/netty/buffer/ByteBuf;", "delta", "apply", "(Lcom/fasterxml/jackson/databind/JsonNode;Lio/netty/buffer/ByteBuf;)Lcom/fasterxml/jackson/databind/JsonNode;", "new", "dest", "encode", "(Lcom/fasterxml/jackson/databind/JsonNode;Lcom/fasterxml/jackson/databind/JsonNode;Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "impl"})
public final class JsonDiffDeltaAlgorithm
implements DeltaAlgorithm<JsonNode> {
    @NotNull
    private final ObjectMapper mapper;

    public JsonDiffDeltaAlgorithm(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull JsonNode old, @NotNull JsonNode jsonNode, @NotNull ByteBuf dest) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"new");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        JsonNode diffJson = JsonDiff.asJson(old, jsonNode);
        byte[] bytes = this.mapper.writeValueAsBytes(diffJson);
        dest.writeInt(bytes.length);
        dest.writeBytes(bytes);
        return dest;
    }

    @Override
    @NotNull
    public JsonNode apply(@NotNull JsonNode old, @NotNull ByteBuf delta) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        int size = delta.readInt();
        JsonNode diffJson = this.mapper.readTree((InputStream)new ByteBufInputStream(delta, size));
        JsonNode jsonNode = JsonPatch.apply(diffJson, old);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"apply(diffJson, old)");
        return jsonNode;
    }
}

