/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.pipelines;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.Segment;
import org.valkyrienskies.physics_api.SegmentDisplacement;
import org.valkyrienskies.physics_api.SegmentTracker;
import org.valkyrienskies.physics_api.SingleSegmentTracker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0012J-\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0017J-\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u0017J-\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001b\u0010\u0017J-\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001c\u0010\u0017J-\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001d\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/core/impl/pipelines/SegmentUtils;", "", "", "dimension", "", "scaling", "Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "createSegmentDisplacementFromScaling", "(ID)Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "Lorg/valkyrienskies/physics_api/SegmentTracker;", "createSegmentTrackerFromScaling", "(ID)Lorg/valkyrienskies/physics_api/SegmentTracker;", "Lorg/valkyrienskies/physics_api/PoseVel;", "poseVel", "segmentDisplacement", "Lorg/joml/Vector3d;", "dest", "getOmega", "(Lorg/valkyrienskies/physics_api/PoseVel;Lorg/valkyrienskies/physics_api/SegmentDisplacement;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "getVelocity", "Lorg/joml/Vector3dc;", "dir", "invTransformDirectionWithScale", "(Lorg/valkyrienskies/physics_api/PoseVel;Lorg/valkyrienskies/physics_api/SegmentDisplacement;Lorg/joml/Vector3dc;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "invTransformDirectionWithoutScale", "pos", "invTransformPos", "transformDirectionWithScale", "transformDirectionWithoutScale", "transformPos", "<init>", "()V", "impl"})
public final class SegmentUtils {
    @NotNull
    public static final SegmentUtils INSTANCE = new SegmentUtils();

    private SegmentUtils() {
    }

    @NotNull
    public final SegmentDisplacement createSegmentDisplacementFromScaling(int dimension, double scaling) {
        return new SegmentDisplacement(PoseVel.Companion.getNULL_POSE_VEL(), scaling, dimension);
    }

    @NotNull
    public final SegmentTracker createSegmentTrackerFromScaling(int dimension, double scaling) {
        return new SingleSegmentTracker(new Segment(0, this.createSegmentDisplacementFromScaling(dimension, scaling)));
    }

    @NotNull
    public final Vector3d transformPos(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3dc pos, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        poseVel.transformPosition(pos, dest);
        segmentDisplacement.transformPosition(dest);
        return dest;
    }

    @NotNull
    public final Vector3d invTransformPos(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3dc pos, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        segmentDisplacement.invTransformPosition(pos, dest);
        poseVel.invTransformPosition(dest);
        return dest;
    }

    @NotNull
    public final Vector3d transformDirectionWithScale(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3dc dir, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        poseVel.transformDirection(dir, dest);
        segmentDisplacement.transformDirectionWithScale(dest);
        return dest;
    }

    @NotNull
    public final Vector3d invTransformDirectionWithScale(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3dc dir, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        segmentDisplacement.invTransformDirectionWithScale(dir, dest);
        poseVel.invTransformDirection(dest);
        return dest;
    }

    @NotNull
    public final Vector3d transformDirectionWithoutScale(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3dc dir, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        poseVel.transformDirection(dir, dest);
        segmentDisplacement.transformDirectionWithoutScale(dest);
        return dest;
    }

    @NotNull
    public final Vector3d invTransformDirectionWithoutScale(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3dc dir, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        segmentDisplacement.invTransformDirectionWithoutScale(dir, dest);
        poseVel.invTransformDirection(dest);
        return dest;
    }

    @NotNull
    public final Vector3d getOmega(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.set(poseVel.getOmega());
        segmentDisplacement.transformDirectionWithoutScale(dest);
        dest.add(segmentDisplacement.getPoseVelForInternalUseOnly().getOmega());
        return dest;
    }

    @NotNull
    public final Vector3d getVelocity(@NotNull PoseVel poseVel, @NotNull SegmentDisplacement segmentDisplacement, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)segmentDisplacement, (String)"segmentDisplacement");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.set(poseVel.getVel());
        segmentDisplacement.transformDirectionWithScale(dest);
        dest.add(segmentDisplacement.getPoseVelForInternalUseOnly().getVel());
        return dest;
    }
}

