/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.pipelines;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.WingManager;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.constraints.VSForceConstraint;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.api.Ticked;
import org.valkyrienskies.core.impl.game.ships.PhysInertia;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServer;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.game.ships.ShipPhysicsData;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.pipelines.NewShipInGameFrameData;
import org.valkyrienskies.core.impl.pipelines.SegmentUtils;
import org.valkyrienskies.core.impl.pipelines.ShipInPhysicsFrameData;
import org.valkyrienskies.core.impl.pipelines.UpdateShipInGameFrameData;
import org.valkyrienskies.core.impl.pipelines.VSGameFrame;
import org.valkyrienskies.core.impl.pipelines.VSPhysicsFrame;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.Segment;
import org.valkyrienskies.physics_api.SegmentTracker;
import org.valkyrienskies.physics_api.voxel_updates.IVoxelShapeUpdate;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\b\u0007\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b\"\u0010#J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0013\u001a\u00020\u00122\n\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u000eJ\r\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0018\u0010\u000bR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSGamePipelineStage;", "", "Lorg/valkyrienskies/core/apigame/constraints/VSForceConstraint;", "vsConstraint", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;", "adjustConstraintLocalPositions", "(Lorg/valkyrienskies/core/apigame/constraints/VSForceConstraint;)Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;", "physicsFrame", "", "applyPhysicsFrame", "(Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;)V", "Lorg/valkyrienskies/core/impl/pipelines/VSGameFrame;", "createGameFrame", "()Lorg/valkyrienskies/core/impl/pipelines/VSGameFrame;", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "dimensionId", "", "getKrunchDimensionId", "(Ljava/lang/String;)I", "postTickGame", "preTickGame", "()V", "pushPhysicsFrame", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "dimensionIntIdToString", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "physicsFramesQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "shipWorld", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;)V", "Companion", "impl"})
public final class VSGamePipelineStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShipObjectServerWorld shipWorld;
    @NotNull
    private final ConcurrentLinkedQueue<VSPhysicsFrame> physicsFramesQueue;
    @NotNull
    private final Int2ObjectOpenHashMap<String> dimensionIntIdToString;
    public static final int GAME_TPS = 20;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.pipelines.VSGamePipelineStage$Companion.$$delegatedProperties[0]);

    @Inject
    public VSGamePipelineStage(@NotNull ShipObjectServerWorld shipWorld) {
        Intrinsics.checkNotNullParameter((Object)shipWorld, (String)"shipWorld");
        this.shipWorld = shipWorld;
        this.physicsFramesQueue = new ConcurrentLinkedQueue();
        this.dimensionIntIdToString = new Int2ObjectOpenHashMap();
    }

    public final void pushPhysicsFrame(@NotNull VSPhysicsFrame physicsFrame) {
        Intrinsics.checkNotNullParameter((Object)physicsFrame, (String)"physicsFrame");
        if (this.physicsFramesQueue.size() >= 300) {
            VSGamePipelineStage.Companion.getLogger().warn("Too many physics frames in the physics frame queue. Is the game stage broken?");
            Thread.sleep(1000L);
        }
        this.physicsFramesQueue.add(physicsFrame);
    }

    public final void preTickGame() {
        Map $this$forEach$iv = this.shipWorld.getShipObjects();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = ((ShipObjectServer)it.getValue()).getToBeTicked();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Ticked p0 = (Ticked)element$iv2;
                boolean bl2 = false;
                p0.tick();
            }
        }
        this.shipWorld.preTick();
    }

    @NotNull
    public final VSGameFrame postTickGame() {
        Map $this$forEach$iv = this.shipWorld.getShipObjects();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            ShipObjectServer shipObject = (ShipObjectServer)entry.getValue();
            shipObject.getShipData().updatePrevTickShipTransform();
        }
        while (!((Collection)this.physicsFramesQueue).isEmpty()) {
            VSPhysicsFrame physicsFrame = (VSPhysicsFrame)this.physicsFramesQueue.remove();
            Intrinsics.checkNotNullExpressionValue((Object)physicsFrame, (String)"physicsFrame");
            this.applyPhysicsFrame(physicsFrame);
        }
        this.shipWorld.postTick();
        VSGameFrame gameFrame = this.createGameFrame();
        Map $this$forEach$iv2 = this.shipWorld.getShipObjects();
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
        while (iterator3.hasNext()) {
            WingManager shipAsWingManager;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator3.next();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((ShipObjectServer)it.getValue()).getAttachment(WingManager.class));
            shipAsWingManager.clearWingChanges();
        }
        return gameFrame;
    }

    private final void applyPhysicsFrame(VSPhysicsFrame physicsFrame) {
        Map<Long, ShipInPhysicsFrameData> $this$forEach$iv = physicsFrame.getShipDataMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, ShipInPhysicsFrameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            ShipData shipData;
            ShipObjectServer shipObject;
            Map.Entry<Long, ShipInPhysicsFrameData> element$iv;
            Map.Entry<Long, ShipInPhysicsFrameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            long shipId = ((Number)entry.getKey()).longValue();
            ShipInPhysicsFrameData shipInPhysicsFrameData = entry.getValue();
            ShipObjectServer shipObjectServer = shipObject = (ShipObjectServer)this.shipWorld.getShipObjects().get(shipId);
            ShipData shipData2 = shipData = shipObjectServer != null ? shipObjectServer.getShipData() : null;
            if (shipData != null) {
                boolean applyTransform = shipObject.getShipTeleportId() == shipInPhysicsFrameData.getLastShipTeleportId();
                if (!applyTransform) continue;
                ShipTransform newShipTransform = Companion.generateTransformFromPhysicsFrameData(shipInPhysicsFrameData, shipData);
                shipData.getPhysicsData().setLinearVelocity(shipInPhysicsFrameData.getPoseVel().getVel());
                shipData.getPhysicsData().setAngularVelocity(shipInPhysicsFrameData.getPoseVel().getOmega());
                shipData.setTransform(newShipTransform);
                continue;
            }
            if (this.shipWorld.getDimensionToGroundBodyIdImmutable().containsValue(shipId)) continue;
            VSGamePipelineStage.Companion.getLogger().warn("Received physics frame update for ship with ShipId: " + shipId + ", but a ship with this ShipId does not exist!");
        }
    }

    private final VSGameFrame createGameFrame() {
        Object it;
        boolean isVoxelsFullyLoaded;
        boolean isStatic;
        Vector3dc voxelOffset;
        SegmentTracker segments;
        PoseVel poseVel;
        Object element$iv;
        ArrayList<NewShipInGameFrameData> newShips = new ArrayList<NewShipInGameFrameData>();
        ArrayList deletedShips = new ArrayList();
        HashMap updatedShips = new HashMap();
        HashMap gameFrameVoxelUpdatesMap = new HashMap();
        ShipObjectServerWorld.CurrentTickChanges lastTickChanges = this.shipWorld.getCurrentTickChanges();
        List<Pair<String, Long>> newGroundRigidBodyObjects = lastTickChanges.getNewGroundRigidBodyObjects();
        Collection<ShipObjectServer> newShipObjects = lastTickChanges.getNewShipObjects();
        Collection<ShipObjectServer> updatedShipObjects = lastTickChanges.getUpdatedShipObjects();
        List<Long> deletedShipObjects = lastTickChanges.getDeletedShipObjectsIncludingGround();
        Map<Long, Map<Vector3ic, IVoxelShapeUpdate>> shipVoxelUpdates = lastTickChanges.getShipToVoxelUpdates();
        Object $this$forEach$iv = newGroundRigidBodyObjects;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Pair newGroundObjectData = (Pair)element$iv;
            boolean bl = false;
            String dimensionId = (String)newGroundObjectData.getFirst();
            long shipId = ((Number)newGroundObjectData.getSecond()).longValue();
            Vector3i minDefined = new Vector3i(Integer.MIN_VALUE, 0, Integer.MIN_VALUE);
            Vector3i maxDefined = new Vector3i(Integer.MAX_VALUE, 255, Integer.MAX_VALUE);
            AABBic totalVoxelRegion = PhysicsWorldReference.Companion.getINFINITE_VOXEL_REGION();
            PhysInertia inertiaData = new PhysInertia(10.0, new Matrix3d(10.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 10.0));
            int krunchDimensionId = this.getKrunchDimensionId(dimensionId);
            poseVel = PoseVel.Companion.createPoseVel(new Vector3d(), new Quaterniond());
            segments = SegmentUtils.INSTANCE.createSegmentTrackerFromScaling(krunchDimensionId, 1.0);
            voxelOffset = new Vector3d(0.5, 0.5, 0.5);
            isStatic = true;
            isVoxelsFullyLoaded = false;
            NewShipInGameFrameData newShipInGameFrameData = new NewShipInGameFrameData(shipId, krunchDimensionId, minDefined, maxDefined, totalVoxelRegion, inertiaData, new ShipPhysicsData(new Vector3d(), new Vector3d()), poseVel, segments, voxelOffset, isStatic, isVoxelsFullyLoaded, CollectionsKt.emptyList(), null, 0);
            newShips.add(newShipInGameFrameData);
        }
        $this$forEach$iv = newShipObjects;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            WingManager shipAsWingManager;
            element$iv = iterator2.next();
            it = (ShipObjectServer)element$iv;
            boolean bl = false;
            long uuid = ((ShipObjectServer)it).getShipData().getId();
            Vector3i minDefined = new Vector3i();
            Vector3i maxDefined = new Vector3i();
            ((ShipObjectServer)it).getShipData().getActiveChunksSet().getMinMaxWorldPos(minDefined, maxDefined);
            AABBi totalVoxelRegion = ChunkClaim.getTotalVoxelRegion$default(((ShipObjectServer)it).getChunkClaim(), this.shipWorld.getYRange(((ShipObjectServer)it).getChunkClaimDimension()), null, 2, null);
            int krunchDimensionId = this.getKrunchDimensionId(((ShipObjectServer)it).getShipData().getChunkClaimDimension());
            double scaling = ((ShipObjectServer)it).getShipData().getTransform().getShipToWorldScaling().x();
            Vector3d vector3d = ((ShipObjectServer)it).getShipData().getTransform().getPositionInWorld().div(scaling, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"it.shipData.transform.po\u2026.div(scaling, Vector3d())");
            poseVel = PoseVel.Companion.createPoseVel(vector3d, ((ShipObjectServer)it).getShipData().getTransform().getShipToWorldRotation());
            segments = SegmentUtils.INSTANCE.createSegmentTrackerFromScaling(krunchDimensionId, scaling);
            voxelOffset = VSGamePipelineStage.Companion.getShipVoxelOffset(((ShipObjectServer)it).getShipData().getInertiaData());
            isStatic = ((ShipObjectServer)it).getShipData().isStatic();
            isVoxelsFullyLoaded = ((ShipObjectServer)it).getShipData().areVoxelsFullyLoaded();
            Intrinsics.checkNotNull((Object)((ShipObjectServer)it).getAttachment(WingManager.class));
            int shipTeleportId = ((ShipObjectServer)it).getShipTeleportId();
            NewShipInGameFrameData newShipInGameFrameData = new NewShipInGameFrameData(uuid, krunchDimensionId, minDefined, maxDefined, totalVoxelRegion, ((ShipObjectServer)it).getShipData().getInertiaData().copyToPhyInertia(), ShipPhysicsData.copy$default(((ShipObjectServer)it).getShipData().getPhysicsData(), null, null, 3, null), poseVel, segments, voxelOffset, isStatic, isVoxelsFullyLoaded, CollectionsKt.toMutableList((Collection)((ShipObjectServer)it).getForceInducers()), shipAsWingManager.getWingChanges(), shipTeleportId);
            newShips.add(newShipInGameFrameData);
        }
        $this$forEach$iv = updatedShipObjects;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            WingManager shipAsWingManager;
            element$iv = iterator2.next();
            it = (ShipObjectServer)element$iv;
            boolean bl = false;
            long uuid = ((ShipObjectServer)it).getShipData().getId();
            Vector3dc newVoxelOffset = VSGamePipelineStage.Companion.getShipVoxelOffset(((ShipObjectServer)it).getShipData().getInertiaData());
            boolean isStatic2 = ((ShipObjectServer)it).getShipData().isStatic();
            boolean isVoxelsFullyLoaded2 = ((ShipObjectServer)it).getShipData().areVoxelsFullyLoaded();
            Intrinsics.checkNotNull((Object)((ShipObjectServer)it).getAttachment(WingManager.class));
            int shipTeleportId = ((ShipObjectServer)it).getShipTeleportId();
            Vector3dc currentShipPos = ((ShipObjectServer)it).getShipData().getTransform().getPositionInWorld();
            Quaterniondc currentShipRot = ((ShipObjectServer)it).getShipData().getTransform().getShipToWorldRotation();
            Vector3dc currentShipVel = ((ShipObjectServer)it).getShipData().getPhysicsData().getLinearVelocity();
            Vector3dc currentShipOmega = ((ShipObjectServer)it).getShipData().getPhysicsData().getAngularVelocity();
            UpdateShipInGameFrameData updateShipInGameFrameData = new UpdateShipInGameFrameData(uuid, newVoxelOffset, ((ShipObjectServer)it).getShipData().getInertiaData().copyToPhyInertia(), ShipPhysicsData.copy$default(((ShipObjectServer)it).getShipData().getPhysicsData(), null, null, 3, null), isStatic2, isVoxelsFullyLoaded2, CollectionsKt.toMutableList((Collection)((ShipObjectServer)it).getForceInducers()), shipAsWingManager.getWingChanges(), shipTeleportId, currentShipPos, currentShipRot, currentShipVel, currentShipOmega);
            Long l = uuid;
            ((Map)updatedShips).put(l, updateShipInGameFrameData);
        }
        deletedShips.addAll(deletedShipObjects);
        $this$forEach$iv = shipVoxelUpdates;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            long shipId = ((Number)it.getKey()).longValue();
            Map voxelUpdatesMap = (Map)it.getValue();
            Long isStatic2 = shipId;
            ((Map)gameFrameVoxelUpdatesMap).put(isStatic2, CollectionsKt.toList((Iterable)voxelUpdatesMap.values()));
        }
        List constraintsCreatedThisTick = new ArrayList();
        Iterable $this$forEach$iv2 = lastTickChanges.getConstraintsCreatedThisTick();
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            VSConstraintAndId it2 = (VSConstraintAndId)element$iv2;
            boolean bl = false;
            VSConstraint vsConstraint = it2.getVsConstraint();
            if (!(vsConstraint instanceof VSForceConstraint)) {
                constraintsCreatedThisTick.add(it2);
                continue;
            }
            VSConstraint adjusted = this.adjustConstraintLocalPositions((VSForceConstraint)vsConstraint);
            if (adjusted == null) {
                VSGamePipelineStage.Companion.getLogger().warn("Failed to adjust a constraint. Was a ship deleted?");
                continue;
            }
            constraintsCreatedThisTick.add(new VSConstraintAndId(it2.getConstraintId(), adjusted));
        }
        List constraintsUpdatedThisTick = new ArrayList();
        Iterable $this$forEach$iv3 = lastTickChanges.getConstraintsUpdatedThisTick();
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            VSConstraintAndId it3 = (VSConstraintAndId)element$iv3;
            boolean bl = false;
            VSConstraint vsConstraint = it3.getVsConstraint();
            if (!(vsConstraint instanceof VSForceConstraint)) {
                constraintsUpdatedThisTick.add(it3);
                continue;
            }
            VSConstraint adjusted = this.adjustConstraintLocalPositions((VSForceConstraint)vsConstraint);
            if (adjusted == null) {
                VSGamePipelineStage.Companion.getLogger().warn("Failed to adjust a constraint. Was a ship deleted?");
                continue;
            }
            constraintsUpdatedThisTick.add(new VSConstraintAndId(it3.getConstraintId(), adjusted));
        }
        List constraintsDeletedThisTick = new ArrayList<Integer>(lastTickChanges.getConstraintsDeletedThisTick());
        this.shipWorld.clearNewUpdatedDeletedShipObjectsAndVoxelUpdates();
        return new VSGameFrame((List<NewShipInGameFrameData>)newShips, deletedShips, updatedShips, gameFrameVoxelUpdatesMap, constraintsCreatedThisTick, constraintsUpdatedThisTick, constraintsDeletedThisTick);
    }

    private final VSConstraint adjustConstraintLocalPositions(VSForceConstraint vsConstraint) {
        Vector3dc vector3dc;
        Vector3dc cm0;
        Vector3dc vector3dc2;
        ShipObjectServer ship0 = this.shipWorld.getLoadedShips().getById(vsConstraint.getShipId0());
        ShipObjectServer ship1 = this.shipWorld.getLoadedShips().getById(vsConstraint.getShipId1());
        if (!this.shipWorld.getDimensionToGroundBodyIdImmutable().containsValue(vsConstraint.getShipId0())) {
            if (ship0 == null) {
                return null;
            }
            vector3dc2 = ship0.getShipData().getInertiaData().getCenterOfMassInShip();
        } else {
            vector3dc2 = cm0 = (Vector3dc)new Vector3d(-0.5, -0.5, -0.5);
        }
        if (!this.shipWorld.getDimensionToGroundBodyIdImmutable().containsValue(vsConstraint.getShipId1())) {
            if (ship1 == null) {
                return null;
            }
            vector3dc = ship1.getShipData().getInertiaData().getCenterOfMassInShip();
        } else {
            vector3dc = new Vector3d(-0.5, -0.5, -0.5);
        }
        Vector3dc cm1 = vector3dc;
        Vector3d vector3d = cm0.mul(-1.0, new Vector3d()).sub(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"cm0.mul(-1.0, Vector3d()).sub(0.5, 0.5, 0.5)");
        Vector3dc vector3dc3 = vector3d;
        Vector3d vector3d2 = cm1.mul(-1.0, new Vector3d()).sub(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"cm1.mul(-1.0, Vector3d()).sub(0.5, 0.5, 0.5)");
        return vsConstraint.offsetLocalPositions(vector3dc3, vector3d2);
    }

    private final int getKrunchDimensionId(String dimensionId) {
        int id = dimensionId.hashCode();
        this.dimensionIntIdToString.put(id, (Object)dimensionId);
        return id;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0016\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSGamePipelineStage$Companion;", "", "Lorg/valkyrienskies/core/impl/pipelines/ShipInPhysicsFrameData;", "physicsFrameData", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "shipData", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "generateTransformFromPhysicsFrameData", "(Lorg/valkyrienskies/core/impl/pipelines/ShipInPhysicsFrameData;Lorg/valkyrienskies/core/impl/api/ServerShipInternal;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/valkyrienskies/core/api/ships/properties/ShipInertiaData;", "inertiaData", "Lorg/joml/Vector3dc;", "getShipVoxelOffset", "(Lorg/valkyrienskies/core/api/ships/properties/ShipInertiaData;)Lorg/joml/Vector3dc;", "", "GAME_TPS", "I", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Vector3dc getShipVoxelOffset(ShipInertiaData inertiaData) {
            Vector3dc cm = inertiaData.getCenterOfMassInShip();
            return new Vector3d(-cm.x(), -cm.y(), -cm.z());
        }

        @NotNull
        public final ShipTransform generateTransformFromPhysicsFrameData(@NotNull ShipInPhysicsFrameData physicsFrameData, @NotNull ServerShipInternal shipData) {
            Intrinsics.checkNotNullParameter((Object)physicsFrameData, (String)"physicsFrameData");
            Intrinsics.checkNotNullParameter((Object)shipData, (String)"shipData");
            PoseVel poseVelFromPhysics = physicsFrameData.getPoseVel();
            Vector3dc voxelOffsetFromPhysics = physicsFrameData.getShipVoxelOffset();
            Vector3dc voxelOffsetFromGame = this.getShipVoxelOffset(shipData.getInertiaData());
            Vector3d deltaVoxelOffset = poseVelFromPhysics.getRot().transform(voxelOffsetFromGame.sub(voxelOffsetFromPhysics, new Vector3d()));
            Vector3d shipPosAccountingForVoxelOffsetDifference = poseVelFromPhysics.getPos().sub(deltaVoxelOffset, new Vector3d());
            double scaling = ((Segment)CollectionsKt.first((Iterable)physicsFrameData.getSegments().getSegments().values())).getSegmentDisplacement().getScaling();
            Vector3d shipPosAccountingForSegment = shipPosAccountingForVoxelOffsetDifference.mul(scaling, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)shipPosAccountingForSegment, (String)"shipPosAccountingForSegment");
            Vector3dc vector3dc = shipPosAccountingForSegment;
            Vector3d vector3d = shipData.getInertiaData().getCenterOfMassInShip().add(0.5, 0.5, 0.5, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"shipData.inertiaData.cen\u2026d(.5, .5, .5, Vector3d())");
            return ShipTransformImpl.Companion.create(vector3dc, vector3d, poseVelFromPhysics.getRot(), new Vector3d(scaling));
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

