/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client.renderer;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.mod.client.IVSCamera;
import org.valkyrienskies.mod.common.IShipObjectWorldClientProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import org.valkyrienskies.mod.mixinducks.client.MinecraftDuck;

@Mixin(value={class_757.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private class_310 field_4015;
    @Shadow
    @Final
    private class_4184 field_18765;

    @Shadow
    protected abstract double method_3196(class_4184 var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f method_22973(double var1);

    @Unique
    private static class_239 entityRaycastNoTransform(class_1297 entity, double maxDistance, float tickDelta, boolean includeFluids) {
        class_243 vec3d = entity.method_5836(tickDelta);
        class_243 vec3d2 = entity.method_5828(tickDelta);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * maxDistance, vec3d2.field_1351 * maxDistance, vec3d2.field_1350 * maxDistance);
        return RaycastUtilsKt.clipIncludeShips(entity.method_37908(), new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17559, includeFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, entity), false);
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;pick(DFZ)Lnet/minecraft/world/phys/HitResult;")})
    public class_239 modifyCrosshairTargetBlocks(class_1297 receiver, double maxDistance, float tickDelta, boolean includeFluids, Operation<class_239> pick) {
        class_239 original = MixinGameRenderer.entityRaycastNoTransform(receiver, maxDistance, tickDelta, includeFluids);
        ((MinecraftDuck)this.field_4015).vs$setOriginalCrosshairTarget(original);
        return (class_239)pick.call(new Object[]{receiver, maxDistance, Float.valueOf(tickDelta), includeFluids});
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;distanceToSqr(Lnet/minecraft/world/phys/Vec3;)D")})
    public double correctDistanceChecks(class_243 instance, class_243 vec, Operation<class_243> distanceToSqr) {
        return VSGameUtilsKt.squaredDistanceBetweenInclShips((class_1937)this.field_4015.field_1687, vec.field_1352, vec.field_1351, vec.field_1350, instance.field_1352, instance.field_1351, instance.field_1350);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRender(float tickDelta, long startTime, boolean tick2, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld != null) {
            ClientShipWorldCore shipWorld = ((IShipObjectWorldClientProvider)IShipObjectWorldClientProvider.class.cast(this.field_4015)).getShipObjectWorld();
            if (shipWorld == null) {
                return;
            }
            shipWorld.updateRenderTransforms(tickDelta);
            for (class_1297 entity : clientWorld.method_18112()) {
                ClientShip shipObject;
                EntityDraggingInformation entityDraggingInformation;
                Long lastShipStoodOn;
                Vector3dc entityShouldBeHere = null;
                ClientShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(clientWorld, entity);
                if (shipMountedTo != null) {
                    Vector3dc passengerPos = VSGameUtilsKt.getPassengerPos(entity.method_5854(), entity.method_5678(), tickDelta);
                    entityShouldBeHere = shipMountedTo.getRenderTransform().getShipToWorld().transformPosition(passengerPos, new Vector3d());
                    entity.method_5814(entityShouldBeHere.x(), entityShouldBeHere.y(), entityShouldBeHere.z());
                    entity.field_6014 = entityShouldBeHere.x();
                    entity.field_6036 = entityShouldBeHere.y();
                    entity.field_5969 = entityShouldBeHere.z();
                    entity.field_6038 = entityShouldBeHere.x();
                    entity.field_5971 = entityShouldBeHere.y();
                    entity.field_5989 = entityShouldBeHere.z();
                    continue;
                }
                if (entityShouldBeHere == null && (lastShipStoodOn = (entityDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation()).getLastShipStoodOn()) != null && entityDraggingInformation.isEntityBeingDraggedByAShip() && (shipObject = (ClientShip)VSGameUtilsKt.getShipObjectWorld(clientWorld).getLoadedShips().getById(lastShipStoodOn)) != null) {
                    entityDraggingInformation.setCachedLastPosition(new Vector3d(entity.field_6014, entity.field_6036, entity.field_5969));
                    entityDraggingInformation.setRestoreCachedLastPosition(true);
                    Vector3dc entityAddedVelocity = entityDraggingInformation.getAddedMovementLastTick();
                    double entityMovementX = entity.method_23317() - entityAddedVelocity.x() - entity.field_6014;
                    double entityMovementY = entity.method_23318() - entityAddedVelocity.y() - entity.field_6036;
                    double entityMovementZ = entity.method_23321() - entityAddedVelocity.z() - entity.field_5969;
                    Vector3d entityShouldBeHerePreTransform = new Vector3d(entity.field_6014 + entityMovementX * (double)tickDelta, entity.field_6036 + entityMovementY * (double)tickDelta, entity.field_5969 + entityMovementZ * (double)tickDelta);
                    entityShouldBeHere = shipObject.getRenderTransform().getShipToWorldMatrix().transformPosition(shipObject.getPrevTickShipTransform().getWorldToShipMatrix().transformPosition(entityShouldBeHerePreTransform, new Vector3d()));
                }
                if (entityShouldBeHere == null || !((double)tickDelta < 0.99999)) continue;
                entity.field_6014 = (entityShouldBeHere.x() - entity.method_23317() * (double)tickDelta) / (1.0 - (double)tickDelta);
                entity.field_6036 = (entityShouldBeHere.y() - entity.method_23318() * (double)tickDelta) / (1.0 - (double)tickDelta);
                entity.field_5969 = (entityShouldBeHere.z() - entity.method_23321() * (double)tickDelta) / (1.0 - (double)tickDelta);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void postRender(float tickDelta, long startTime, boolean tick2, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld != null) {
            for (class_1297 entity : clientWorld.method_18112()) {
                EntityDraggingInformation vsEntity = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
                if (!vsEntity.getRestoreCachedLastPosition()) continue;
                vsEntity.setRestoreCachedLastPosition(false);
                Vector3dc cachedLastPosition = vsEntity.getCachedLastPosition();
                if (cachedLastPosition != null) {
                    entity.field_6014 = cachedLastPosition.x();
                    entity.field_6036 = cachedLastPosition.y();
                    entity.field_5969 = cachedLastPosition.z();
                    continue;
                }
                System.err.println("How was cachedLastPosition was null?");
            }
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;)V")})
    private void setupCameraWithMountedShip(class_761 instance, class_4587 ignore, class_243 vec3, Matrix4f matrix4f, Operation<Void> prepareCullFrustum, float partialTicks, long finishTimeNano, class_4587 matrixStack) {
        class_638 clientLevel = this.field_4015.field_1687;
        class_746 player = this.field_4015.field_1724;
        if (clientLevel == null || player == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        ClientShip playerShipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(clientLevel, (class_1297)player);
        if (playerShipMountedTo == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        class_1297 playerVehicle = player.method_5854();
        if (playerVehicle == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        Vector3dc inShipPos = VSGameUtilsKt.getPassengerPos(playerVehicle, player.method_5678(), partialTicks);
        class_4184 camera = this.field_18765;
        if (camera == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        ((IVSCamera)camera).setupWithShipMounted((class_1922)this.field_4015.field_1687, (class_1297)(this.field_4015.method_1560() == null ? this.field_4015.field_1724 : this.field_4015.method_1560()), !this.field_4015.field_1690.method_31044().method_31034(), this.field_4015.field_1690.method_31044().method_31035(), partialTicks, playerShipMountedTo, inShipPos);
        Quaterniond invShipRenderRotation = playerShipMountedTo.getRenderTransform().getShipToWorldRotation().conjugate(new Quaterniond());
        matrixStack.method_22907(new Quaternionf().set(invShipRenderRotation));
        Matrix3f matrix3f = new Matrix3f(matrixStack.method_23760().method_23762());
        matrix3f.invert();
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)matrix3f);
        double fov = this.method_3196(camera, partialTicks, true);
        prepareCullFrustum.call(new Object[]{instance, matrixStack, camera.method_19326(), this.method_22973(Math.max(fov, (double)((Integer)this.field_4015.field_1690.method_41808().method_41753()).intValue()))});
    }
}

