/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client.world;

import net.minecraft.class_1109;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.impl.util.AABBdUtilKt;
import org.valkyrienskies.core.impl.util.VectorConversionsKt;
import org.valkyrienskies.mod.client.audio.SimpleSoundInstanceOnShip;
import org.valkyrienskies.mod.common.IShipObjectWorldClientProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;

@Mixin(value={class_638.class})
public abstract class MixinClientLevel
implements IShipObjectWorldClientProvider {
    @Unique
    private final class_5819 vsRandom = class_5819.method_43047();
    @Shadow
    @Final
    private class_310 field_3729;

    @Override
    @NotNull
    public ClientShipWorldCore getShipObjectWorld() {
        return ((IShipObjectWorldClientProvider)this.field_3729).getShipObjectWorld();
    }

    @Shadow
    private void method_2938(class_2338 blockPos, class_2680 blockState, class_2394 particleData, boolean shapeDownSolid) {
    }

    @Inject(method={"disconnect"}, at={@At(value="TAIL")})
    private void afterDisconnect(CallbackInfo ci) {
        ValkyrienSkiesMod.getVsCore().getHooks().afterDisconnect();
    }

    @Inject(at={@At(value="TAIL")}, method={"animateTick"})
    private void afterAnimatedTick(int posX, int posY, int posZ, CallbackInfo ci) {
        boolean holdingBarrierItem = false;
        if (this.field_3729.field_1761.method_2920() == class_1934.field_9220) {
            for (class_1799 itemStack : this.field_3729.field_1724.method_5877()) {
                if (itemStack.method_7909() != class_2246.field_10499.method_8389()) continue;
                holdingBarrierItem = true;
                break;
            }
        }
        AABBd biggerBB = AABBdUtilKt.expand(new AABBd(posX, posY, posZ, posX, posY, posZ), 32.0);
        AABBd smallerBB = AABBdUtilKt.expand(new AABBd(posX, posY, posZ, posX, posY, posZ), 16.0);
        double biggerBBProbability = 0.0203857421875;
        double smallerBBProbability = 0.1630859375;
        AABBd temp0 = new AABBd();
        AABBi temp1 = new AABBi();
        AABBd temp2 = new AABBd();
        AABBi temp3 = new AABBi();
        AABBi temp4 = new AABBi();
        AABBi temp5 = new AABBi();
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting((class_1937)class_638.class.cast(this), biggerBB)) {
            AABBic shipVoxelAABB = ship.getShipVoxelAABB();
            if (shipVoxelAABB == null) continue;
            AABBi biggerBBTransformed = VectorConversionsKt.toAABBi(biggerBB.transform(ship.getWorldToShip(), temp0), temp1);
            AABBi smallerBBTransformed = VectorConversionsKt.toAABBi(smallerBB.transform(ship.getWorldToShip(), temp2), temp3);
            AABBi biggerBBIntersection = VectorConversionsKt.expand(shipVoxelAABB, 1, temp4).intersection(biggerBBTransformed);
            AABBi smallerBBIntersection = VectorConversionsKt.expand(shipVoxelAABB, 1, temp5).intersection(smallerBBTransformed);
            if (biggerBBIntersection.isValid()) {
                this.animateTickVS(biggerBBIntersection, 0.0203857421875, holdingBarrierItem);
            }
            if (!smallerBBIntersection.isValid()) continue;
            this.animateTickVS(smallerBBIntersection, 0.1630859375, holdingBarrierItem);
        }
    }

    @Unique
    private void animateTickVS(AABBic region, double regionBlockProbability, boolean holdingBarrierItem) {
        int volume = (region.maxX() - region.minX() + 1) * (region.maxY() - region.minY() + 1) * (region.maxZ() - region.minZ() + 1);
        double blocksToTickAsDouble = (double)volume * regionBlockProbability;
        int blocksToTick = (int)Math.floor(blocksToTickAsDouble);
        if (this.vsRandom.method_43058() > blocksToTickAsDouble - (double)blocksToTick) {
            ++blocksToTick;
        }
        class_638 thisAsClientLevel = (class_638)class_638.class.cast(this);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int i = 0; i < blocksToTick; ++i) {
            int posX = region.minX() + this.vsRandom.method_43048(region.maxX() - region.minX() + 1);
            int posY = region.minY() + this.vsRandom.method_43048(region.maxY() - region.minY() + 1);
            int posZ = region.minZ() + this.vsRandom.method_43048(region.maxZ() - region.minZ() + 1);
            mutableBlockPos.method_10103(posX, posY, posZ);
            class_2680 blockState = thisAsClientLevel.method_8320((class_2338)mutableBlockPos);
            blockState.method_26204().method_9496(blockState, (class_1937)thisAsClientLevel, (class_2338)mutableBlockPos, this.vsRandom);
            class_3610 fluidState = thisAsClientLevel.method_8316((class_2338)mutableBlockPos);
            if (!fluidState.method_15769()) {
                fluidState.method_15768((class_1937)thisAsClientLevel, (class_2338)mutableBlockPos, this.vsRandom);
                class_2394 particleOptions = fluidState.method_15766();
                if (particleOptions != null && this.vsRandom.method_43048(10) == 0) {
                    boolean bl2 = blockState.method_26206((class_1922)thisAsClientLevel, (class_2338)mutableBlockPos, class_2350.field_11033);
                    class_2338 blockPos = mutableBlockPos.method_10074();
                    this.method_2938(blockPos, thisAsClientLevel.method_8320(blockPos), particleOptions, bl2);
                }
            }
            if (holdingBarrierItem && blockState.method_27852(class_2246.field_10499)) {
                thisAsClientLevel.method_8406((class_2394)new class_2388(class_2398.field_35434, blockState), (double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 0.0, 0.0, 0.0);
            }
            if (blockState.method_26234((class_1922)thisAsClientLevel, (class_2338)mutableBlockPos)) continue;
            ((class_1959)thisAsClientLevel.method_23753((class_2338)mutableBlockPos).comp_349()).method_24378().ifPresent(ambientParticleSettings -> {
                if (ambientParticleSettings.method_24370(this.vsRandom)) {
                    thisAsClientLevel.method_8406(ambientParticleSettings.method_24369(), (double)mutableBlockPos.method_10263() + this.vsRandom.method_43058(), (double)mutableBlockPos.method_10264() + this.vsRandom.method_43058(), (double)mutableBlockPos.method_10260() + this.vsRandom.method_43058(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    @Redirect(at=@At(value="NEW", target="net/minecraft/client/resources/sounds/SimpleSoundInstance"), method={"playSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZJ)V"})
    private class_1109 redirectNewSoundInstance(class_3414 soundEvent, class_3419 soundSource, float volume, float pitch, class_5819 randomSource, double x, double y, double z) {
        Ship ship = VSGameUtilsKt.getShipManagingPos((class_1937)class_638.class.cast(this), x, y, z);
        if (ship != null) {
            return new SimpleSoundInstanceOnShip(soundEvent, soundSource, volume, pitch, randomSource, x, y, z, ship);
        }
        return new class_1109(soundEvent, soundSource, volume, pitch, randomSource, x, y, z);
    }
}

