/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.entity;

import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_148;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5539;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Mixin(value={class_1297.class})
public abstract class MixinEntity
implements IEntityDraggingInformationProvider {
    @Unique
    private final EntityDraggingInformation draggingInformation = new EntityDraggingInformation();
    @Shadow
    private class_243 field_22467;
    @Shadow
    public class_1937 field_6002;
    @Shadow
    @Nullable
    private class_1297 field_6034;

    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;clip(Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;"))
    public class_3965 addShipsToRaycast(class_1937 receiver, class_3959 ctx) {
        return RaycastUtilsKt.clipIncludeShips(receiver, ctx);
    }

    @Inject(at={@At(value="TAIL")}, method={"checkInsideBlocks"})
    private void afterCheckInside(CallbackInfo ci) {
        AABBd boundingBox = VectorConversionsMCKt.toJOML(this.method_5829());
        AABBd temp = new AABBd();
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting(this.field_6002, boundingBox)) {
            AABBd inShipBB = boundingBox.transform(ship.getShipTransform().getWorldToShipMatrix(), temp);
            this.originalCheckInside(inShipBB);
        }
    }

    @Unique
    private void originalCheckInside(AABBd aABB) {
        class_1297 self = (class_1297)class_1297.class.cast(this);
        class_2338 blockPos = class_2338.method_49637((double)(aABB.minX + 0.001), (double)(aABB.minY + 0.001), (double)(aABB.minZ + 0.001));
        class_2338 blockPos2 = class_2338.method_49637((double)(aABB.maxX - 0.001), (double)(aABB.maxY - 0.001), (double)(aABB.maxZ - 0.001));
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (this.field_6002.method_22343(blockPos, blockPos2)) {
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                        mutableBlockPos.method_10103(i, j, k);
                        class_2680 blockState = this.field_6002.method_8320((class_2338)mutableBlockPos);
                        try {
                            blockState.method_26178(this.field_6002, (class_2338)mutableBlockPos, self);
                            this.method_5622(blockState);
                            continue;
                        }
                        catch (Throwable var12) {
                            class_128 crashReport = class_128.method_560((Throwable)var12, (String)"Colliding entity with block");
                            class_129 crashReportCategory = crashReport.method_562("Block being collided with");
                            class_129.method_586((class_129)crashReportCategory, (class_5539)this.field_6002, (class_2338)mutableBlockPos, (class_2680)blockState);
                            throw new class_148(crashReport);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetEyePosition(float partialTicks, CallbackInfoReturnable<class_243> cir) {
        LoadedShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(this.field_6002, (class_1297)class_1297.class.cast(this));
        if (shipMountedTo == null) {
            return;
        }
        ShipTransform shipTransform = shipMountedTo instanceof ShipObjectClient ? ((ShipObjectClient)shipMountedTo).getRenderTransform() : shipMountedTo.getShipTransform();
        Vector3d basePos = shipTransform.getShipToWorldMatrix().transformPosition(VSGameUtilsKt.getPassengerPos(this.field_6034, this.method_5678(), partialTicks), new Vector3d());
        Vector3d eyeRelativePos = shipTransform.getShipCoordinatesToWorldCoordinatesRotation().transform(new Vector3d(0.0, this.method_5751(), 0.0));
        class_243 newEyePos = VectorConversionsMCKt.toMinecraft(basePos.add(eyeRelativePos, new Vector3d()));
        cir.setReturnValue((Object)newEyePos);
    }

    @Inject(method={"calculateViewVector"}, at={@At(value="HEAD")}, cancellable=true)
    private void preCalculateViewVector(float xRot, float yRot, CallbackInfoReturnable<class_243> cir) {
        LoadedShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(this.field_6002, (class_1297)class_1297.class.cast(this));
        if (shipMountedTo == null) {
            return;
        }
        float f = xRot * ((float)Math.PI / 180);
        float g = -yRot * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        Vector3d originalViewVector = new Vector3d(i * j, -k, h * j);
        ShipTransform shipTransform = shipMountedTo instanceof ClientShip ? ((ClientShip)shipMountedTo).getRenderTransform() : shipMountedTo.getShipTransform();
        class_243 newViewVector = VectorConversionsMCKt.toMinecraft(shipTransform.getShipCoordinatesToWorldCoordinatesRotation().transform(originalViewVector, new Vector3d()));
        cir.setReturnValue((Object)newViewVector);
    }

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    protected abstract void method_5865(class_1297 var1, class_1297.class_4738 var2);

    @Shadow
    protected abstract void method_5622(class_2680 var1);

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract float method_5751();

    @Shadow
    public abstract class_1299<?> method_5864();

    @Shadow
    public abstract double method_5678();

    @Override
    @NotNull
    public EntityDraggingInformation getDraggingInformation() {
        return this.draggingInformation;
    }
}

