/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.sodium;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import java.util.WeakHashMap;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RegionChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.util.frustum.Frustum;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.joml.primitives.AABBd;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.mixinducks.mod_compat.sodium.RenderSectionManagerDuck;

@Mixin(value={RenderSectionManager.class}, remap=false)
public abstract class MixinRenderSectionManager
implements RenderSectionManagerDuck {
    @Unique
    private final WeakHashMap<ClientShip, ChunkRenderList> shipRenderLists = new WeakHashMap();
    @Shadow
    @Final
    private class_638 world;
    @Shadow
    @Final
    private ObjectList<RenderSection> tickableChunks;
    @Shadow
    @Final
    private RegionChunkRenderer chunkRenderer;
    @Shadow
    @Final
    private Map<ChunkUpdateType, PriorityQueue<RenderSection>> rebuildQueues;
    @Shadow
    private float cameraX;
    @Shadow
    private float cameraY;
    @Shadow
    private float cameraZ;
    @Shadow
    @Final
    private static double NEARBY_CHUNK_DISTANCE;

    @Override
    public WeakHashMap<ClientShip, ChunkRenderList> getShipRenderLists() {
        return this.shipRenderLists;
    }

    @Shadow
    protected abstract RenderSection getRenderSection(int var1, int var2, int var3);

    @Shadow
    protected abstract void addEntitiesToRenderLists(RenderSection var1);

    @Inject(at={@At(value="TAIL")}, method={"iterateChunks"})
    private void afterIterateChunks(class_4184 camera, Frustum frustum, int frame, boolean spectator, CallbackInfo ci) {
        for (ClientShip clientShip : VSGameUtilsKt.getShipObjectWorld(class_310.method_1551()).getLoadedShips()) {
            clientShip.getActiveChunksSet().forEach((x, z) -> {
                for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
                    PriorityQueue<RenderSection> queue;
                    RenderSection section = this.getRenderSection(x, y, z);
                    if (section == null) continue;
                    if (section.getPendingUpdate() != null && (queue = this.rebuildQueues.get(section.getPendingUpdate())).size() < 31) {
                        queue.enqueue((Object)section);
                    }
                    ChunkRenderBounds b = section.getBounds();
                    AABBd b2 = new AABBd((double)b.x1 - 0.6, (double)b.y1 - 0.6, (double)b.z1 - 0.6, (double)b.x2 + 0.6, (double)b.y2 + 0.6, (double)b.z2 + 0.6).transform(ship.getRenderTransform().getShipToWorld());
                    if (section.isEmpty() || !frustum.isBoxVisible((float)b2.minX, (float)b2.minY, (float)b2.minZ, (float)b2.maxX, (float)b2.maxY, (float)b2.maxZ)) continue;
                    this.shipRenderLists.computeIfAbsent(ship, k -> new ChunkRenderList()).add(section);
                    if (section.isTickable()) {
                        this.tickableChunks.add((Object)section);
                    }
                    this.addEntitiesToRenderLists(section);
                }
            });
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSectionManager;isChunkPrioritized(Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;)Z"), method={"scheduleRebuild"})
    private boolean redirectIsChunkPrioritized(RenderSectionManager instance, RenderSection render) {
        return VSGameUtilsKt.squaredDistanceBetweenInclShips((class_1937)this.world, render.getOriginX() + 8, render.getOriginY() + 8, render.getOriginZ() + 8, this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE;
    }

    @Inject(at={@At(value="TAIL")}, method={"resetLists"})
    private void afterResetLists(CallbackInfo ci) {
        this.shipRenderLists.values().forEach(ChunkRenderList::clear);
    }
}

