/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.VSPipeline;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.ShipSavedData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.hooks.VSGameEvents;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.world.ChunkManagement;
import org.valkyrienskies.mod.util.KrunchSupport;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
implements IShipObjectWorldServerProvider {
    @Shadow
    private class_3324 field_4550;
    @Unique
    private ServerShipWorldCore shipWorld;
    @Unique
    private VSPipeline vsPipeline;
    private Set<String> loadedLevels = new HashSet<String>();

    @Shadow
    public abstract class_3218 method_30002();

    @Shadow
    public abstract Iterable<class_3218> method_3738();

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;initServer()Z")}, method={"runServer"})
    private void beforeInitServer(CallbackInfo info) {
        ValkyrienSkiesMod.setCurrentServer((MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Inject(at={@At(value="TAIL")}, method={"stopServer"})
    private void afterStopServer(CallbackInfo ci) {
        ValkyrienSkiesMod.setCurrentServer(null);
    }

    @Inject(at={@At(value="HEAD")}, method={"tickServer"})
    public void onTick(BooleanSupplier booleanSupplier, CallbackInfo ci) {
        Set vsPlayers = this.field_4550.method_14571().stream().map(VSGameUtilsKt::getPlayerWrapper).collect(Collectors.toSet());
        this.shipWorld.setPlayers(vsPlayers);
    }

    @Override
    @Nullable
    public ServerShipWorldCore getShipObjectWorld() {
        return this.shipWorld;
    }

    @Override
    @Nullable
    public VSPipeline getVsPipeline() {
        return this.vsPipeline;
    }

    @Inject(method={"createLevels"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getDataStorage()Lnet/minecraft/world/level/storage/DimensionDataStorage;")})
    private void postCreateLevels(CallbackInfo ci) {
        ShipSavedData shipSavedData = (ShipSavedData)this.method_30002().method_17983().method_17924(ShipSavedData::load, ShipSavedData.Companion::createEmpty, "vs_ship_data");
        Throwable ex = shipSavedData.getLoadingException();
        if (ex != null) {
            System.err.println("VALKYRIEN SKIES ERROR WHILE LOADING SHIP DATA");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        this.vsPipeline = shipSavedData.getPipeline();
        KrunchSupport.INSTANCE.setKrunchSupported(!this.vsPipeline.isUsingDummyPhysics());
        this.shipWorld = this.vsPipeline.getShipWorld();
        VSGameEvents.INSTANCE.getRegistriesCompleted().emit(Unit.INSTANCE);
        this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((class_1937)this.method_30002()), VSGameUtilsKt.getYRange((class_1937)this.method_30002()));
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void preTick(CallbackInfo ci) {
        HashMap<String, class_3218> newLoadedLevels = new HashMap<String, class_3218>();
        for (class_3218 level : this.method_3738()) {
            newLoadedLevels.put(VSGameUtilsKt.getDimensionId((class_1937)level), level);
        }
        for (String oldLoadedLevelId : this.loadedLevels) {
            if (newLoadedLevels.containsKey(oldLoadedLevelId)) continue;
            this.shipWorld.removeDimension(oldLoadedLevelId);
        }
        this.loadedLevels = newLoadedLevels.keySet();
        this.vsPipeline.preTickGame();
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerConnectionListener;tick()V", shift=At.Shift.AFTER)})
    private void preConnectionTick(CallbackInfo ci) {
        ChunkManagement.tickChunkLoading(this.shipWorld, (MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void postTick(CallbackInfo ci) {
        this.vsPipeline.postTickGame();
        for (class_3218 level : this.method_3738()) {
            EntityDragger.INSTANCE.dragEntitiesWithShips(level.method_27909());
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void preStopServer(CallbackInfo ci) {
        if (this.vsPipeline != null) {
            this.vsPipeline.setDeleteResources(true);
        }
        this.shipWorld = null;
    }
}

