/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5539;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.common.util.ShipSettingsKt;

@Mixin(value={class_3898.class})
public abstract class MixinChunkMap {
    @Shadow
    @Final
    class_3218 field_17214;
    @Shadow
    @Final
    private Supplier<class_26> field_17705;

    @Shadow
    protected abstract class_2487 method_43381(class_2487 var1);

    @Inject(method={"readChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void preReadChunk(class_1923 chunkPos, CallbackInfoReturnable<CompletableFuture<Optional<class_2487>>> cir) {
        class_3898 self = (class_3898)class_3898.class.cast(this);
        cir.setReturnValue((Object)self.method_23696(chunkPos).thenApplyAsync(compoundTag -> {
            ServerShip ship;
            if (compoundTag.isEmpty() && ((ship = VSGameUtilsKt.getShipManagingPos(this.field_17214, chunkPos.field_9181, chunkPos.field_9180)) == null && VSGameUtilsKt.isChunkInShipyard((class_1937)this.field_17214, chunkPos.field_9181, chunkPos.field_9180) || ship != null && !ShipSettingsKt.getSettings(ship).getShouldGenerateChunks())) {
                class_2818 generatedChunk = new class_2818(this.field_17214, new class_2839(chunkPos, class_2843.field_12950, (class_5539)this.field_17214, this.field_17214.method_30349().method_30530(class_7924.field_41236), null), null);
                return Optional.of(class_2852.method_12410((class_3218)this.field_17214, (class_2791)generatedChunk));
            }
            return compoundTag.map(this::method_43381);
        }));
    }

    @Inject(method={"getPlayers"}, at={@At(value="TAIL")}, cancellable=true)
    private void postGetPlayersWatchingChunk(class_1923 chunkPos, boolean onlyOnWatchDistanceEdge, CallbackInfoReturnable<List<class_3222>> cir) {
        Iterator<IPlayer> playersWatchingShipChunk = VSGameUtilsKt.getShipObjectWorld(this.field_17214).getIPlayersWatchingShipChunk(chunkPos.field_9181, chunkPos.field_9180, VSGameUtilsKt.getDimensionId((class_1937)this.field_17214));
        if (!playersWatchingShipChunk.hasNext()) {
            return;
        }
        List oldReturnValue = (List)cir.getReturnValue();
        HashSet watchingPlayers = new HashSet(oldReturnValue);
        playersWatchingShipChunk.forEachRemaining(iPlayer -> {
            MinecraftPlayer minecraftPlayer = (MinecraftPlayer)iPlayer;
            class_3222 playerEntity = (class_3222)minecraftPlayer.getPlayerEntityReference().get();
            if (playerEntity != null) {
                watchingPlayers.add(playerEntity);
            }
        });
        cir.setReturnValue(new ArrayList(watchingPlayers));
    }
}

