/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.core.api.ships.WingManager;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.chunks.TerrainUpdate;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.block.WingBlock;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.accessors.server.world.ChunkMapAccessor;

@Mixin(value={class_3218.class})
public abstract class MixinServerLevel
implements IShipObjectWorldServerProvider {
    @Shadow
    @Final
    private class_3215 field_24624;
    private final Map<class_1923, List<Vector3ic>> knownChunks = new HashMap<class_1923, List<Vector3ic>>();

    @Shadow
    @NotNull
    public abstract MinecraftServer method_8503();

    @Override
    @Nullable
    public ServerShipWorldCore getShipObjectWorld() {
        return ((IShipObjectWorldServerProvider)this.method_8503()).getShipObjectWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    void onInit(CallbackInfo ci) {
        if (this.getShipObjectWorld() != null) {
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((class_1937)((class_3218)this)), VSGameUtilsKt.getYRange((class_1937)((class_3218)this)));
        }
    }

    @WrapOperation(method={"sendParticles(Lnet/minecraft/server/level/ServerPlayer;ZDDDLnet/minecraft/network/protocol/Packet;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;closerToCenterThan(Lnet/minecraft/core/Position;D)Z")})
    private boolean includeShipsInParticleDistanceCheck(class_2338 player, class_2374 particle, double distance, Operation<Boolean> closerToCenterThan) {
        class_3218 self = (class_3218)class_3218.class.cast(this);
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos(self, (int)particle.method_10216() >> 4, (int)particle.method_10215() >> 4);
        if (ship == null) {
            return (Boolean)closerToCenterThan.call(new Object[]{player, particle, distance});
        }
        Vector3d posInWorld = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(particle));
        return posInWorld.distanceSquared(player.method_10263(), player.method_10264(), player.method_10260()) < distance * distance;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void postTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        class_3218 self = (class_3218)class_3218.class.cast(this);
        ServerShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld(self);
        ChunkMapAccessor chunkMapAccessor = (ChunkMapAccessor)this.field_24624.field_17254;
        ArrayList<TerrainUpdate> voxelShapeUpdates = new ArrayList<TerrainUpdate>();
        for (class_3193 chunkHolder : chunkMapAccessor.callGetChunks()) {
            class_2818 worldChunk;
            Optional worldChunkOptional = chunkHolder.method_16145().getNow(class_3193.field_16427).left();
            if (!worldChunkOptional.isPresent() || this.knownChunks.containsKey((worldChunk = (class_2818)worldChunkOptional.get()).method_12004())) continue;
            ArrayList<Vector3i> voxelChunkPositions = new ArrayList<Vector3i>();
            int chunkX = worldChunk.method_12004().field_9181;
            int chunkZ = worldChunk.method_12004().field_9180;
            class_2826[] chunkSections = worldChunk.method_12006();
            for (int sectionY = 0; sectionY < chunkSections.length; ++sectionY) {
                class_2826 chunkSection = chunkSections[sectionY];
                Vector3i chunkPos = new Vector3i(chunkX, worldChunk.method_31604(sectionY), chunkZ);
                voxelChunkPositions.add(chunkPos);
                if (chunkSection != null && !chunkSection.method_38292()) {
                    TerrainUpdate voxelShapeUpdate = VSGameUtilsKt.toDenseVoxelUpdate(chunkSection, chunkPos);
                    voxelShapeUpdates.add(voxelShapeUpdate);
                    class_3218 thisAsLevel = (class_3218)class_3218.class.cast(this);
                    LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos(thisAsLevel, chunkX, chunkZ);
                    if (ship == null) continue;
                    WingManager shipAsWingManager = ship.getAttachment(WingManager.class);
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2680 blockState = chunkSection.method_12254(x, y, z);
                                int posX = (chunkX << 4) + x;
                                int posY = (sectionY << 4) + worldChunk.method_31607() + y;
                                int posZ = (chunkZ << 4) + z;
                                if (!(blockState.method_26204() instanceof WingBlock)) continue;
                                mutableBlockPos.method_10103(posX, posY, posZ);
                                Wing wing = ((WingBlock)blockState.method_26204()).getWing((class_1937)thisAsLevel, (class_2338)mutableBlockPos, blockState);
                                if (wing == null) continue;
                                shipAsWingManager.setWing(shipAsWingManager.getFirstWingGroupId(), posX, posY, posZ, wing);
                            }
                        }
                    }
                    continue;
                }
                TerrainUpdate emptyVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newEmptyVoxelShapeUpdate(chunkPos.x(), chunkPos.y(), chunkPos.z(), true);
                voxelShapeUpdates.add(emptyVoxelShapeUpdate);
            }
            this.knownChunks.put(worldChunk.method_12004(), voxelChunkPositions);
        }
        Iterator<Map.Entry<class_1923, List<Vector3ic>>> knownChunkPosIterator = this.knownChunks.entrySet().iterator();
        while (knownChunkPosIterator.hasNext()) {
            Map.Entry<class_1923, List<Vector3ic>> knownChunkPosEntry = knownChunkPosIterator.next();
            if (chunkMapAccessor.callGetVisibleChunkIfPresent(knownChunkPosEntry.getKey().method_8324()) != null) continue;
            for (Vector3ic unloadedChunk : knownChunkPosEntry.getValue()) {
                TerrainUpdate deleteVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newDeleteTerrainUpdate(unloadedChunk.x(), unloadedChunk.y(), unloadedChunk.z());
                voxelShapeUpdates.add(deleteVoxelShapeUpdate);
            }
            knownChunkPosIterator.remove();
        }
        shipObjectWorld.addTerrainUpdates(VSGameUtilsKt.getDimensionId((class_1937)self), voxelShapeUpdates);
    }
}

