/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.constraints.AttachmentConstraint;
import org.valkyrienskies.physics_api.constraints.Constraint;
import org.valkyrienskies.physics_api.constraints.ConstraintAndId;
import org.valkyrienskies.physics_api.constraints.ConstraintType;
import org.valkyrienskies.physics_api.constraints.FixedAttachmentOrientationConstraint;
import org.valkyrienskies.physics_api.constraints.FixedOrientationConstraint;
import org.valkyrienskies.physics_api.constraints.HingeOrientationConstraint;
import org.valkyrienskies.physics_api.constraints.HingeSwingLimitsConstraint;
import org.valkyrienskies.physics_api.constraints.HingeTargetAngleConstraint;
import org.valkyrienskies.physics_api.constraints.PosDampingConstraint;
import org.valkyrienskies.physics_api.constraints.RopeConstraint;
import org.valkyrienskies.physics_api.constraints.RotDampingAxes;
import org.valkyrienskies.physics_api.constraints.RotDampingConstraint;
import org.valkyrienskies.physics_api.constraints.SlideConstraint;
import org.valkyrienskies.physics_api.constraints.SphericalSwingLimitsConstraint;
import org.valkyrienskies.physics_api.constraints.SphericalTwistLimitsConstraint;

public class ConstraintEncoder {
    private static final int CONSTRAINT_MAX_SIZE = 156;
    private static final int CONSTRAINT_ID_SIZE = 4;
    private static final int BYTE_ARRAY_LENGTH_SIZE = 4;

    public static void encodeConstraint(@NotNull Constraint constraint, @NotNull ByteBuffer writeBuffer) {
        switch (constraint.getConstraintType()) {
            case ATTACHMENT: {
                ConstraintEncoder.encodeAttachmentConstraint((AttachmentConstraint)constraint, writeBuffer);
                break;
            }
            case FIXED_ATTACHMENT_ORIENTATION: {
                ConstraintEncoder.encodeFixedAttachmentOrientationConstraint((FixedAttachmentOrientationConstraint)constraint, writeBuffer);
                break;
            }
            case FIXED_ORIENTATION: {
                ConstraintEncoder.encodeFixedOrientationConstraint((FixedOrientationConstraint)constraint, writeBuffer);
                break;
            }
            case HINGE_ORIENTATION: {
                ConstraintEncoder.encodeHingeOrientationConstraint((HingeOrientationConstraint)constraint, writeBuffer);
                break;
            }
            case HINGE_SWING_LIMITS: {
                ConstraintEncoder.encodeHingeSwingLimitsConstraint((HingeSwingLimitsConstraint)constraint, writeBuffer);
                break;
            }
            case HINGE_TARGET_ANGLE: {
                ConstraintEncoder.encodeHingeTargetAngleConstraint((HingeTargetAngleConstraint)constraint, writeBuffer);
                break;
            }
            case POS_DAMPING: {
                ConstraintEncoder.encodePosDampingConstraint((PosDampingConstraint)constraint, writeBuffer);
                break;
            }
            case ROPE: {
                ConstraintEncoder.encodeRopeConstraint((RopeConstraint)constraint, writeBuffer);
                break;
            }
            case ROT_DAMPING: {
                ConstraintEncoder.encodeRotDampingConstraint((RotDampingConstraint)constraint, writeBuffer);
                break;
            }
            case SLIDE: {
                ConstraintEncoder.encodeSlideConstraint((SlideConstraint)constraint, writeBuffer);
                break;
            }
            case SPHERICAL_SWING_LIMITS: {
                ConstraintEncoder.encodeSphericalSwingLimitsConstraint((SphericalSwingLimitsConstraint)constraint, writeBuffer);
                break;
            }
            case SPHERICAL_TWIST_LIMITS: {
                ConstraintEncoder.encodeSphericalTwistLimitsConstraint((SphericalTwistLimitsConstraint)constraint, writeBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constraintType " + (Object)((Object)constraint.getConstraintType()));
            }
        }
    }

    @NotNull
    public static Constraint decodeConstraint(@NotNull ByteBuffer readBuffer) {
        ConstraintType constraintType = ConstraintType.values()[readBuffer.getInt()];
        switch (constraintType) {
            case ATTACHMENT: {
                return ConstraintEncoder.decodeAttachmentConstraint(readBuffer);
            }
            case FIXED_ATTACHMENT_ORIENTATION: {
                return ConstraintEncoder.decodeFixedAttachmentOrientationConstraint(readBuffer);
            }
            case FIXED_ORIENTATION: {
                return ConstraintEncoder.decodeFixedOrientationConstraint(readBuffer);
            }
            case HINGE_ORIENTATION: {
                return ConstraintEncoder.decodeHingeOrientationConstraint(readBuffer);
            }
            case HINGE_SWING_LIMITS: {
                return ConstraintEncoder.decodeHingeSwingLimitsConstraint(readBuffer);
            }
            case HINGE_TARGET_ANGLE: {
                return ConstraintEncoder.decodeHingeTargetAngleConstraintConstraint(readBuffer);
            }
            case POS_DAMPING: {
                return ConstraintEncoder.decodePosDampingConstraint(readBuffer);
            }
            case ROPE: {
                return ConstraintEncoder.decodeRopeConstraint(readBuffer);
            }
            case ROT_DAMPING: {
                return ConstraintEncoder.decodeRotDampingConstraint(readBuffer);
            }
            case SLIDE: {
                return ConstraintEncoder.decodeSlideConstraint(readBuffer);
            }
            case SPHERICAL_SWING_LIMITS: {
                return ConstraintEncoder.decodeSphericalSwingLimitsConstraint(readBuffer);
            }
            case SPHERICAL_TWIST_LIMITS: {
                return ConstraintEncoder.decodeSphericalTwistLimitsConstraint(readBuffer);
            }
        }
        throw new IllegalArgumentException("Unknown constraintType " + (Object)((Object)constraintType));
    }

    public static void encodeConstraintAndId(@NotNull ConstraintAndId constraintAndId, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(constraintAndId.getConstraintId());
        ConstraintEncoder.encodeConstraint(constraintAndId.getConstraint(), writeBuffer);
    }

    @NotNull
    public static ConstraintAndId decodeConstraintAndId(@NotNull ByteBuffer readBuffer) {
        int constraintId = readBuffer.getInt();
        Constraint constraint = ConstraintEncoder.decodeConstraint(readBuffer);
        return new ConstraintAndId(constraintId, constraint);
    }

    @NotNull
    public static byte[] encodeConstraintAndId(@NotNull ConstraintAndId constraintAndId) {
        byte[] bytesRaw = new byte[160];
        ConstraintEncoder.encodeConstraintAndId(constraintAndId, ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
        return bytesRaw;
    }

    @NotNull
    public static ConstraintAndId decodeConstraintAndId(@NotNull byte[] bytesRaw) {
        return ConstraintEncoder.decodeConstraintAndId(ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
    }

    private static void encodeAttachmentConstraint(@NotNull AttachmentConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.ATTACHMENT.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        writeBuffer.putDouble(constraint.getFixedDistance());
    }

    @NotNull
    private static AttachmentConstraint decodeAttachmentConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        double fixedDistance = readBuffer.getDouble();
        return new AttachmentConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localPos0, localPos1, maxForce, fixedDistance);
    }

    private static void encodeFixedAttachmentOrientationConstraint(@NotNull FixedAttachmentOrientationConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.FIXED_ATTACHMENT_ORIENTATION.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
    }

    @NotNull
    private static FixedAttachmentOrientationConstraint decodeFixedAttachmentOrientationConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        return new FixedAttachmentOrientationConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque, localPos0, localPos1, maxForce);
    }

    private static void encodeFixedOrientationConstraint(@NotNull FixedOrientationConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.FIXED_ORIENTATION.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
    }

    @NotNull
    private static FixedOrientationConstraint decodeFixedOrientationConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        return new FixedOrientationConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque);
    }

    private static void encodeHingeOrientationConstraint(@NotNull HingeOrientationConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.HINGE_ORIENTATION.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
    }

    @NotNull
    private static HingeOrientationConstraint decodeHingeOrientationConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        return new HingeOrientationConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque);
    }

    private static void encodeHingeSwingLimitsConstraint(@NotNull HingeSwingLimitsConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.HINGE_SWING_LIMITS.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getMinSwingAngle());
        writeBuffer.putDouble(constraint.getMaxSwingAngle());
    }

    @NotNull
    private static HingeSwingLimitsConstraint decodeHingeSwingLimitsConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double minSwingAngle = readBuffer.getDouble();
        double maxSwingAngle = readBuffer.getDouble();
        return new HingeSwingLimitsConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque, minSwingAngle, maxSwingAngle);
    }

    private static void encodeHingeTargetAngleConstraint(@NotNull HingeTargetAngleConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.HINGE_TARGET_ANGLE.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getTargetAngle());
        writeBuffer.putDouble(constraint.getNextTickTargetAngle());
    }

    @NotNull
    private static HingeTargetAngleConstraint decodeHingeTargetAngleConstraintConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double targetAngle = readBuffer.getDouble();
        double nextTickTargetAngle = readBuffer.getDouble();
        return new HingeTargetAngleConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque, targetAngle, nextTickTargetAngle);
    }

    private static void encodePosDampingConstraint(@NotNull PosDampingConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.POS_DAMPING.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        writeBuffer.putDouble(constraint.getPosDamping());
    }

    @NotNull
    private static PosDampingConstraint decodePosDampingConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        double posDamping = readBuffer.getDouble();
        return new PosDampingConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localPos0, localPos1, maxForce, posDamping);
    }

    private static void encodeRopeConstraint(@NotNull RopeConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.ROPE.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        writeBuffer.putDouble(constraint.getRopeLength());
    }

    @NotNull
    private static RopeConstraint decodeRopeConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        double ropeLength = readBuffer.getDouble();
        return new RopeConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localPos0, localPos1, maxForce, ropeLength);
    }

    private static void encodeRotDampingConstraint(@NotNull RotDampingConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.ROT_DAMPING.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getRotDamping());
        switch (constraint.getRotDampingAxes()) {
            case PARALLEL: {
                writeBuffer.putInt(0);
                break;
            }
            case PERPENDICULAR: {
                writeBuffer.putInt(1);
                break;
            }
            case ALL_AXES: {
                writeBuffer.putInt(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of constraint.getRotDampingAxes() " + (Object)((Object)constraint.getRotDampingAxes()));
            }
        }
    }

    @NotNull
    private static RotDampingConstraint decodeRotDampingConstraint(@NotNull ByteBuffer readBuffer) {
        RotDampingAxes rotDampingAxes;
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double rotDamping = readBuffer.getDouble();
        int rotDampingAxesRaw = readBuffer.getInt();
        switch (rotDampingAxesRaw) {
            case 0: {
                rotDampingAxes = RotDampingAxes.PARALLEL;
                break;
            }
            case 1: {
                rotDampingAxes = RotDampingAxes.PERPENDICULAR;
                break;
            }
            case 2: {
                rotDampingAxes = RotDampingAxes.ALL_AXES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of rotDampingAxesRaw " + rotDampingAxesRaw);
            }
        }
        return new RotDampingConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque, rotDamping, rotDampingAxes);
    }

    private static void encodeSlideConstraint(@NotNull SlideConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.SLIDE.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos0(), writeBuffer);
        ConstraintEncoder.writeVector3dc(constraint.getLocalPos1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxForce());
        ConstraintEncoder.writeVector3dc(constraint.getLocalSlideAxis0(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxDistBetweenPoints());
    }

    @NotNull
    private static SlideConstraint decodeSlideConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Vector3dc localPos0 = ConstraintEncoder.readVector3dc(readBuffer);
        Vector3dc localPos1 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxForce = readBuffer.getDouble();
        Vector3dc localSlideAxis0 = ConstraintEncoder.readVector3dc(readBuffer);
        double maxDistBetweenPoints = readBuffer.getDouble();
        return new SlideConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localPos0, localPos1, maxForce, localSlideAxis0, maxDistBetweenPoints);
    }

    private static void encodeSphericalSwingLimitsConstraint(@NotNull SphericalSwingLimitsConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.SPHERICAL_SWING_LIMITS.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getMinSwingAngle());
        writeBuffer.putDouble(constraint.getMaxSwingAngle());
    }

    @NotNull
    private static SphericalSwingLimitsConstraint decodeSphericalSwingLimitsConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double minSwingAngle = readBuffer.getDouble();
        double maxSwingAngle = readBuffer.getDouble();
        return new SphericalSwingLimitsConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque, minSwingAngle, maxSwingAngle);
    }

    private static void encodeSphericalTwistLimitsConstraint(@NotNull SphericalTwistLimitsConstraint constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(ConstraintType.SPHERICAL_TWIST_LIMITS.ordinal());
        writeBuffer.putInt(constraint.getRigidBodyId0());
        writeBuffer.putInt(constraint.getRigidBodyId1());
        writeBuffer.putInt(constraint.getSegment0Id());
        writeBuffer.putInt(constraint.getSegment1Id());
        writeBuffer.putDouble(constraint.getCompliance());
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot0(), writeBuffer);
        ConstraintEncoder.writeQuaterniondc(constraint.getLocalRot1(), writeBuffer);
        writeBuffer.putDouble(constraint.getMaxTorque());
        writeBuffer.putDouble(constraint.getMinTwistAngle());
        writeBuffer.putDouble(constraint.getMaxTwistAngle());
    }

    @NotNull
    private static SphericalTwistLimitsConstraint decodeSphericalTwistLimitsConstraint(@NotNull ByteBuffer readBuffer) {
        int rigidBodyId0 = readBuffer.getInt();
        int rigidBodyId1 = readBuffer.getInt();
        int segment0Id = readBuffer.getInt();
        int segment1Id = readBuffer.getInt();
        double compliance = readBuffer.getDouble();
        Quaterniondc localRot0 = ConstraintEncoder.readQuaterniondc(readBuffer);
        Quaterniondc localRot1 = ConstraintEncoder.readQuaterniondc(readBuffer);
        double maxTorque = readBuffer.getDouble();
        double minTwistAngle = readBuffer.getDouble();
        double maxTwistAngle = readBuffer.getDouble();
        return new SphericalTwistLimitsConstraint(rigidBodyId0, rigidBodyId1, segment0Id, segment1Id, compliance, localRot0, localRot1, maxTorque, minTwistAngle, maxTwistAngle);
    }

    public static void encodeConstraints(@NotNull List<ConstraintAndId> constraints, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(0);
        for (ConstraintAndId constraintAndId : constraints) {
            ConstraintEncoder.encodeConstraintAndId(constraintAndId, writeBuffer);
        }
        int position = writeBuffer.position();
        writeBuffer.putInt(0, position);
    }

    @NotNull
    public static List<ConstraintAndId> decodeConstraints(@NotNull ByteBuffer readBuffer) {
        ArrayList<ConstraintAndId> constraints = new ArrayList<ConstraintAndId>();
        int bytesSize = readBuffer.getInt();
        while (readBuffer.position() != bytesSize) {
            ConstraintAndId constraintAndId = ConstraintEncoder.decodeConstraintAndId(readBuffer);
            constraints.add(constraintAndId);
        }
        return constraints;
    }

    @NotNull
    public static byte[] encodeConstraints(@NotNull List<ConstraintAndId> constraints) {
        byte[] bytesRaw = new byte[constraints.size() * 160 + 4];
        ConstraintEncoder.encodeConstraints(constraints, ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
        return bytesRaw;
    }

    @NotNull
    public static List<ConstraintAndId> decodeConstraints(@NotNull byte[] bytesRaw) {
        return ConstraintEncoder.decodeConstraints(ByteBuffer.wrap(bytesRaw).order(ByteOrder.LITTLE_ENDIAN));
    }

    private static void writeVector3dc(@NotNull Vector3dc vector3dc, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putDouble(vector3dc.x());
        writeBuffer.putDouble(vector3dc.y());
        writeBuffer.putDouble(vector3dc.z());
    }

    @NotNull
    private static Vector3dc readVector3dc(@NotNull ByteBuffer readBuffer) {
        return new Vector3d(readBuffer.getDouble(), readBuffer.getDouble(), readBuffer.getDouble());
    }

    private static void writeQuaterniondc(@NotNull Quaterniondc quaterniondc, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putDouble(quaterniondc.w());
        writeBuffer.putDouble(quaterniondc.x());
        writeBuffer.putDouble(quaterniondc.y());
        writeBuffer.putDouble(quaterniondc.z());
    }

    @NotNull
    private static Quaterniondc readQuaterniondc(@NotNull ByteBuffer readBuffer) {
        double w = readBuffer.getDouble();
        double x = readBuffer.getDouble();
        double y = readBuffer.getDouble();
        double z = readBuffer.getDouble();
        return new Quaterniond(x, y, z, w);
    }
}

