/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api_krunch.KrunchBinariesNotLoadedException;
import org.valkyrienskies.physics_api_krunch.KrunchNativePhysicsWorldReference;
import org.valkyrienskies.physics_api_krunch.KrunchPhysicsWorldSettingsc;
import org.valkyrienskies.physics_api_krunch.shared_library_loader.KrunchPhysicsAPISharedLibraryLoader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0007J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/physics_api_krunch/KrunchBootstrap;", "", "Lorg/valkyrienskies/physics_api/PhysicsWorldReference;", "createKrunchPhysicsWorld", "()Lorg/valkyrienskies/physics_api/PhysicsWorldReference;", "", "loadNativeBinaries", "()V", "", "krunchPath", "loadNativeBinariesTesting", "(Ljava/lang/String;)V", "physicsWorldReference", "Lorg/valkyrienskies/physics_api_krunch/KrunchPhysicsWorldSettingsc;", "settingsWrapper", "setKrunchSettings", "(Lorg/valkyrienskies/physics_api/PhysicsWorldReference;Lorg/valkyrienskies/physics_api_krunch/KrunchPhysicsWorldSettingsc;)V", "", "areKrunchLibsLoaded", "Z", "<init>", "physics_api_krunch"})
public final class KrunchBootstrap {
    @NotNull
    public static final KrunchBootstrap INSTANCE = new KrunchBootstrap();
    private static boolean areKrunchLibsLoaded;

    private KrunchBootstrap() {
    }

    @NotNull
    public final PhysicsWorldReference createKrunchPhysicsWorld() throws KrunchBinariesNotLoadedException {
        if (!areKrunchLibsLoaded) {
            throw new KrunchBinariesNotLoadedException();
        }
        return new KrunchNativePhysicsWorldReference();
    }

    public final void setKrunchSettings(@NotNull PhysicsWorldReference physicsWorldReference, @NotNull KrunchPhysicsWorldSettingsc settingsWrapper) {
        Intrinsics.checkNotNullParameter((Object)physicsWorldReference, (String)"physicsWorldReference");
        Intrinsics.checkNotNullParameter((Object)settingsWrapper, (String)"settingsWrapper");
        KrunchNativePhysicsWorldReference cfr_ignored_0 = (KrunchNativePhysicsWorldReference)physicsWorldReference;
        ((KrunchNativePhysicsWorldReference)physicsWorldReference).setSettings(settingsWrapper);
    }

    public final void loadNativeBinaries() {
        if (areKrunchLibsLoaded) {
            return;
        }
        KrunchPhysicsAPISharedLibraryLoader nativeLoader = new KrunchPhysicsAPISharedLibraryLoader();
        String libraryName = "KrunchJni";
        nativeLoader.load(libraryName);
        areKrunchLibsLoaded = true;
    }

    public final void loadNativeBinariesTesting(@NotNull String krunchPath) {
        Intrinsics.checkNotNullParameter((Object)krunchPath, (String)"krunchPath");
        if (areKrunchLibsLoaded) {
            return;
        }
        System.loadLibrary(krunchPath);
        areKrunchLibsLoaded = true;
    }
}

