/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBi;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.RigidBodyInertiaData;
import org.valkyrienskies.physics_api.RigidBodyReference;
import org.valkyrienskies.physics_api.SegmentDisplacement;
import org.valkyrienskies.physics_api.SegmentTracker;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api_krunch.KrunchNativePhysicsWorldReference;
import org.valkyrienskies.physics_api_krunch.PoseVelEncoder;
import org.valkyrienskies.physics_api_krunch.RigidBodyInertiaDataEncoder;
import org.valkyrienskies.physics_api_krunch.SegmentDisplacementEncoder;
import org.valkyrienskies.physics_api_krunch.SegmentTrackerEncoder;

class KrunchNativeRigidBodyReference
implements RigidBodyReference {
    private static final int DEFAULT_CACHED_RIGID_BODY_INDEX_IN_PHYSICS_WORLD = 0;
    private static final int DELETED_CACHED_RIGID_BODY_INDEX_IN_PHYSICS_WORLD = -1;
    private final KrunchNativePhysicsWorldReference physicsWorldReference;
    private final int rigidBodyUniqueId;
    private int cachedRigidBodyIndex;
    public static final int VOXEL_STATE_RIGID_BODY_NOT_VOXEL = -1;
    public static final int VOXEL_STATE_UNLOADED = -2;

    protected KrunchNativeRigidBodyReference(KrunchNativePhysicsWorldReference physicsWorldReference, int rigidBodyUniqueId) {
        this.physicsWorldReference = physicsWorldReference;
        this.rigidBodyUniqueId = rigidBodyUniqueId;
        this.cachedRigidBodyIndex = 0;
    }

    @Override
    public int getRigidBodyId() {
        return this.rigidBodyUniqueId;
    }

    @Override
    @NotNull
    public PoseVel getPoseVel() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        byte[] encoded = new byte[104];
        KrunchNativeRigidBodyReference.getPoseVel(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, encoded);
        return PoseVelEncoder.decodePoseVel(encoded);
    }

    @Override
    public void setPoseVel(@NotNull PoseVel poseVel) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        byte[] encoded = PoseVelEncoder.encodePoseVel(poseVel);
        KrunchNativeRigidBodyReference.setPoseVel(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, encoded);
    }

    @Override
    @NotNull
    public SegmentTracker getSegmentTracker() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        int segmentTrackerSize = KrunchNativeRigidBodyReference.getSegmentTrackerSize(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
        byte[] segmentTrackerEncoded = new byte[segmentTrackerSize];
        boolean success = KrunchNativeRigidBodyReference.getSegmentTracker(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, segmentTrackerEncoded);
        if (!success) {
            throw new IllegalStateException("Failed to get segment tracker from Krunch!");
        }
        return SegmentTrackerEncoder.decodeSegmentTracker(segmentTrackerEncoded);
    }

    @Override
    public boolean setSegmentDisplacement(int segmentId, @NotNull SegmentDisplacement segmentDisplacement) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        byte[] encoded = SegmentDisplacementEncoder.encodeSegmentDisplacement(segmentDisplacement);
        return KrunchNativeRigidBodyReference.setSegmentDisplacement(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, segmentId, encoded);
    }

    @Override
    public double getDynamicFrictionCoefficient() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getDynamicFrictionCoefficient(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setDynamicFrictionCoefficient(double coefficient) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setDynamicFrictionCoefficient(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, coefficient);
    }

    @Override
    public boolean isStatic() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getIsStatic(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setStatic(boolean isStatic) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setStatic(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, isStatic);
    }

    @Override
    public double getRestitutionCoefficient() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getRestitutionCoefficient(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setRestitutionCoefficient(double coefficient) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setRestitutionCoefficient(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, coefficient);
    }

    @Override
    public double getStaticFrictionCoefficient() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getStaticFrictionCoefficient(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setStaticFrictionCoefficient(double coefficient) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setStaticFrictionCoefficient(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, coefficient);
    }

    @Override
    @NotNull
    public Vector3dc getCollisionShapeOffset() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getCollisionShapeOffset(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setCollisionShapeOffset(@NotNull Vector3dc offset) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setCollisionShapeOffset(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, offset.x(), offset.y(), offset.z());
    }

    @Override
    public boolean isVoxelTerrainFullyLoaded() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getIsVoxelTerrainFullyLoaded(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setVoxelTerrainFullyLoaded(boolean isVoxelTerrainFullyLoaded) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setIsVoxelTerrainFullyLoaded(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, isVoxelTerrainFullyLoaded);
    }

    @Override
    public double getBuoyantFactor() {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getBuoyancyFactor(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setBuoyantFactor(double buoyantFactor) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setBuoyancyFactor(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, buoyantFactor);
    }

    @Override
    @NotNull
    public RigidBodyInertiaData getInertiaData() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        byte[] encoded = new byte[80];
        KrunchNativeRigidBodyReference.getInertiaData(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, encoded);
        return RigidBodyInertiaDataEncoder.decodeRigidBodyInertiaData(encoded);
    }

    @Override
    public void setInertiaData(@NotNull RigidBodyInertiaData rigidBodyInertiaData) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        byte[] encoded = RigidBodyInertiaDataEncoder.encodeRigidBodyInertiaData(rigidBodyInertiaData);
        KrunchNativeRigidBodyReference.setInertiaData(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, encoded);
    }

    @Override
    public double getCollisionShapeScaling() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getCollisionShapeScaling(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setCollisionShapeScaling(double scaling) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setCollisionShapeScaling(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, scaling);
    }

    private void updateCachedIndexAndEnsureReferenceNotDeleted() throws UsingDeletedReferenceException {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("The underlying rigid body has been deleted!");
        }
    }

    @Override
    public boolean hasBeenDeleted() {
        this.updateCachedIndex();
        return this.getCachedHasBeenDeleted();
    }

    private void updateCachedIndex() {
        if (this.getCachedHasBeenDeleted()) {
            return;
        }
        this.cachedRigidBodyIndex = this.physicsWorldReference.hasBeenDeleted() ? -1 : KrunchNativeRigidBodyReference.getCachedRigidBodyIndex(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    private boolean getCachedHasBeenDeleted() {
        return this.cachedRigidBodyIndex == -1;
    }

    @Override
    @NotNull
    public PhysicsWorldReference getPhysicsWorldReference() {
        return this.physicsWorldReference;
    }

    @Override
    public void addInvariantForceAtPosToNextPhysTick(@NotNull Vector3dc forcePosInLocal, @NotNull Vector3dc invariantForce) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.addInvariantForceAtPosToNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, forcePosInLocal.x(), forcePosInLocal.y(), forcePosInLocal.z(), invariantForce.x(), invariantForce.y(), invariantForce.z());
    }

    @Override
    public void addInvariantForceToNextPhysTick(@NotNull Vector3dc invariantForce) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.addInvariantForceToNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, invariantForce.x(), invariantForce.y(), invariantForce.z());
    }

    @Override
    public void addInvariantTorqueToNextPhysTick(@NotNull Vector3dc invariantTorque) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.addInvariantTorqueToNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, invariantTorque.x(), invariantTorque.y(), invariantTorque.z());
    }

    @Override
    public void addRotDependentForceToNextPhysTick(@NotNull Vector3dc rotDepForce) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.addRotDependentForceToNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, rotDepForce.x(), rotDepForce.y(), rotDepForce.z());
    }

    @Override
    public void addRotDependentTorqueToNextPhysTick(@NotNull Vector3dc rotDepTorque) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.addRotDependentTorqueToNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, rotDepTorque.x(), rotDepTorque.y(), rotDepTorque.z());
    }

    @Override
    public boolean getAABB(@NotNull AABBd outputBB) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        double[] output = new double[6];
        boolean success = KrunchNativeRigidBodyReference.getAABB(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        if (!success) {
            return false;
        }
        outputBB.minX = output[0];
        outputBB.minY = output[1];
        outputBB.minZ = output[2];
        outputBB.maxX = output[3];
        outputBB.maxY = output[4];
        outputBB.maxZ = output[5];
        return true;
    }

    @Override
    public boolean getVoxelShapeAABB(@NotNull AABBi outputBB) {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        int[] output = new int[6];
        boolean success = KrunchNativeRigidBodyReference.getVoxelShapeAABB(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        if (!success) {
            return false;
        }
        outputBB.minX = output[0];
        outputBB.minY = output[1];
        outputBB.minZ = output[2];
        outputBB.maxX = output[3];
        outputBB.maxY = output[4];
        outputBB.maxZ = output[5];
        return true;
    }

    @Override
    public boolean getDoFluidDrag() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getDoFluidDrag(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setDoFluidDrag(boolean doFluidDrag) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setDoFluidDrag(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, doFluidDrag);
    }

    @Override
    public int getCollisionMask() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getCollisionMask(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    @Override
    public void setCollisionMask(int collisionMask) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        KrunchNativeRigidBodyReference.setCollisionMask(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, collisionMask);
    }

    protected Vector3dc getTotalInvariantForceNextPhysTick() {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        double[] output = new double[3];
        KrunchNativeRigidBodyReference.getTotalInvariantForcesNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        return new Vector3d(output[0], output[1], output[2]);
    }

    protected Vector3dc getTotalInvariantTorqueNextPhysTick() {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        double[] output = new double[3];
        KrunchNativeRigidBodyReference.getTotalInvariantTorquesNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        return new Vector3d(output[0], output[1], output[2]);
    }

    protected Vector3dc getTotalRotDependentForceNextPhysTick() {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        double[] output = new double[3];
        KrunchNativeRigidBodyReference.getTotalRotDependentForcesNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        return new Vector3d(output[0], output[1], output[2]);
    }

    protected Vector3dc getTotalRotDependentTorqueNextPhysTick() {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        double[] output = new double[3];
        KrunchNativeRigidBodyReference.getTotalRotDependentTorquesNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        return new Vector3d(output[0], output[1], output[2]);
    }

    protected List<Pair<Vector3dc, Vector3dc>> getInvariantForcesAtPosNextPhysTick() {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        int invariantForcesCount = KrunchNativeRigidBodyReference.getInvariantForcesAtPosNextPhysTickCount(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
        double[] output = new double[invariantForcesCount * 6];
        KrunchNativeRigidBodyReference.getInvariantForcesAtPosNextPhysTick(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, output);
        ArrayList<Pair<Vector3dc, Vector3dc>> toReturn = new ArrayList<Pair<Vector3dc, Vector3dc>>();
        for (int i = 0; i < invariantForcesCount; ++i) {
            int baseIndex = i * 6;
            Vector3d forcePosInLocal = new Vector3d(output[baseIndex], output[baseIndex + 1], output[baseIndex + 2]);
            Vector3d invariantForce = new Vector3d(output[baseIndex + 3], output[baseIndex + 4], output[baseIndex + 5]);
            toReturn.add((Pair<Vector3dc, Vector3dc>)new Pair((Object)forcePosInLocal, (Object)invariantForce));
        }
        return toReturn;
    }

    protected int getVoxelState(int posX, int posY, int posZ) throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        return KrunchNativeRigidBodyReference.getVoxelState(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, posX, posY, posZ);
    }

    protected List<Vector3ic> getSolidSetVoxels() throws UsingDeletedReferenceException {
        this.updateCachedIndexAndEnsureReferenceNotDeleted();
        int voxelsSize = KrunchNativeRigidBodyReference.getSolidSetVoxelsSize(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
        int[] setVoxels = new int[voxelsSize * 3];
        KrunchNativeRigidBodyReference.getSolidSetVoxels(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex, setVoxels);
        ArrayList<Vector3ic> toReturn = new ArrayList<Vector3ic>(voxelsSize);
        for (int i = 0; i < voxelsSize; ++i) {
            toReturn.add(new Vector3i(setVoxels[i * 3], setVoxels[i * 3 + 1], setVoxels[i * 3 + 2]));
        }
        return toReturn;
    }

    protected boolean isStaticUnsafe() throws IllegalArgumentException {
        return KrunchNativeRigidBodyReference.getIsStatic(this.physicsWorldReference.getPhysicsWorldPointer(), this.rigidBodyUniqueId, this.cachedRigidBodyIndex);
    }

    private static native int getCachedRigidBodyIndex(long var0, int var2, int var3);

    private static native void getPoseVel(long var0, int var2, int var3, @NotNull byte[] var4);

    private static native void setPoseVel(long var0, int var2, int var3, @NotNull byte[] var4);

    private static native int getSegmentTrackerSize(long var0, int var2, int var3);

    private static native boolean getSegmentTracker(long var0, int var2, int var3, @NotNull byte[] var4);

    private static native boolean setSegmentDisplacement(long var0, int var2, int var3, int var4, @NotNull byte[] var5);

    private static native double getDynamicFrictionCoefficient(long var0, int var2, int var3);

    private static native void setDynamicFrictionCoefficient(long var0, int var2, int var3, double var4);

    private static native boolean getIsStatic(long var0, int var2, int var3);

    private static native void setStatic(long var0, int var2, int var3, boolean var4);

    private static native double getRestitutionCoefficient(long var0, int var2, int var3);

    private static native void setRestitutionCoefficient(long var0, int var2, int var3, double var4);

    private static native double getStaticFrictionCoefficient(long var0, int var2, int var3);

    private static native void setStaticFrictionCoefficient(long var0, int var2, int var3, double var4);

    private static native Vector3dc getCollisionShapeOffset(long var0, int var2, int var3);

    private static native void setCollisionShapeOffset(long var0, int var2, int var3, double var4, double var6, double var8);

    private static native boolean getIsVoxelTerrainFullyLoaded(long var0, int var2, int var3);

    private static native void setIsVoxelTerrainFullyLoaded(long var0, int var2, int var3, boolean var4);

    private static native double getBuoyancyFactor(long var0, int var2, int var3);

    private static native void setBuoyancyFactor(long var0, int var2, int var3, double var4);

    private static native void getInertiaData(long var0, int var2, int var3, @NotNull byte[] var4);

    private static native void setInertiaData(long var0, int var2, int var3, @NotNull byte[] var4);

    private static native double getCollisionShapeScaling(long var0, int var2, int var3);

    private static native void setCollisionShapeScaling(long var0, int var2, int var3, double var4);

    private static native void addInvariantForceAtPosToNextPhysTick(long var0, int var2, int var3, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native void addInvariantForceToNextPhysTick(long var0, int var2, int var3, double var4, double var6, double var8);

    private static native void addInvariantTorqueToNextPhysTick(long var0, int var2, int var3, double var4, double var6, double var8);

    private static native void addRotDependentForceToNextPhysTick(long var0, int var2, int var3, double var4, double var6, double var8);

    private static native void addRotDependentTorqueToNextPhysTick(long var0, int var2, int var3, double var4, double var6, double var8);

    private static native boolean getVoxelShapeAABB(long var0, int var2, int var3, @NotNull int[] var4);

    private static native boolean getAABB(long var0, int var2, int var3, @NotNull double[] var4);

    private static native int getVoxelState(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int getSolidSetVoxelsSize(long var0, int var2, int var3);

    private static native void getSolidSetVoxels(long var0, int var2, int var3, @NotNull int[] var4);

    private static native void getTotalInvariantForcesNextPhysTick(long var0, int var2, int var3, @NotNull double[] var4);

    private static native void getTotalInvariantTorquesNextPhysTick(long var0, int var2, int var3, @NotNull double[] var4);

    private static native void getTotalRotDependentForcesNextPhysTick(long var0, int var2, int var3, @NotNull double[] var4);

    private static native void getTotalRotDependentTorquesNextPhysTick(long var0, int var2, int var3, @NotNull double[] var4);

    private static native int getInvariantForcesAtPosNextPhysTickCount(long var0, int var2, int var3);

    private static native void getInvariantForcesAtPosNextPhysTick(long var0, int var2, int var3, @NotNull double[] var4);

    private static native boolean getDoFluidDrag(long var0, int var2, int var3);

    private static native void setDoFluidDrag(long var0, int var2, int var3, boolean var4);

    private static native void setCollisionMask(long var0, int var2, int var3, int var4);

    private static native int getCollisionMask(long var0, int var2, int var3);
}

