/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.SegmentDisplacement;
import org.valkyrienskies.physics_api_krunch.PoseVelEncoder;

public class SegmentDisplacementEncoder {
    private static final int SEGMENT_DISPLACEMENT_SIZE = 116;

    public static void encodeSegmentDisplacementToByteBuf(@NotNull SegmentDisplacement segmentDisplacement, @NotNull ByteBuffer outputBuffer) {
        outputBuffer.putInt(segmentDisplacement.getDimension());
        outputBuffer.putDouble(segmentDisplacement.getScaling());
        PoseVel poseVel = segmentDisplacement.getPoseVelForInternalUseOnly();
        PoseVelEncoder.encodePoseVelToByteBuf(poseVel, outputBuffer);
    }

    @NotNull
    public static byte[] encodeSegmentDisplacement(@NotNull SegmentDisplacement segmentDisplacement) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(116);
        outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        SegmentDisplacementEncoder.encodeSegmentDisplacementToByteBuf(segmentDisplacement, outputBuffer);
        return outputBuffer.array();
    }

    @NotNull
    public static SegmentDisplacement decodeSegmentDisplacementToByteBuf(@NotNull ByteBuffer byteBuffer) {
        int dimension = byteBuffer.getInt();
        double scaling = byteBuffer.getDouble();
        PoseVel poseVel = PoseVelEncoder.decodePoseVelFromByteBuf(byteBuffer);
        return new SegmentDisplacement(poseVel, scaling, dimension);
    }

    @NotNull
    public static SegmentDisplacement decodeSegmentDisplacement(@NotNull byte[] encoded) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return SegmentDisplacementEncoder.decodeSegmentDisplacementToByteBuf(byteBuffer);
    }
}

