/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.Segment;
import org.valkyrienskies.physics_api.SegmentDisplacement;
import org.valkyrienskies.physics_api.SegmentTracker;
import org.valkyrienskies.physics_api_krunch.KrunchSegmentTracker;
import org.valkyrienskies.physics_api_krunch.PoseVelEncoder;

public class SegmentTrackerEncoder {
    private static final int SEGMENT_SIZE = 120;

    @NotNull
    public static SegmentTracker decodeSegmentTracker(@NotNull ByteBuffer byteBuffer) {
        int segmentsCount = byteBuffer.getInt();
        HashMap<Integer, Segment> segments = new HashMap<Integer, Segment>();
        for (int i = 0; i < segmentsCount; ++i) {
            int segmentId = byteBuffer.getInt();
            int dimension = byteBuffer.getInt();
            double scaling = byteBuffer.getDouble();
            PoseVel poseVel = PoseVelEncoder.decodePoseVelFromByteBuf(byteBuffer);
            Segment segment = new Segment(segmentId, new SegmentDisplacement(poseVel, scaling, dimension));
            segments.put(segmentId, segment);
        }
        return new KrunchSegmentTracker(segments);
    }

    @NotNull
    public static SegmentTracker decodeSegmentTracker(@NotNull byte[] encoded) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return SegmentTrackerEncoder.decodeSegmentTracker(byteBuffer);
    }
}

