/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.voxel_updates.DeleteVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.DenseVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.EmptyVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.IVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.SparseVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.VoxelRigidBodyShapeUpdates;

public class VoxelRigidBodyShapeUpdatesEncoder {
    private static int getVoxelShapeUpdateSize(@NotNull IVoxelShapeUpdate voxelShapeUpdate) {
        if (voxelShapeUpdate instanceof EmptyVoxelShapeUpdate) {
            return 16;
        }
        if (voxelShapeUpdate instanceof DenseVoxelShapeUpdate) {
            return 4112;
        }
        if (voxelShapeUpdate instanceof SparseVoxelShapeUpdate) {
            SparseVoxelShapeUpdate sparseVoxelShapeUpdate = (SparseVoxelShapeUpdate)voxelShapeUpdate;
            return 20 + sparseVoxelShapeUpdate.getUpdatesPositions().size() * 3;
        }
        if (voxelShapeUpdate instanceof DeleteVoxelShapeUpdate) {
            return 16;
        }
        throw new IllegalArgumentException("Unknown update with class type: " + voxelShapeUpdate.getClass());
    }

    private static void writeVoxelRigidBodyShapeUpdatesToByteBuf(@NotNull VoxelRigidBodyShapeUpdates update, @NotNull ByteBuffer outputBuffer) {
        outputBuffer.putInt(update.getRigidBodyId());
        outputBuffer.putInt(update.getShapeUpdates().length);
        for (IVoxelShapeUpdate voxelShapeUpdate : update.getShapeUpdates()) {
            VoxelRigidBodyShapeUpdatesEncoder.writeIVoxelShapeUpdateByteBuf(voxelShapeUpdate, outputBuffer);
        }
    }

    private static void writeIVoxelShapeUpdateByteBuf(@NotNull IVoxelShapeUpdate update, @NotNull ByteBuffer outputBuffer) {
        outputBuffer.putInt(update.getRegionX());
        outputBuffer.putInt(update.getRegionY());
        outputBuffer.putInt(update.getRegionZ());
        if (update instanceof EmptyVoxelShapeUpdate) {
            int fourthInt = 0;
            if (update.getRunImmediately()) {
                fourthInt |= 4;
            }
            if (((EmptyVoxelShapeUpdate)update).getOverwriteExistingVoxels()) {
                fourthInt |= 8;
            }
            outputBuffer.putInt(fourthInt);
        } else if (update instanceof DenseVoxelShapeUpdate) {
            int fourthInt = 1;
            if (update.getRunImmediately()) {
                fourthInt |= 4;
            }
            outputBuffer.putInt(fourthInt);
            outputBuffer.put(((DenseVoxelShapeUpdate)update).getVoxelDataRaw());
        } else if (update instanceof SparseVoxelShapeUpdate) {
            int fourthInt = 2;
            if (update.getRunImmediately()) {
                fourthInt |= 4;
            }
            outputBuffer.putInt(fourthInt);
            SparseVoxelShapeUpdate sparseVoxelShapeUpdate = (SparseVoxelShapeUpdate)update;
            outputBuffer.putInt(sparseVoxelShapeUpdate.getUpdatesPositions().size());
            for (int i = 0; i < sparseVoxelShapeUpdate.getUpdatesPositions().size(); ++i) {
                short singleUpdatePos = sparseVoxelShapeUpdate.getUpdatesPositions().getShort(i);
                byte singleUpdateData = sparseVoxelShapeUpdate.getUpdatesTypes().getByte(i);
                outputBuffer.putShort(singleUpdatePos);
                outputBuffer.put(singleUpdateData);
            }
        } else if (update instanceof DeleteVoxelShapeUpdate) {
            int fourthInt = 3;
            if (update.getRunImmediately()) {
                fourthInt |= 4;
            }
            outputBuffer.putInt(fourthInt);
        } else {
            throw new IllegalArgumentException("Unknown update with class type: " + update.getClass());
        }
    }

    @NotNull
    public static byte[] encodeVoxelRigidBodyShapeUpdatesArray(@NotNull VoxelRigidBodyShapeUpdates[] array) {
        int size = 4;
        for (VoxelRigidBodyShapeUpdates update : array) {
            int extraSize = 8;
            for (IVoxelShapeUpdate voxelShapeUpdate : update.getShapeUpdates()) {
                extraSize += VoxelRigidBodyShapeUpdatesEncoder.getVoxelShapeUpdateSize(voxelShapeUpdate);
            }
            size += extraSize;
        }
        ByteBuffer outputBuffer = ByteBuffer.allocate(size);
        outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        outputBuffer.putInt(array.length);
        for (VoxelRigidBodyShapeUpdates update : array) {
            VoxelRigidBodyShapeUpdatesEncoder.writeVoxelRigidBodyShapeUpdatesToByteBuf(update, outputBuffer);
        }
        return outputBuffer.array();
    }

    public static VoxelRigidBodyShapeUpdates[] decodeVoxelRigidBodyShapeUpdatesArray(@NotNull byte[] encoded) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int arraySize = byteBuffer.getInt();
        VoxelRigidBodyShapeUpdates[] toReturn = new VoxelRigidBodyShapeUpdates[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            int rigidBodyId = byteBuffer.getInt();
            int updatesArraySize = byteBuffer.getInt();
            IVoxelShapeUpdate[] updatesArray = new IVoxelShapeUpdate[updatesArraySize];
            block7: for (int j = 0; j < updatesArraySize; ++j) {
                int regionX = byteBuffer.getInt();
                int regionY = byteBuffer.getInt();
                int regionZ = byteBuffer.getInt();
                int fourthInt = byteBuffer.getInt();
                boolean updateImmediately = (fourthInt & 4) != 0;
                int updateType = fourthInt & 3;
                switch (updateType) {
                    case 0: {
                        boolean overwriteExistingVoxels = (fourthInt & 8) != 0;
                        updatesArray[j] = new EmptyVoxelShapeUpdate(regionX, regionY, regionZ, updateImmediately, overwriteExistingVoxels);
                        continue block7;
                    }
                    case 1: {
                        byte[] voxelDataRaw = new byte[4096];
                        VoxelRigidBodyShapeUpdatesEncoder.copyFromByteBufferToByteArray(byteBuffer, voxelDataRaw, 4096);
                        updatesArray[j] = new DenseVoxelShapeUpdate(regionX, regionY, regionZ, updateImmediately, voxelDataRaw);
                        continue block7;
                    }
                    case 2: {
                        SparseVoxelShapeUpdate sparseVoxelShapeUpdate = new SparseVoxelShapeUpdate(regionX, regionY, regionZ, updateImmediately);
                        int sparseUpdatesSize = byteBuffer.getInt();
                        for (int k = 0; k < sparseUpdatesSize; ++k) {
                            short sparseUpdateAsShort = byteBuffer.getShort();
                            int posX = sparseUpdateAsShort & 0xF;
                            int posY = sparseUpdateAsShort >> 8 & 0xF;
                            int posZ = sparseUpdateAsShort >> 4 & 0xF;
                            byte voxelData = byteBuffer.get();
                            sparseVoxelShapeUpdate.addUpdate(posX, posY, posZ, voxelData);
                        }
                        updatesArray[j] = sparseVoxelShapeUpdate;
                        continue block7;
                    }
                    case 3: {
                        DeleteVoxelShapeUpdate deleteVoxelShapeUpdate = new DeleteVoxelShapeUpdate(regionX, regionY, regionZ, updateImmediately);
                        updatesArray[j] = deleteVoxelShapeUpdate;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown update encoded type: " + updateType);
                    }
                }
            }
            toReturn[i] = new VoxelRigidBodyShapeUpdates(rigidBodyId, updatesArray);
        }
        return toReturn;
    }

    private static void copyFromByteBufferToByteArray(ByteBuffer src, byte[] dest, int bytesToCopy) {
        int oldPosition = src.position();
        byte[] backingArray = src.array();
        System.arraycopy(backingArray, oldPosition, dest, 0, bytesToCopy);
        src.position(oldPosition + bytesToCopy);
    }
}

