/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_7923;

public enum ContraptionMovementSetting {
    MOVABLE,
    NO_PICKUP,
    UNMOVABLE;

    private static final AttachedRegistry<class_2248, Supplier<ContraptionMovementSetting>> SETTING_SUPPLIERS;

    public static void register(class_2960 block, Supplier<ContraptionMovementSetting> settingSupplier) {
        SETTING_SUPPLIERS.register((class_2248)block, settingSupplier);
    }

    public static void register(class_2248 block, Supplier<ContraptionMovementSetting> settingSupplier) {
        SETTING_SUPPLIERS.register(block, settingSupplier);
    }

    @Nullable
    public static ContraptionMovementSetting get(class_2248 block) {
        if (block instanceof IMovementSettingProvider) {
            IMovementSettingProvider provider = (IMovementSettingProvider)block;
            return provider.getContraptionMovementSetting();
        }
        Supplier<ContraptionMovementSetting> supplier = SETTING_SUPPLIERS.get(block);
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    public static boolean allAre(Collection<class_3499.class_3501> blocks, ContraptionMovementSetting are) {
        return blocks.stream().anyMatch(b -> ContraptionMovementSetting.get(b.comp_1342().method_26204()) == are);
    }

    public static boolean isNoPickup(Collection<class_3499.class_3501> blocks) {
        return ContraptionMovementSetting.allAre(blocks, NO_PICKUP);
    }

    public static void registerDefaults() {
        ContraptionMovementSetting.register(class_2246.field_10260, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.server().kinetics.spawnerMovement.get())));
        ContraptionMovementSetting.register(class_2246.field_27160, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.server().kinetics.amethystMovement.get())));
        ContraptionMovementSetting.register(class_2246.field_10540, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.server().kinetics.obsidianMovement.get())));
        ContraptionMovementSetting.register(class_2246.field_22423, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.server().kinetics.obsidianMovement.get())));
        ContraptionMovementSetting.register(class_2246.field_23152, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.server().kinetics.obsidianMovement.get())));
        ContraptionMovementSetting.register(class_2246.field_38420, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.server().kinetics.reinforcedDeepslateMovement.get())));
    }

    static {
        SETTING_SUPPLIERS = new AttachedRegistry(class_7923.field_41175);
    }

    public static interface IMovementSettingProvider {
        public ContraptionMovementSetting getContraptionMovementSetting();
    }
}

