/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.sync.ContraptionFluidPacket;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class MountedFluidStorage {
    SmartFluidTank tank;
    private boolean valid;
    private class_2586 blockEntity;
    private int packetCooldown = 0;
    private boolean sendPacket = false;

    public static boolean canUseAsStorage(class_2586 be) {
        if (be instanceof FluidTankBlockEntity) {
            return ((FluidTankBlockEntity)be).isController();
        }
        return false;
    }

    public MountedFluidStorage(class_2586 be) {
        this.assignBlockEntity(be);
    }

    public void assignBlockEntity(class_2586 be) {
        this.blockEntity = be;
        this.tank = this.createMountedTank(be);
    }

    private SmartFluidTank createMountedTank(class_2586 be) {
        if (be instanceof CreativeFluidTankBlockEntity) {
            return new CreativeFluidTankBlockEntity.CreativeSmartFluidTank((long)((FluidTankBlockEntity)be).getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier(), $ -> {});
        }
        if (be instanceof FluidTankBlockEntity) {
            return new SmartFluidTank((long)((FluidTankBlockEntity)be).getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
        }
        return null;
    }

    public void tick(class_1297 entity, class_2338 pos, boolean isRemote) {
        if (!isRemote) {
            if (this.packetCooldown > 0) {
                --this.packetCooldown;
            } else if (this.sendPacket) {
                this.sendPacket = false;
                AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionFluidPacket(entity.method_5628(), pos, this.tank.getFluid()), entity);
                this.packetCooldown = 8;
            }
            return;
        }
        if (!(this.blockEntity instanceof FluidTankBlockEntity)) {
            return;
        }
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.blockEntity;
        tank.getFluidLevel().tickChaser();
    }

    public void updateFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
        if (!(this.blockEntity instanceof FluidTankBlockEntity)) {
            return;
        }
        float fillState = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.blockEntity;
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue(fillState));
        }
        tank.getFluidLevel().chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        FluidTank tankInventory = tank.getTankInventory();
        if (tankInventory instanceof SmartFluidTank) {
            ((SmartFluidTank)tankInventory).setFluid(fluid);
        }
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.blockEntity == null) {
            return;
        }
        Storage teHandler = TransferUtil.getFluidStorage((class_2586)this.blockEntity);
        if (!(teHandler instanceof SmartFluidTank)) {
            return;
        }
        SmartFluidTank smartTank = (SmartFluidTank)teHandler;
        this.tank.setFluid(smartTank.getFluid());
        this.sendPacket = false;
        this.valid = true;
    }

    private void onFluidStackChanged(FluidStack fs) {
        this.sendPacket = true;
    }

    public void addStorageToWorld(class_2586 be) {
        if (this.tank instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
            return;
        }
        Storage teHandler = TransferUtil.getFluidStorage((class_2586)be);
        if (!(teHandler instanceof SmartFluidTank)) {
            return;
        }
        SmartFluidTank inv = (SmartFluidTank)teHandler;
        inv.setFluid(this.tank.getFluid().copy());
    }

    public SmartFluidTank getFluidHandler() {
        return this.tank;
    }

    public class_2487 serialize() {
        if (!this.valid) {
            return null;
        }
        class_2487 tag = this.tank.writeToNBT(new class_2487());
        tag.method_10544("Capacity", this.tank.getCapacity());
        if (this.tank instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
            NBTHelper.putMarker(tag, "Bottomless");
            tag.method_10566("ProvidedStack", (class_2520)this.tank.getFluid().writeToNBT(new class_2487()));
        }
        return tag;
    }

    public static MountedFluidStorage deserialize(class_2487 nbt) {
        MountedFluidStorage storage = new MountedFluidStorage(null);
        if (nbt == null) {
            return storage;
        }
        int capacity = nbt.method_10550("Capacity");
        storage.tank = new SmartFluidTank(capacity, storage::onFluidStackChanged);
        storage.valid = true;
        if (nbt.method_10545("Bottomless")) {
            FluidStack providedStack = FluidStack.loadFluidStackFromNBT((class_2487)nbt.method_10562("ProvidedStack"));
            CreativeFluidTankBlockEntity.CreativeSmartFluidTank creativeSmartFluidTank = new CreativeFluidTankBlockEntity.CreativeSmartFluidTank(capacity, $ -> {});
            creativeSmartFluidTank.setContainedFluid(providedStack);
            storage.tank = creativeSmartFluidTank;
            return storage;
        }
        storage.tank.readFromNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }
}

