/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedFluidStorage;
import com.simibubi.create.content.contraptions.MountedStorage;
import com.simibubi.create.content.contraptions.MountedStorageInteraction;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_5250;

public class MountedStorageManager {
    protected Contraption.ContraptionInvWrapper inventory;
    protected Contraption.ContraptionInvWrapper fuelInventory;
    protected CombinedTankWrapper fluidInventory;
    protected Map<class_2338, MountedStorage> storage = new HashMap<class_2338, MountedStorage>();
    protected Map<class_2338, MountedFluidStorage> fluidStorage = new HashMap<class_2338, MountedFluidStorage>();

    public void entityTick(AbstractContraptionEntity entity) {
        this.fluidStorage.forEach((pos, mfs) -> mfs.tick(entity, (class_2338)pos, entity.method_37908().field_9236));
    }

    public void createHandlers() {
        Collection<MountedStorage> itemHandlers = this.storage.values();
        this.inventory = this.wrapItems(itemHandlers.stream().filter(MountedStorage::isValid).map(MountedStorage::getItemHandler).toList(), false);
        this.fuelInventory = this.wrapItems(itemHandlers.stream().filter(MountedStorage::canUseForFuel).map(MountedStorage::getItemHandler).toList(), true);
        this.fluidInventory = this.wrapFluids(this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).collect(Collectors.toList()));
    }

    protected Contraption.ContraptionInvWrapper wrapItems(Collection<? extends Storage<ItemVariant>> list, boolean fuel) {
        return new Contraption.ContraptionInvWrapper((Storage[])Arrays.copyOf(list.toArray(), list.size(), Storage[].class));
    }

    protected CombinedTankWrapper wrapFluids(Collection<? extends Storage<FluidVariant>> list) {
        return new CombinedTankWrapper((Storage[])Arrays.copyOf(list.toArray(), list.size(), Storage[].class));
    }

    public void addBlock(class_2338 localPos, class_2586 be) {
        if (be != null && MountedStorage.canUseAsStorage(be)) {
            this.storage.put(localPos, new MountedStorage(be));
        }
        if (be != null && MountedFluidStorage.canUseAsStorage(be)) {
            this.fluidStorage.put(localPos, new MountedFluidStorage(be));
        }
    }

    public void read(class_2487 nbt, Map<class_2338, class_2586> presentBlockEntities, boolean clientPacket) {
        this.storage.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("Storage", 10), c -> this.storage.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), MountedStorage.deserialize(c.method_10562("Data"))));
        this.fluidStorage.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("FluidStorage", 10), c -> this.fluidStorage.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), MountedFluidStorage.deserialize(c.method_10562("Data"))));
        if (clientPacket && presentBlockEntities != null) {
            this.bindTanks(presentBlockEntities);
        }
        ArrayList<ItemStackHandler> handlers = new ArrayList<ItemStackHandler>();
        ArrayList<ItemStackHandler> fuelHandlers = new ArrayList<ItemStackHandler>();
        for (MountedStorage mountedStorage : this.storage.values()) {
            ItemStackHandler itemHandler = mountedStorage.getItemHandler();
            handlers.add(itemHandler);
            if (!mountedStorage.canUseForFuel()) continue;
            fuelHandlers.add(itemHandler);
        }
        this.inventory = this.wrapItems(handlers, false);
        this.fuelInventory = this.wrapItems(fuelHandlers, true);
        this.fluidInventory = this.wrapFluids(this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).map(tank -> tank).toList());
    }

    public void bindTanks(Map<class_2338, class_2586> presentBlockEntities) {
        this.fluidStorage.forEach((pos, mfs) -> {
            class_2586 blockEntity = (class_2586)presentBlockEntities.get(pos);
            if (!(blockEntity instanceof FluidTankBlockEntity)) {
                return;
            }
            FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
            FluidTank tankInventory = tank.getTankInventory();
            if (tankInventory instanceof FluidTank) {
                tankInventory.setFluid(mfs.tank.getFluid());
            }
            tank.getFluidLevel().startWithValue(tank.getFillState());
            mfs.assignBlockEntity(tank);
        });
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        class_2499 storageNBT = new class_2499();
        if (!clientPacket) {
            for (class_2338 pos : this.storage.keySet()) {
                class_2487 c = new class_2487();
                MountedStorage mountedStorage = this.storage.get(pos);
                if (!mountedStorage.isValid()) continue;
                c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)pos));
                c.method_10566("Data", (class_2520)mountedStorage.serialize());
                storageNBT.add((Object)c);
            }
        }
        class_2499 fluidStorageNBT = new class_2499();
        for (class_2338 pos : this.fluidStorage.keySet()) {
            class_2487 c = new class_2487();
            MountedFluidStorage mountedStorage = this.fluidStorage.get(pos);
            if (!mountedStorage.isValid()) continue;
            c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)pos));
            c.method_10566("Data", (class_2520)mountedStorage.serialize());
            fluidStorageNBT.add((Object)c);
        }
        nbt.method_10566("Storage", (class_2520)storageNBT);
        nbt.method_10566("FluidStorage", (class_2520)fluidStorageNBT);
    }

    public void removeStorageFromWorld() {
        this.storage.values().forEach(MountedStorage::removeStorageFromWorld);
        this.fluidStorage.values().forEach(MountedFluidStorage::removeStorageFromWorld);
    }

    public void addStorageToWorld(class_3499.class_3501 block, class_2586 blockEntity) {
        Object mountedStorage;
        if (this.storage.containsKey(block.comp_1341()) && ((MountedStorage)(mountedStorage = this.storage.get(block.comp_1341()))).isValid()) {
            ((MountedStorage)mountedStorage).addStorageToWorld(blockEntity);
        }
        if (this.fluidStorage.containsKey(block.comp_1341()) && ((MountedFluidStorage)(mountedStorage = this.fluidStorage.get(block.comp_1341()))).isValid()) {
            ((MountedFluidStorage)mountedStorage).addStorageToWorld(blockEntity);
        }
    }

    public void clear() {
        for (Storage storage : this.inventory.parts) {
            if (storage instanceof Contraption.ContraptionInvWrapper) {
                Contraption.ContraptionInvWrapper wrapper = (Contraption.ContraptionInvWrapper)storage;
                if (wrapper.isExternal) continue;
            }
            TransferUtil.clearStorage((Storage)storage);
        }
        TransferUtil.clearStorage((Storage)this.fluidInventory);
    }

    public void updateContainedFluid(class_2338 localPos, FluidStack containedFluid) {
        MountedFluidStorage mountedFluidStorage = this.fluidStorage.get(localPos);
        if (mountedFluidStorage != null) {
            mountedFluidStorage.updateFluid(containedFluid);
        }
    }

    public void attachExternal(Storage<ItemVariant> externalStorage) {
        this.inventory = new Contraption.ContraptionInvWrapper(new Storage[]{externalStorage, this.inventory});
        this.fuelInventory = new Contraption.ContraptionInvWrapper(new Storage[]{externalStorage, this.fuelInventory});
    }

    public Contraption.ContraptionInvWrapper getItems() {
        return this.inventory;
    }

    public Contraption.ContraptionInvWrapper getFuelItems() {
        return this.fuelInventory;
    }

    public CombinedTankWrapper getFluids() {
        return this.fluidInventory;
    }

    public boolean handlePlayerStorageInteraction(Contraption contraption, class_1657 player, class_2338 localPos) {
        int slotCount;
        if (player.method_37908().method_8608()) {
            class_2586 localBE = contraption.presentBlockEntities.get(localPos);
            return MountedStorage.canUseAsStorage(localBE);
        }
        MountedStorageManager storageManager = contraption.getStorageForSpawnPacket();
        MountedStorage storage = storageManager.storage.get(localPos);
        if (storage == null || storage.getItemHandler() == null) {
            return false;
        }
        ItemStackHandler primary = storage.getItemHandler();
        ItemStackHandler secondary = null;
        class_3499.class_3501 info = contraption.getBlocks().get(localPos);
        if (info != null && info.comp_1342().method_28498((class_2769)class_2281.field_10770)) {
            MountedStorage storage2;
            class_2350 connectedDirection;
            class_2745 chestType = (class_2745)info.comp_1342().method_11654((class_2769)class_2281.field_10770);
            class_2350 facing = info.comp_1342().method_28500((class_2769)class_2281.field_10768).orElse(class_2350.field_11035);
            class_2350 class_23502 = connectedDirection = chestType == class_2745.field_12574 ? facing.method_10170() : facing.method_10160();
            if (chestType != class_2745.field_12569 && (storage2 = storageManager.storage.get(localPos.method_10093(connectedDirection))) != null && storage2.getItemHandler() != null) {
                secondary = storage2.getItemHandler();
                if (chestType == class_2745.field_12574) {
                    ItemStackHandler temp = primary;
                    primary = secondary;
                    secondary = temp;
                }
            }
        }
        if ((slotCount = primary.getSlotCount() + (secondary == null ? 0 : secondary.getSlotCount())) == 0) {
            return false;
        }
        if (slotCount % 9 != 0) {
            return false;
        }
        Supplier<Boolean> stillValid = () -> contraption.entity.method_5805() && player.method_5707(contraption.entity.toGlobalVector(class_243.method_24953((class_2382)localPos), 0.0f)) < 64.0;
        class_5250 name = info != null ? info.comp_1342().method_26204().method_9518() : Components.literal("Container");
        player.method_17355(MountedStorageInteraction.createMenuProvider((class_2561)name, primary, secondary, slotCount, stillValid));
        class_243 soundPos = contraption.entity.toGlobalVector(class_243.method_24953((class_2382)localPos), 0.0f);
        player.method_37908().method_8396(null, class_2338.method_49638((class_2374)soundPos), class_3417.field_17604, class_3419.field_15245, 0.75f, 1.0f);
        return true;
    }
}

