/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.transfer;

import com.simibubi.create.content.fluids.transfer.FluidManipulationBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LiquidBlockAccessor;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4706;

public class FluidDrainingBehaviour
extends FluidManipulationBehaviour {
    public static final BehaviourType<FluidDrainingBehaviour> TYPE = new BehaviourType();
    class_3611 fluid;
    Set<class_2338> validationSet;
    class_4706<FluidManipulationBehaviour.BlockPosEntry> queue;
    boolean isValid;
    List<FluidManipulationBehaviour.BlockPosEntry> validationFrontier;
    Set<class_2338> validationVisited;
    Set<class_2338> newValidationSet;
    SnapshotParticipant<Data> snapshotParticipant = new SnapshotParticipant<Data>(){

        protected Data createSnapshot() {
            FluidDrainingBehaviour b = FluidDrainingBehaviour.this;
            class_2338 rootPos = b.rootPos == null ? null : b.rootPos.method_10062();
            class_3341 box = b.affectedArea == null ? null : new class_3341(FluidDrainingBehaviour.this.affectedArea.method_35415(), FluidDrainingBehaviour.this.affectedArea.method_35416(), FluidDrainingBehaviour.this.affectedArea.method_35417(), FluidDrainingBehaviour.this.affectedArea.method_35418(), FluidDrainingBehaviour.this.affectedArea.method_35419(), FluidDrainingBehaviour.this.affectedArea.method_35420());
            return new Data(FluidDrainingBehaviour.this.fluid, FluidDrainingBehaviour.this.isValid, rootPos, new ArrayList<FluidManipulationBehaviour.BlockPosEntry>(FluidDrainingBehaviour.this.validationFrontier), new HashSet<class_2338>(FluidDrainingBehaviour.this.validationVisited), new HashSet<class_2338>(FluidDrainingBehaviour.this.newValidationSet), FluidDrainingBehaviour.this.revalidateIn, box, FluidManipulationBehaviour.copySet(FluidDrainingBehaviour.this.queue));
        }

        protected void readSnapshot(Data snapshot) {
            FluidDrainingBehaviour.this.fluid = snapshot.fluid;
            FluidDrainingBehaviour.this.isValid = snapshot.valid;
            FluidDrainingBehaviour.this.validationFrontier = snapshot.validationFrontier;
            FluidDrainingBehaviour.this.validationVisited = snapshot.validationVisited;
            FluidDrainingBehaviour.this.newValidationSet = snapshot.newValidationSet;
            FluidDrainingBehaviour.this.revalidateIn = snapshot.revalidateIn;
            FluidDrainingBehaviour.this.affectedArea = snapshot.affectedArea;
            FluidDrainingBehaviour.this.rootPos = snapshot.rootPos;
            FluidDrainingBehaviour.this.queue = snapshot.queue;
        }
    };

    @Override
    protected SnapshotParticipant<?> snapshotParticipant() {
        return this.snapshotParticipant;
    }

    public FluidDrainingBehaviour(SmartBlockEntity be) {
        super(be);
        this.validationVisited = new HashSet<class_2338>();
        this.validationFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.validationSet = new HashSet<class_2338>();
        this.newValidationSet = new HashSet<class_2338>();
        this.queue = class_4706.method_34959(this::comparePositions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public boolean pullNext(class_2338 root, TransactionContext ctx) {
        if (!this.frontier.isEmpty()) {
            return false;
        }
        if (!Objects.equals(root, this.rootPos)) {
            this.rebuildContext(root, ctx);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root, ctx);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = class_3341.method_34390((class_2382)root, (class_2382)root);
        }
        class_1937 world = this.getWorld();
        if (!this.queue.isEmpty() && !this.isValid) {
            this.rebuildContext(root, ctx);
            return false;
        }
        this.snapshotParticipant.updateSnapshots(ctx);
        if (this.validationFrontier.isEmpty() && !this.queue.isEmpty() && this.revalidateIn == 0) {
            this.revalidate(root);
        }
        if (this.infinite) {
            this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
            if (FluidHelper.isLava(this.fluid)) {
                this.blockEntity.award(AllAdvancements.HOSE_PULLEY_LAVA);
            }
            this.playEffect(world, root, this.fluid, true);
            return true;
        }
        while (!this.queue.isEmpty()) {
            class_3611 fluid;
            class_2680 emptied;
            class_2338 currentPos;
            block22: {
                class_2680 blockState;
                currentPos = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.method_23865()).pos();
                emptied = blockState = world.method_8320(currentPos);
                fluid = class_3612.field_15906;
                if (blockState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                    emptied = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                    fluid = class_3612.field_15910;
                } else {
                    if (blockState.method_26204() instanceof class_2404) {
                        class_2404 flowingFluid = (class_2404)blockState.method_26204();
                        emptied = class_2246.field_10124.method_9564();
                        if ((Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0) {
                            fluid = ((LiquidBlockAccessor)flowingFluid).port_lib$getFluid().method_15751();
                            break block22;
                        } else {
                            this.affectedArea = BBHelper.encapsulate(this.affectedArea, class_3341.method_34390((class_2382)currentPos, (class_2382)currentPos));
                            if (!this.blockEntity.isVirtual()) {
                                world.method_8652(currentPos, emptied, 18);
                            }
                            FluidDrainingBehaviour.dequeue(this.queue);
                            if (!this.queue.isEmpty()) continue;
                            this.isValid = this.checkValid(world, this.rootPos);
                            this.reset(ctx);
                            continue;
                        }
                    }
                    if (blockState.method_26227().method_15772() != class_3612.field_15906 && blockState.method_26194((class_1922)world, currentPos, class_3726.method_16194()).method_1110()) {
                        fluid = blockState.method_26227().method_15772();
                        emptied = class_2246.field_10124.method_9564();
                    }
                }
            }
            if (this.fluid == null) {
                this.fluid = fluid;
            }
            if (!this.fluid.method_15780(fluid)) {
                FluidDrainingBehaviour.dequeue(this.queue);
                if (!this.queue.isEmpty()) continue;
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset(ctx);
                continue;
            }
            class_3611 finalFluid = fluid;
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                this.playEffect(world, currentPos, finalFluid, true);
                this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
                if (this.infinite && FluidHelper.isLava(finalFluid)) {
                    this.blockEntity.award(AllAdvancements.HOSE_PULLEY_LAVA);
                }
            });
            if (this.infinite) {
                return true;
            }
            if (!this.blockEntity.isVirtual()) {
                world.updateSnapshots(ctx);
                world.method_8652(currentPos, emptied, 18);
            }
            this.affectedArea = BBHelper.encapsulate(this.affectedArea, currentPos);
            FluidDrainingBehaviour.dequeue(this.queue);
            if (this.queue.isEmpty()) {
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset(ctx);
                return true;
            }
            if (this.validationSet.contains(currentPos)) return true;
            this.reset(ctx);
            return true;
        }
        if (this.rootPos == null) {
            return false;
        }
        if (!this.isValid) return false;
        this.rebuildContext(root, ctx);
        return false;
    }

    protected void softReset(class_2338 root, TransactionContext ctx) {
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.visited.clear();
        this.infinite = false;
        this.setValidationTimer();
        this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        TransactionCallback.onSuccess((TransactionContext)ctx, this.blockEntity::sendData);
    }

    protected boolean checkValid(class_1937 world, class_2338 root) {
        class_2338 currentPos = root;
        for (int timeout = 1000; timeout > 0 && !root.equals((Object)this.blockEntity.method_11016()); --timeout) {
            FluidBlockType canPullFluidsFrom = this.canPullFluidsFrom(world.method_8320(currentPos), currentPos);
            if (canPullFluidsFrom == FluidBlockType.FLOWING) {
                for (class_2350 d : Iterate.directions) {
                    class_2338 side = currentPos.method_10093(d);
                    if (this.canPullFluidsFrom(world.method_8320(side), side) != FluidBlockType.SOURCE) continue;
                    return true;
                }
            } else {
                if (canPullFluidsFrom != FluidBlockType.SOURCE) break;
                return true;
            }
            currentPos = currentPos.method_10084();
        }
        return false;
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && this.affectedArea != null) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(this.rootPos, 0));
        }
    }

    protected FluidBlockType canPullFluidsFrom(class_2680 blockState, class_2338 pos) {
        if (blockState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            return FluidBlockType.SOURCE;
        }
        if (blockState.method_26204() instanceof class_2404) {
            return (Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0 ? FluidBlockType.SOURCE : FluidBlockType.FLOWING;
        }
        if (blockState.method_26227().method_15772() != class_3612.field_15906 && blockState.method_26194((class_1922)this.getWorld(), pos, class_3726.method_16194()).method_1110()) {
            return FluidBlockType.SOURCE;
        }
        return FluidBlockType.NONE;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.rootPos != null) {
            this.isValid = this.checkValid(this.getWorld(), this.rootPos);
        }
        if (!this.frontier.isEmpty()) {
            this.continueSearch();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            this.continueValidation();
            return;
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    public void rebuildContext(class_2338 root, TransactionContext ctx) {
        this.reset(ctx);
        this.rootPos = root;
        this.affectedArea = class_3341.method_34390((class_2382)this.rootPos, (class_2382)this.rootPos);
        if (this.isValid) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        }
    }

    public void revalidate(class_2338 root) {
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.newValidationSet.clear();
        this.validationFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.setValidationTimer();
    }

    private void continueSearch() {
        try {
            this.fluid = this.search(this.fluid, this.frontier, this.visited, (e, d) -> {
                FluidManipulationBehaviour.BlockPosEntry entry = new FluidManipulationBehaviour.BlockPosEntry((class_2338)e, (int)d);
                this.queue.add((Object)entry);
                this.validationSet.add((class_2338)e);
            }, false);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e2) {
            this.blockEntity.sendData();
            this.frontier.clear();
            this.visited.clear();
        }
        int maxBlocks = this.maxBlocks();
        if (this.visited.size() > maxBlocks && this.canDrainInfinitely(this.fluid) && !this.queue.isEmpty()) {
            this.infinite = true;
            class_2338 firstValid = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.method_23865()).pos();
            this.frontier.clear();
            this.visited.clear();
            this.queue.clear();
            this.queue.add((Object)new FluidManipulationBehaviour.BlockPosEntry(firstValid, 0));
            this.blockEntity.sendData();
            return;
        }
        if (!this.frontier.isEmpty()) {
            return;
        }
        this.blockEntity.sendData();
        this.visited.clear();
    }

    private void continueValidation() {
        try {
            this.search(this.fluid, this.validationFrontier, this.validationVisited, (e, d) -> this.newValidationSet.add((class_2338)e), false);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e2) {
            this.validationFrontier.clear();
            this.validationVisited.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.validationVisited.size() > maxBlocks && this.canDrainInfinitely(this.fluid)) {
            if (!this.infinite) {
                this.reset(null);
            }
            this.validationFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset(null);
            return;
        }
        this.validationSet = this.newValidationSet;
        this.newValidationSet = new HashSet<class_2338>();
        this.validationVisited.clear();
    }

    @Override
    public void reset(@Nullable TransactionContext ctx) {
        super.reset(ctx);
        this.fluid = null;
        this.rootPos = null;
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        if (ctx != null) {
            TransactionCallback.onSuccess((TransactionContext)ctx, this.blockEntity::sendData);
        } else {
            this.blockEntity.sendData();
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    protected boolean isSearching() {
        return !this.frontier.isEmpty();
    }

    public FluidStack getDrainableFluid(class_2338 rootPos) {
        try (Transaction t = TransferUtil.getTransaction();){
            if (this.fluid == null || this.isSearching() || !this.pullNext(rootPos, (TransactionContext)t)) {
                FluidStack fluidStack = FluidStack.EMPTY;
                return fluidStack;
            }
        }
        return new FluidStack(this.fluid, 81000L);
    }

    static enum FluidBlockType {
        NONE,
        SOURCE,
        FLOWING;

    }

    record Data(class_3611 fluid, boolean valid, class_2338 rootPos, List<FluidManipulationBehaviour.BlockPosEntry> validationFrontier, Set<class_2338> validationVisited, Set<class_2338> newValidationSet, int revalidateIn, class_3341 affectedArea, class_4706<FluidManipulationBehaviour.BlockPosEntry> queue) {
    }
}

