/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_918;

public class ArmInstance
extends SingleRotatingInstance<ArmBlockEntity>
implements DynamicInstance {
    final ModelData base;
    final ModelData lowerBody;
    final ModelData upperBody;
    ModelData claw;
    private final ArrayList<ModelData> clawGrips;
    private final ArrayList<ModelData> models;
    private final Boolean ceiling;
    private boolean firstRender = true;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmInstance(MaterialManager materialManager, ArmBlockEntity blockEntity) {
        super(materialManager, blockEntity);
        Material mat = this.getTransformMaterial();
        this.base = (ModelData)mat.getModel(AllPartialModels.ARM_BASE, this.blockState).createInstance();
        this.lowerBody = (ModelData)mat.getModel(AllPartialModels.ARM_LOWER_BODY, this.blockState).createInstance();
        this.upperBody = (ModelData)mat.getModel(AllPartialModels.ARM_UPPER_BODY, this.blockState).createInstance();
        this.claw = (ModelData)mat.getModel(blockEntity.goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, this.blockState).createInstance();
        ModelData clawGrip1 = (ModelData)mat.getModel(AllPartialModels.ARM_CLAW_GRIP_UPPER, this.blockState).createInstance();
        ModelData clawGrip2 = (ModelData)mat.getModel(AllPartialModels.ARM_CLAW_GRIP_LOWER, this.blockState).createInstance();
        this.clawGrips = Lists.newArrayList((Object[])new ModelData[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new ModelData[]{this.base, this.lowerBody, this.upperBody, this.claw, clawGrip1, clawGrip2});
        this.ceiling = (Boolean)this.blockState.method_11654((class_2769)ArmBlock.CEILING);
        this.animateArm(false);
    }

    public void beginFrame() {
        if (((ArmBlockEntity)this.blockEntity).phase == ArmBlockEntity.Phase.DANCING && ((ArmBlockEntity)this.blockEntity).getSpeed() != 0.0f) {
            this.animateArm(true);
            this.firstRender = true;
            return;
        }
        float pt = AnimationTickHolder.getPartialTicks();
        float baseAngleNow = ((ArmBlockEntity)this.blockEntity).baseAngle.getValue(pt);
        float lowerArmAngleNow = ((ArmBlockEntity)this.blockEntity).lowerArmAngle.getValue(pt);
        float upperArmAngleNow = ((ArmBlockEntity)this.blockEntity).upperArmAngle.getValue(pt);
        float headAngleNow = ((ArmBlockEntity)this.blockEntity).headAngle.getValue(pt);
        boolean settled = class_3532.method_15347((float)this.baseAngle, (float)baseAngleNow) && class_3532.method_15347((float)this.lowerArmAngle, (float)lowerArmAngleNow) && class_3532.method_15347((float)this.upperArmAngle, (float)upperArmAngleNow) && class_3532.method_15347((float)this.headAngle, (float)headAngleNow);
        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;
        if (!settled || this.firstRender) {
            this.animateArm(false);
        }
        if (this.firstRender) {
            this.firstRender = false;
        }
    }

    private void animateArm(boolean rave) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((class_1936)((ArmBlockEntity)this.blockEntity).method_10997()) + (float)(((ArmBlockEntity)this.blockEntity).hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = this.baseAngle;
            lowerArmAngle = this.lowerArmAngle - 135.0f;
            upperArmAngle = this.upperArmAngle - 90.0f;
            headAngle = this.headAngle;
            color = 0xFFFFFF;
        }
        class_4587 msLocal = new class_4587();
        TransformStack msr = TransformStack.cast((class_4587)msLocal);
        msr.translate((class_2382)this.getInstancePosition());
        msr.centre();
        if (this.ceiling.booleanValue()) {
            msr.rotateX(180.0);
        }
        ArmRenderer.transformBase(msr, baseAngle);
        this.base.setTransform(msLocal);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        this.lowerBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        this.upperBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformHead(msr, headAngle);
        if (this.ceiling.booleanValue() && ((ArmBlockEntity)this.blockEntity).goggles) {
            msr.rotateZ(180.0);
        }
        this.claw.setTransform(msLocal);
        if (this.ceiling.booleanValue() && ((ArmBlockEntity)this.blockEntity).goggles) {
            msr.rotateZ(180.0);
        }
        class_1799 item = ((ArmBlockEntity)this.blockEntity).heldItem;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        boolean hasItem = !item.method_7960();
        boolean isBlockItem = hasItem && item.method_7909() instanceof class_1747 && itemRenderer.method_4019(item, (class_1937)class_310.method_1551().field_1687, null, 0).method_4712();
        for (int index : Iterate.zeroAndOne) {
            msLocal.method_22903();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            this.clawGrips.get(index).setTransform(msLocal);
            msLocal.method_22909();
        }
    }

    @Override
    public void update() {
        super.update();
        this.models.remove(this.claw);
        this.claw.delete();
        this.claw = (ModelData)this.getTransformMaterial().getModel(((ArmBlockEntity)this.blockEntity).goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, this.blockState).createInstance();
        this.models.add(this.claw);
        this.updateLight();
        this.animateArm(false);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.models.stream());
    }

    @Override
    protected Instancer<RotatingData> getModel() {
        return this.getRotatingMaterial().getModel(AllPartialModels.ARM_COG, ((ArmBlockEntity)this.blockEntity).method_11010());
    }

    @Override
    public void remove() {
        super.remove();
        this.models.forEach(InstanceData::delete);
    }
}

