/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class AdvancementBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<AdvancementBehaviour> TYPE = new BehaviourType();
    private UUID playerId;
    private Set<CreateAdvancement> advancements = new HashSet<CreateAdvancement>();

    public AdvancementBehaviour(SmartBlockEntity be, CreateAdvancement ... advancements) {
        super(be);
        this.add(advancements);
    }

    public void add(CreateAdvancement ... advancements) {
        for (CreateAdvancement advancement : advancements) {
            this.advancements.add(advancement);
        }
    }

    public boolean isOwnerPresent() {
        return this.playerId != null;
    }

    public void setPlayer(UUID id) {
        class_1657 player = this.getWorld().method_18470(id);
        if (player == null) {
            return;
        }
        this.playerId = id;
        this.removeAwarded();
        this.blockEntity.method_5431();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.removeAwarded();
    }

    private void removeAwarded() {
        class_1657 player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.advancements.removeIf(c -> c.isAlreadyAwardedTo(player));
        if (this.advancements.isEmpty()) {
            this.playerId = null;
            this.blockEntity.method_5431();
        }
    }

    public void awardPlayerIfNear(CreateAdvancement advancement, int maxDistance) {
        class_1657 player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.method_5707(class_243.method_24953((class_2382)this.getPos())) > (double)(maxDistance * maxDistance)) {
            return;
        }
        this.award(advancement, player);
    }

    public void awardPlayer(CreateAdvancement advancement) {
        class_1657 player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.award(advancement, player);
    }

    private void award(CreateAdvancement advancement, class_1657 player) {
        if (this.advancements.contains(advancement)) {
            advancement.awardTo(player);
        }
        this.removeAwarded();
    }

    private class_1657 getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        return this.getWorld().method_18470(this.playerId);
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.playerId != null) {
            nbt.method_25927("Owner", this.playerId);
        }
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.method_10545("Owner")) {
            this.playerId = nbt.method_25926("Owner");
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void tryAward(class_1922 reader, class_2338 pos, CreateAdvancement advancement) {
        AdvancementBehaviour behaviour = BlockEntityBehaviour.get(reader, pos, TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public static void setPlacedBy(class_1937 worldIn, class_2338 pos, class_1309 placer) {
        class_3222 player;
        AdvancementBehaviour behaviour = BlockEntityBehaviour.get((class_1922)worldIn, pos, TYPE);
        if (behaviour == null) {
            return;
        }
        if (placer instanceof class_3222 && !(player = (class_3222)placer).isFake()) {
            behaviour.setPlayer(placer.method_5667());
        }
    }
}

