/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui.compat.flywheel;

import com.google.common.base.Predicates;
import com.jozufozu.flywheel.config.Option;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.entries.ValueEntry;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class FlwValueEntry<T>
extends ValueEntry<T> {
    protected Option<T> option;

    public FlwValueEntry(String label, Option option) {
        super(label);
        this.option = option;
        this.path = String.join((CharSequence)".", option.getKey());
        this.resetButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(0, 0, 16, 16).showingElement(AllIcons.I_CONFIG_RESET.asStencil())).withCallback(() -> {
            this.setValue(option.get());
            this.onReset();
        });
        this.resetButton.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.resetButton)));
        this.listeners.add(this.resetButton);
        String path = option.getKey();
        this.labelTooltip.add(class_2561.method_43470((String)label).method_27692(class_124.field_1068));
        String comment = null;
        if (comment == null || comment.isEmpty()) {
            return;
        }
        ArrayList<String> commentLines = new ArrayList<String>(Arrays.asList(comment.split("\n")));
        Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(commentLines);
        if (metadata.getFirst() != null) {
            this.unit = metadata.getFirst();
        }
        if (metadata.getSecond() != null && !metadata.getSecond().isEmpty()) {
            this.annotations.putAll(metadata.getSecond());
        }
        this.labelTooltip.addAll(commentLines.stream().filter(Predicates.not(s -> s.startsWith("Range"))).map(class_2561::method_43470).flatMap(stc -> TooltipHelper.cutTextComponent((class_2561)stc, TooltipHelper.Palette.ALL_GRAY).stream()).collect(Collectors.toList()));
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
            this.labelTooltip.addAll(TooltipHelper.cutTextComponent((class_2561)class_2561.method_43470((String)"Changing this value will require a _relog_ to take full effect"), TooltipHelper.Palette.GRAY_AND_GOLD));
        }
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
            this.labelTooltip.addAll(TooltipHelper.cutTextComponent((class_2561)class_2561.method_43470((String)"Changing this value will require a _restart_ to take full effect"), TooltipHelper.Palette.GRAY_AND_RED));
        }
        this.labelTooltip.add(class_2561.method_43470((String)(ConfigScreen.modID + ":" + path)).method_27692(class_124.field_1063));
    }

    @Override
    public void setValue(@NotNull T value) {
        this.option.set(value);
        this.onValueChange(value);
    }

    @Override
    @NotNull
    public T getValue() {
        return (T)this.option.get();
    }

    @Override
    protected boolean isCurrentValueDefault() {
        return false;
    }
}

