/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllBlockEntityTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_5250;

public final class NBTProcessors {
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> processors = new HashMap();
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> survivalProcessors = new HashMap();

    public static synchronized void addProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<class_2487> itemProcessor(String tagKey) {
        return data -> {
            class_2487 compound = data.method_10562(tagKey);
            if (!compound.method_10573("tag", 10)) {
                return data;
            }
            class_2487 itemTag = compound.method_10562("tag");
            if (itemTag == null) {
                return data;
            }
            HashSet keys = new HashSet(itemTag.method_10541());
            for (String key : keys) {
                if (!NBTProcessors.isUnsafeItemNBTKey(key)) continue;
                itemTag.method_10551(key);
            }
            if (itemTag.method_33133()) {
                compound.method_10551("tag");
            }
            return data;
        };
    }

    public static class_1799 withUnsafeNBTDiscarded(class_1799 stack) {
        if (stack.method_7969() == null) {
            return stack;
        }
        class_1799 copy = stack.method_7972();
        stack.method_7969().method_10541().stream().filter(NBTProcessors::isUnsafeItemNBTKey).forEach(arg_0 -> ((class_1799)copy).method_7983(arg_0));
        if (copy.method_7969().method_33133()) {
            copy.method_7980(null);
        }
        return copy;
    }

    public static boolean isUnsafeItemNBTKey(String name) {
        if (name.equals("StoredEnchantments")) {
            return false;
        }
        if (name.equals("Enchantments")) {
            return false;
        }
        if (name.contains("Potion")) {
            return false;
        }
        if (name.contains("Damage")) {
            return false;
        }
        return !name.equals("display");
    }

    public static boolean textComponentHasClickEvent(String json) {
        class_5250 component = class_2561.class_2562.method_10877((String)(json.isEmpty() ? "\"\"" : json));
        return component != null && component.method_10866() != null && component.method_10866().method_10970() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static class_2487 process(class_2586 blockEntity, class_2487 compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        class_2591 type = blockEntity.method_11017();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (class_2487)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (class_2487)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof class_2636) {
            return compound;
        }
        if (blockEntity.method_11011()) {
            return null;
        }
        return compound;
    }

    static {
        String[] signSides = new String[]{"front_text", "back_text"};
        UnaryOperator signProcessor = data -> {
            for (String side : signSides) {
                class_2487 sideData;
                if (!data.method_10573(side, 10) || !(sideData = data.method_10562(side)).method_10573("messages", 9)) continue;
                class_2499 messages = sideData.method_10554("messages", 8);
                for (int i = 0; i < messages.size(); ++i) {
                    String string = messages.method_10608(i);
                    if (!NBTProcessors.textComponentHasClickEvent(string)) continue;
                    return null;
                }
            }
            return data;
        };
        NBTProcessors.addProcessor(class_2591.field_11911, signProcessor);
        NBTProcessors.addProcessor(class_2591.field_40330, signProcessor);
        NBTProcessors.addProcessor(class_2591.field_16412, data -> {
            if (!data.method_10573("Book", 10)) {
                return data;
            }
            class_2487 book = data.method_10562("Book");
            if (!book.method_10573("tag", 10)) {
                return data;
            }
            class_2487 tag = book.method_10562("tag");
            if (!tag.method_10573("pages", 9)) {
                return data;
            }
            class_2499 pages = tag.method_10554("pages", 8);
            for (class_2520 inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent(inbt.method_10714())) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor((class_2591)AllBlockEntityTypes.CREATIVE_CRATE.get(), NBTProcessors.itemProcessor("Filter"));
        NBTProcessors.addProcessor((class_2591)AllBlockEntityTypes.PLACARD.get(), NBTProcessors.itemProcessor("Item"));
    }
}

