/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonPlumeParticleData;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.BigCannonBreechStrengthHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterial;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialProperties;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;

public class MountedBigCannonContraption
extends AbstractMountedCannonContraption {
    private BigCannonMaterial cannonMaterial;
    public boolean hasFired = false;

    @Override
    public float maximumDepression(@Nonnull ControlPitchContraption controller) {
        class_2680 state = controller.getControllerState();
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            return 30.0f;
        }
        if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
            return 15.0f;
        }
        return 0.0f;
    }

    @Override
    public float maximumElevation(@Nonnull ControlPitchContraption controller) {
        class_2680 state = controller.getControllerState();
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            return 60.0f;
        }
        if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
            return 30.0f;
        }
        return 0.0f;
    }

    public boolean assemble(class_1937 level, class_2338 pos) throws AssemblyException {
        if (!this.collectCannonBlocks(level, pos)) {
            return false;
        }
        this.bounds = new class_238(class_2338.field_10980);
        this.bounds = this.bounds.method_1014(Math.ceil(Math.sqrt(MountedBigCannonContraption.getRadius(this.getBlocks().keySet(), (class_2350.class_2351)class_2350.class_2351.field_11052))));
        return !this.blocks.isEmpty();
    }

    private boolean collectCannonBlocks(class_1937 level, class_2338 pos) throws AssemblyException {
        class_2338 negativeEndPos;
        class_2680 startState = level.method_8320(pos);
        class_2248 class_22482 = startState.method_26204();
        if (!(class_22482 instanceof BigCannonBlock)) {
            return false;
        }
        BigCannonBlock startCannon = (BigCannonBlock)class_22482;
        if (!startCannon.isComplete(startState)) {
            throw MountedBigCannonContraption.hasIncompleteCannonBlocks(pos);
        }
        if (this.hasCannonLoaderInside((class_1936)level, startState, pos)) {
            throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(pos);
        }
        BigCannonMaterial material = startCannon.getCannonMaterial();
        BigCannonEnd startEnd = startCannon.getOpeningType(level, startState, pos);
        ArrayList<class_3499.class_3501> cannonBlocks = new ArrayList<class_3499.class_3501>();
        cannonBlocks.add(new class_3499.class_3501(pos, startState, this.getBlockEntityNBT(level, pos)));
        int cannonLength = 1;
        class_2350 cannonFacing = startCannon.getFacing(startState);
        class_2350 positive = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)cannonFacing.method_10166());
        class_2350 negative = positive.method_10153();
        class_2338 start = pos;
        class_2680 nextState = level.method_8320(pos.method_10093(positive));
        BigCannonEnd positiveEnd = startEnd;
        while (this.isValidCannonBlock((class_1936)level, nextState, start.method_10093(positive)) && this.isConnectedToCannon((class_1936)level, nextState, start.method_10093(positive), positive, material)) {
            start = start.method_10093(positive);
            if (!((BigCannonBlock)nextState.method_26204()).isComplete(nextState)) {
                throw MountedBigCannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new class_3499.class_3501(start, nextState, this.getBlockEntityNBT(level, start)));
            ++cannonLength;
            positiveEnd = ((BigCannonBlock)nextState.method_26204()).getOpeningType(level, nextState, start);
            if (this.hasCannonLoaderInside((class_1936)level, nextState, start)) {
                throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(start);
            }
            nextState = level.method_8320(start.method_10093(positive));
            if (cannonLength > MountedBigCannonContraption.getMaxCannonLength()) {
                throw MountedBigCannonContraption.cannonTooLarge();
            }
            if (positiveEnd == BigCannonEnd.OPEN) continue;
        }
        class_2338 positiveEndPos = positiveEnd == BigCannonEnd.OPEN ? start : start.method_10093(negative);
        start = pos;
        nextState = level.method_8320(pos.method_10093(negative));
        BigCannonEnd negativeEnd = startEnd;
        while (this.isValidCannonBlock((class_1936)level, nextState, start.method_10093(negative)) && this.isConnectedToCannon((class_1936)level, nextState, start.method_10093(negative), negative, material)) {
            start = start.method_10093(negative);
            if (!((BigCannonBlock)nextState.method_26204()).isComplete(nextState)) {
                throw MountedBigCannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new class_3499.class_3501(start, nextState, this.getBlockEntityNBT(level, start)));
            ++cannonLength;
            negativeEnd = ((BigCannonBlock)nextState.method_26204()).getOpeningType(level, nextState, start);
            if (this.hasCannonLoaderInside((class_1936)level, nextState, start)) {
                throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(start);
            }
            nextState = level.method_8320(start.method_10093(negative));
            if (cannonLength > MountedBigCannonContraption.getMaxCannonLength()) {
                throw MountedBigCannonContraption.cannonTooLarge();
            }
            if (negativeEnd == BigCannonEnd.OPEN) continue;
        }
        class_2338 class_23382 = negativeEndPos = negativeEnd == BigCannonEnd.OPEN ? start : start.method_10093(positive);
        if (positiveEnd == negativeEnd) {
            throw MountedBigCannonContraption.invalidCannon();
        }
        boolean openEndFlag = positiveEnd == BigCannonEnd.OPEN;
        this.initialOrientation = openEndFlag ? positive : negative;
        this.startPos = openEndFlag ? negativeEndPos : positiveEndPos;
        this.anchor = pos;
        this.startPos = this.startPos.method_10059((class_2382)pos);
        for (class_3499.class_3501 blockInfo : cannonBlocks) {
            class_2338 localPos = blockInfo.comp_1341().method_10059((class_2382)pos);
            class_3499.class_3501 localBlockInfo = new class_3499.class_3501(localPos, blockInfo.comp_1342(), blockInfo.comp_1343());
            this.getBlocks().put(localPos, localBlockInfo);
            if (blockInfo.comp_1343() == null) continue;
            class_2586 be = class_2586.method_11005((class_2338)localPos, (class_2680)blockInfo.comp_1342(), (class_2487)blockInfo.comp_1343());
            this.presentBlockEntities.put(localPos, be);
        }
        this.cannonMaterial = material;
        return true;
    }

    private boolean isValidCannonBlock(class_1936 level, class_2680 state, class_2338 pos) {
        return state.method_26204() instanceof BigCannonBlock;
    }

    private boolean hasCannonLoaderInside(class_1936 level, class_2680 state, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof IBigCannonBlockEntity)) {
            return false;
        }
        IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)be;
        class_2680 containedState = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block().comp_1342();
        return CBCBlocks.RAM_HEAD.has(containedState) || CBCBlocks.WORM_HEAD.has(containedState) || AllBlocks.PISTON_EXTENSION_POLE.has(containedState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectedToCannon(class_1936 level, class_2680 state, class_2338 pos, class_2350 connection, BigCannonMaterial material) {
        BigCannonBlock cBlock = (BigCannonBlock)state.method_26204();
        if (cBlock.getCannonMaterialInLevel(level, state, pos) != material) {
            return false;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof IBigCannonBlockEntity)) return false;
        IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)class_25862;
        class_25862 = level.method_8321(pos.method_10093(connection.method_10153()));
        if (!(class_25862 instanceof IBigCannonBlockEntity)) return false;
        IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)class_25862;
        if (!((BigCannonBehavior)((Object)cbe.cannonBehavior())).isConnectedTo(connection.method_10153())) return false;
        if (!((BigCannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(connection)) return false;
        return true;
    }

    @Override
    public float getWeightForStress() {
        if (this.cannonMaterial == null) {
            return this.blocks.size();
        }
        return (float)this.blocks.size() * this.cannonMaterial.properties().weight();
    }

    @Override
    public void tick(class_1937 level, PitchOrientedContraptionEntity entity) {
        super.tick(level, entity);
        class_2338 endPos = this.startPos.method_10093(this.initialOrientation.method_10153());
        Object v = this.presentBlockEntities.get(endPos);
        if (v instanceof QuickfiringBreechBlockEntity) {
            QuickfiringBreechBlockEntity qfbreech = (QuickfiringBreechBlockEntity)v;
            qfbreech.tickAnimation();
        }
    }

    @Override
    public void onRedstoneUpdate(class_3218 level, PitchOrientedContraptionEntity entity, boolean togglePower, int firePower, ControlPitchContraption controller) {
        if (!togglePower || firePower <= 0) {
            return;
        }
        this.fireShot(level, entity, controller);
    }

    @Override
    public void fireShot(class_3218 level, PitchOrientedContraptionEntity entity, @Nullable ControlPitchContraption controller) {
        class_2248 cannonState;
        Object v;
        QuickfiringBreechBlockEntity qfbreech;
        class_2338 endPos = this.startPos.method_10093(this.initialOrientation.method_10153());
        Object v2 = this.presentBlockEntities.get(endPos);
        if (v2 instanceof QuickfiringBreechBlockEntity && (qfbreech = (QuickfiringBreechBlockEntity)v2).getOpenProgress() > 0) {
            return;
        }
        class_3499.class_3501 foundProjectile = null;
        float chargesUsed = 0.0f;
        float stress = 0.0f;
        float smokeScale = 0.0f;
        int barrelTravelled = 0;
        class_5819 rand = level.method_8409();
        boolean failed = false;
        boolean canFail = (Boolean)CBCConfigs.SERVER.failure.disableAllFailure.get() == false;
        class_2338 currentPos = this.startPos.method_10062();
        int count = 0;
        SmartBlockEntity failedEntity = null;
        float spread = 0.0f;
        float spreadSub = CBCConfigs.SERVER.cannons.barrelSpreadReduction.getF();
        boolean emptyNoProjectile = false;
        BigCannonMaterialProperties properties = this.cannonMaterial.properties();
        class_3499.class_3501 breech = (class_3499.class_3501)this.blocks.get(this.startPos.method_10093(this.initialOrientation.method_10153()));
        int materialStrength = properties.maxSafeBaseCharges();
        int maxSafeCharges = Math.min(materialStrength, BigCannonBreechStrengthHandler.getStrength(breech.comp_1342().method_26204(), materialStrength));
        BigCannonPropellantBlock propellant = null;
        while ((v = this.presentBlockEntities.get(currentPos)) instanceof IBigCannonBlockEntity) {
            BigCannonBlock cannon;
            class_2248 failIgnitePos;
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)v;
            BigCannonBehavior behavior = (BigCannonBehavior)((Object)cbe.cannonBehavior());
            class_3499.class_3501 containedBlockInfo = behavior.block();
            class_3499.class_3501 cannonInfo = (class_3499.class_3501)this.blocks.get(currentPos);
            if (foundProjectile == null && containedBlockInfo.comp_1342().method_26215()) {
                if (count == 0) {
                    return;
                }
                emptyNoProjectile = true;
                chargesUsed = Math.max(chargesUsed - 1.0f, 0.0f);
            } else {
                class_2248 class_22482 = containedBlockInfo.comp_1342().method_26204();
                if (class_22482 instanceof BigCannonPropellantBlock) {
                    BigCannonPropellantBlock cpropel = (BigCannonPropellantBlock)class_22482;
                    if (propellant == null) {
                        if (!cpropel.canBeIgnited(containedBlockInfo, this.initialOrientation)) {
                            return;
                        }
                        propellant = cpropel;
                    } else if (propellant.isCompatibleWith(cpropel, containedBlockInfo, this.initialOrientation)) {
                        propellant = cpropel;
                    } else if (canFail) {
                        failed = true;
                        failedEntity = behavior.blockEntity;
                        break;
                    }
                    this.consumeBlock(behavior, currentPos, propellant::consumePropellant);
                    float power = Math.max(0.0f, propellant.getChargePower(containedBlockInfo));
                    chargesUsed += power;
                    smokeScale += power;
                    stress += propellant.getStressOnCannon(containedBlockInfo);
                    spread += propellant.getSpread(containedBlockInfo);
                    if (canFail && (!cbe.blockCanHandle(cannonInfo) && MountedBigCannonContraption.rollBarrelBurst(rand) || stress > (float)maxSafeCharges && MountedBigCannonContraption.rollOverloadBurst(rand))) {
                        failed = true;
                        failedEntity = behavior.blockEntity;
                        break;
                    }
                    if (emptyNoProjectile && canFail && MountedBigCannonContraption.rollFailToIgnite(rand)) {
                        failIgnitePos = entity.toGlobalVector(class_243.method_24953((class_2382)currentPos.method_10093(this.initialOrientation)), 1.0f);
                        level.method_43128(null, failIgnitePos.field_1352, failIgnitePos.field_1351, failIgnitePos.field_1350, cannonInfo.comp_1342().method_26231().method_10595(), class_3419.field_15245, 5.0f, 0.0f);
                        return;
                    }
                    emptyNoProjectile = false;
                } else if (containedBlockInfo.comp_1342().method_26204() instanceof ProjectileBlock && foundProjectile == null) {
                    if (chargesUsed == 0.0f) {
                        return;
                    }
                    foundProjectile = containedBlockInfo;
                    if (emptyNoProjectile && MountedBigCannonContraption.rollFailToIgnite(rand) && canFail) {
                        class_243 failIgnitePos2 = entity.toGlobalVector(class_243.method_24953((class_2382)currentPos.method_10093(this.initialOrientation)), 1.0f);
                        level.method_43128(null, failIgnitePos2.field_1352, failIgnitePos2.field_1351, failIgnitePos2.field_1350, cannonInfo.comp_1342().method_26231().method_10595(), class_3419.field_15245, 5.0f, 0.0f);
                        return;
                    }
                    this.consumeBlock(behavior, currentPos);
                    emptyNoProjectile = false;
                } else if (!containedBlockInfo.comp_1342().method_26215() && foundProjectile != null) {
                    if (canFail) {
                        failed = true;
                        failedEntity = behavior.blockEntity;
                        break;
                    }
                    this.consumeBlock(behavior, currentPos);
                }
            }
            currentPos = currentPos.method_10093(this.initialOrientation);
            cannonState = cannonInfo.comp_1342();
            failIgnitePos = cannonState.method_26204();
            if (failIgnitePos instanceof BigCannonBlock && (cannon = (BigCannonBlock)failIgnitePos).getOpeningType((class_1937)level, (class_2680)cannonState, currentPos) == BigCannonEnd.OPEN) {
                ++count;
            }
            if (foundProjectile == null) continue;
            ++barrelTravelled;
            if (cannonInfo.comp_1342().method_26164(CBCTags.CBCBlockTags.REDUCES_SPREAD)) {
                spread = Math.max(spread - spreadSub, 0.0f);
            }
            if (!(chargesUsed > 0.0f) || !((double)barrelTravelled / (double)chargesUsed > this.cannonMaterial.properties().squibRatio()) || !MountedBigCannonContraption.rollSquib(rand)) continue;
            behavior.loadBlock(foundProjectile);
            class_2487 tag = behavior.blockEntity.method_38242();
            tag.method_10551("x");
            tag.method_10551("y");
            tag.method_10551("z");
            class_3499.class_3501 squibInfo = new class_3499.class_3501(cannonInfo.comp_1341(), cannonInfo.comp_1342(), tag);
            this.blocks.put(cannonInfo.comp_1341(), squibInfo);
            class_243 squibPos = entity.toGlobalVector(class_243.method_24953((class_2382)currentPos.method_10093(this.initialOrientation)), 1.0f);
            level.method_43128(null, squibPos.field_1352, squibPos.field_1351, squibPos.field_1350, cannonInfo.comp_1342().method_26231().method_10595(), class_3419.field_15245, 10.0f, 0.0f);
            return;
        }
        if (canFail && failed && failedEntity != null) {
            this.fail(currentPos, (class_1937)level, entity, (class_2586)failedEntity, (int)chargesUsed);
            return;
        }
        if (chargesUsed <= 0.0f) {
            chargesUsed = 0.5f;
        }
        class_243 spawnPos = entity.toGlobalVector(class_243.method_24953((class_2382)currentPos.method_10093(this.initialOrientation)), 1.0f);
        class_243 vec = spawnPos.method_1020(entity.toGlobalVector(class_243.method_24953((class_2382)class_2338.field_10980), 1.0f)).method_1029();
        float recoilMagnitude = chargesUsed;
        if (foundProjectile != null && (cannonState = foundProjectile.comp_1342().method_26204()) instanceof ProjectileBlock) {
            ProjectileBlock projectileBlock = (ProjectileBlock)cannonState;
            class_2586 projectileBE = foundProjectile.comp_1343() == null ? null : class_2586.method_11005((class_2338)foundProjectile.comp_1341(), (class_2680)foundProjectile.comp_1342(), (class_2487)foundProjectile.comp_1343());
            AbstractCannonProjectile projectile = projectileBlock.getProjectile((class_1937)level, foundProjectile.comp_1342(), foundProjectile.comp_1341(), projectileBE);
            projectile.method_33574(spawnPos);
            projectile.setChargePower(chargesUsed);
            projectile.method_7485(vec.field_1352, vec.field_1351, vec.field_1350, chargesUsed, spread);
            projectile.field_6004 = projectile.method_36455();
            projectile.field_5982 = projectile.method_36454();
            level.method_8649((class_1297)projectile);
            recoilMagnitude += 1.0f;
        }
        recoilMagnitude *= CBCConfigs.SERVER.cannons.bigCannonRecoilScale.getF();
        if (controller != null) {
            controller.onRecoil(vec.method_1021((double)(-recoilMagnitude)), (AbstractContraptionEntity)entity);
        }
        this.hasFired = true;
        for (class_3222 player : level.method_18456()) {
            level.method_14166(player, (class_2394)new CannonPlumeParticleData(smokeScale * 0.5f), true, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, 0, vec.field_1352, vec.field_1351, vec.field_1350, 1.0);
        }
        CBCSoundEvents.FIRE_BIG_CANNON.playOnServer((class_1937)level, (class_2382)class_2338.method_49638((class_2374)spawnPos));
    }

    private void consumeBlock(BigCannonBehavior behavior, class_2338 pos) {
        this.consumeBlock(behavior, pos, BigCannonBehavior::removeBlock);
    }

    private void consumeBlock(BigCannonBehavior behavior, class_2338 pos, Consumer<BigCannonBehavior> action) {
        action.accept(behavior);
        class_2487 tag = behavior.blockEntity.method_38242();
        tag.method_10551("x");
        tag.method_10551("y");
        tag.method_10551("z");
        class_3499.class_3501 oldInfo = (class_3499.class_3501)this.blocks.get(pos);
        if (oldInfo == null) {
            return;
        }
        class_3499.class_3501 consumedInfo = new class_3499.class_3501(oldInfo.comp_1341(), oldInfo.comp_1342(), tag);
        this.blocks.put(oldInfo.comp_1341(), consumedInfo);
    }

    private static boolean rollSquib(class_5819 random) {
        float f = CBCConfigs.SERVER.failure.squibChance.getF();
        return f != 0.0f && random.method_43057() <= f;
    }

    private static boolean rollBarrelBurst(class_5819 random) {
        float f = CBCConfigs.SERVER.failure.barrelChargeBurstChance.getF();
        return f != 0.0f && random.method_43057() <= f;
    }

    private static boolean rollOverloadBurst(class_5819 random) {
        float f = CBCConfigs.SERVER.failure.overloadBurstChance.getF();
        return f != 0.0f && random.method_43057() <= f;
    }

    private static boolean rollFailToIgnite(class_5819 random) {
        float f = CBCConfigs.SERVER.failure.interruptedIgnitionChance.getF();
        return f != 0.0f && random.method_43057() <= f;
    }

    public void fail(class_2338 localPos, class_1937 level, PitchOrientedContraptionEntity entity, class_2586 failed, int charges) {
        class_243 failurePoint = entity.toGlobalVector(class_243.method_24953((class_2382)failed.method_11016()), 1.0f);
        float failScale = CBCConfigs.SERVER.failure.failureExplosionPower.getF();
        if (this.cannonMaterial.properties().failureMode() == BigCannonMaterialProperties.FailureMode.RUPTURE) {
            level.method_8437(null, failurePoint.field_1352, failurePoint.field_1351, failurePoint.field_1350, 2.0f * failScale + 1.0f, class_1937.class_7867.field_40888);
            int failInt = class_3532.method_15386((float)failScale);
            class_2338 startPos = localPos.method_10079(this.initialOrientation.method_10153(), failInt);
            for (int i = 0; i < failInt * 2 + 1; ++i) {
                class_2338 pos = startPos.method_10079(this.initialOrientation, i);
                this.blocks.remove(pos);
                this.presentBlockEntities.remove(pos);
            }
            ControlPitchContraption controller = entity.getController();
            if (controller != null) {
                controller.disassemble();
            }
        } else {
            Iterator iter = this.blocks.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.presentBlockEntities.remove(entry.getKey());
                iter.remove();
            }
            float power = (float)charges * failScale;
            level.method_8437(null, failurePoint.field_1352, failurePoint.field_1351, failurePoint.field_1350, power, class_1937.class_7867.field_40889);
            entity.method_31472();
        }
    }

    @Override
    public class_243 getInteractionVec(PitchOrientedContraptionEntity poce) {
        return poce.toGlobalVector(class_243.method_24953((class_2382)this.startPos.method_10093(this.initialOrientation.method_10153())), 1.0f);
    }

    @Override
    public class_2487 writeNBT(boolean clientData) {
        class_2487 tag = super.writeNBT(clientData);
        tag.method_10582("CannonMaterial", this.cannonMaterial == null ? CBCBigCannonMaterials.CAST_IRON.name().toString() : this.cannonMaterial.name().toString());
        return tag;
    }

    @Override
    public void readNBT(class_1937 level, class_2487 tag, boolean clientData) {
        super.readNBT(level, tag, clientData);
        this.cannonMaterial = BigCannonMaterial.fromNameOrNull(new class_2960(tag.method_10558("CannonMaterial")));
        if (this.cannonMaterial == null) {
            this.cannonMaterial = CBCBigCannonMaterials.CAST_IRON;
        }
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.MOUNTED_CANNON;
    }
}

