/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3499;
import rbasamoyai.createbigcannons.base.PreciseProjectile;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.CBCContraptionRotationState;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedAutocannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.IAutocannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;

public class PitchOrientedContraptionEntity
extends OrientedContraptionEntity
implements PreciseProjectile {
    private class_2338 controllerPos;
    private boolean updatesOwnRotation;

    public PitchOrientedContraptionEntity(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    public static PitchOrientedContraptionEntity create(class_1937 level, Contraption contraption, class_2350 initialOrientation, boolean updatesOwnRotation) {
        PitchOrientedContraptionEntity entity = (PitchOrientedContraptionEntity)CBCEntityTypes.PITCH_ORIENTED_CONTRAPTION.create(level);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        entity.updatesOwnRotation = updatesOwnRotation;
        return entity;
    }

    public static PitchOrientedContraptionEntity create(class_1937 level, Contraption contraption, class_2350 initialOrientation, ControlPitchContraption.Block block) {
        PitchOrientedContraptionEntity poce = PitchOrientedContraptionEntity.create(level, contraption, initialOrientation, true);
        poce.controllerPos = block.getControllerBlockPos();
        return poce;
    }

    protected void readAdditional(class_2487 compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        if (compound.method_10545("ControllerRelative")) {
            this.controllerPos = class_2512.method_10691((class_2487)compound.method_10562("ControllerRelative")).method_10081((class_2382)this.method_24515());
        } else {
            class_2586 class_25862 = this.method_37908().method_8321(this.method_24515().method_10087(2));
            if (class_25862 instanceof ControlPitchContraption.Block) {
                ControlPitchContraption.Block controller = (ControlPitchContraption.Block)class_25862;
                if (!this.method_5765()) {
                    this.controllerPos = controller.getControllerBlockPos();
                }
            }
        }
        this.updatesOwnRotation = compound.method_10577("UpdatesOwnRotation");
    }

    protected void writeAdditional(class_2487 compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        if (this.controllerPos != null) {
            compound.method_10566("ControllerRelative", (class_2520)class_2512.method_10692((class_2338)this.controllerPos.method_10059((class_2382)this.method_24515())));
        }
        compound.method_10556("UpdatesOwnRotation", this.updatesOwnRotation);
    }

    protected ControlPitchContraption getController() {
        ControlPitchContraption controller;
        if (this.controllerPos != null) {
            ControlPitchContraption controller2;
            if (!this.method_37908().method_8477(this.controllerPos)) {
                return null;
            }
            class_2586 class_25862 = this.method_37908().method_8321(this.controllerPos);
            return class_25862 instanceof ControlPitchContraption ? (controller2 = (ControlPitchContraption)class_25862) : null;
        }
        class_1297 class_12972 = this.method_5854();
        return class_12972 instanceof ControlPitchContraption ? (controller = (ControlPitchContraption)class_12972) : null;
    }

    protected void tickContraption() {
        ControlPitchContraption controller;
        super.tickContraption();
        if (this.updatesOwnRotation) {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
        }
        this.contraption.anchor = this.method_24515();
        class_1937 level = this.method_37908();
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption mounted = (AbstractMountedCannonContraption)contraption;
            mounted.tick(level, this);
        }
        if ((controller = this.getController()) == null) {
            if (!level.field_9236) {
                this.disassemble();
            }
            return;
        }
        if (!controller.isAttachedTo((AbstractContraptionEntity)this)) {
            controller.attach(this);
            if (level.field_9236) {
                this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
    }

    public void handleAnimation() {
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption mounted = (AbstractMountedCannonContraption)contraption;
            mounted.animate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float maximumDepression() {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof AbstractMountedCannonContraption)) return 90.0f;
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        if (this.getController() == null) return 90.0f;
        float f = cannon.maximumDepression(this.getController());
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float maximumElevation() {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof AbstractMountedCannonContraption)) return 90.0f;
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        if (this.getController() == null) return 90.0f;
        float f = cannon.maximumElevation(this.getController());
        return f;
    }

    protected void onContraptionStalled() {
        ControlPitchContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return new CBCContraptionRotationState(this);
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, class_1297 riding, boolean isOnCoupling) {
        return false;
    }

    public void method_5674(class_2940<?> key) {
        float prevYaw = this.yaw;
        super.method_5674(key);
        this.yaw = prevYaw;
    }

    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate((class_243)localPos, (double)this.method_5695(partialTicks), (class_2350.class_2351)(this.getInitialOrientation().method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
        localPos = VecHelper.rotate((class_243)localPos, (double)this.method_5705(partialTicks), (class_2350.class_2351)class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate((class_243)localPos, (double)this.getInitialYaw(), (class_2350.class_2351)class_2350.class_2351.field_11052);
        return localPos;
    }

    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate((class_243)localPos, (double)(-this.getInitialYaw()), (class_2350.class_2351)class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate((class_243)localPos, (double)(-this.method_5705(partialTicks)), (class_2350.class_2351)class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate((class_243)localPos, (double)(-this.method_5695(partialTicks)), (class_2350.class_2351)(this.getInitialOrientation().method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
        return localPos;
    }

    public float getRotationCoefficient() {
        float f;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            f = Math.max(1.0f / cannon.getWeightForStress(), 0.1f);
        } else {
            f = 0.1f;
        }
        return f;
    }

    public void method_5644(class_1297 entity) {
        AbstractMountedCannonContraption cannon;
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption && (cannon = (AbstractMountedCannonContraption)contraption).canBeTurnedByPassenger(entity)) {
            class_2350 dir = this.getInitialOrientation();
            boolean flag = dir.method_10171() == class_2350.class_2352.field_11056 == (dir.method_10166() == class_2350.class_2351.field_11048);
            this.prevPitch = flag ? -entity.field_6004 : entity.field_6004;
            this.pitch = flag ? -entity.method_36455() : entity.method_36455();
            this.prevYaw = entity.field_5982;
            this.yaw = entity.method_36454();
            entity.method_5636(entity.method_36454());
            if (CBCEntityTypes.CANNON_CARRIAGE.is(this.method_5854())) {
                this.method_5854().method_5644((class_1297)this);
            } else {
                ControlPitchContraption controlPitchContraption = this.getController();
                if (controlPitchContraption instanceof CannonMountBlockEntity) {
                    CannonMountBlockEntity mount = (CannonMountBlockEntity)controlPitchContraption;
                    mount.applyHandRotation();
                    this.field_6004 = this.prevPitch;
                    this.method_36457(this.pitch);
                    this.field_5982 = this.prevYaw;
                    this.method_36456(this.yaw);
                }
            }
        }
    }

    public void addSittingPassenger(class_1297 passenger, int seatIndex) {
        class_1308 mob;
        class_1297 class_12972;
        if (passenger instanceof class_1308 && (class_12972 = (mob = (class_1308)passenger).method_5933()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.addSittingPassenger((class_1297)player, seatIndex);
        }
        super.addSittingPassenger(passenger, seatIndex);
    }

    protected void method_5627(class_1297 entity) {
        super.method_5627(entity);
        class_2350 dir = this.getInitialOrientation();
        boolean flag = dir.method_10171() == class_2350.class_2352.field_11056 == (dir.method_10166() == class_2350.class_2351.field_11048);
        entity.method_36457(flag ? -this.pitch : this.prevPitch);
        entity.method_36456(this.yaw);
        entity.field_6004 = flag ? -this.prevPitch : this.prevPitch;
        entity.field_5982 = this.prevYaw;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 function) {
        if (!this.method_5626(passenger)) {
            return;
        }
        class_243 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        if ((transformedVector = this.processRiderPositionHook(passenger, transformedVector)) == null) {
            return;
        }
        passenger.method_5814(transformedVector.field_1352, transformedVector.field_1351, transformedVector.field_1350);
    }

    @Nullable
    protected class_243 processRiderPositionHook(class_1297 passenger, @Nullable class_243 original) {
        return original;
    }

    public class_243 getPassengerPosition(class_1297 passenger, float partialTicks) {
        Contraption contraption;
        if (passenger != this.method_5642() || !((contraption = this.contraption) instanceof AbstractMountedCannonContraption)) {
            return super.getPassengerPosition(passenger, partialTicks);
        }
        AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
        class_2338 seat = cannon.getSeatPos(passenger);
        if (seat == null) {
            return null;
        }
        class_243 normal = new class_243(this.getInitialOrientation().method_23955());
        return this.toGlobalVector(class_243.method_24953((class_2382)seat).method_1019(normal.method_1021(-0.25)), partialTicks);
    }

    public class_243 method_24829(class_1309 entityLiving) {
        ControlPitchContraption controller = this.getController();
        class_243 superResult = super.method_24829(entityLiving);
        return controller != null ? class_243.method_24953((class_2382)controller.getDismountPositionForContraption(this)) : superResult;
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
    }

    public class_2338 getSeatPos(class_1297 passenger) {
        return ((AbstractMountedCannonContraption)this.contraption).getSeatPos(passenger);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1657 player;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1657 ? (player = (class_1657)class_12972) : null;
    }

    public boolean canBeTurnedByController(ControlPitchContraption control) {
        AbstractMountedCannonContraption cannon;
        Contraption contraption = this.contraption;
        return contraption instanceof AbstractMountedCannonContraption && (cannon = (AbstractMountedCannonContraption)contraption).canBeTurnedByController(control);
    }

    public void tryFiringShot() {
        Contraption contraption = this.contraption;
        if (contraption instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            contraption = this.method_37908();
            if (contraption instanceof class_3218) {
                class_3218 slevel = (class_3218)contraption;
                cannon.fireShot(slevel, this, this.getController());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handlePlayerInteraction(class_1657 player, class_2338 localPos, class_2350 side, class_1268 interactionHand) {
        Contraption be;
        Contraption contraption = this.contraption;
        if (contraption instanceof MountedBigCannonContraption) {
            MountedBigCannonContraption cannon = (MountedBigCannonContraption)contraption;
            if (interactionHand == class_1268.field_5808) {
                be = (class_2586)this.contraption.presentBlockEntities.get(localPos);
                class_3499.class_3501 info = (class_3499.class_3501)this.contraption.getBlocks().get(localPos);
                class_2248 class_22482 = info.comp_1342().method_26204();
                if (!(class_22482 instanceof BigCannonBlock)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
                BigCannonBlock cBlock = (BigCannonBlock)class_22482;
                if (!(be instanceof IBigCannonBlockEntity)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
                if (!cBlock.onInteractWhileAssembled(player, localPos, side, interactionHand, this.method_37908(), cannon, (class_2586)cbe, info, (AbstractContraptionEntity)this)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
                return true;
            }
        }
        if (!((be = this.contraption) instanceof MountedAutocannonContraption)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
        MountedAutocannonContraption autocannon = (MountedAutocannonContraption)be;
        if (interactionHand != class_1268.field_5808) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
        be = (class_2586)this.contraption.presentBlockEntities.get(localPos);
        class_3499.class_3501 info = (class_3499.class_3501)this.contraption.getBlocks().get(localPos);
        class_2248 class_22483 = info.comp_1342().method_26204();
        if (!(class_22483 instanceof AutocannonBlock)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
        AutocannonBlock cBlock = (AutocannonBlock)class_22483;
        if (!(be instanceof IAutocannonBlockEntity)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
        IAutocannonBlockEntity cbe = (IAutocannonBlockEntity)be;
        if (!cBlock.onInteractWhileAssembled(player, localPos, side, interactionHand, this.method_37908(), autocannon, (class_2586)cbe, info, (AbstractContraptionEntity)this)) return super.handlePlayerInteraction(player, localPos, side, interactionHand);
        return true;
    }
}

