/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_3542;

public record BigCannonMaterialProperties(int squibRatioNum, int squibRatioDem, float weight, int maxSafeBaseCharges, FailureMode failureMode) {
    public double squibRatio() {
        return this.squibRatioDem == 0 ? 0.0 : (double)this.squibRatioNum / (double)this.squibRatioDem;
    }

    public static BigCannonMaterialProperties fromJson(JsonObject obj) {
        int squibRatioNum = Math.max(0, class_3518.method_15260((JsonObject)obj, (String)"squib_ratio_barrels"));
        int squibRatioDem = Math.max(1, class_3518.method_15260((JsonObject)obj, (String)"squib_ratio_propellant"));
        float weight = Math.max(0.0f, class_3518.method_15277((JsonObject)obj, (String)"weight", (float)2.0f));
        int maxSafeBaseCharges = Math.max(0, class_3518.method_15282((JsonObject)obj, (String)"max_safe_charges", (int)2));
        FailureMode failureMode = FailureMode.byId(class_3518.method_15265((JsonObject)obj, (String)"failure_mode"));
        return new BigCannonMaterialProperties(squibRatioNum, squibRatioDem, weight, maxSafeBaseCharges, failureMode);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("squib_ratio_barrels", (Number)this.squibRatioNum);
        obj.addProperty("squib_ratio_propellant", (Number)this.squibRatioDem);
        obj.addProperty("weight", (Number)Float.valueOf(this.weight));
        obj.addProperty("max_safe_charges", (Number)this.maxSafeBaseCharges);
        obj.addProperty("failure_mode", this.failureMode.toString());
        return obj;
    }

    public void writeBuf(class_2540 buf) {
        buf.method_10804(this.squibRatioNum).method_10804(this.squibRatioDem).writeFloat(this.weight);
        buf.method_10804(this.maxSafeBaseCharges).method_10804(this.failureMode.ordinal());
    }

    public static BigCannonMaterialProperties fromBuf(class_2540 buf) {
        int squibRatioNum = buf.method_10816();
        int squibRatioDem = buf.method_10816();
        float weight = buf.readFloat();
        int maxSafeBaseCharges = buf.method_10816();
        FailureMode mode = FailureMode.values()[buf.method_10816()];
        return new BigCannonMaterialProperties(squibRatioNum, squibRatioDem, weight, maxSafeBaseCharges, mode);
    }

    public static enum FailureMode implements class_3542
    {
        RUPTURE,
        FRAGMENT;

        private static final Map<String, FailureMode> BY_ID;
        private final String name = this.name().toLowerCase();

        public String method_15434() {
            return this.name;
        }

        public static FailureMode byId(String id) {
            return BY_ID.getOrDefault(id, RUPTURE);
        }

        static {
            BY_ID = Arrays.stream(FailureMode.values()).collect(Collectors.toMap(class_3542::method_15434, Function.identity()));
        }
    }
}

