/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;

public class BlockRecipesManager {
    private static final Map<class_2960, BlockRecipe> BLOCK_RECIPES_BY_NAME = new HashMap<class_2960, BlockRecipe>();
    private static final Map<BlockRecipeType<?>, Map<class_2960, BlockRecipe>> BLOCK_RECIPES_BY_TYPE = new HashMap();

    public static Collection<BlockRecipe> getRecipes() {
        return BLOCK_RECIPES_BY_NAME.values();
    }

    public static Collection<BlockRecipe> getRecipesOfType(BlockRecipeType<?> type) {
        return ((Map)BLOCK_RECIPES_BY_TYPE.getOrDefault(type, new HashMap())).values();
    }

    public static void clear() {
        BLOCK_RECIPES_BY_NAME.clear();
        BLOCK_RECIPES_BY_TYPE.clear();
    }

    public static void writeBuf(class_2540 buf) {
        buf.method_10804(BLOCK_RECIPES_BY_NAME.size());
        for (Map.Entry<class_2960, BlockRecipe> entry : BLOCK_RECIPES_BY_NAME.entrySet()) {
            buf.method_10812(entry.getKey());
            BlockRecipesManager.toNetworkCasted(buf, entry.getValue());
        }
    }

    public static <T extends BlockRecipe> void toNetworkCasted(class_2540 buf, T recipe) {
        BlockRecipeSerializer<?> ser = recipe.getSerializer();
        buf.method_10812(CBCRegistries.blockRecipeSerializers().method_10221(ser));
        ser.toNetwork(buf, recipe);
    }

    public static void readBuf(class_2540 buf) {
        BlockRecipesManager.clear();
        int sz = buf.method_10816();
        class_2378<BlockRecipeSerializer<?>> serializersRegistry = CBCRegistries.blockRecipeSerializers();
        class_2378<BlockRecipeType<?>> typeRegistry = CBCRegistries.blockRecipeTypes();
        for (int i = 0; i < sz; ++i) {
            class_2960 id = buf.method_10810();
            class_2960 type = buf.method_10810();
            Object recipe = ((BlockRecipeSerializer)serializersRegistry.method_10223(type)).fromNetwork(id, buf);
            BLOCK_RECIPES_BY_NAME.put(id, (BlockRecipe)recipe);
            BlockRecipeType recipeType = (BlockRecipeType)typeRegistry.method_10223(type);
            if (!BLOCK_RECIPES_BY_TYPE.containsKey(recipeType)) {
                BLOCK_RECIPES_BY_TYPE.put(recipeType, new HashMap());
            }
            BLOCK_RECIPES_BY_TYPE.get(recipeType).put(id, (BlockRecipe)recipe);
        }
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundRecipesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundRecipesPacket(), server);
    }

    public static class ClientboundRecipesPacket
    implements RootPacket {
        private class_2540 buf;

        public ClientboundRecipesPacket() {
        }

        public ClientboundRecipesPacket(class_2540 buf) {
            this.buf = buf;
        }

        @Override
        public void rootEncode(class_2540 buf) {
            BlockRecipesManager.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            BlockRecipesManager.readBuf(this.buf);
        }
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "block_recipes");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resources, class_3695 profiler) {
            BlockRecipesManager.clear();
            class_2378<BlockRecipeSerializer<?>> serializersRegistry = CBCRegistries.blockRecipeSerializers();
            class_2378<BlockRecipeType<?>> typeRegistry = CBCRegistries.blockRecipeTypes();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                class_2960 id = entry.getKey();
                JsonObject obj = el.getAsJsonObject();
                class_2960 type = new class_2960(obj.get("type").getAsString());
                Object recipe = ((BlockRecipeSerializer)serializersRegistry.method_10223(type)).fromJson(id, obj);
                BLOCK_RECIPES_BY_NAME.put(id, (BlockRecipe)recipe);
                BlockRecipeType recipeType = (BlockRecipeType)typeRegistry.method_10223(type);
                if (!BLOCK_RECIPES_BY_TYPE.containsKey(recipeType)) {
                    BLOCK_RECIPES_BY_TYPE.put(recipeType, new HashMap());
                }
                BLOCK_RECIPES_BY_TYPE.get(recipeType).put(id, (BlockRecipe)recipe);
            }
        }
    }
}

