/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterial;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlockEntity;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderHeadBlock;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;

public class CannonBuildingContraption
extends PoleContraption {
    protected boolean isActivated = false;
    protected BigCannonMaterial material = null;
    private static final class_2753 FACING = class_2741.field_12525;

    public CannonBuildingContraption() {
    }

    public CannonBuildingContraption(class_2350 orientation, boolean retract) {
        super(orientation, retract);
    }

    @Override
    protected boolean collectExtensions(class_1937 level, class_2338 pos, class_2350 direction) throws AssemblyException {
        if (!CBCBlocks.CANNON_BUILDER.has(level.method_8320(pos))) {
            return false;
        }
        ArrayList<class_3499.class_3501> poles = new ArrayList<class_3499.class_3501>();
        class_2338 start = pos;
        class_2680 nextBlock = level.method_8320(start.method_10093(direction));
        int extensionsInFront = 0;
        class_2350.class_2351 blockAxis = direction.method_10166();
        PistonExtensionPoleBlock.PlacementHelper matcher = PistonExtensionPoleBlock.PlacementHelper.get();
        if (level.method_8320(pos).method_11654(CannonBuilderBlock.STATE) == CannonBuilderBlock.BuilderState.EXTENDED) {
            while (matcher.matchesAxis(nextBlock, blockAxis) || CannonBuildingContraption.isBuilderHead(nextBlock) && nextBlock.method_11654((class_2769)FACING) == direction) {
                start = start.method_10093(direction);
                poles.add(new class_3499.class_3501(start, (class_2680)nextBlock.method_11657((class_2769)FACING, (Comparable)direction), null));
                ++extensionsInFront;
                if (CannonBuildingContraption.isBuilderHead(nextBlock)) {
                    this.isActivated = (Boolean)nextBlock.method_11654((class_2769)CannonBuilderHeadBlock.ATTACHED);
                    break;
                }
                nextBlock = level.method_8320(start.method_10093(direction));
                if (extensionsInFront <= CannonBuilderBlock.maxAllowedBuilderLength()) continue;
                throw CannonBuildingContraption.tooManyPistonPoles();
            }
        }
        if (extensionsInFront == 0) {
            this.isActivated = level.method_8320(pos).method_11654(CannonBuilderBlock.STATE) == CannonBuilderBlock.BuilderState.ACTIVATED;
            poles.add(new class_3499.class_3501(pos, (class_2680)((class_2680)CBCBlocks.CANNON_BUILDER_HEAD.getDefaultState().method_11657((class_2769)FACING, (Comparable)direction)).method_11657((class_2769)CannonBuilderHeadBlock.ATTACHED, (Comparable)Boolean.valueOf(this.isActivated)), null));
        } else {
            poles.add(new class_3499.class_3501(pos, (class_2680)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().method_11657((class_2769)FACING, (Comparable)direction), null));
        }
        class_2338 end = pos;
        int extensionsInBack = 0;
        class_2350 opposite = direction.method_10153();
        nextBlock = level.method_8320(end.method_10093(opposite));
        while (matcher.matchesAxis(nextBlock, blockAxis)) {
            end = end.method_10093(opposite);
            poles.add(new class_3499.class_3501(end, (class_2680)nextBlock.method_11657((class_2769)FACING, (Comparable)direction), null));
            nextBlock = level.method_8320(end.method_10093(opposite));
            if (extensionsInFront + ++extensionsInBack <= CannonBuilderBlock.maxAllowedBuilderLength()) continue;
            throw CannonBuildingContraption.tooManyPistonPoles();
        }
        this.extensionLength = extensionsInFront + extensionsInBack;
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.anchor = pos.method_10079(direction, this.initialExtensionProgress + 1);
        this.initialExtensionProgress = extensionsInFront;
        this.pistonContraptionHitbox = new class_238(class_2338.field_10980, class_2338.field_10980.method_10079(direction, -this.extensionLength - 1)).method_1012(1.0, 1.0, 1.0);
        this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (class_3499.class_3501 pole : poles) {
            class_2338 relPos = pole.comp_1341().method_10079(direction, -extensionsInFront);
            class_2338 localPos = relPos.method_10059((class_2382)this.anchor);
            this.getBlocks().put(localPos, new class_3499.class_3501(localPos, pole.comp_1342(), null));
        }
        return true;
    }

    protected boolean addToInitialFrontier(class_1937 level, class_2338 pos, class_2350 forcedDirection, Queue<class_2338> frontier) throws AssemblyException {
        frontier.clear();
        if (!this.isActivated) {
            return true;
        }
        boolean retracting = forcedDirection != this.orientation;
        HashSet<CannonCastShape> connectedShapes = new HashSet<CannonCastShape>();
        CannonCastShape fullShape = null;
        HashMap<class_2338, Pair> preAddedBlocks = new HashMap<class_2338, Pair>();
        class_2350 opposite = this.orientation.method_10153();
        boolean firstBlock = true;
        for (int offset = 0; offset <= (Integer)CBCConfigs.SERVER.crafting.maxCannonBuilderRange.get(); ++offset) {
            class_2338 currentPos = pos.method_10079(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && level.method_31606(currentPos)) {
                preAddedBlocks.forEach(this::addBlock);
                return this.material != null && !firstBlock;
            }
            if (!level.method_8477(currentPos)) {
                throw AssemblyException.unloadedChunk((class_2338)currentPos);
            }
            class_2680 state = level.method_8320(currentPos);
            if (this.isValidCannonBlock(level, state, currentPos) && CannonBuildingContraption.matchesCannonAxis(state, this.orientation.method_10166()) && this.matchesCurrentMaterial(level, state, currentPos)) {
                class_2338 backPos;
                class_2586 class_25862;
                class_2586 class_25863;
                BigCannonBlock cBlock = (BigCannonBlock)state.method_26204();
                if (this.material == null) {
                    this.material = cBlock.getCannonMaterialInLevel((class_1936)level, state, currentPos);
                }
                if ((class_25863 = level.method_8321(currentPos)) instanceof LayeredBigCannonBlockEntity) {
                    LayeredBigCannonBlockEntity split;
                    LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)class_25863;
                    if (fullShape == null && connectedShapes.isEmpty()) {
                        if (firstBlock) {
                            CannonCastShape topShape = layered.getTopCannonShape();
                            connectedShapes.add(topShape);
                            firstBlock = false;
                        } else {
                            if (!preAddedBlocks.isEmpty()) break;
                            return false;
                        }
                    }
                    LayeredBigCannonBlockEntity layeredBigCannonBlockEntity = fullShape == null ? layered.getSplitBlockEntity(connectedShapes, offset == 0 ? null : opposite) : (split = layered.getSplitBlockEntity(fullShape, opposite));
                    if (split.isEmpty()) break;
                    if (layered.getLayers().size() > 1 && offset == 0 && forcedDirection == this.orientation) {
                        return false;
                    }
                    class_2680 simpleState = split.getSimplifiedBlock().method_9564();
                    if (!simpleState.method_28498((class_2769)class_2741.field_12525)) {
                        return false;
                    }
                    simpleState = (class_2680)simpleState.method_11657((class_2769)class_2741.field_12525, (Comparable)cBlock.getFacing(state));
                    class_2487 tag = this.getBlockEntityTag((class_2586)split);
                    preAddedBlocks.put(currentPos, Pair.of((Object)new class_3499.class_3501(currentPos, simpleState, tag), (Object)split));
                    connectedShapes.addAll(split.getLayers().keySet());
                    Collection<CannonCastShape> connectedShapes1 = split.getConnectedTo(this.orientation);
                    connectedShapes.removeIf(s -> !connectedShapes1.contains(s));
                    fullShape = null;
                    continue;
                }
                CannonCastShape shape = cBlock.getShapeInLevel((class_1936)level, state, currentPos);
                if (fullShape == null && !CannonBuildingContraption.isConnected(connectedShapes, shape)) {
                    if (firstBlock) {
                        connectedShapes.add(shape);
                        firstBlock = false;
                    } else {
                        if (!preAddedBlocks.isEmpty()) break;
                        return false;
                    }
                }
                for (int back = 1; back < offset && (class_25862 = level.method_8321(backPos = currentPos.method_10079(opposite, back))) instanceof LayeredBigCannonBlockEntity; ++back) {
                    LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)class_25862;
                    Pair backPair = (Pair)preAddedBlocks.get(backPos);
                    Object object = backPair.getRight();
                    if (!(object instanceof LayeredBigCannonBlockEntity)) break;
                    LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)object;
                    Set backConnected = layered.getConnectedTo(this.orientation).stream().filter(s -> s.diameter() < shape.diameter()).collect(Collectors.toCollection(HashSet::new));
                    if (backConnected.isEmpty()) break;
                    Set allSet = layered.getLayers().keySet().stream().filter(s -> s.diameter() < shape.diameter()).collect(Collectors.toCollection(HashSet::new));
                    allSet.removeAll(backConnected);
                    if (!allSet.isEmpty() && forcedDirection != this.orientation) {
                        return false;
                    }
                    for (CannonCastShape shape1 : backConnected) {
                        if (shape1.diameter() >= shape.diameter()) continue;
                        layered1.setLayer(shape1, layered.getLayer(shape1));
                        for (class_2350 dir : Iterate.directions) {
                            layered1.setLayerConnectedTo(dir, shape1, layered.isLayerConnectedTo(dir, shape1));
                        }
                    }
                    class_2680 simpleState = layered1.getSimplifiedBlock().method_9564();
                    if (!simpleState.method_28498((class_2769)class_2741.field_12525)) {
                        return false;
                    }
                    simpleState = (class_2680)simpleState.method_11657((class_2769)class_2741.field_12525, (Comparable)cBlock.getFacing(state));
                    class_2487 tag = this.getBlockEntityTag((class_2586)layered1);
                    preAddedBlocks.put(backPos, Pair.of((Object)new class_3499.class_3501(backPos, simpleState, tag), (Object)layered1));
                }
                class_2586 be = level.method_8321(currentPos);
                preAddedBlocks.put(currentPos, Pair.of((Object)new class_3499.class_3501(currentPos, state, this.getBlockEntityTag(be)), (Object)be));
                fullShape = CannonBuildingContraption.isConnectedTo(level, shape, cBlock, state, currentPos, this.orientation) ? shape : null;
                connectedShapes.clear();
                continue;
            }
            if (forcedDirection != this.orientation || state.method_45474() && state.method_26220((class_1922)level, currentPos).method_1110()) break;
            return false;
        }
        if (this.material != null && !firstBlock) {
            preAddedBlocks.forEach(this::addBlock);
        } else {
            this.isActivated = false;
        }
        return true;
    }

    protected class_2487 getBlockEntityTag(class_2586 be) {
        if (be == null) {
            return null;
        }
        class_2487 tag = be.method_38242();
        tag.method_10551("x");
        tag.method_10551("y");
        tag.method_10551("z");
        return tag;
    }

    private boolean isValidCannonBlock(class_1937 level, class_2680 state, class_2338 currentPos) {
        return state.method_26204() instanceof BigCannonBlock && level.method_8321(currentPos) instanceof ICannonBlockEntity;
    }

    private static boolean matchesCannonAxis(class_2680 state, class_2350.class_2351 axis) {
        return ((BigCannonBlock)state.method_26204()).getFacing(state).method_10166() == axis;
    }

    private boolean matchesCurrentMaterial(class_1937 level, class_2680 state, class_2338 pos) {
        return this.material == null || ((BigCannonBlock)state.method_26204()).getCannonMaterialInLevel((class_1936)level, state, pos) == this.material;
    }

    private static boolean isConnectedTo(class_1937 level, CannonCastShape shape, BigCannonBlock cBlock, class_2680 state, class_2338 pos, class_2350 dir) {
        ICannonBlockEntity cbe;
        class_2586 class_25862;
        if (cBlock.getFacing(state).method_10166() != dir.method_10166() || cBlock.getShapeInLevel((class_1936)level, state, pos) != shape || !((class_25862 = level.method_8321(pos)) instanceof ICannonBlockEntity) || !((CannonBehavior)((Object)(cbe = (ICannonBlockEntity)class_25862).cannonBehavior())).isConnectedTo(dir)) {
            return false;
        }
        class_2586 be = level.method_8321(pos.method_10093(dir));
        if (be instanceof LayeredBigCannonBlockEntity) {
            LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)be;
            return layered.isLayerConnectedTo(dir.method_10153(), shape);
        }
        if (be instanceof ICannonBlockEntity) {
            ICannonBlockEntity cbe1 = (ICannonBlockEntity)be;
            return ((CannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(dir.method_10153());
        }
        return false;
    }

    private static boolean isConnected(Collection<CannonCastShape> connected, CannonCastShape full) {
        return connected.stream().anyMatch(s -> s.diameter() <= full.diameter());
    }

    protected void addBlock(class_2338 pos, Pair<class_3499.class_3501, class_2586> pair) {
        class_2338 offset = pos.method_10079(this.orientation, -this.initialExtensionProgress);
        super.addBlock(offset, pair);
        class_2586 te = (class_2586)pair.getRight();
        if (te != null) {
            this.presentBlockEntities.put(offset.method_10059((class_2382)this.anchor), te);
        }
    }

    protected boolean customBlockPlacement(class_1936 level, class_2338 pos, class_2680 state) {
        CannonBuilderBlockEntity builder;
        class_2680 builderState;
        class_2338 levelPos;
        block10: {
            block9: {
                levelPos = this.anchor.method_10079(this.orientation, -1);
                builderState = level.method_8320(levelPos);
                class_2586 blockEntity = level.method_8321(levelPos);
                if (!(blockEntity instanceof CannonBuilderBlockEntity)) break block9;
                builder = (CannonBuilderBlockEntity)blockEntity;
                if (!blockEntity.method_11015()) break block10;
            }
            return true;
        }
        if (pos.equals((Object)levelPos)) {
            if (CBCBlocks.CANNON_BUILDER_HEAD.has(state) && CBCBlocks.CANNON_BUILDER.has(builderState)) {
                CannonBuilderBlock.BuilderState bState = (Boolean)state.method_11654((class_2769)CannonBuilderHeadBlock.ATTACHED) != false ? CannonBuilderBlock.BuilderState.ACTIVATED : CannonBuilderBlock.BuilderState.UNACTIVATED;
                level.method_8652(levelPos, (class_2680)builderState.method_11657(CannonBuilderBlock.STATE, (Comparable)((Object)bState)), 19);
            }
            return true;
        }
        if (builder.movedContraption != null) {
            class_2338 entityAnchor = class_2338.method_49638((class_2374)builder.movedContraption.getAnchorVec().method_1031(0.5, 0.5, 0.5));
            class_2338 blockPos = pos.method_10059((class_2382)entityAnchor);
            class_3499.class_3501 blockInfo = (class_3499.class_3501)this.getBlocks().get(blockPos);
            class_2586 blockEntity1 = level.method_8321(pos);
            if (blockEntity1 instanceof LayeredBigCannonBlockEntity) {
                LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity1;
                if (blockInfo.comp_1343() == null || !blockInfo.comp_1343().method_10545("id")) {
                    return true;
                }
                class_2586 infoBE = class_2586.method_11005((class_2338)blockPos, (class_2680)builderState, (class_2487)blockInfo.comp_1343());
                if (!(infoBE instanceof LayeredBigCannonBlockEntity)) {
                    return true;
                }
                LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)infoBE;
                layered.addLayersOfOther(layered1);
                layered.updateBlockstate();
                layered.sendData();
                return true;
            }
        }
        return false;
    }

    protected boolean customBlockRemoval(class_1936 level, class_2338 pos, class_2680 state) {
        class_2338 levelPos = this.anchor.method_10079(this.orientation, -1);
        class_2680 builderState = level.method_8320(levelPos);
        class_2586 class_25862 = level.method_8321(levelPos);
        if (!(class_25862 instanceof CannonBuilderBlockEntity)) {
            return true;
        }
        CannonBuilderBlockEntity builder = (CannonBuilderBlockEntity)class_25862;
        if (pos.equals((Object)levelPos) && CBCBlocks.CANNON_BUILDER.has(builderState)) {
            level.method_8652(levelPos, (class_2680)builderState.method_11657(CannonBuilderBlock.STATE, (Comparable)((Object)CannonBuilderBlock.BuilderState.MOVING)), 82);
            return true;
        }
        class_2338 blockPos = pos.method_10079(this.orientation, -this.initialExtensionProgress).method_10059((class_2382)this.anchor);
        class_3499.class_3501 blockInfo = (class_3499.class_3501)this.getBlocks().get(blockPos);
        class_2586 blockEntity1 = level.method_8321(pos);
        if (blockInfo != null && blockEntity1 instanceof LayeredBigCannonBlockEntity) {
            LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity1;
            class_2487 infoNbt = blockInfo.comp_1343();
            if (infoNbt == null || !infoNbt.method_10545("id")) {
                return true;
            }
            class_2586 infoBE = class_2586.method_11005((class_2338)blockPos, (class_2680)builderState, (class_2487)infoNbt);
            if (!(infoBE instanceof LayeredBigCannonBlockEntity)) {
                return true;
            }
            LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)infoBE;
            layered.removeLayersOfOther(layered1);
            layered.updateBlockstate();
            layered.sendData();
            return true;
        }
        return false;
    }

    public Set<class_2338> getOrCreateColliders(class_1937 level, class_2350 movementDirection) {
        if (!this.isActivated) {
            return super.getOrCreateColliders(level, movementDirection);
        }
        if (this.getBlocks() == null) {
            return Collections.emptySet();
        }
        if (this.cachedColliders == null || this.cachedColliderDirection != movementDirection) {
            this.cachedColliders = new HashSet();
            this.cachedColliderDirection = movementDirection;
            for (class_3499.class_3501 blockInfo : this.getBlocks().values()) {
                class_3499.class_3501 offsetInfo;
                class_2338 offsetPos = blockInfo.comp_1341().method_10093(movementDirection);
                if (blockInfo.comp_1342().method_26220((class_1922)level, offsetPos).method_1110() || CBCBlocks.CANNON_BUILDER_HEAD.has(blockInfo.comp_1342()) && movementDirection != this.orientation || this.getBlocks().containsKey(offsetPos) && !(offsetInfo = (class_3499.class_3501)this.getBlocks().get(offsetPos)).comp_1342().method_26220((class_1922)level, offsetPos).method_1110() && (AllBlocks.PISTON_EXTENSION_POLE.has(blockInfo.comp_1342()) || CBCBlocks.CANNON_BUILDER_HEAD.has(offsetInfo.comp_1342()))) continue;
                this.cachedColliders.add(blockInfo.comp_1341());
            }
        }
        return this.cachedColliders;
    }

    private static boolean isBuilderHead(class_2680 state) {
        return CBCBlocks.CANNON_BUILDER_HEAD.has(state);
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        tag.method_10556("Activated", this.isActivated);
        if (this.material != null) {
            tag.method_10582("Material", this.material.name().toString());
        }
        return tag;
    }

    @Override
    public void readNBT(class_1937 level, class_2487 tag, boolean spawnData) {
        super.readNBT(level, tag, spawnData);
        this.isActivated = tag.method_10577("Activated");
        this.material = BigCannonMaterial.fromNameOrNull(new class_2960(tag.method_10558("Material")));
        if (this.material == null) {
            this.material = CBCBigCannonMaterials.STEEL;
        }
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.CANNON_BUILDER;
    }

    public static AssemblyException tooManyPistonPoles() {
        return new AssemblyException("tooManyPistonPoles", new Object[]{CannonBuilderBlock.maxAllowedBuilderLength()});
    }
}

