/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.values;

import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import rbasamoyai.createbigcannons.datagen.values.CBCDataProvider;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.munitions.config.MunitionProperties;
import rbasamoyai.createbigcannons.munitions.config.ShrapnelProperties;

public class MunitionPropertiesProvider
extends CBCDataProvider {
    private final Map<class_1299<?>, MunitionProperties> projectiles = new LinkedHashMap();

    public MunitionPropertiesProvider(String modid, class_7784 output) {
        super(modid, output, "munition_properties");
    }

    @Override
    protected final void generateData(BiConsumer<class_2960, JsonObject> cons) {
        this.addEntries();
        for (Map.Entry<class_1299<?>, MunitionProperties> entry : this.projectiles.entrySet()) {
            cons.accept(class_7923.field_41177.method_10221(entry.getKey()), entry.getValue().serialize());
        }
    }

    protected void addEntries() {
        this.builder((class_1299)CBCEntityTypes.SHOT.get()).entityDamage(30.0).durabilityMass(10.0).build(this);
        this.builder((class_1299)CBCEntityTypes.HE_SHELL.get()).entityDamage(30.0).explosivePower(8.0).durabilityMass(8.0).build(this);
        this.builder((class_1299)CBCEntityTypes.AP_SHOT.get()).entityDamage(50.0).durabilityMass(30.0).build(this);
        this.builder((class_1299)CBCEntityTypes.TRAFFIC_CONE.get()).entityDamage(100.0).durabilityMass(36.0).build(this);
        this.builder((class_1299)CBCEntityTypes.AP_SHELL.get()).entityDamage(50.0).explosivePower(5.0).durabilityMass(20.0).baseFuze().build(this);
        this.builder((class_1299)CBCEntityTypes.FLUID_SHELL.get()).entityDamage(30.0).durabilityMass(8.0).build(this);
        this.builder((class_1299)CBCEntityTypes.SMOKE_SHELL.get()).entityDamage(30.0).durabilityMass(8.0).build(this);
        this.builder((class_1299)CBCEntityTypes.MORTAR_STONE.get()).entityDamage(50.0).explosivePower(4.0).durabilityMass(4.0).gravity(-0.025f).build(this);
        this.builder((class_1299)CBCEntityTypes.SHRAPNEL_SHELL.get()).entityDamage(30.0).durabilityMass(8.0).shrapnel(5.0, 0.25, 50).build(this);
        this.builder((class_1299)CBCEntityTypes.BAG_OF_GRAPESHOT.get()).entityDamage(0.0).durabilityMass(1.0).renderInvulnerable().accountForEntityArmor().shrapnel(8.0, 0.05, 25).build(this);
        this.builder((class_1299)CBCEntityTypes.AP_AUTOCANNON.get()).entityDamage(6.0).durabilityMass(6.0).accountForEntityArmor().gravity(-0.025).build(this);
        this.builder((class_1299)CBCEntityTypes.FLAK_AUTOCANNON.get()).entityDamage(2.0).durabilityMass(1.0).accountForEntityArmor().gravity(-0.025).shrapnel(5.0, 0.25, 15).build(this);
        this.builder((class_1299)CBCEntityTypes.MACHINE_GUN_BULLET.get()).entityDamage(4.0).durabilityMass(0.1).accountForEntityArmor().gravity(-0.025).build(this);
        this.shrapnel((class_1299)CBCEntityTypes.SHRAPNEL.get()).durabilityMass(2.0).gravity(-0.025).drag(1.0).build(this);
        this.shrapnel((class_1299)CBCEntityTypes.GRAPESHOT.get()).durabilityMass(5.0).gravity(-0.025).drag(1.0).build(this);
    }

    protected Builder builder(class_1299<?> type) {
        return new Builder(type);
    }

    protected Builder shrapnel(class_1299<?> type) {
        return this.builder(type).renderInvulnerable().accountForEntityArmor();
    }

    public String method_10321() {
        return "Munition properties: " + this.modid;
    }

    public static class Builder {
        private final class_1299<?> type;
        private double entityDamage;
        private double explosivePower = 0.0;
        private double durabilityMass;
        private boolean renderInvulnerable = false;
        private boolean ignoresEntityArmor = true;
        private double gravity = -0.05;
        private double drag = 0.99;
        private boolean baseFuze = false;
        private double shrapnelDamage;
        private double shrapnelSpread;
        private int shrapnelCount;
        private boolean buildShrapnel = false;

        public Builder(class_1299<?> type) {
            this.type = type;
        }

        public Builder entityDamage(double value) {
            this.entityDamage = value;
            return this;
        }

        public Builder explosivePower(double value) {
            this.explosivePower = value;
            return this;
        }

        public Builder durabilityMass(double value) {
            this.durabilityMass = value;
            return this;
        }

        public Builder renderInvulnerable() {
            this.renderInvulnerable = true;
            return this;
        }

        public Builder accountForEntityArmor() {
            this.ignoresEntityArmor = false;
            return this;
        }

        public Builder baseFuze() {
            this.baseFuze = true;
            return this;
        }

        public Builder gravity(double value) {
            this.gravity = value;
            return this;
        }

        public Builder drag(double value) {
            this.drag = value;
            return this;
        }

        public Builder shrapnel(double damage, double spread, int count) {
            this.shrapnelDamage = damage;
            this.shrapnelSpread = spread;
            this.shrapnelCount = count;
            this.buildShrapnel = true;
            return this;
        }

        public void build(MunitionPropertiesProvider cons) {
            cons.projectiles.put(this.type, new MunitionProperties(this.entityDamage, this.explosivePower, this.durabilityMass, this.renderInvulnerable, this.ignoresEntityArmor, this.baseFuze, this.gravity, this.drag, this.buildShrapnel ? new ShrapnelProperties(this.shrapnelDamage, this.shrapnelSpread, this.shrapnelCount) : null));
        }
    }
}

