/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.munitions.config.ShrapnelProperties;

public record MunitionProperties(double entityDamage, double explosivePower, double durabilityMass, boolean rendersInvulnerable, boolean ignoresEntityArmor, boolean baseFuze, double gravity, double drag, @Nullable ShrapnelProperties shrapnel) {
    @Nullable
    private final ShrapnelProperties shrapnel;

    public static MunitionProperties fromJson(JsonObject obj, String id) {
        double entityDmg = Math.max(0.0, MunitionProperties.getOrWarn(obj, "entity_damage", id, 1.0, JsonElement::getAsDouble));
        double durabilityMass = Math.max(0.0, MunitionProperties.getOrWarn(obj, "durability_mass", id, 1.0, JsonElement::getAsDouble));
        double explosivePower = Math.max(0.0, obj.has("explosive_power") ? obj.get("explosive_power").getAsDouble() : 0.0);
        boolean rendersInvulnerable = !obj.has("renders_invulnerable") || obj.get("renders_invulnerable").getAsBoolean();
        boolean ignoresEntityArmor = obj.has("ignores_entity_armor") && obj.get("ignores_entity_armor").getAsBoolean();
        boolean baseFuze = class_3518.method_15258((JsonObject)obj, (String)"base_fuze", (boolean)false);
        double gravity = Math.min(0.0, class_3518.method_34915((JsonObject)obj, (String)"gravity", (double)-0.05));
        double drag = class_3532.method_15350((double)class_3518.method_34915((JsonObject)obj, (String)"drag", (double)0.99), (double)0.9, (double)1.0);
        ShrapnelProperties shrapnel = obj.has("shrapnel_properties") ? ShrapnelProperties.fromJson(obj.getAsJsonObject("shrapnel_properties"), id) : null;
        return new MunitionProperties(entityDmg, explosivePower, durabilityMass, rendersInvulnerable, ignoresEntityArmor, baseFuze, gravity, drag, shrapnel);
    }

    private static <T> T getOrWarn(JsonObject obj, String key, String id, T defValue, Function<JsonElement, T> func) {
        if (!obj.has(key)) {
            CreateBigCannons.LOGGER.warn("{} is missing {} value, will be set to 1", (Object)id, (Object)key);
            return defValue;
        }
        return func.apply((JsonElement)obj.getAsJsonPrimitive(key));
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("entity_damage", (Number)this.entityDamage);
        obj.addProperty("durability_mass", (Number)this.durabilityMass);
        obj.addProperty("renders_invulnerable", Boolean.valueOf(this.rendersInvulnerable));
        obj.addProperty("ignores_entity_armor", Boolean.valueOf(this.ignoresEntityArmor));
        obj.addProperty("base_fuze", Boolean.valueOf(this.baseFuze));
        obj.addProperty("gravity", (Number)this.gravity);
        obj.addProperty("drag", (Number)this.drag);
        if (this.explosivePower > 0.0) {
            obj.addProperty("explosive_power", (Number)this.explosivePower);
        }
        if (this.shrapnel != null) {
            obj.add("shrapnel_properties", this.shrapnel.serialize());
        }
        return obj;
    }

    public ShrapnelProperties shrapnel() {
        return this.shrapnel == null ? ShrapnelProperties.DEFAULT : this.shrapnel;
    }

    public void writeBuf(class_2540 buf) {
        buf.writeDouble(this.entityDamage).writeDouble(this.explosivePower).writeDouble(this.durabilityMass).writeBoolean(this.rendersInvulnerable).writeBoolean(this.ignoresEntityArmor).writeBoolean(this.baseFuze).writeDouble(this.gravity).writeDouble(this.drag).writeBoolean(this.shrapnel != null);
        if (this.shrapnel != null) {
            this.shrapnel.writeBuf(buf);
        }
    }

    public static MunitionProperties readBuf(class_2540 buf) {
        double damage = buf.readDouble();
        double power = buf.readDouble();
        double mass = buf.readDouble();
        boolean invulnerable = buf.readBoolean();
        boolean ignoresArmor = buf.readBoolean();
        boolean baseFuze = buf.readBoolean();
        double gravity = buf.readDouble();
        double drag = buf.readDouble();
        ShrapnelProperties shrapnel = buf.readBoolean() ? ShrapnelProperties.readBuf(buf) : null;
        return new MunitionProperties(damage, power, mass, invulnerable, ignoresArmor, baseFuze, gravity, drag, shrapnel);
    }
}

